/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.storeage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.customize.storeage.app.AbstractSaleIssueBillExtendFacadeControllerBean;
import com.kingdee.eas.scm.customize.storeage.app.constants.SaleissueExtendConstant;
import com.kingdee.eas.scm.customize.storeage.util.WSUtil;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.ws.ImportException;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SaleIssueBillExtendFacadeControllerBean
extends AbstractSaleIssueBillExtendFacadeControllerBean {
    private static final long serialVersionUID = 879064790880628360L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.customize.storeage.app.SaleIssueBillExtendFacadeControllerBean");

    @Override
    protected void _handleExtendField(Context ctx, IObjectValue info, String xmlData) throws BOSException {
        String[] msg = new String[2];
        try {
            if (info instanceof SaleIssueBillInfo) {
                SaleIssueBillInfo salIsueInfo = (SaleIssueBillInfo)info;
                Document doc = XMLUtil.builderDocument((String)xmlData);
                HashMap billHeadMap = WSUtil.getBillHeadPropMap((Document)doc, (String[])SaleissueExtendConstant.HEADPROPERTIES);
                ArrayList billEntriesList = WSUtil.getBillEntries((Document)doc, (String[])SaleissueExtendConstant.ENTRYPROPERTIES);
                this.buildBillHead(ctx, salIsueInfo, billHeadMap);
                this.builBillEntries(ctx, salIsueInfo, billEntriesList, null);
            }
        }
        catch (EASBizException e) {
            msg[0] = e.getCode();
            msg[1] = e.getMessage();
            logger.error((Object)e);
        }
        catch (SAXException e) {
            ImportException excep = new ImportException(ImportException.PRASERXMLEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
            logger.error((Object)excep);
        }
        catch (IOException e) {
            ImportException excep = new ImportException(ImportException.READXMLIOEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
        }
        catch (ParserConfigurationException e) {
            ImportException excep = new ImportException(ImportException.CONVERFORMATEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
            logger.error((Object)excep);
        }
        catch (TransformerException e) {
            ImportException excep = new ImportException(ImportException.WRITERXMLEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
            logger.error((Object)excep);
        }
    }

    private void buildBillHead(Context ctx, SaleIssueBillInfo info, HashMap billHeadMap) throws EASBizException {
        WSUtil.setIntProperties((CoreBaseInfo)info, (HashMap)billHeadMap, (String[])SaleissueExtendConstant.headintProperties);
        WSUtil.setLinkProperties((Context)ctx, (CoreBaseInfo)info, (HashMap)billHeadMap, null, (String[])SaleissueExtendConstant.headLinkProperties, null);
    }

    private void builBillEntries(Context ctx, SaleIssueBillInfo info, ArrayList entriesList, String cuNumber) throws EASBizException {
        if (entriesList != null) {
            for (int i = 0; i < entriesList.size(); ++i) {
                HashMap entryMap = (HashMap)entriesList.get(i);
                SaleIssueEntryInfo entryInfo = info.getEntry().get(i);
                WSUtil.setStrProperties((CoreBaseInfo)entryInfo, (HashMap)entryMap, (String[])SaleissueExtendConstant.entryStrProperties);
                WSUtil.setDeciamlProperties((CoreBaseInfo)entryInfo, (HashMap)entryMap, (String[])SaleissueExtendConstant.entryDecimalProperties);
                WSUtil.setLinkProperties((Context)ctx, (CoreBaseInfo)entryInfo, (HashMap)entryMap, (String)cuNumber, (String[])SaleissueExtendConstant.entryLinkProperties, null);
            }
        }
    }
}

