/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.im.inv.app.IVirtualBill;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractVirtualBill
implements IVirtualBill {
    protected static final String SaleIssueToSaleIssue_Sale_Mapping = "7oaZzawjS9GgNiZmMD47+gRRIsQ=";
    protected static final String SaleIssueToSaleIssue_Balance_Mapping = "vtc6+DmzRZuctXJnN2Xq8QRRIsQ=";
    protected static final String SaleIssueToPurInWarehs_Sale_Mapping = "gYsvHf7jTfCEbbqwWIMWuwRRIsQ=";
    protected static final String SaleIssueToPurInWarehs_Balance_Mapping = "1GPQQQpoT6mGd1cRsEbMywRRIsQ=";
    protected static final String SaleIssueToSaleIssue_Sale_Return_Mapping = "u3Nsc67/TiyEmdEOAC010QRRIsQ=";
    protected static final String SaleIssueToSaleIssue_Balance_Return_Mapping = "O4XFvJXdSFqcaYymgkoNtQRRIsQ=";
    protected static final String SaleIssueToPurInWarehs_Sale_Return_Mapping = "fPtmUjQgT9ylqW1IIQ28bARRIsQ=";
    protected static final String SaleIssueToPurInWarehs_Balance_Return_Mapping = "zS8fGI3OQ1CcKqZA671dtgRRIsQ=";
    protected static final String ArOtherBillToArOtherBill_Issue_Mapping = "GHD+j2uWQ5qH/x+T50O9YARRIsQ=";
    protected static final String ArOtherBillToArOtherBill_Balance_Mapping = "ZEgoBwTjSDq2vzyZiaIL1ARRIsQ=";
    protected static final String ArOtherBillToApOtherBill_Sale_Mapping = "XPAH0JfWTLqvTTwuFmF8PwRRIsQ=";
    protected static final String ArOtherBillToApOtherBill_Balance_Mapping = "dJDEnFDQQPOPM4PvQSNgdgRRIsQ=";
    protected static final BOSObjectType SaleIssueDestBosType = BOSObjectType.create((String)"CC3E933B");
    protected static final BOSObjectType PurInWarehsDestBosType = BOSObjectType.create((String)"783061E3");
    protected static final BOSObjectType ArOtherBillDestBosType = BOSObjectType.create((String)"FC910EF3");
    protected static final BOSObjectType ApOtherBillDestBosType = BOSObjectType.create((String)"48DA3A71");
    protected static final Timestamp NOW_TIME = new Timestamp(new Date().getTime());
    public static final int DEFAULT_PRICISION = 2;
    protected int localPrecision = 2;
    protected int saleLocalPrecision = 2;
    protected int balanceLocalPrecision = 2;
    protected static final BigDecimal ZERO = new BigDecimal(0);
    protected static final BigDecimal PRECENT = new BigDecimal(100);
    protected static final BigDecimal ONE = new BigDecimal(1);
    protected boolean isSaleReturn = false;
    protected boolean isSaleReturnCoreBill = false;

    protected Map transform(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        BTPTransformResult transformResult = null;
        HashMap<String, CoreBillBaseInfo> map = new HashMap<String, CoreBillBaseInfo>();
        if (model != null && model.getBOSType().toString().equals("CC3E933B")) {
            CoreBillBaseInfo saleIssueBillInfo = (CoreBillBaseInfo)model;
            CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
            coreBillBaseColl.add(saleIssueBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, SaleIssueDestBosType.toString(), (IObjectPK)new ObjectStringPK(this.isSaleReturn ? SaleIssueToSaleIssue_Sale_Return_Mapping : SaleIssueToSaleIssue_Sale_Mapping));
            CoreBillBaseInfo destSaleBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destSaleBillInfo.setNumber("*" + saleIssueBillInfo.getNumber());
            destSaleBillInfo.setAuditor(userInfo);
            destSaleBillInfo.setTimestamp("auditTime", NOW_TIME);
            destSaleBillInfo.setInt("baseStatus", 4);
            map.put(SaleIssueToSaleIssue_Sale_Mapping, destSaleBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, SaleIssueDestBosType.toString(), (IObjectPK)new ObjectStringPK(this.isSaleReturn ? SaleIssueToSaleIssue_Balance_Return_Mapping : SaleIssueToSaleIssue_Balance_Mapping));
            CoreBillBaseInfo destBalanceSaleBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destBalanceSaleBillInfo.setNumber("**" + saleIssueBillInfo.getNumber());
            destBalanceSaleBillInfo.setAuditor(userInfo);
            destBalanceSaleBillInfo.setTimestamp("auditTime", NOW_TIME);
            destBalanceSaleBillInfo.setInt("baseStatus", 4);
            map.put(SaleIssueToSaleIssue_Balance_Mapping, destBalanceSaleBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, PurInWarehsDestBosType.toString(), (IObjectPK)new ObjectStringPK(this.isSaleReturn ? SaleIssueToPurInWarehs_Sale_Return_Mapping : SaleIssueToPurInWarehs_Sale_Mapping));
            CoreBillBaseInfo destPurInBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destPurInBillInfo.setNumber("*" + saleIssueBillInfo.getNumber());
            destPurInBillInfo.setAuditor(userInfo);
            destPurInBillInfo.setTimestamp("auditTime", NOW_TIME);
            destPurInBillInfo.setInt("baseStatus", 4);
            map.put(SaleIssueToPurInWarehs_Sale_Mapping, destPurInBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, PurInWarehsDestBosType.toString(), (IObjectPK)new ObjectStringPK(this.isSaleReturn ? SaleIssueToPurInWarehs_Balance_Return_Mapping : SaleIssueToPurInWarehs_Balance_Mapping));
            CoreBillBaseInfo destBalancePurInBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destBalancePurInBillInfo.setNumber("**" + saleIssueBillInfo.getNumber());
            destBalancePurInBillInfo.setAuditor(userInfo);
            destBalancePurInBillInfo.setTimestamp("auditTime", NOW_TIME);
            destBalancePurInBillInfo.setInt("baseStatus", 4);
            map.put(SaleIssueToPurInWarehs_Balance_Mapping, destBalancePurInBillInfo);
        } else if (model != null && model.getBOSType().toString().equals("FC910EF3")) {
            CoreBillBaseInfo arOtherBillInfo = (CoreBillBaseInfo)model;
            CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
            coreBillBaseColl.add(arOtherBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, ArOtherBillDestBosType.toString(), (IObjectPK)new ObjectStringPK(ArOtherBillToArOtherBill_Issue_Mapping));
            CoreBillBaseInfo destArOtherBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destArOtherBillInfo.setNumber("*" + arOtherBillInfo.getNumber());
            destArOtherBillInfo.setAuditor(userInfo);
            destArOtherBillInfo.setInt("billStatus", 3);
            destArOtherBillInfo.setDate("auditDate", (Date)NOW_TIME);
            map.put(ArOtherBillToArOtherBill_Issue_Mapping, destArOtherBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, ArOtherBillDestBosType.toString(), (IObjectPK)new ObjectStringPK(ArOtherBillToArOtherBill_Balance_Mapping));
            CoreBillBaseInfo destBalanceArOtherBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destBalanceArOtherBillInfo.setNumber("**" + arOtherBillInfo.getNumber());
            destBalanceArOtherBillInfo.setAuditor(userInfo);
            destBalanceArOtherBillInfo.setInt("billStatus", 3);
            destBalanceArOtherBillInfo.setDate("auditDate", (Date)NOW_TIME);
            map.put(ArOtherBillToArOtherBill_Balance_Mapping, destBalanceArOtherBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, ApOtherBillDestBosType.toString(), (IObjectPK)new ObjectStringPK(ArOtherBillToApOtherBill_Sale_Mapping));
            CoreBillBaseInfo destApOtherBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destApOtherBillInfo.setNumber("*" + arOtherBillInfo.getNumber());
            destApOtherBillInfo.setAuditor(userInfo);
            destApOtherBillInfo.setInt("billStatus", 3);
            destApOtherBillInfo.setDate("auditDate", (Date)NOW_TIME);
            map.put(ArOtherBillToApOtherBill_Sale_Mapping, destApOtherBillInfo);
            transformResult = iBTPManager.transform(coreBillBaseColl, ArOtherBillDestBosType.toString(), (IObjectPK)new ObjectStringPK(ArOtherBillToApOtherBill_Balance_Mapping));
            CoreBillBaseInfo destBalanceApOtherBillInfo = (CoreBillBaseInfo)transformResult.getBills().getObject(0);
            destBalanceApOtherBillInfo.setNumber("**" + arOtherBillInfo.getNumber());
            destBalanceApOtherBillInfo.setAuditor(userInfo);
            destBalanceApOtherBillInfo.setInt("billStatus", 3);
            destBalanceApOtherBillInfo.setDate("auditDate", (Date)NOW_TIME);
            map.put(ArOtherBillToApOtherBill_Balance_Mapping, destBalanceApOtherBillInfo);
        }
        return map;
    }

    protected void afterVirtualBill(Context ctx, CoreBillBaseInfo srcBillInfo, CoreBillBaseInfo destBillBaseInfo) throws BOSException, EASBizException {
        AbstractVirtualBill.traceUpAndDown(ctx, srcBillInfo.getId().toString(), destBillBaseInfo.getId().toString(), srcBillInfo.getBOSType().toString(), destBillBaseInfo.getBOSType().toString());
    }

    private static void traceUpAndDown(Context ctx, String srcId, String desId, String srcBosType, String desBosType) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(desBosType);
        info.setDestObjectID(desId);
        info.setOperatorID("unknown");
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }
}

