/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.scm.common.SCMCommonData;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class BuildSysOrderBillProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public BuildSysOrderBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public BuildSysOrderBillProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public BuildSysOrderBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        boolean isAudit = false;
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            isAudit = true;
        } else if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            isAudit = false;
        } else {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            ObjectUuidPK pk = new ObjectUuidPK(aInvBillBaseInfo.getId().toString());
            if (isAudit) {
                this.buildOrderOrReturnBill(this.ctx, (IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getId().toString()), aInvBillBaseInfo);
                continue;
            }
            this.delBuildOrderOrReturnBill(this.ctx, (IObjectPK)pk, aInvBillBaseInfo);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildOrderOrReturnBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        Statement stmt;
        Connection conn;
        String tempTable;
        block23: {
            CompanyOrgUnitInfo cou;
            String transType;
            boolean isReversed;
            block25: {
                block24: {
                    TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
                    if (tti == null) {
                        return;
                    }
                    if (!this.isBuildOrderOrRetBill(ctx, aInvBillBaseInfo)) {
                        return;
                    }
                    isReversed = aInvBillBaseInfo.isIsReversed();
                    BillTypeInfo bti = aInvBillBaseInfo.getBillType();
                    if (tti.getBillType() == null || tti.getRiType() == null) {
                        ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
                        tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()));
                    }
                    if ((transType = this.getTransType(bti.getId().toString(), tti.getRiType().getBizDirection())) == null) {
                        return;
                    }
                    cou = null;
                    if (this.getExecuteContext() == null || this.getExecuteContext().getApplicationContext() == null) break block24;
                    Object obj = this.getExecuteContext().getApplicationContext().getData("commonData");
                    if (obj != null && obj instanceof SCMCommonData) {
                        SCMCommonData commonData = (SCMCommonData)obj;
                        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
                        if (iObjectCollection != null && iObjectCollection.size() > 0) {
                            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
                            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
                            if (aCompanyOrgUnitInfo == null) throw new InvBizException(InvBizException.AP_NOCOMPANY);
                            if (aCompanyOrgUnitInfo.getId() == null) {
                                throw new InvBizException(InvBizException.AP_NOCOMPANY);
                            }
                            cou = (CompanyOrgUnitInfo)commonData.getCompanys().get(aCompanyOrgUnitInfo.getId().toString());
                        }
                    }
                    break block25;
                }
                cou = this.getComanyOrgUnit(ctx, aInvBillBaseInfo);
            }
            int pcs = 2;
            if (cou != null && cou.getBaseCurrency() != null) {
                pcs = cou.getBaseCurrency().getPrecision();
            }
            int precision = pcs;
            StringBuffer createTempTable = new StringBuffer();
            createTempTable.append("Create Table tt").append("(");
            createTempTable.append("FSaleOrderNumber Varchar(200),");
            createTempTable.append("FSaleOrderEntrySeq int default 0,");
            createTempTable.append("FSaleOrderID Varchar(44),");
            createTempTable.append("FSaleOrderEntryID Varchar(44),");
            createTempTable.append("FCoreBillTypeID Varchar(44),");
            createTempTable.append("FEntryID Varchar(44));");
            tempTable = KsqlUtil.createTempTable((Context)ctx, (String)createTempTable.toString());
            conn = null;
            stmt = null;
            try {
                block29: {
                    block31: {
                        StringBuffer stringBuff;
                        String bizTypeID;
                        String billTypeID;
                        String entryBosType;
                        String billBosType;
                        String ordEntryName;
                        String ordTableName;
                        String invEntryName;
                        String invTableName;
                        IRowSet rs;
                        block30: {
                            block26: {
                                block28: {
                                    StringBuffer stringBuff2;
                                    String bizTypeID2;
                                    String billTypeID2;
                                    String entryBosType2;
                                    String billBosType2;
                                    String ordEntryName2;
                                    String ordTableName2;
                                    String invEntryName2;
                                    String invTableName2;
                                    block27: {
                                        conn = EJBFactory.getConnection((Context)ctx);
                                        stmt = conn.createStatement();
                                        rs = null;
                                        if (transType.equals("sal")) {
                                            if (isReversed) {
                                                SaleIssueBillInfo siInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
                                                this.updateSaleOrderBill(siInfo, conn, ctx);
                                                break block23;
                                            } else {
                                                CoreBaseCollection infos = this.transformSystemBillViaBotp((CoreBillBaseInfo)aInvBillBaseInfo, ctx);
                                                this.fillAndSaveSystemBill(infos, ctx);
                                                this.reWriteSaleIssueBill(infos, conn, ctx);
                                            }
                                            break block23;
                                        }
                                        if (!transType.equals("pur")) break block26;
                                        invTableName2 = "T_IM_PurInWarehsBill";
                                        invEntryName2 = "T_IM_PurInwarehsEntry";
                                        ordTableName2 = "T_SM_PurOrder";
                                        ordEntryName2 = "T_SM_PurOrderEntry";
                                        billBosType2 = new PurOrderInfo().getBOSType().toString();
                                        entryBosType2 = new PurOrderEntryInfo().getBOSType().toString();
                                        billTypeID2 = "510b6503-0105-1000-e000-010bc0a812fd463ED552";
                                        bizTypeID2 = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
                                        stringBuff2 = new StringBuffer();
                                        stringBuff2.append("select FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID from T_IM_PurInwarehsEntry where FParentID = '");
                                        stringBuff2.append(pk.toString());
                                        stringBuff2.append("' Group By FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID");
                                        if (!isReversed) break block27;
                                        ArrayList orderList = this.getPurOrdersID(ctx, pk, aInvBillBaseInfo, transType);
                                        if (orderList != null) {
                                            int size = orderList.size();
                                            for (int index = 0; index < size; ++index) {
                                                this.updateOrderOrReturnBill(ctx, stmt, transType, invEntryName2, ordTableName2, ordEntryName2, pk.toString(), (String)orderList.get(index), precision);
                                            }
                                        }
                                        break block28;
                                    }
                                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff2.toString());
                                    String numberTag = "*";
                                    while (rs.next()) {
                                        String orderBillID = BOSUuid.create((String)billBosType2).toString();
                                        String purOrgUnit = rs.getString("FPurchaseOrgUnitID");
                                        String purGroup = rs.getString("FPurchaseGroupID");
                                        String purPerson = rs.getString("FPurchasePersonID");
                                        String number = numberTag + aInvBillBaseInfo.getNumber();
                                        String insertOrderEntrySql = this.getInsertOrderEntrySql(transType, invTableName2, invEntryName2, ordEntryName2, entryBosType2, pk.toString(), orderBillID, precision, purOrgUnit, purGroup, purPerson);
                                        String insertOrderBillSql = this.getInsertOrderBillSql(transType, invTableName2, invEntryName2, ordTableName2, ordEntryName2, number, pk.toString(), orderBillID, billTypeID2, bizTypeID2, purOrgUnit, purGroup, purPerson);
                                        String updateSql = this.getUpdateSql(ctx, transType, invTableName2, invEntryName2, ordTableName2, ordEntryName2, orderBillID, pk.toString(), tempTable);
                                        stmt.addBatch(insertOrderEntrySql);
                                        stmt.addBatch(insertOrderBillSql);
                                        stmt.addBatch(updateSql.split(";")[0]);
                                        stmt.addBatch(updateSql.split(";")[1]);
                                        numberTag = numberTag + "*";
                                    }
                                }
                                stmt.executeBatch();
                                break block23;
                            }
                            if (!transType.equals("purRet")) break block29;
                            invTableName = "T_IM_PurInWarehsBill";
                            invEntryName = "T_IM_PurInwarehsEntry";
                            ordTableName = "T_SM_PurReturns";
                            ordEntryName = "T_SM_PurReturnsEntry";
                            billBosType = new PurReturnsInfo().getBOSType().toString();
                            entryBosType = new PurReturnsEntryInfo().getBOSType().toString();
                            billTypeID = "50957179-0105-1000-e006-6152c0a812fd463ED552";
                            bizTypeID = "d8e80652-0107-1000-e000-04c5c0a812202407435C";
                            stringBuff = new StringBuffer();
                            stringBuff.append("select FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID from T_IM_PurInwarehsEntry where FParentID =  '");
                            stringBuff.append(pk.toString());
                            stringBuff.append("' Group By FPurchaseOrgUnitID, FPurchaseGroupID, FPurchasePersonID");
                            if (!isReversed) break block30;
                            ArrayList orderList = this.getPurOrdersID(ctx, pk, aInvBillBaseInfo, transType);
                            if (orderList != null) {
                                int size = orderList.size();
                                for (int index = 0; index < size; ++index) {
                                    this.updateOrderOrReturnBill(ctx, stmt, transType, invEntryName, ordTableName, ordEntryName, pk.toString(), (String)orderList.get(index), precision);
                                }
                            }
                            break block31;
                        }
                        rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                        String numberTag = "*";
                        while (rs.next()) {
                            String orderBillID = BOSUuid.create((String)billBosType).toString();
                            String purOrgUnit = rs.getString("FPurchaseOrgUnitID");
                            String purGroup = rs.getString("FPurchaseGroupID");
                            String purPerson = rs.getString("FPurchasePersonID");
                            String number = numberTag + aInvBillBaseInfo.getNumber();
                            String insertOrderEntrySql = this.getInsertOrderEntrySql(transType, invTableName, invEntryName, ordEntryName, entryBosType, pk.toString(), orderBillID, precision, purOrgUnit, purGroup, purPerson);
                            String insertOrderBillSql = this.getInsertOrderBillSql(transType, invTableName, invEntryName, ordTableName, ordEntryName, number, pk.toString(), orderBillID, billTypeID, bizTypeID, purOrgUnit, purGroup, purPerson);
                            String updateSql = this.getUpdateSql(ctx, transType, invTableName, invEntryName, ordTableName, ordEntryName, orderBillID, pk.toString(), tempTable);
                            stmt.addBatch(insertOrderEntrySql);
                            stmt.addBatch(insertOrderBillSql);
                            stmt.addBatch(updateSql.split(";")[0]);
                            stmt.addBatch(updateSql.split(";")[1]);
                            numberTag = numberTag + "*";
                        }
                    }
                    stmt.executeBatch();
                    break block23;
                }
                if (transType.equals("salRet")) {
                    this.updateSoureBill(ctx, pk, aInvBillBaseInfo, true);
                }
            }
            catch (SQLException ex) {
                try {
                    Logger.error((Throwable)ex);
                    throw new BOSException((Throwable)ex);
                    catch (Exception e) {
                        Logger.error((Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }

    private boolean isBuildOrderOrRetBill(Context ctx, InvBillBaseInfo ivbInfo) throws EASBizException, BOSException {
        InvBillBaseEntryInfo entry;
        String bizCategoryId;
        String billType = ivbInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType) && !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            return false;
        }
        BizTypeInfo bizType = ivbInfo.getBizType();
        if (bizType.getBizCategory() == null) {
            bizType = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizType.getId()));
        }
        if ((bizCategoryId = bizType.getBizCategory().getId().toString()).equals("+f4mYqj4xUGaNf69/HWRdqk4kCA=") || bizCategoryId.equals("6LFeB81CJ0mD3wyAekUV7Kk4kCA=")) {
            return false;
        }
        String coreBillId = null;
        if (ivbInfo.getEntries() != null && ivbInfo.getEntries().size() > 0 && (entry = (InvBillBaseEntryInfo)ivbInfo.getEntries().getObject(0)) != null) {
            coreBillId = entry.getCoreBillId();
        }
        return (bizCategoryId.equals("88a7587a-e010-497b-9f86-b8f00ab2fe72A9389020") || bizCategoryId.equals("88a7587a-e015-497b-9f86-b8f00ab2fe72A9389020")) && StringUtil.isEmpty(coreBillId);
    }

    private boolean isDeleteOrderOrRetBill(Context ctx, InvBillBaseInfo ivbInfo) throws EASBizException, BOSException {
        String billType = ivbInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType) && !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            return false;
        }
        String bizTypeID = "";
        if (ivbInfo.getBizType() != null) {
            bizTypeID = ivbInfo.getBizType().getId().toString();
        }
        if (bizTypeID.equals("1x7KMBq4mUmpj58T4jNPqiQHQ1w=") || bizTypeID.equals("WelYLYZybUG8XkVZygC6PSQHQ1w=") || bizTypeID.equals("fJRJ3EF19QngQKjAYj0KxSQHQ1w=") || bizTypeID.equals("cm2OIC07JkyQ+M1S9LxbyCQHQ1w=") || bizTypeID.equals("gD7iVt0xekC5tFu/OjJ/dyQHQ1w=")) {
            return false;
        }
        boolean isBotp = false;
        if (ivbInfo.getSourceBillType() != null) {
            isBotp = true;
        }
        boolean isSysBill = false;
        String coreBillTypeId = "";
        String coreBillId = "";
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
            PurReturnsInfo purRet;
            PurInWarehsBillInfo piInfo = (PurInWarehsBillInfo)ivbInfo;
            coreBillTypeId = piInfo.getEntry().get(0).getCoreBillTypeId();
            coreBillId = piInfo.getEntry().get(0).getPurOrder();
            if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId)) {
                PurOrderInfo purOrder = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(coreBillId));
                if (purOrder.isIsSysBill()) {
                    isSysBill = true;
                }
            } else if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(coreBillTypeId) && (purRet = PurReturnsFactory.getLocalInstance((Context)ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(coreBillId))).isIsSysBill()) {
                isSysBill = true;
            }
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            SaleIssueBillInfo siInfo = (SaleIssueBillInfo)ivbInfo;
            coreBillTypeId = siInfo.getEntry().get(0).getCoreBillTypeId();
            coreBillId = siInfo.getEntry().get(0).getSaleOrder();
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId)) {
                SaleOrderInfo saleOrder = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(coreBillId));
                if (saleOrder.isIsSysBill()) {
                    isSysBill = true;
                }
            } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(coreBillTypeId)) {
                isSysBill = true;
            }
        }
        return isSysBill && !isBotp;
    }

    private ArrayList getPurOrdersID(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, String transType) throws BOSException, EASBizException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PurInWarehsBillInfo purInfo = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillInfo(pk);
        PurInWarehsEntryCollection entryCollection = purInfo.getEntry();
        if (entryCollection != null) {
            for (int index = 0; index < entryCollection.size(); ++index) {
                String purOrderID = entryCollection.get(index).getPurOrder();
                if (arrayList.contains(purOrderID)) continue;
                arrayList.add(purOrderID);
            }
        }
        return arrayList;
    }

    private String getUpdateSql(Context ctx, String transType, String invTableName, String invEntryName, String ordTableName, String ordEntryName, String orderBillID, String billID, String tempTable) throws BOSException, EASBizException {
        StringBuffer stringBuffer = new StringBuffer();
        if (transType.equals("pur")) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-010bc0a812fd463ED552");
            stringBuffer.append("', c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else if (transType.equals("sal")) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-0113c0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FSaleOrderNumber, FSaleOrderEntrySeq,  ");
            stringBuffer.append("FSaleOrderID, FSaleOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else if ("purRet".equals(transType)) {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("50957179-0105-1000-e006-6152c0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        } else {
            stringBuffer.append("insert into ").append(tempTable).append(" ");
            stringBuffer.append("SELECT A.FNumber, B.FSeq, A.FID, B.FID,'");
            stringBuffer.append("510b6503-0105-1000-e000-010bc0a812fd463ED552");
            stringBuffer.append("',c.fid FROM " + ordTableName + " A INNER JOIN " + ordEntryName + " B ON A.FID = B.FParentID ");
            stringBuffer.append(" INNER JOIN " + invEntryName + " c ON c.FSeq = B.FSeq");
            stringBuffer.append(" WHERE A.FID = '").append(orderBillID).append("' ");
            stringBuffer.append("AND c.FParentID='").append(billID).append("' ;");
            stringBuffer.append("UPDATE " + invEntryName + " SET ");
            stringBuffer.append("(FPurOrderNumber, FPurOrderEntrySeq,  ");
            stringBuffer.append("FPurOrderID, FPurOrderEntryID, FCoreBillTypeID) = ");
            stringBuffer.append("(SELECT FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, ");
            stringBuffer.append("FSaleOrderEntryID, FCoreBillTypeID FROM  ").append(tempTable);
            stringBuffer.append(" t WHERE t.FEntryID=" + invEntryName + ".FID);");
        }
        return stringBuffer.toString();
    }

    private String getInsertOrderEntrySql(String transType, String invTableName, String invEntryName, String ordEntryName, String bosType, String billID, String orderBillID, int precision, String orgID, String groupID, String personID) {
        String taxRate = null;
        taxRate = transType.equals("pur") || transType.equals("purRet") ? "Decimal(ISNULL((SELECT ISNULL(FTaxRate/100, 0) FROM T_BD_SUPPLIER WHERE FID = (SELECT FSupplierID FROM T_IM_PurInWarehsBill WHERE FID = '" + billID + "')),0),21,8)" : "Decimal(ISNULL((SELECT ISNULL(FTaxRate/100, 0) FROM T_BD_MaterialSales WHERE FMaterialID = A.FMaterialID AND FOrgUnit = A.FSaleOrgUnitID),0),21,8)";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + ordEntryName + "(");
        stringBuffer.append("FID,");
        stringBuffer.append("FSeq,");
        stringBuffer.append("FAssCoefficient,");
        stringBuffer.append("FBaseStatus,");
        stringBuffer.append("FMaterialID,");
        stringBuffer.append("FUnitID,");
        stringBuffer.append("FBaseUnitID,");
        stringBuffer.append("FAssistUnitID,");
        stringBuffer.append("FIsPresent,");
        stringBuffer.append("FAssistPropertyID,");
        stringBuffer.append("FQty,");
        stringBuffer.append("FStorageOrgUnitID,");
        stringBuffer.append("FCompanyOrgUnitID,");
        stringBuffer.append("FAssistQty,");
        stringBuffer.append("FBaseQty,");
        stringBuffer.append("FRemark,");
        stringBuffer.append("FParentID,");
        if (transType.equals("pur")) {
            stringBuffer.append("FVersion,");
            stringBuffer.append("FRequestOrgUnitID,");
            stringBuffer.append("FTotalUnReturnBaseQty,");
            stringBuffer.append("FDeliveryDate,");
            stringBuffer.append("FCloseDate,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax,");
            stringBuffer.append("FLocalAmount,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("FPREPAYMENT,");
            stringBuffer.append("FDemandQty,");
            stringBuffer.append("FTotalUnReceiveBaseQty,");
            stringBuffer.append("FTotalUnReceiveQty,");
            stringBuffer.append("FDiscountRate,");
            stringBuffer.append("FDiscountAmount,");
            stringBuffer.append("FActualPrice)");
        } else if (transType.equals("sal")) {
            stringBuffer.append("FDeliveryCustomerID,");
            stringBuffer.append("FReceiveCustomerID,");
            stringBuffer.append("FPaymentCustomerID,");
            stringBuffer.append("FDiscountType,");
            stringBuffer.append("FTotalUnReturnBaseQty,");
            stringBuffer.append("FDeliveryDate,");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax,");
            stringBuffer.append("FSendDate,");
            stringBuffer.append("FLocalAmount)");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("FClosedDate,");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FLocationID,");
            stringBuffer.append("FLot,");
            stringBuffer.append("FUninvoicedQty,");
            stringBuffer.append("FUninvoicedBaseQty,");
            stringBuffer.append("FUnreturnedQty,");
            stringBuffer.append("FUnReturnedBaseQty,");
            stringBuffer.append("FReturnedQty,");
            stringBuffer.append("FReturnedBaseQty,");
            stringBuffer.append("FInvoicedQty,");
            stringBuffer.append("FInvoicedAmount,");
            stringBuffer.append("FInvoicedBaseQty,");
            stringBuffer.append("FTotalReturnAmt,");
            stringBuffer.append("FLocalAmount,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("FTotalInvoicedAmt,");
            stringBuffer.append("FReturnsDate,");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax)");
        }
        stringBuffer.append("SELECT ");
        stringBuffer.append("NEWBOSID('" + bosType + "'),");
        stringBuffer.append("FSeq,");
        stringBuffer.append("0,");
        stringBuffer.append("7,");
        stringBuffer.append("FMaterialID,");
        stringBuffer.append("FUnitID,");
        stringBuffer.append("FBaseUnitID,");
        stringBuffer.append("FAssistUnitID,");
        stringBuffer.append("FIsPresent,");
        stringBuffer.append("FAssistPropertyID,");
        stringBuffer.append("ABS(FQty),");
        stringBuffer.append("C.FStorageOrgUnitID,");
        stringBuffer.append("FCompanyOrgUnitID,");
        stringBuffer.append("ABS(FAssistQty),");
        stringBuffer.append("ABS(FBaseQty),");
        stringBuffer.append("a.FRemark,");
        stringBuffer.append("'" + orderBillID + "',");
        if (transType.equals("pur")) {
            stringBuffer.append("0,");
            stringBuffer.append("C.FStorageOrgUnitID,");
            stringBuffer.append("FBaseQty,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("FTaxPrice,");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax,");
            stringBuffer.append("FPurchaseCost,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("0,");
            stringBuffer.append("FQty,");
            stringBuffer.append("FBaseQty,");
            stringBuffer.append("FQty,");
            stringBuffer.append("FDiscountRate,");
            stringBuffer.append("FDiscountAmount,");
            stringBuffer.append("FActualPrice");
        } else if (transType.equals("sal")) {
            stringBuffer.append("C.FCustomerID,");
            stringBuffer.append("A.FBalanceCustomerID,");
            stringBuffer.append("A.FPaymentCustomerID,");
            stringBuffer.append("-1,");
            stringBuffer.append("FBaseQty,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("FPrice,");
            stringBuffer.append("ROUND(FAmount," + precision + "),");
            stringBuffer.append("ROUND(Decimal(FPrice / (1 + " + taxRate + "),21,8),B.FPricePrecision),");
            stringBuffer.append(taxRate + " * 100,");
            stringBuffer.append("ROUND(Decimal(FAmount / (1 + " + taxRate + "),17,4)," + precision + "),");
            stringBuffer.append("ROUND(FAmount," + precision + ") - ROUND(Decimal(FAmount / (1 + " + taxRate + "),17,4)," + precision + "),");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("ROUND(Decimal(FAmount / (1 + " + taxRate + "),17,4)," + precision + ")");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("FWarehouseID,");
            stringBuffer.append("FLocationID,");
            stringBuffer.append("FLot,");
            stringBuffer.append("ABS(FQty),");
            stringBuffer.append("ABS(FBaseQty),");
            stringBuffer.append("ABS(FQty),");
            stringBuffer.append("ABS(FBaseQty),");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("FPurchaseCost,");
            stringBuffer.append("FLocalTax,");
            stringBuffer.append("FLocalTaxAmount,");
            stringBuffer.append("0,");
            stringBuffer.append("(SELECT FBizDate FROM " + invTableName + " WHERE FID = '" + billID + "'),");
            stringBuffer.append("FActualTaxPrice,");
            stringBuffer.append("FTaxAmount,");
            stringBuffer.append("FActualPrice,");
            stringBuffer.append("FTaxRate,");
            stringBuffer.append("FAmount,");
            stringBuffer.append("FTax");
        }
        stringBuffer.append(" FROM " + invEntryName + " A");
        stringBuffer.append(" INNER JOIN T_BD_Material B ON A.FMaterialID = B.FID ");
        stringBuffer.append(" LEFT JOIN ").append(invTableName).append(" C ON C.FID = A.FParentID ");
        stringBuffer.append(" WHERE FParentID = '" + billID + "'");
        if (transType.equals("sal")) {
            if (orgID == null || orgID.equals("")) {
                stringBuffer.append(" And FSaleOrgUnitID is null");
            } else {
                stringBuffer.append(" And FSaleOrgUnitID ='" + orgID + "'");
            }
            if (groupID == null || groupID.equals("")) {
                stringBuffer.append(" And FSaleGroupID is null");
            } else {
                stringBuffer.append(" And FSaleGroupID ='" + groupID + "'");
            }
            if (personID == null || personID.equals("")) {
                stringBuffer.append(" And FSalePersonID is null");
            } else {
                stringBuffer.append(" And FSalePersonID ='" + personID + "'");
            }
        } else if (transType.equals("pur") || transType.equals("purRet")) {
            if (orgID == null || orgID.equals("")) {
                stringBuffer.append(" And FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" And FPurchaseOrgUnitID ='" + orgID + "'");
            }
            if (groupID == null || groupID.equals("")) {
                stringBuffer.append(" And FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" And FPurchaseGroupID ='" + groupID + "'");
            }
            if (personID == null || personID.equals("")) {
                stringBuffer.append(" And FPurchasePersonID is null");
            } else {
                stringBuffer.append(" And FPurchasePersonID ='" + personID + "'");
            }
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private void updateOrderOrReturnBill(Context ctx, Statement stmt, String transType, String invEntryName, String ordTableName, String ordEntryName, String billID, String orderBillID, int precision) throws BOSException, EASBizException {
        StringBuffer updateEntryFields = new StringBuffer();
        updateEntryFields.append("UPDATE " + ordEntryName);
        if (transType.equals("pur")) {
            updateEntryFields.append(" SET (FTotalUnReturnBaseQty,FDemandQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        } else if (transType.equals("sal")) {
            updateEntryFields.append(" SET (FTotalUnReturnBaseQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        } else {
            updateEntryFields.append(" SET (FUninvoicedQty,FUninvoicedBaseQty,FQty,FAssistQty,FBaseQty,FAmount,FTax,FTaxAmount) = ");
        }
        updateEntryFields.append(" (SELECT ");
        if (transType.equals("pur")) {
            updateEntryFields.append(" (" + ordEntryName + ".FTotalUnReturnBaseQty - ABS(A.FBaseQty)),");
            updateEntryFields.append(" (" + ordEntryName + ".FDemandQty - ABS(A.FQty)),");
        } else if (transType.equals("sal")) {
            updateEntryFields.append(" (" + ordEntryName + ".FTotalUnReturnBaseQty - ABS(A.FBaseQty)),");
        } else {
            updateEntryFields.append(" (" + ordEntryName + ".FUninvoicedQty - ABS(A.FQty)),");
            updateEntryFields.append(" (" + ordEntryName + ".FUninvoicedBaseQty - ABS(A.FBaseQty)),");
        }
        updateEntryFields.append(" (" + ordEntryName + ".FQty - ABS(A.FQty)),");
        updateEntryFields.append(" (" + ordEntryName + ".FAssistQty - ABS(A.FAssistQty)),");
        updateEntryFields.append(" (" + ordEntryName + ".FBaseQty - ABS(A.FBaseQty)),");
        updateEntryFields.append(" ROUND(Decimal((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice,17,4)," + precision + "),");
        updateEntryFields.append(" ROUND(Decimal(Decimal(((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice),17,4) * Decimal(" + ordEntryName + ".FTAXRATE/100,21,8),17,4)," + precision + "),");
        updateEntryFields.append(" ROUND(Decimal((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice,17,4)," + precision + ") + ");
        updateEntryFields.append(" ROUND(Decimal(Decimal(((" + ordEntryName + ".FQty - ABS(A.FQty)) * " + ordEntryName + ".FPrice),17,4) * Decimal(" + ordEntryName + ".FTAXRATE/100,21,8),17,4)," + precision + ")");
        updateEntryFields.append(" FROM " + invEntryName + " A ");
        if (transType.equals("sal")) {
            updateEntryFields.append(" WHERE A.FSaleOrderEntryID = " + ordEntryName + ".FID");
        } else {
            updateEntryFields.append(" WHERE A.FPurOrderEntryID = " + ordEntryName + ".FID");
        }
        updateEntryFields.append(" AND " + ordEntryName + ".FParentID = '" + orderBillID + "' AND A.FParentID = '" + billID + "');");
        StringBuffer updateHeadFields = new StringBuffer();
        updateHeadFields.append("UPDATE " + ordTableName);
        updateHeadFields.append(" SET FTotalAmount = (SELECT ISNULL(SUM(FAmount),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),");
        updateHeadFields.append(" FTotalTax = (SELECT ISNULL(SUM(FTax),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),");
        updateHeadFields.append(" FTotalTaxAmount = (SELECT ISNULL(SUM(FTaxAmount),0) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "')");
        updateHeadFields.append(" WHERE FID = '" + orderBillID + "';");
        try {
            stmt.addBatch(updateEntryFields.toString());
            stmt.addBatch(updateHeadFields.toString());
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getInsertOrderBillSql(String transType, String invTableName, String invEntryName, String ordTableName, String ordEntryName, String number, String billID, String orderBillID, String billTypeID, String bizTypeID, String orgID, String groupID, String personID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + ordTableName + "(");
        stringBuffer.append("FID,");
        stringBuffer.append("FCreatorID,");
        stringBuffer.append("FCreateTime,");
        stringBuffer.append("FModifierID,");
        stringBuffer.append("FModificationTime,");
        stringBuffer.append("FLastUpdateUserID,");
        stringBuffer.append("FLastUpdateTime,");
        stringBuffer.append("FControlUnitID,");
        stringBuffer.append("FNumber,");
        stringBuffer.append("FBizDate,");
        stringBuffer.append("FHandlerID,");
        stringBuffer.append("FAuditorID,");
        stringBuffer.append("FAuditTime,");
        stringBuffer.append("FBaseStatus,");
        stringBuffer.append("FBillTypeID,");
        stringBuffer.append("FBizTypeID,");
        stringBuffer.append("FYear,");
        stringBuffer.append("FPeriod,");
        stringBuffer.append("FCurrencyID,");
        stringBuffer.append("FExchangeRate,");
        stringBuffer.append("FAdminOrgUnitID,");
        stringBuffer.append("FTotalAmount,");
        stringBuffer.append("FTotalTax,");
        stringBuffer.append("FTotalTaxAmount,");
        stringBuffer.append("FIsSysBill,");
        if (transType.equals("pur")) {
            stringBuffer.append("FCompanyOrgUnitID,");
            stringBuffer.append("FVersion,");
            stringBuffer.append("FPaymentTypeID,");
            stringBuffer.append("FSupplierID,");
            stringBuffer.append("FSupplierAddress,");
            stringBuffer.append("FSettlementTypeID,");
            stringBuffer.append("FCashDiscountID,");
            stringBuffer.append("FIsInnerSale,");
            stringBuffer.append("FIsDirectSend,");
            stringBuffer.append("FPurchaseOrgUnitID,");
            stringBuffer.append("FPurchaseGroupID,");
            stringBuffer.append("FIsInTax,");
            stringBuffer.append("FIsPriceInTax,");
            stringBuffer.append("FConvertMode,");
            stringBuffer.append("FPurchasePersonID)");
        } else if (transType.equals("sal")) {
            stringBuffer.append("FCompanyOrgUnitID,");
            stringBuffer.append("FPaymentTypeID,");
            stringBuffer.append("FDeliveryTypeID,");
            stringBuffer.append("FOrderCustomerID,");
            stringBuffer.append("FSendAddress,");
            stringBuffer.append("FSettlementTypeID,");
            stringBuffer.append("FCashDiscountID,");
            stringBuffer.append("FIsInnerSale,");
            stringBuffer.append("FSaleOrgUnitID,");
            stringBuffer.append("FSaleGroupID,");
            stringBuffer.append("FSalePersonID)");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("FSupplierID,");
            stringBuffer.append("FPurchaseOrgUnitID,");
            stringBuffer.append("FPurchaseGroupID,");
            stringBuffer.append("FPurchasePersonID,");
            stringBuffer.append("FConvertMode,");
            stringBuffer.append("FIsInTax)");
        }
        stringBuffer.append("SELECT DISTINCT ");
        stringBuffer.append("'" + orderBillID + "',");
        stringBuffer.append("A.FCreatorID,");
        stringBuffer.append("A.FCreateTime,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("A.FControlUnitID,");
        stringBuffer.append("'" + number + "',");
        stringBuffer.append("A.FBizDate,");
        stringBuffer.append("A.FHandlerID,");
        stringBuffer.append("A.FLastUpdateUserID,");
        stringBuffer.append("A.FLastUpdateTime,");
        stringBuffer.append("7,");
        stringBuffer.append("'" + billTypeID + "',");
        stringBuffer.append("'" + bizTypeID + "',");
        stringBuffer.append("A.FYear,");
        stringBuffer.append("A.FPeriod,");
        stringBuffer.append("A.FCurrencyID,");
        stringBuffer.append("A.FExchangeRate,");
        stringBuffer.append("A.FAdminOrgUnitID,");
        stringBuffer.append("ISNULL((SELECT SUM(FAmount) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("ISNULL((SELECT SUM(FTax) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("ISNULL((SELECT SUM(FTaxAmount) FROM " + ordEntryName + " WHERE FParentID = '" + orderBillID + "'),0),");
        stringBuffer.append("1,");
        if (transType.equals("pur")) {
            stringBuffer.append("B.FCompanyOrgUnitID,");
            stringBuffer.append("0,");
            stringBuffer.append("A.FPaymentTypeID,");
            stringBuffer.append("A.FSupplierID,");
            stringBuffer.append("(SELECT FAddress FROM T_BD_Supplier WHERE FID = A.FSupplierID),");
            stringBuffer.append("(SELECT FSettlementTypeID FROM T_BD_SupplierCompanyInfo WHERE FComOrgID = B.FCompanyOrgUnitID AND FSupplierID = A.FSupplierID),");
            stringBuffer.append("NULL,");
            stringBuffer.append("0,");
            stringBuffer.append("0,");
            stringBuffer.append("B.FPurchaseOrgUnitID,");
            stringBuffer.append("B.FPurchaseGroupID,");
            stringBuffer.append("A.FIsInTax,");
            stringBuffer.append("A.FIsPriceInTax,");
            stringBuffer.append("A.FConvertMode,");
            stringBuffer.append("B.FPurchasePersonID");
        } else if (transType.equals("sal")) {
            stringBuffer.append("B.FCompanyOrgUnitID,");
            stringBuffer.append("A.FPaymentTypeID,");
            stringBuffer.append("'521733ca-0105-1000-e000-00e2c0a8123362E9EE3F',");
            stringBuffer.append("A.FCustomerID,");
            stringBuffer.append("(SELECT FAddress FROM T_BD_Customer WHERE FID = A.FCustomerID),");
            stringBuffer.append("(SELECT FSettlementTypeID FROM T_BD_CustomerCompanyInfo WHERE FComOrgID = B.FCompanyOrgUnitID AND FCustomerID = A.FCustomerID),");
            stringBuffer.append("NULL,");
            stringBuffer.append("(CASE WHEN (SELECT FIsInternalCompany FROM T_BD_Customer WHERE FID = A.FCustomerID) = 1 THEN 1 ELSE 0 END),");
            stringBuffer.append("B.FSaleOrgUnitID,");
            stringBuffer.append("B.FSaleGroupID,");
            stringBuffer.append("B.FSalePersonID");
        } else if (transType.equals("purRet")) {
            stringBuffer.append("A.FSupplierID,");
            stringBuffer.append("B.FPurchaseOrgUnitID,");
            stringBuffer.append("B.FPurchaseGroupID,");
            stringBuffer.append("B.FPurchasePersonID,");
            stringBuffer.append("A.FConvertMode,");
            stringBuffer.append("A.FIsInTax");
        }
        stringBuffer.append(" FROM " + invTableName + " A");
        stringBuffer.append(" INNER JOIN " + invEntryName + " B ON A.FID = B.FParentID");
        stringBuffer.append(" WHERE A.FID = '" + billID + "'");
        if (transType.equals("pur")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FPurchasePersonID is null ;");
            } else {
                stringBuffer.append(" AND B.FPurchasePersonID = '" + personID + "';");
            }
        } else if (transType.equals("sal")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FSaleOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FSaleOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FSaleGroupID is null");
            } else {
                stringBuffer.append(" AND B.FSaleGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FSalePersonID is null;");
            } else {
                stringBuffer.append(" AND B.FSalePersonID = '" + personID + "';");
            }
        } else if (transType.equals("purRet")) {
            if (orgID == null) {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseOrgUnitID = '" + orgID + "'");
            }
            if (groupID == null) {
                stringBuffer.append(" AND B.FPurchaseGroupID is null");
            } else {
                stringBuffer.append(" AND B.FPurchaseGroupID = '" + groupID + "'");
            }
            if (personID == null) {
                stringBuffer.append(" AND B.FPurchasePersonID is null ;");
            } else {
                stringBuffer.append(" AND B.FPurchasePersonID = '" + personID + "';");
            }
        }
        return stringBuffer.toString();
    }

    private void updateSaleOrderBill(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.updateSaleOrderEntry(siInfo, conn, ctx);
        this.updateSaleOrderHead(siInfo, conn, ctx);
    }

    private void updateSaleOrderEntry(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        String updateEntrySql = "update t_sd_saleorderentry set FTotalUnReturnBaseQty=?,FQty=?,FAssistQty=?,FBaseQty=?,FAmount=?,FTax=?,FTaxAmount=? where fid = ?";
        PreparedStatement pmUpdateEntry = conn.prepareStatement("update t_sd_saleorderentry set FTotalUnReturnBaseQty=?,FQty=?,FAssistQty=?,FBaseQty=?,FAmount=?,FTax=?,FTaxAmount=? where fid = ?");
        for (int i = 0; i < siInfo.getEntry().size(); ++i) {
            SaleIssueEntryInfo entry = siInfo.getEntry().get(i);
            SaleOrderEntryInfo saleOrderEntry = iSaleOrderEntry.getSaleOrderEntryInfo("where id='" + entry.getSaleOrderEntry() + "'");
            BigDecimal totalUnReturnBaseQty = saleOrderEntry.getTotalUnReturnBaseQty().subtract(entry.getBaseQty().abs());
            BigDecimal qty = saleOrderEntry.getQty().subtract(entry.getQty().abs());
            BigDecimal assistQty = saleOrderEntry.getAssistQty().subtract(entry.getAssistQty().abs());
            BigDecimal baseQty = saleOrderEntry.getBaseQty().subtract(entry.getBaseQty());
            BigDecimal amount = qty.multiply(saleOrderEntry.getPrice()).setScale(saleOrderEntry.getAmount().scale(), 4);
            BigDecimal tax = amount.multiply(saleOrderEntry.getTaxRate()).setScale(saleOrderEntry.getTax().scale(), 4);
            BigDecimal taxAmount = amount.add(tax);
            pmUpdateEntry.setBigDecimal(1, totalUnReturnBaseQty);
            pmUpdateEntry.setBigDecimal(2, qty);
            pmUpdateEntry.setBigDecimal(3, assistQty);
            pmUpdateEntry.setBigDecimal(4, baseQty);
            pmUpdateEntry.setBigDecimal(5, amount);
            pmUpdateEntry.setBigDecimal(6, tax);
            pmUpdateEntry.setBigDecimal(7, taxAmount);
            pmUpdateEntry.setString(8, entry.getSaleOrderEntry());
            pmUpdateEntry.addBatch();
        }
        pmUpdateEntry.executeBatch();
        pmUpdateEntry.close();
    }

    private void updateSaleOrderHead(SaleIssueBillInfo siInfo, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        String updateHeadSql = "update t_sd_saleorder set ftotalamount = (select sum(isnull(famount, 0)) from t_sd_saleorderentry where fparentid=?),ftotalTax = (select sum(isnull(ftax, 0)) from t_sd_saleorderentry where fparentid=?),ftotaltaxamount = (select sum(isnull(ftaxamount, 0)) from t_sd_saleorderentry where fparentid=?) where fid = ?";
        PreparedStatement pmUpdateHead = conn.prepareStatement("update t_sd_saleorder set ftotalamount = (select sum(isnull(famount, 0)) from t_sd_saleorderentry where fparentid=?),ftotalTax = (select sum(isnull(ftax, 0)) from t_sd_saleorderentry where fparentid=?),ftotaltaxamount = (select sum(isnull(ftaxamount, 0)) from t_sd_saleorderentry where fparentid=?) where fid = ?");
        HashSet<String> soSet = new HashSet<String>();
        for (int i = 0; i < siInfo.getEntry().size(); ++i) {
            SaleIssueEntryInfo entry = siInfo.getEntry().get(i);
            if (soSet.contains(entry.getSaleOrder())) continue;
            soSet.add(entry.getSaleOrder());
            pmUpdateHead.setString(1, entry.getSaleOrder());
            pmUpdateHead.setString(2, entry.getSaleOrder());
            pmUpdateHead.setString(3, entry.getSaleOrder());
            pmUpdateHead.setString(4, entry.getSaleOrder());
            pmUpdateHead.addBatch();
        }
        pmUpdateHead.executeBatch();
        pmUpdateHead.close();
    }

    private void reWriteSaleIssueBill(CoreBaseCollection infos, Connection conn, Context ctx) throws BOSException, EASBizException, SQLException {
        String updateSql = "update T_IM_SaleIssueEntry set FSaleOrderNumber = ?, FSaleOrderEntrySeq = ?, FSaleOrderID = ?, FSaleOrderEntryID = ?, FCoreBillTypeID = ? where fid = ?";
        PreparedStatement pmUpdate = conn.prepareStatement("update T_IM_SaleIssueEntry set FSaleOrderNumber = ?, FSaleOrderEntrySeq = ?, FSaleOrderID = ?, FSaleOrderEntryID = ?, FCoreBillTypeID = ? where fid = ?");
        for (int infoLoop = 0; infoLoop < infos.size(); ++infoLoop) {
            SaleOrderInfo info = (SaleOrderInfo)infos.getObject(infoLoop);
            for (int entryLoop = 0; entryLoop < info.getEntries().size(); ++entryLoop) {
                SaleOrderEntryInfo entry = info.getEntries().get(entryLoop);
                pmUpdate.setString(1, info.getNumber());
                pmUpdate.setInt(2, entry.getSeq());
                pmUpdate.setString(3, info.getId().toString());
                pmUpdate.setString(4, entry.getId().toString());
                pmUpdate.setString(5, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
                pmUpdate.setString(6, entry.getSourceBillEntryId());
                pmUpdate.addBatch();
            }
        }
        pmUpdate.executeBatch();
        pmUpdate.close();
    }

    private CoreBaseCollection transformSystemBillViaBotp(CoreBillBaseInfo aInvBillBaseInfo, Context ctx) throws BOSException, EASBizException {
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add(aInvBillBaseInfo);
        BOTMappingInfo botMappingInfo = null;
        String botpName = "SaleIssue_SaleOrder_SysOrderBill";
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name='SaleIssue_SaleOrder_SysOrderBill'");
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        IObjectCollection infos = transformResult.getBills();
        CoreBaseCollection bills = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            infos.getObject(i).setString("number", aInvBillBaseInfo.getNumber());
            bills.add((CoreBaseInfo)infos.getObject(i));
        }
        return bills;
    }

    private void fillAndSaveSystemBill(CoreBaseCollection infos, Context ctx) throws BOSException, EASBizException {
        String numberFlag = "";
        for (int infoLoop = 0; infoLoop < infos.size(); ++infoLoop) {
            SaleOrderInfo info = (SaleOrderInfo)infos.getObject(infoLoop);
            numberFlag = numberFlag + "*";
            info.setNumber(numberFlag + info.getNumber());
            info.setIsSysBill(true);
            for (int entryLoop = 0; entryLoop < info.getEntries().size(); ++entryLoop) {
                SaleOrderEntryInfo entry = info.getEntries().get(entryLoop);
                entry.setSeq(entryLoop + 1);
            }
        }
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        iSaleOrder.handleAfterTransform("SAVE", (IObjectCollection)infos);
        iSaleOrder.addnew(infos);
    }

    private CompanyOrgUnitInfo getComanyOrgUnit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            if (aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
                throw new InvBizException(InvBizException.AP_NOCOMPANY);
            }
            ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
            if (aCompanyOrgUnitInfo.getBaseCurrency() == null || aCompanyOrgUnitInfo.getBaseCurrency().getId() == null) {
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                aCompanyOrgUnitInfo = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId()));
            }
            CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()));
            aCompanyOrgUnitInfo.setBaseCurrency(ci);
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    private void updateSoureBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, boolean isAudit) throws BOSException, EASBizException {
        if (aInvBillBaseInfo.isIsReversed()) {
            return;
        }
        String billTypeID = aInvBillBaseInfo.getBillType().getId().toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            int i;
            int size;
            SaleIssueEntryCollection coll;
            String billTypeid;
            String sql;
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) && aInvBillBaseInfo instanceof SaleIssueBillInfo) {
                if (isAudit) {
                    sql = "update T_IM_SaleIssueEntry set FSaleOrderNumber =?,FSaleOrderID =?,FSaleOrderEntrySeq=?,FSaleOrderEntryID=?,FCoreBillTypeID=?  where fid = ?";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
                    SaleIssueBillInfo aSaleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo(pk);
                    String saleOrderNumber = aSaleIssueBillInfo.getNumber().trim();
                    String saleOrderID = aSaleIssueBillInfo.getId().toString();
                    billTypeid = billTypeID;
                    coll = aSaleIssueBillInfo.getEntry();
                    if (coll != null) {
                        size = coll.size();
                        for (i = 0; i < size; ++i) {
                            SaleIssueEntryInfo aSaleIssueEntryInfo = coll.get(i);
                            stmt.setString(1, saleOrderNumber);
                            stmt.setString(2, saleOrderID);
                            stmt.setInt(3, aSaleIssueEntryInfo.getSeq());
                            stmt.setString(4, aSaleIssueEntryInfo.getId().toString());
                            stmt.setString(5, billTypeid);
                            stmt.setString(6, aSaleIssueEntryInfo.getId().toString());
                            stmt.addBatch();
                        }
                    }
                    if (coll.size() > 0) {
                        stmt.executeBatch();
                    }
                } else {
                    sql = "update T_IM_SaleIssueEntry set FSaleOrderNumber =null,FSaleOrderID =null,FSaleOrderEntrySeq= null,FSaleOrderEntryID=null,FCoreBillTypeID=null  where fparentid = '" + aInvBillBaseInfo.getId().toString() + "'";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    stmt.execute();
                }
            }
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) && aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
                if (isAudit) {
                    sql = "update T_IM_PurInWarehsEntry set FPurOrderNumber =?,FPurOrderID =?,FPurOrderEntrySeq=?,FPurOrderEntryID=?,FCoreBillTypeID=?  where fid = ?";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
                    PurInWarehsBillInfo aPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo(pk);
                    String purOrderNumber = aPurInWarehsBillInfo.getNumber().trim();
                    String purOrderID = aPurInWarehsBillInfo.getId().toString();
                    billTypeid = billTypeID;
                    coll = aPurInWarehsBillInfo.getEntry();
                    if (coll != null) {
                        size = coll.size();
                        for (i = 0; i < size; ++i) {
                            PurInWarehsEntryInfo aPurInWarehsEntryInfo = coll.get(i);
                            stmt.setString(1, purOrderNumber);
                            stmt.setString(2, purOrderID);
                            stmt.setInt(3, aPurInWarehsEntryInfo.getSeq());
                            stmt.setString(4, aPurInWarehsEntryInfo.getId().toString());
                            stmt.setString(5, billTypeid);
                            stmt.setString(6, aPurInWarehsEntryInfo.getId().toString());
                            stmt.addBatch();
                        }
                    }
                    if (coll.size() > 0) {
                        stmt.executeBatch();
                    }
                } else {
                    sql = "update T_IM_PurInWarehsEntry set FPurOrderNumber =null,FPurOrderID =null,FPurOrderEntrySeq=null,FPurOrderEntryID=null,FCoreBillTypeID=null  where fparentid = '" + aInvBillBaseInfo.getId().toString() + "'";
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.prepareStatement(sql);
                    stmt.execute();
                }
            }
        }
        catch (SQLException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }

    private void delBuildOrderOrReturnBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        String transType;
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return;
        }
        if (!this.isDeleteOrderOrRetBill(ctx, aInvBillBaseInfo)) {
            return;
        }
        boolean isReversed = aInvBillBaseInfo.isIsReversed();
        String invTableName = null;
        String invEntryName = null;
        String ordTableName = null;
        String ordEntryName = null;
        BillTypeInfo bti = aInvBillBaseInfo.getBillType();
        if (tti.getBillType() == null || tti.getRiType() == null) {
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()));
        }
        if ((transType = this.getTransType(bti.getId().toString(), tti.getRiType().getBizDirection())) == null) {
            return;
        }
        if (transType.equals("pur")) {
            invTableName = "T_IM_PurInWarehsBill";
            invEntryName = "T_IM_PurInwarehsEntry";
            ordTableName = "T_SM_PurOrder";
            ordEntryName = "T_SM_PurOrderEntry";
        } else if (transType.equals("sal")) {
            invTableName = "T_IM_SaleIssueBill";
            invEntryName = "T_IM_SaleIssueEntry";
            ordTableName = "T_SD_SaleOrder";
            ordEntryName = "T_SD_SaleOrderEntry";
        } else if (transType.equals("purRet")) {
            invTableName = "T_IM_PurInWarehsBill";
            invEntryName = "T_IM_PurInwarehsEntry";
            ordTableName = "T_SM_PurReturns";
            ordEntryName = "T_SM_PurReturnsEntry";
        }
        try {
            IRowSet rs = null;
            IRowSet rsSaleIssuer = null;
            if (transType.equals("sal")) {
                StringBuffer stringBuff = new StringBuffer();
                stringBuff.append("select distinct FSaleOrderID from T_IM_SaleIssueEntry where FParentID = '");
                stringBuff.append(pk.toString());
                stringBuff.append("'");
                if (!isReversed) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    Vector<String> vOrderID = new Vector<String>(0);
                    StringBuffer strSaleIssue = new StringBuffer();
                    while (rs.next()) {
                        strSaleIssue.setLength(0);
                        strSaleIssue.append("select distinct bill.FID from  T_IM_SaleIssueBill bill ");
                        strSaleIssue.append(" left outer join T_IM_SaleIssueEntry entry ");
                        strSaleIssue.append(" on  bill.FID = entry.FParentID ");
                        strSaleIssue.append(" where entry.FSaleOrderID = '");
                        strSaleIssue.append(rs.getString("FSaleOrderID"));
                        strSaleIssue.append("'");
                        strSaleIssue.append(" and bill.FBaseStatus = 4");
                        rsSaleIssuer = DbUtil.executeQuery((Context)ctx, (String)strSaleIssue.toString());
                        if (rsSaleIssuer.next()) {
                            return;
                        }
                        vOrderID.add(rs.getString("FSaleOrderID"));
                    }
                    if (vOrderID.size() > 0) {
                        String inid = SCMServerUtils.getInID(vOrderID);
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("pur")) {
                StringBuffer stringBuff = new StringBuffer();
                stringBuff.append("select distinct FPurOrderID from T_IM_PurInwarehsEntry where FParentID = '");
                stringBuff.append(pk.toString());
                stringBuff.append("'");
                if (!isReversed) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    Vector<String> vOrderID = new Vector<String>(0);
                    while (rs.next()) {
                        vOrderID.add(rs.getString("FPurOrderID"));
                    }
                    if (vOrderID.size() > 0) {
                        String inid = SCMServerUtils.getInID(vOrderID);
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("purRet")) {
                StringBuffer stringBuff = new StringBuffer();
                stringBuff.append("select distinct FPurOrderID from T_IM_PurInwarehsEntry where FParentID = '");
                stringBuff.append(pk.toString());
                stringBuff.append("'");
                if (!isReversed) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)stringBuff.toString());
                    Vector<String> vOrderID = new Vector<String>(0);
                    while (rs.next()) {
                        vOrderID.add(rs.getString("FPurOrderID"));
                    }
                    if (vOrderID.size() > 0) {
                        String inid = SCMServerUtils.getInID(vOrderID);
                        String delOrderEntrySql = "delete " + ordEntryName + " where Fparentid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderEntrySql);
                        String delOrderBillSql = "delete " + ordTableName + " where Fid " + inid;
                        DbUtil.execute((Context)ctx, (String)delOrderBillSql);
                        String sql = this.getUpdateClearSql(transType, invTableName, invEntryName, pk.toString());
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                }
            } else if (transType.equals("salRet")) {
                this.updateSoureBill(ctx, pk, aInvBillBaseInfo, false);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private String getUpdateClearSql(String transType, String invTableName, String invEntryName, String billId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE " + invEntryName + " SET");
        if (transType.equals("pur")) {
            stringBuffer.append(" FPurOrderNumber = null,FPurOrderEntrySeq = null,FPurOrderID = null,FPurOrderEntryID = null,FCoreBillTypeID  = null ");
        } else if (transType.equals("sal")) {
            stringBuffer.append(" FSaleOrderNumber = null,FSaleOrderEntrySeq = null,FSaleOrderID = null,FSaleOrderEntryID = null,FCoreBillTypeID = null ");
        } else {
            stringBuffer.append(" FPurOrderNumber = null,FPurOrderEntrySeq = null,FPurOrderID = null,FPurOrderEntryID = null,FCoreBillTypeID = null ");
        }
        stringBuffer.append(" WHERE " + invEntryName + ".FParentID = '" + billId + "'");
        return stringBuffer.toString();
    }

    private String getTransType(String billTypeID, BizDirectionEnum bizDirection) {
        String transType = null;
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) && bizDirection == BizDirectionEnum.normal) {
            transType = "pur";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) && bizDirection == BizDirectionEnum.normal) {
            transType = "sal";
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID) && bizDirection == BizDirectionEnum.back) {
            transType = "purRet";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID) && bizDirection == BizDirectionEnum.back) {
            transType = "salRet";
        }
        return transType;
    }
}

