/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.ICreditBalanceUpdateFacade;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.DefaultDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Map;

public class CreditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -3683012697585400306L;

    public CreditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public CreditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public CreditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block7: {
            ICreditBalanceUpdateFacade iCreditBalanceUpdateFacade;
            IObjectCollection objCol;
            block8: {
                block6: {
                    if (batchResults == null || batchResults.getObjCollection() == null) {
                        return;
                    }
                    objCol = batchResults.getObjCollection();
                    iCreditBalanceUpdateFacade = CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)this.ctx);
                    if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) break block6;
                    Map<String, Object> paramMap = this.getParamMap();
                    if (paramMap.get("isCloseCredit") != null && ((Boolean)paramMap.get("isCloseCredit")).booleanValue()) {
                        return;
                    }
                    int size = objCol.size();
                    for (int i = 0; i < size; ++i) {
                        SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
                        iCreditBalanceUpdateFacade.updateBalance(new Object[]{info.getId()}, CreditOperationEnum.AUDIT);
                    }
                    break block7;
                }
                if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) break block8;
                int size = objCol.size();
                for (int i = 0; i < size; ++i) {
                    SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
                    iCreditBalanceUpdateFacade.updateBalance(new Object[]{info.getId()}, CreditOperationEnum.UNAUDIT);
                }
                break block7;
            }
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) break block7;
            IRowSet rs = null;
            IDataCache dataCache = this.getDataCacheFromContext();
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
                if (info.getId() != null) {
                    rs = (IRowSet)dataCache.get(info.getId().toString(), DataTypeEnum.CREDIT_TEMP_TABLE);
                }
                iCreditBalanceUpdateFacade.updateBalance(new Object[]{info.getId()}, rs, CreditOperationEnum.SUBMIT);
            }
        }
    }

    private Map<String, Object> getParamMap() throws BOSException, EASBizException {
        IDataCache dataCache = this.getDataCacheFromContext();
        Map paramMap = dataCache.getDataMapByType(DataTypeEnum.PARAMS);
        if (paramMap == null || paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance((Context)this.ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
            paramMap = paramMap == null ? new HashMap() : paramMap;
            dataCache.putAll(DataTypeEnum.PARAMS, paramMap);
        }
        return paramMap;
    }

    private IDataCache getDataCacheFromContext() {
        ExecuteContext executeContext = this.getExecuteContext();
        DefaultDataCache dataCache = null;
        if (executeContext != null) {
            dataCache = (IDataCache)executeContext.getApplicationContext().getData("CONTEXT_KEY_DATACACHE");
        }
        return dataCache == null ? new DefaultDataCache() : dataCache;
    }
}

