/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import java.util.ArrayList;

public class CreditUnCloseProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 9203016555444210692L;

    public CreditUnCloseProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public CreditUnCloseProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public CreditUnCloseProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        ArrayList<String> idList = new ArrayList<String>(objCol.size());
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseInfo info = (InvBillBaseInfo)objCol.getObject(i);
            if (!info.isIsReversed()) continue;
            idList.add(info.getId().toString());
        }
        if (idList.size() > 0) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)this.ctx).updateBalance(idList.toArray(), CreditOperationEnum.UNCLOSE);
        }
    }
}

