/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMCommonData;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMBizDataCheckProcessor;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class InvBizDataCheckProcessor
extends SCMBizDataCheckProcessor {
    private static final long serialVersionUID = -438181556580865075L;
    protected Map matInventoryMap = null;
    protected Map matCompanyMap = null;
    protected Map matPlansMap = new HashMap();
    protected Map companyMap = null;
    protected Map specialParammap = null;
    public final String stringNo = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"No", (Context)this.ctx);
    public final String stringRow = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"Row", (Context)this.ctx);

    public InvBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public InvBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public InvBizDataCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected IObjectCollection getEntryCollection(InvBillBaseInfo aInvBillBaseInfo) {
        if (aInvBillBaseInfo == null) {
            return new InvBillBaseEntryCollection();
        }
        if (aInvBillBaseInfo.getBillType() != null && "50957179-0105-1000-e002-2152c0a812fd463ED552".equals(aInvBillBaseInfo.getBillType().getId().toString())) {
            return (IObjectCollection)aInvBillBaseInfo.get("entries");
        }
        return (IObjectCollection)aInvBillBaseInfo.get("entry");
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        SCMCommonData commonData;
        InvBillBaseEntryInfo entry;
        InvBillBaseInfo invBillBaseInfo;
        IObjectValue vo;
        super.doProcessing(batchResults);
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            return;
        }
        IObjectCollection entrys = null;
        ArrayList<String> matIdList = new ArrayList<String>();
        ArrayList<String> companyOrgIdList = new ArrayList<String>();
        ArrayList<String> storageOrgIdList = new ArrayList<String>();
        String[] sOrgIds = new String[collection.size()];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            vo = collection.getObject(i);
            if (vo == null) continue;
            invBillBaseInfo = (InvBillBaseInfo)vo;
            entrys = this.getEntryCollection(invBillBaseInfo);
            sOrgIds[i] = invBillBaseInfo.getStorageOrgUnit() != null ? invBillBaseInfo.getStorageOrgUnit().getId().toString() : null;
            if (entrys == null) continue;
            int len = entrys.size();
            for (int j = 0; j < len; ++j) {
                entry = (InvBillBaseEntryInfo)entrys.getObject(j);
                if (entry == null || entry.getMaterial() == null) continue;
                matIdList.add(entry.getMaterial().getId().toString());
                storageOrgIdList.add(sOrgIds[i]);
                if (entry.getCompanyOrgUnit() != null) {
                    companyOrgIdList.add(entry.getCompanyOrgUnit().getId().toString());
                    continue;
                }
                companyOrgIdList.add(null);
            }
        }
        int leng = matIdList.size();
        String[] matIds = new String[leng];
        String[] companyOrgIds = new String[leng];
        String[] storageOrgIds = new String[leng];
        for (int i = 0; i < leng; ++i) {
            matIds[i] = matIdList.get(i) != null ? matIdList.get(i).toString() : null;
            storageOrgIds[i] = storageOrgIdList.get(i) != null ? storageOrgIdList.get(i).toString() : null;
            companyOrgIds[i] = companyOrgIdList.get(i) != null ? companyOrgIdList.get(i).toString() : null;
        }
        if (this.getExecuteContext() != null && this.getExecuteContext().getApplicationContext() != null && (commonData = (SCMCommonData)this.getExecuteContext().getApplicationContext().getData("commonData")) != null) {
            this.companyMap = commonData.getCompanys();
            this.matCompanyMap = commonData.getFetchData().getMapMaterialCompany();
            this.matInventoryMap = commonData.getFetchData().getMapMaterialInventory();
            this.specialParammap = (Map)commonData.getOtherCommonDatas().get("specialParamMap");
        }
        if (this.companyMap == null || this.companyMap.entrySet().size() <= 0) {
            this.companyMap = this.getCompanyInfos(sOrgIds, OrgType.Storage, OrgType.Company);
        }
        if (this.matCompanyMap == null || this.matCompanyMap.entrySet().size() <= 0) {
            this.matCompanyMap = this.getMatCompanyInfoCollection(matIds, companyOrgIds);
        }
        if (this.matInventoryMap == null || this.matInventoryMap.entrySet().size() <= 0) {
            this.matInventoryMap = this.getMaterialInventoryCollection(matIds, storageOrgIds);
        }
        boolean isCheckProject = true;
        if (this.specialParammap != null && null != this.specialParammap.get("isUseProjectTrack")) {
            isCheckProject = (Boolean)this.specialParammap.get("isUseProjectTrack");
        }
        this.matPlansMap = this.getMaterialPlanCollec(matIds, storageOrgIds);
        int size2 = collection.size();
        for (int i = 0; i < size2; ++i) {
            int j;
            int len;
            vo = collection.getObject(i);
            if (vo == null) continue;
            invBillBaseInfo = (InvBillBaseInfo)vo;
            entrys = this.getEntryCollection(invBillBaseInfo);
            this.checkBizDate4Period(this.ctx, (IObjectValue)invBillBaseInfo);
            if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT) || this.batchAction.equals((Object)BatchActionEnum.AUDIT) || this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                this.checkAccountClosed(this.ctx, (SCMBillBaseInfo)invBillBaseInfo);
            }
            if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
                if (!BillBaseStatusEnum.ADD.equals((Object)invBillBaseInfo.getBaseStatus()) && !BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)invBillBaseInfo.getBaseStatus())) {
                    throw new InvBizException(InvBizException.AUDITBILLDONOTSUBMITORSAVE, new Object[]{invBillBaseInfo.getNumber()});
                }
                if (invBillBaseInfo.getStorageOrgUnit() == null) {
                    throw new InvBizException(InvBizException.STOREORG_IS_NULL, (Object[])new String[]{invBillBaseInfo.getNumber()});
                }
                if (invBillBaseInfo.isIsInitBill()) {
                    this.checkInitBizDate((IObjectValue)invBillBaseInfo);
                    continue;
                }
                if (!this.isCheckBizDate()) continue;
                this.checkBizDate(this.ctx, (IObjectValue)invBillBaseInfo);
                continue;
            }
            if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                if (invBillBaseInfo.getStorageOrgUnit() == null) {
                    throw new InvBizException(InvBizException.STOREORG_IS_NULL, (Object[])new String[]{invBillBaseInfo.getNumber()});
                }
                if (entrys == null || entrys.size() == 0) {
                    throw new InvBizException(InvBizException.ENTRY_NULL, (Object[])new String[]{invBillBaseInfo.getNumber()});
                }
                if (this.companyMap.get(invBillBaseInfo.getStorageOrgUnit().getId().toString()) == null) {
                    throw new InvBizException(InvBizException.STORAGEORGNOTHASCOMPANYORG, (Object[])new String[]{invBillBaseInfo.getNumber()});
                }
                if (invBillBaseInfo.getTransactionType() == null) {
                    throw new InvBizException(InvBizException.TRANSTYPE_IS_NULL, new Object[]{invBillBaseInfo.getNumber()});
                }
                if (this.isNeedSourceBillForIndustry() && invBillBaseInfo.isIsReversed() && invBillBaseInfo.getSourceBillType() == null) {
                    throw new InvBizException(InvBizException.INV_NOSRCBILL, new Object[]{invBillBaseInfo.getNumber()});
                }
                this.checkIsStart(invBillBaseInfo);
                if (invBillBaseInfo.isIsInitBill()) {
                    this.checkInitBizDate((IObjectValue)invBillBaseInfo);
                } else if (this.isCheckBizDate()) {
                    this.checkBizDate(this.ctx, (IObjectValue)invBillBaseInfo);
                }
                if (entrys == null) continue;
                if (this.isCheckEntrySourceBillInfo()) {
                    this.checkEntrySourceBillForBOTP(invBillBaseInfo);
                    boolean isSameCoreBillType = this.checkEntryCoreBillType(invBillBaseInfo);
                    if (!isSameCoreBillType) {
                        throw new InvBizException(InvBizException.CANNOTSUBMIT_NOTSAMECOREBILL);
                    }
                }
                len = entrys.size();
                for (j = 0; j < len; ++j) {
                    MaterialPlanInfo mpInfo;
                    entry = (InvBillBaseEntryInfo)entrys.getObject(j);
                    if (entry.getMaterial() == null) {
                        entrys.removeObject(j);
                        continue;
                    }
                    if (entry.getMaterial().getNumber() == null) {
                        throw new InvBizException(InvBizException.MATERIALNUMISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (entry.getMaterial().getAssistAttr() != null && entry.getAssistProperty() == null) {
                        throw new InvBizException(InvBizException.ASSISTPROPERTYISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (invBillBaseInfo.getStorageOrgUnit() != null && invBillBaseInfo.getStorageOrgUnit().getId() != null && entry.getMaterial() != null && entry.getMaterial().getId() != null && (mpInfo = (MaterialPlanInfo)this.matPlansMap.get(entry.getMaterial().getId().toString() + invBillBaseInfo.getStorageOrgUnit().getId().toString())) != null) {
                        boolean isBotp = false;
                        if (invBillBaseInfo.getSourceBillType() != null) {
                            isBotp = true;
                        }
                        InvServerUtils.checkProjectTrackIsNotNull((Context)this.ctx, (boolean)isBotp, (int)(j + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNumber());
                    }
                    if (entry != null && entry.getUnit() != null && entry.getBaseUnit() != null) {
                        if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString()) && entry.getQty().compareTo(entry.getBaseQty()) != 0) {
                            throw new InvBizException(InvBizException.BASEQTYNOTMATCH, (Object[])new String[]{invBillBaseInfo.getNumber(), "" + (j + 1)});
                        }
                        if (entry.getQty() != null && SysConstant.BIGZERO.compareTo(entry.getQty()) != 0 && (entry.getBaseQty() == null || entry.getBaseQty().compareTo(SysConstant.BIGZERO) == 0)) {
                            throw new InvBizException(InvBizException.BASEQTYNULL, (Object[])new String[]{invBillBaseInfo.getNumber(), "" + (j + 1)});
                        }
                    }
                    if (entry != null && entry.getQty().equals(SysConstant.BIGZERO)) {
                        throw new InvBizException(InvBizException.QTYGREATERZERO, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
                    MaterialCompanyInfoInfo matCompany = (MaterialCompanyInfoInfo)this.matCompanyMap.get(entry.getMaterial().getId().toString() + entry.getCompanyOrgUnit().getId().toString());
                    if (matCompany == null) {
                        throw new InvBizException(InvBizException.MATERIALNOTFI, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (entry.getWarehouse() == null) {
                        throw new InvBizException(InvBizException.WAREHOUSEISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (entry.getUnit() == null) {
                        throw new InvBizException(InvBizException.UNITISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (entry.getWarehouse().isHasLocation() && entry.getLocation() == null) {
                        throw new InvBizException(InvBizException.LOCATIONISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (invBillBaseInfo.getStorageOrgUnit() != null) {
                        MaterialInventoryInfo invInfo = (MaterialInventoryInfo)this.matInventoryMap.get(entry.getMaterial().getId().toString() + invBillBaseInfo.getStorageOrgUnit().getId().toString());
                        if (null != invInfo && invInfo.isIsLotNumber() && (entry.getLot() == null || entry.getLot().trim().length() == 0)) {
                            throw new InvBizException(InvBizException.BATCHISNULL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                        }
                        if (invInfo != null && invInfo.isIsPeriodValid()) {
                            if (entry.getMfg() == null || entry.getExp() == null) {
                                throw new InvBizException(InvBizException.MATERIAL_IS_PERIODVALID, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                            }
                            entryList.add(entry);
                        }
                    }
                    if (entryList == null) continue;
                    int count = entryList.size();
                    for (int k = 0; k < count; ++k) {
                        InvBillBaseEntryInfo billEntry = (InvBillBaseEntryInfo)entryList.get(k);
                        for (int z = k; z < entryList.size() - 1; ++z) {
                            if (!billEntry.getLot().equals(((InvBillBaseEntryInfo)entryList.get(z)).getLot()) || !billEntry.getMaterial().getId().toString().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMaterial().getId().toString()) || billEntry.getMfg().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMfg()) && billEntry.getExp().equals(((InvBillBaseEntryInfo)entryList.get(z)).getExp())) continue;
                            throw new InvBizException(InvBizException.DUPLICATELOTSALL, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (z + 1) + this.stringRow});
                        }
                    }
                }
                continue;
            }
            if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                if (invBillBaseInfo.getBaseStatus().getValue() != 2) {
                    throw new SCMBillException(SCMBillException.CHECKAUDITEDOK, new Object[]{invBillBaseInfo.getNumber()});
                }
                if (invBillBaseInfo.isIsInitBill()) {
                    this.checkInitBizDate((IObjectValue)invBillBaseInfo);
                } else if (this.isCheckBizDate()) {
                    this.checkBizDate(this.ctx, (IObjectValue)invBillBaseInfo);
                }
                if (entrys == null) continue;
                len = entrys.size();
                for (j = 0; j < len; ++j) {
                    entry = (InvBillBaseEntryInfo)entrys.getObject(j);
                    MaterialCompanyInfoInfo matCompany = (MaterialCompanyInfoInfo)this.matCompanyMap.get(entry.getMaterial().getId().toString() + entry.getCompanyOrgUnit().getId().toString());
                    if (matCompany != null) continue;
                    throw new InvBizException(InvBizException.MATERIALNOTFI, (Object[])new String[]{invBillBaseInfo.getNumber() + this.stringNo + (j + 1) + this.stringRow});
                }
                continue;
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT) || invBillBaseInfo.getBaseStatus() == null || invBillBaseInfo.getBaseStatus().getValue() == 4) continue;
            throw new SCMBillException(SCMBillException.CHECKSUBMITNOTOK, new Object[]{invBillBaseInfo.getNumber()});
        }
    }

    protected boolean checkBizDate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)model, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(ctx, model), (boolean)false);
    }

    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    protected void checkEntrySourceBillForBOTP(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (aInvBillBaseInfo.getSourceBillType() != null) {
            IObjectCollection col = aInvBillBaseInfo.getEntries();
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = null;
            String billtypeId = null;
            BillTypeInfo billtype = new BillTypeInfo();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)col.getObject(i);
                if (aInvBillBaseEntryInfo.getSourceBillType() != null) continue;
                if (billtypeId == null) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select fid from t_scm_billtype where fbostype in ").append("(select FSrcEntityID from t_bot_relation where FDestObjectID = '").append(aInvBillBaseInfo.getId().toString()).append("')");
                    IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billtypeId = rs.getString("fid");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                billtype.setId(BOSUuid.read(billtypeId));
                aInvBillBaseInfo.setSourceBillType(billtype);
            }
        }
    }

    protected boolean checkEntryCoreBillType(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        return true;
    }

    public boolean isNeedSourceBillForIndustry() {
        return true;
    }

    protected boolean isCheckEntrySourceBillInfo() {
        return true;
    }

    protected void checkIsStart(InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        TransactionTypeInfo transactionTypeInfo = invBillBaseInfo.getTransactionType();
        IObjectCollection entrys = (IObjectCollection)invBillBaseInfo.get(this.getEntryName());
        boolean isManuAdjustBill = false;
        if (transactionTypeInfo == null && invBillBaseInfo.getBillType() != null && "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(invBillBaseInfo.getBillType().getId().toString())) {
            isManuAdjustBill = CostAdjuestCreateTypeEnum.USERINPUT.equals(invBillBaseInfo.get("createType"));
        }
        Object[] msgs = new String[1];
        if (transactionTypeInfo != null || isManuAdjustBill) {
            msgs[0] = this.checkIsStarted(this.ctx, transactionTypeInfo, entrys, invBillBaseInfo, isManuAdjustBill);
            if (msgs[0].length() > 0) {
                if (transactionTypeInfo != null && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(transactionTypeInfo.getBillType().getId().toString())) {
                    throw new InvBizException(InvBizException.ISSTARTED, msgs);
                }
                throw new InvBizException(InvBizException.ISNOTSTARTED, msgs);
            }
        }
    }

    private String checkIsStarted(Context ctx, TransactionTypeInfo tti, IObjectCollection iObjectCollection, InvBillBaseInfo invBillBaseInfo, boolean isNotChkTti) throws BOSException, EASBizException {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        String msg = "";
        if (invBillBaseInfo.isIsInitBill()) {
            return msg.toString();
        }
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        try {
            invUpdateTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getDefaultInvUpdateType(tti.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((isNotChkTti || invUpdateTypeInfo != null && !invUpdateTypeInfo.isIsNotUpdateInv()) && iObjectCollection != null && iObjectCollection.size() > 0 && (aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0)).getStorageOrgUnit() != null) {
            String storageOrgUnitID = aInvBillBaseEntryInfo.getStorageOrgUnit().getId().toString();
            Vector<BOSUuid> vctSou = new Vector<BOSUuid>();
            for (int i = 0; i < iObjectCollection.size(); ++i) {
                aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
                if (aInvBillBaseEntryInfo.getWarehouse() == null || vctSou.contains(aInvBillBaseEntryInfo.getWarehouse().getId())) continue;
                vctSou.add(aInvBillBaseEntryInfo.getWarehouse().getId());
            }
            Object[] warehouses = null;
            if (vctSou.size() > 0) {
                ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
                warehouses = !isNotChkTti && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(tti.getBillType().getId().toString()) ? iso.isStarted(storageOrgUnitID, vctSou.toArray(), true) : iso.isStarted(storageOrgUnitID, vctSou.toArray(), false);
            }
            if (warehouses != null && warehouses.length > 0) {
                StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitID)));
                for (int i = 0; i < warehouses.length; ++i) {
                    msg = msg + "\n" + sou.getName() + " - " + warehouses[i].toString();
                }
            }
        }
        return msg;
    }

    protected boolean checkInitBizDate(IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (aSCMBillBaseInfo.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.getCompanyOrgUnit(this.ctx, (IObjectValue)aSCMBillBaseInfo);
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (currentPeriodInfo == null) {
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
            }
            if (!aSCMBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                Object[] temp = new String[1];
                StringBuffer sb = new StringBuffer();
                sb.append(currentPeriodInfo.getBeginDate().getYear() + 1900);
                sb.append("-");
                int month = currentPeriodInfo.getBeginDate().getMonth() + 1;
                if (month < 10) {
                    sb.append("0");
                }
                sb.append(month);
                sb.append("-");
                int date = currentPeriodInfo.getBeginDate().getDate();
                if (date < 10) {
                    sb.append("0");
                }
                sb.append(date);
                temp[0] = sb.toString();
                throw new SCMBillException(SCMBillException.BIZDATEAFTERPERIOD, temp);
            }
        }
        return true;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get(this.getEntryName());
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    public boolean setRequiredCostCenter(CompanyOrgUnitInfo cou, TransactionTypeInfo transactionTypeInfo) throws BOSException, EASBizException {
        if (cou == null || transactionTypeInfo == null) {
            return false;
        }
        boolean costManageIsStart = SystemStatusCtrolUtils.isStart((Context)this.ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)cou);
        return costManageIsStart && transactionTypeInfo.isIsManuCostCalculate();
    }

    protected String getEntryName() {
        return "entry";
    }
}

