/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.IMoveInWarehsBill;
import com.kingdee.eas.scm.im.inv.IMoveIssueBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCreateVirtualBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.VirtualBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.AutoCreatePurInBill4VMIHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Vector;

public class InvVirtualBillProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -3163397176182181737L;

    public InvVirtualBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public InvVirtualBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public InvVirtualBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block8: {
            IObjectCollection collection;
            block7: {
                if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction) && !BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
                    return;
                }
                if (batchResults == null || batchResults.getObjCollection() == null) {
                    return;
                }
                collection = batchResults.getObjCollection();
                if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) break block7;
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    String bizTypeID;
                    InvBillBaseInfo invInfo = (InvBillBaseInfo)collection.getObject(i);
                    if (this.isExecuteBizProcess(this.ctx, invInfo)) continue;
                    if (SCMConstant.BOSTYPE_PURINWAREHS.equals(invInfo.getBOSType().toString())) {
                        InvCreateVirtualBillFacadeFactory.getLocalInstance((Context)this.ctx).createVirtualBill((IObjectValue)invInfo);
                        continue;
                    }
                    if (SCMConstant.BOSTYPE_SALEISSUE.equals(invInfo.getBOSType().toString())) {
                        boolean flag = VirtualBillFacadeFactory.getLocalInstance((Context)this.ctx).createVirtualBill((IObjectValue)invInfo);
                        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)invInfo;
                        if (saleIssueBillInfo.getEntry().get(0).isIsSquareBalance()) {
                            return;
                        }
                        if (flag) continue;
                        InvCreateVirtualBillFacadeFactory.getLocalInstance((Context)this.ctx).createVirtualBill((IObjectValue)invInfo);
                        continue;
                    }
                    if (!"500AB75E".equals(invInfo.getBOSType().toString()) || invInfo.getBizType() == null || !(bizTypeID = invInfo.getBizType().getId().toString()).equals("nhvcdx82RzuTw48FSlV79CQHQ1w=") && !bizTypeID.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=") && !bizTypeID.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=")) continue;
                    InvCreateVirtualBillFacadeFactory.getLocalInstance((Context)this.ctx).createVirtualBill((IObjectValue)invInfo);
                }
                break block8;
            }
            if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) break block8;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                InvBillBaseInfo invInfo = (InvBillBaseInfo)collection.getObject(i);
                ObjectUuidPK pk = new ObjectUuidPK(invInfo.getId().toString());
                this.unAuditVirtualBill(this.ctx, (IObjectPK)pk, invInfo);
            }
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected void unAuditVirtualBill(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String transTypeID;
        IInventoryUpdate iInventoryUpdate;
        String transTypeID2;
        IInventoryUpdate iInventoryUpdate2;
        IManualWriteOffFacade iManualWriteOffFacade;
        String[] strIDs;
        if (!(aInvBillBaseInfo instanceof SaleIssueBillInfo || aInvBillBaseInfo instanceof MaterialReqBillInfo || aInvBillBaseInfo instanceof PurInWarehsBillInfo)) {
            return;
        }
        Vector vecPurVisualBill = (Vector)aInvBillBaseInfo.get("purInWarehsVirtualBill");
        Vector vecSaleVisualBill = (Vector)aInvBillBaseInfo.get("purSaleIssueVirtualBill");
        Vector vecMoveInVisualBill = (Vector)aInvBillBaseInfo.get("purMoveInVirtualBill");
        Vector vecMoveIssueVisualBill = (Vector)aInvBillBaseInfo.get("purMoveIssueVirtualBill");
        if (vecSaleVisualBill != null && vecSaleVisualBill.size() > 0) {
            strIDs = new String[vecSaleVisualBill.size()];
            ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int j = 0; j < vecSaleVisualBill.size(); ++j) {
                strIDs[j] = (String)vecSaleVisualBill.get(j);
                SaleIssueBillInfo aSaleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(strIDs[j]));
                iInventoryUpdate2 = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                transTypeID2 = null;
                if (aSaleIssueBillInfo.getTransactionType() != null) {
                    transTypeID2 = aSaleIssueBillInfo.getTransactionType().getId().toString();
                    if (this.isJumpOrg(aSaleIssueBillInfo.getBizType())) {
                        iInventoryUpdate2.updateInventory(BizActionEnum.UNAUDIT, strIDs[j], transTypeID2);
                        new AutoCreatePurInBill4VMIHandler(ctx, strIDs[j], BizActionEnum.UNAUDIT).execute();
                    } else {
                        iInventoryUpdate2.updateInventory(strIDs[j], BizActionEnum.UNAUDIT);
                    }
                }
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[j]});
                this.updateUnAuditStatus(ctx, (IObjectValue)aSaleIssueBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aSaleIssueBillInfo);
                iSaleIssueBill.delete((IObjectPK)new ObjectUuidPK(strIDs[j]));
            }
        }
        if (vecPurVisualBill != null && vecPurVisualBill.size() > 0) {
            strIDs = new String[vecPurVisualBill.size()];
            IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
            iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < vecPurVisualBill.size(); ++i) {
                strIDs[i] = (String)vecPurVisualBill.get(i);
                PurInWarehsBillInfo aPurInWarehsBillInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                iInventoryUpdate2 = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                transTypeID2 = null;
                if (aPurInWarehsBillInfo.getTransactionType() != null) {
                    transTypeID2 = aPurInWarehsBillInfo.getTransactionType().getId().toString();
                    if (this.isJumpOrg(aPurInWarehsBillInfo.getBizType())) {
                        iInventoryUpdate2.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID2);
                    } else {
                        iInventoryUpdate2.updateInventory(strIDs[i], BizActionEnum.UNAUDIT);
                    }
                }
                iManualWriteOffFacade.inverseWriteOff(new String[]{strIDs[i]});
                this.updateUnAuditStatus(ctx, (IObjectValue)aPurInWarehsBillInfo);
                this.calculate(ctx, (InvBillBaseInfo)aPurInWarehsBillInfo);
                iPurInWarehsBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
        if (vecMoveInVisualBill != null && vecMoveInVisualBill.size() > 0) {
            strIDs = new String[vecMoveInVisualBill.size()];
            IMoveInWarehsBill imoveInWarehsBill = MoveInWarehsBillFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < vecMoveInVisualBill.size(); ++i) {
                strIDs[i] = (String)vecMoveInVisualBill.get(i);
                MoveInWarehsBillInfo moveInInfo = imoveInWarehsBill.getMoveInWarehsBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                if (this.isJumpOrg(moveInInfo.getBizType())) {
                    iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID = null;
                    if (moveInInfo.getTransactionType() != null) {
                        transTypeID = moveInInfo.getTransactionType().getId().toString();
                        iInventoryUpdate.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID);
                    }
                }
                this.updateUnAuditStatus(ctx, (IObjectValue)moveInInfo);
                this.calculate(ctx, (InvBillBaseInfo)moveInInfo);
                imoveInWarehsBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
        if (vecMoveIssueVisualBill != null && vecMoveIssueVisualBill.size() > 0) {
            strIDs = new String[vecMoveIssueVisualBill.size()];
            IMoveIssueBill iMoveIssueBill = MoveIssueBillFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < vecMoveIssueVisualBill.size(); ++i) {
                strIDs[i] = (String)vecMoveIssueVisualBill.get(i);
                MoveIssueBillInfo moveIssueBillInfo = iMoveIssueBill.getMoveIssueBillInfo((IObjectPK)new ObjectUuidPK(strIDs[i]));
                if (this.isJumpOrg(moveIssueBillInfo.getBizType())) {
                    iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
                    transTypeID = null;
                    if (moveIssueBillInfo.getTransactionType() != null) {
                        transTypeID = moveIssueBillInfo.getTransactionType().getId().toString();
                        iInventoryUpdate.updateInventory(BizActionEnum.UNAUDIT, strIDs[i], transTypeID);
                    }
                    new AutoCreatePurInBill4VMIHandler(ctx, strIDs[i], BizActionEnum.UNAUDIT).execute();
                }
                this.updateUnAuditStatus(ctx, (IObjectValue)moveIssueBillInfo);
                CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)moveIssueBillInfo);
                iMoveIssueBill.delete((IObjectPK)new ObjectUuidPK(strIDs[i]));
            }
        }
    }

    void calculate(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        if (!this.isJumpOrg(aInvBillBaseInfo.getBizType())) {
            CalculateFacadeFactory.getLocalInstance((Context)ctx).calculate((CoreBillBaseInfo)aInvBillBaseInfo);
        }
    }

    public String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    private void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuilder sqlBuff = new StringBuilder();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, null);
            preStmt.setString(2, null);
            preStmt.setInt(3, 1);
            preStmt.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm);
                SQLUtils.cleanup(preStmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(sm);
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    private boolean isExecuteBizProcess(Context ctx, InvBillBaseInfo info) throws BOSException {
        boolean isExecute = false;
        InvBillBaseEntryInfo entryInfo = null;
        if (!(info instanceof SaleIssueBillInfo || info instanceof MaterialReqBillInfo || info instanceof PurInWarehsBillInfo)) {
            return isExecute;
        }
        EntityObjectInfo entityInfo = CommonUtils.getEntityByBosType((String)info.getBOSType().toString());
        if (entityInfo != null) {
            EntityObjectInfo entryEntity = CommonUtils.getEntryEntityObject((EntityObjectInfo)entityInfo);
            if (entryEntity == null || entryEntity.getTable() == null) {
                return isExecute;
            }
            String tableName = entryEntity.getTable().getName();
            if (StringUtils.isEmpty((String)tableName)) {
                return isExecute;
            }
            if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName)) {
                HashSet<String> idSet = new HashSet<String>();
                IObjectCollection entryColl = (IObjectCollection)info.get("entry");
                if (entryColl != null && entryColl.size() > 0) {
                    int size = entryColl.size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
                        if (entryInfo == null) continue;
                        idSet.add(entryInfo.get("id").toString());
                    }
                    if (SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, idSet)) {
                        isExecute = true;
                    }
                }
            }
        }
        return isExecute;
    }
}

