/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;

public class InventoryUpdateProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -2928674513557897989L;

    public InventoryUpdateProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public InventoryUpdateProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public InventoryUpdateProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return batchResults.hasToDos();
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)vo;
            if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
                this.updateInventory4Audit(this.ctx, aInvBillBaseInfo);
                continue;
            }
            if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
                this.updateInventory4UnAudit(this.ctx, aInvBillBaseInfo);
                continue;
            }
            throw new BOSException("not supported .... (" + this.batchAction.getName() + ")");
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected void updateInventory4Audit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(aInvBillBaseInfo.getId().toString());
        if (aInvBillBaseInfo.getTransactionType() != null && !InvAppUtils.checkBillCreateVirtualbill((Context)ctx, (IObjectValue)aInvBillBaseInfo) && !InvAppUtils.isExecuteBizProcess((Context)ctx, (InvBillBaseInfo)aInvBillBaseInfo)) {
            iInventoryUpdate.updateInventory(pk.toString(), BizActionEnum.AUDIT);
        }
    }

    protected void updateInventory4UnAudit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(aInvBillBaseInfo.getId().toString());
        if (aInvBillBaseInfo.getTransactionType() != null && ctx.get((Object)"isNeedUpdateInventory") == null && !InvAppUtils.checkHasVirtualbill((Context)ctx, (IObjectValue)aInvBillBaseInfo) && !InvAppUtils.isExecuteBizProcess((Context)ctx, (InvBillBaseInfo)aInvBillBaseInfo)) {
            iInventoryUpdate.updateInventory(pk.toString(), BizActionEnum.UNAUDIT);
        }
    }
}

