/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;

public class LotUpdatingProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -3508873210562097196L;

    public LotUpdatingProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public LotUpdatingProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public LotUpdatingProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() == 0) {
            return;
        }
        InvBillBaseInfo aInvBillBaseInfo = null;
        ArrayList<String> idList = new ArrayList<String>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objValue = collection.getObject(i);
            String id = objValue.get(objValue.getPKField()).toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            aInvBillBaseInfo = (InvBillBaseInfo)objValue;
            try {
                if (!this.batchAction.equals((Object)BatchActionEnum.AUDIT) || !this.isNeedInsertLots((IObjectPK)pk, aInvBillBaseInfo)) continue;
                idList.add(id);
                continue;
            }
            catch (Exception e) {
                batchResults.addError(id, e);
            }
        }
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance((Context)this.ctx);
            if (aInvBillBaseInfo != null && aInvBillBaseInfo.getBillType().getId() != null && idList.size() > 0) {
                String[] ids = new String[idList.size()];
                int i = 0;
                for (String id : idList) {
                    ids[i++] = id;
                }
                ido.batchInsertData(ids, aInvBillBaseInfo.getBillType().getId().toString());
            }
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    private boolean isNeedInsertLots(IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        boolean isInsert = false;
        TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
        if (tti == null) {
            return isInsert;
        }
        if (tti.getBillType() == null || tti.getRiType() == null || tti.getRiType().getBizDirection() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("riType.id"));
            sic.add(new SelectorItemInfo("riType.bizDirection"));
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)this.ctx);
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()), sic);
            aInvBillBaseInfo.setTransactionType(tti);
        }
        String billTypeID = tti.getBillType().getId().toString();
        int bizDerection = tti.getRiType().getBizDirection().getValue();
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID) && bizDerection == 1) {
            return this.isNeedInsertLots4PurRec(aInvBillBaseInfo);
        }
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) && bizDerection == 1 || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID) && bizDerection == -1 || this.isRITypeForIndustry(this.ctx, (IObjectValue)aInvBillBaseInfo) && !aInvBillBaseInfo.isIsInitBill() && !aInvBillBaseInfo.isIsReversed() || "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(billTypeID)) {
            isInsert = true;
        }
        return isInsert;
    }

    private boolean isNeedInsertLots4PurRec(InvBillBaseInfo aInvBillBaseInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 1 from T_IM_PurReceivalBill bill").append(" inner join T_IM_PurReceivalEntry e on e.fparentid = bill.fid ").append(" inner join T_IM_InvUpdateType invupd on e.finvUpdateTypeID = invupd.fid ").append(" where invupd.FIsNotUpdateInv = 0 and bill.fid = '").append(aInvBillBaseInfo.getId().toString()).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public boolean isRITypeForIndustry(Context ctx, IObjectValue model) {
        return false;
    }
}

