/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.IReqPlanForSCMFacade;
import com.kingdee.eas.mm.planning.ReqPlanForSCMFacadeFactory;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import java.util.List;

public class ReqPlanForInvProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 6325819762784544364L;

    public ReqPlanForInvProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public ReqPlanForInvProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public ReqPlanForInvProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IReqPlanForSCMFacade iReqPlanForSCMFacade = ReqPlanForSCMFacadeFactory.getLocalInstance((Context)this.ctx);
        String billTypeId = null;
        List toIDList = batchResults.getToDoIdsList();
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection != null && collection.size() > 0) {
            IObjectValue vo = collection.getObject(0);
            SCMBillBaseInfo billInfo = (SCMBillBaseInfo)vo;
            billTypeId = billInfo.getBillType().getId().toString();
        }
        if (toIDList == null || toIDList.size() <= 0) {
            return;
        }
        BizActionEnum operateType = null;
        if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            operateType = BizActionEnum.AUDIT;
        } else if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            operateType = BizActionEnum.UNAUDIT;
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            operateType = BizActionEnum.SUBMIT;
        } else {
            return;
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId)) {
            SaleIssueBillInfo saleIssueInfo = (SaleIssueBillInfo)collection.getObject(0);
            String companyID = InvServerUtils.getCompanyInfoForStorage((Context)this.ctx, (StorageOrgUnitInfo)saleIssueInfo.getStorageOrgUnit()).getId().toString();
            ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
            String paramValue = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)companyPK, (String)"CONSIGNSALES");
            String bizTypeId = saleIssueInfo.getBizType().getId().toString();
            if (!Boolean.valueOf(paramValue).booleanValue() && "d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeId) && !saleIssueInfo.getTransactionType().isIsWriteOff()) {
                return;
            }
        }
        iReqPlanForSCMFacade.counteractFromInvBill(billTypeId, toIDList, operateType);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ASYNCHRONOUS;
    }
}

