/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SerialNumUpdatingProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public SerialNumUpdatingProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SerialNumUpdatingProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SerialNumUpdatingProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return batchResults.hasToDos();
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        EntityViewInfo view;
        Set idSet = batchResults.getToDoIdsSet();
        if (idSet.size() == 0) {
            return;
        }
        String oql = "select *,isInitBill,transactionType.id,transactionType.ritype,transactionType.existingQty,isReversed,billType,entry.id,entry.seq,entry.sourcebillid,entry.storageOrgUnit,entry.material,entry.sourcebillentryid,entry.baseqty,entry.baseunit,entry.* ";
        try {
            view = new EntityViewInfo(oql);
            view = new EntityViewInfo();
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        Method mGetCollection = BusinessProcessUtil.getCollectionMethod((Context)this.ctx, (BOSObjectType)this.bosType);
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface((Context)this.ctx, (BOSObjectType)this.bosType);
        IObjectCollection collection = (IObjectCollection)BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBiz, (Method)mGetCollection, (Object[])new Object[]{view});
        if (collection == null || collection.size() == 0) {
            return;
        }
        InvBillBaseInfo aInvBillBaseInfo = null;
        ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)this.ctx);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objValue = collection.getObject(i);
            String id = objValue.get(objValue.getPKField()).toString();
            aInvBillBaseInfo = (InvBillBaseInfo)objValue;
            if (aInvBillBaseInfo.getTransactionType() == null || aInvBillBaseInfo.getTransactionType().getId() == null) {
                return;
            }
            TransactionTypeInfo tti = aInvBillBaseInfo.getTransactionType();
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getTransactionType().getId()));
            aInvBillBaseInfo.setTransactionType(tti);
            try {
                if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                    this.updateSerialNumInventory(this.ctx, aInvBillBaseInfo);
                    continue;
                }
                if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
                MaterialSerialNumberFactory.getLocalInstance((Context)this.ctx).unAduitSerialInventory((SCMBillBaseInfo)aInvBillBaseInfo);
                continue;
            }
            catch (Exception e) {
                batchResults.addError(id, e);
            }
        }
    }

    private void updateSerialNumInventory(Context ctx, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        String billtypeid = billInfo.getBillType().getId().toString();
        if (!("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtypeid) || "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billtypeid) || "50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billtypeid) || "50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billtypeid) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billtypeid) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billtypeid))) {
            return;
        }
        if (billInfo.getTransactionType() == null || billInfo.getTransactionType().getId() == null) {
            return;
        }
        TransactionTypeInfo tti = billInfo.getTransactionType();
        if (tti.getRiType() == null) {
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(billInfo.getTransactionType().getId()));
            billInfo.setTransactionType(tti);
        }
        boolean isSaleBack = false;
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billtypeid) && tti.getRiType().getBizDirection() == BizDirectionEnum.back) {
            isSaleBack = true;
        }
        SerialNumberStatusEnum snstatus = null;
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        int entrySize = iObjectCollection.size();
        InvBillBaseEntryInfo ibb = null;
        MaterialSerialNumberInfo snInfo = null;
        MaterialInfo material = null;
        String[] materialIds = new String[entrySize];
        String[] storageOrgIds = new String[entrySize];
        String[] seqUnitIDS = new String[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            materialIds[i] = ibb.getMaterial().getId().toString();
            storageOrgIds[i] = ibb.getStorageOrgUnit().getId().toString();
        }
        SelectorItemCollection sicCol = new SelectorItemCollection();
        sicCol.add("isSequenceNo");
        sicCol.add("material.id");
        sicCol.add("orgUnit.id");
        Map mapMaterialInventorys = DataLoaderHelper.loadMaterialInventorys((Context)ctx, (String[])storageOrgIds, (String[])materialIds, (SelectorItemCollection)sicCol);
        SelectorItemCollection siCol = new SelectorItemCollection();
        siCol.add(new SelectorItemInfo("id"));
        siCol.add(new SelectorItemInfo("number"));
        siCol.add(new SelectorItemInfo("name"));
        siCol.add(new SelectorItemInfo("seqUnit.id"));
        siCol.add(new SelectorItemInfo("seqUnit.number"));
        siCol.add(new SelectorItemInfo("seqUnit.name"));
        Map mapMaterialSeq = DataLoaderHelper.loadMaterial((Context)ctx, (String[])materialIds, (SelectorItemCollection)siCol);
        boolean isNeedSele = false;
        MeasureUnitInfo seqUnit = null;
        HashMap map = new HashMap();
        for (int i = 0; i < entrySize; ++i) {
            seqUnit = ((MaterialInfo)mapMaterialSeq.get(materialIds[i])).getSeqUnit();
            if (seqUnit != null) {
                isNeedSele = true;
                seqUnitIDS[i] = seqUnit.getId().toString();
                continue;
            }
            seqUnitIDS[i] = "";
        }
        if (isNeedSele) {
            map = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])materialIds, (String[])seqUnitIDS);
        }
        MaterialSerialNumberInfo[] serialNumberInfos = new MaterialSerialNumberInfo[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            BigDecimal baseQty;
            ibb = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            MaterialInventoryInfo mii = (MaterialInventoryInfo)mapMaterialInventorys.get(ibb.getMaterial().getId().toString() + ibb.getStorageOrgUnit().getId().toString());
            if (mii == null || !mii.isIsSequenceNo() || ibb == null || (snstatus = InvCommonUtils.getSnStatusByTranType((TransactionTypeInfo)tti, (InvUpdateTypeInfo)ibb.getInvUpdateType(), (boolean)(billInfo.isIsReversed() ^ InvAppUtils.isNegative((TransactionTypeInfo)billInfo.getTransactionType())))) == SerialNumberStatusEnum.NULL) continue;
            snInfo = new MaterialSerialNumberInfo();
            snInfo.setBillID(billInfo.getId().toString());
            snInfo.setBillEntryID(ibb.getId().toString());
            snInfo.setIsReversed(billInfo.isIsReversed());
            snInfo.setSoureBillID(ibb.getSourceBillId());
            snInfo.setSoureBillEntryID(ibb.getSourceBillEntryId());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setSnStatus(snstatus == SerialNumberStatusEnum.SALE ? snstatus : SerialNumberStatusEnum.INWAREHOUSE);
            snInfo.setBillType(billInfo.getBillType());
            snInfo.setBillNumber(billInfo.getNumber());
            snInfo.setBillEntrySeq(ibb.getSeq());
            snInfo.setStorageOrgUnit(ibb.getStorageOrgUnit());
            snInfo.setMaterial(ibb.getMaterial());
            material = ibb.getMaterial();
            MeasureUnitInfo sNUnitInfo = material.getSeqUnit();
            if (sNUnitInfo == null && (sNUnitInfo = ((MaterialInfo)mapMaterialSeq.get(material.getId().toString())).getSeqUnit()) == null) {
                return;
            }
            BigDecimal sNqty = baseQty = ibb.getBaseQty();
            if (!ibb.getBaseUnit().getId().toString().equals(sNUnitInfo.getId().toString())) {
                BigDecimal coefficient = SCMConstant.BIGDECIMAL_ONE;
                MultiMeasureUnitInfo mulUnit = null;
                mulUnit = (MultiMeasureUnitInfo)map.get(material.getId().toString() + sNUnitInfo.getId().toString());
                if (mulUnit != null) {
                    coefficient = mulUnit.getBaseConvsRate();
                    int precision = mulUnit.getQtyPrecision();
                    if (coefficient != null) {
                        sNqty = baseQty.divide(coefficient, precision, 4);
                    }
                }
            }
            snInfo.setSnUnit(sNUnitInfo);
            snInfo.setSnQty(sNqty);
            snInfo.put("isSaleBack", (Object)isSaleBack);
            serialNumberInfos[i] = snInfo;
        }
        IMaterialSerialNumber imsn = MaterialSerialNumberFactory.getLocalInstance((Context)ctx);
        imsn.checkSerialNumber(true, (IObjectValue[])serialNumberInfos);
        imsn.updateSerialInventory((SCMBillBaseInfo)billInfo);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }
}

