/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryFactory;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble.AbstractMatAssembleOtherBiz4AuditProcessor;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MatAssembleOtherBiz4AuditProcessor
extends AbstractMatAssembleOtherBiz4AuditProcessor {
    private static final long serialVersionUID = 4320824866491194208L;

    public MatAssembleOtherBiz4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MatAssembleOtherBiz4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MatAssembleOtherBiz4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.XTZHBISSUE = "zzhck001";
        this.XTZHAINWAREHS = "zzhrk001";
        super.doProcessing(batchResults);
    }

    @Override
    protected void sysOutEntryActualCost(Context ctx, String issueBillID, String inWarehsBillID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.qty"));
        selector.add(new SelectorItemInfo("entry.unitActualCost"));
        selector.add(new SelectorItemInfo("entry.actualCost"));
        selector.add(new SelectorItemInfo("entry.sourceBillEntryID"));
        selector.add(new SelectorItemInfo("entry.material.pricePrecision"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.id"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.number"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.name"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.isNotUpdateInv"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.scheduled"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.status"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.id"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.number"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.name"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.storeFlag"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.isForwardAmt"));
        HashMap<String, MatCostObject> matCostObjMap = new HashMap<String, MatCostObject>();
        OtherIssueBillInfo issueBill = OtherIssueBillFactory.getLocalInstance((Context)ctx).getOtherIssueBillInfo((IObjectPK)new ObjectUuidPK(issueBillID), selector);
        for (int i = 0; i < issueBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, (InvBillBaseEntryInfo)issueBill.getEntry().get(i), true);
        }
        OtherInWarehsBillInfo inWarehsBill = OtherInWarehsBillFactory.getLocalInstance((Context)ctx).getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(inWarehsBillID), selector);
        for (int i = 0; i < inWarehsBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, (InvBillBaseEntryInfo)inWarehsBill.getEntry().get(i), false);
        }
        Iterator<MatCostObject> it = matCostObjMap.values().iterator();
        MatCostObject obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (!obj.isNeedSyncCost()) continue;
            obj.calculateCost();
            obj.updateInWarehsEntryCost();
        }
    }

    protected void buildMatCostObjectMap(Context ctx, HashMap<String, MatCostObject> matCostObjMap, InvBillBaseEntryInfo entry, boolean isIssueEntry) {
        String sourceEntryID = entry.getSourceBillEntryId();
        MatCostObject vo = matCostObjMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatCostObject(ctx, sourceEntryID);
        }
        if (isIssueEntry) {
            vo.addIssueEntry(entry);
        } else {
            vo.addInWarehsEntry(entry);
        }
        matCostObjMap.put(sourceEntryID, vo);
    }

    class MatCostObject {
        Context ctx;
        String sourceBillEntryID;
        List<InvBillBaseEntryInfo> issueList;
        List<InvBillBaseEntryInfo> inWarehsList;

        public MatCostObject(Context ctx, String sourceBillEntryID) {
            this.ctx = ctx;
            this.sourceBillEntryID = sourceBillEntryID;
            this.issueList = new ArrayList<InvBillBaseEntryInfo>();
            this.inWarehsList = new ArrayList<InvBillBaseEntryInfo>();
        }

        public void addIssueEntry(InvBillBaseEntryInfo entry) {
            this.issueList.add(entry);
        }

        public void addInWarehsEntry(InvBillBaseEntryInfo entry) {
            this.inWarehsList.add(entry);
        }

        public boolean isNeedSyncCost() throws BOSException {
            if (this.inWarehsList.size() <= 0) {
                return false;
            }
            String materialId = this.inWarehsList.get(0).getMaterial().getId().toString();
            String couID = this.inWarehsList.get(0).getCompanyOrgUnit().getId().toString();
            MaterialCompanyInfoInfo matComInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, couID);
            return matComInfo != null && AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType());
        }

        public void calculateCost() throws BOSException, EASBizException {
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal processCharge = this.getProcessCharge();
            totalCost = totalCost.add(processCharge);
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            InvBillBaseEntryInfo entry = null;
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                entry = this.inWarehsList.get(i);
                recentCost = totalCost.multiply(entry.getQty().divide(totalQty, 8, 4)).setScale(entry.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                if (i == this.inWarehsList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                if (entry.getInvUpdateType().getStoreType().isIsForwardAmt() && recentCost.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new InvBizException(InvBizException.INWAREHS_ACTCOSTISNULL);
                }
                entry.setActualCost(recentCost);
                entry.setUnitActualCost(entry.getActualCost().divide(entry.getQty(), entry.getMaterial().getPricePrecision(), 4));
                entry.setBoolean("isNeedUpdate", true);
                dealCost = dealCost.add(entry.getActualCost());
            }
        }

        public void updateInWarehsEntryCost() throws BOSException {
            String updateSQL = "update t_im_otherinwarehsbillentry set FUnitActualCost = ?, FActualCost = ? where fid = ?";
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                ps = conn.prepareStatement(updateSQL);
                InvBillBaseEntryInfo entry = null;
                for (int i = 0; i < this.inWarehsList.size(); ++i) {
                    entry = this.inWarehsList.get(i);
                    ps.setBigDecimal(1, entry.getUnitActualCost());
                    ps.setBigDecimal(2, entry.getActualCost());
                    ps.setString(3, entry.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.issueList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.issueList.get(i);
                result = result.add(entry.getActualCost());
            }
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.inWarehsList.get(i);
                result = result.add(entry.getQty());
            }
            return result;
        }

        private BigDecimal getProcessCharge() throws BOSException, EASBizException {
            MatAssembleBeforeEntryInfo beforeEntryInfo = MatAssembleBeforeEntryFactory.getLocalInstance((Context)this.ctx).getMatAssembleBeforeEntryInfo((IObjectPK)new ObjectUuidPK(this.sourceBillEntryID));
            return beforeEntryInfo.getProcessCharge() == null ? BigDecimal.ZERO : beforeEntryInfo.getProcessCharge();
        }
    }
}

