/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matdisassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.matassemble.AbstractMatAssembleOtherBiz4AuditProcessor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MatDisassembleOtherBiz4AuditProcessor
extends AbstractMatAssembleOtherBiz4AuditProcessor {
    private static final long serialVersionUID = -2133808027004455030L;

    public MatDisassembleOtherBiz4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MatDisassembleOtherBiz4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MatDisassembleOtherBiz4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.XTZHBISSUE = "CXCK001";
        this.XTZHAINWAREHS = "CXRK002";
        super.doProcessing(batchResults);
    }

    @Override
    protected void sysOutEntryActualCost(Context ctx, String issueBillID, String inWarehsBillID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.qty"));
        selector.add(new SelectorItemInfo("entry.unitActualCost"));
        selector.add(new SelectorItemInfo("entry.actualCost"));
        selector.add(new SelectorItemInfo("entry.sourceBillEntryID"));
        selector.add(new SelectorItemInfo("entry.material.pricePrecision"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.id"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.number"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.name"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.isNotUpdateInv"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.scheduled"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.status"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.id"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.number"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.name"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.storeFlag"));
        selector.add(new SelectorItemInfo("entry.invUpdateType.storeType.isForwardAmt"));
        HashMap<String, MatDisCostObject> matCostObjMap = new HashMap<String, MatDisCostObject>();
        OtherIssueBillInfo issueBill = OtherIssueBillFactory.getLocalInstance((Context)ctx).getOtherIssueBillInfo((IObjectPK)new ObjectUuidPK(issueBillID), selector);
        for (int i = 0; i < issueBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, (InvBillBaseEntryInfo)issueBill.getEntry().get(i), true, null);
        }
        OtherInWarehsBillInfo inWarehsBill = OtherInWarehsBillFactory.getLocalInstance((Context)ctx).getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(inWarehsBillID), selector);
        HashMap<String, MatDisAfterEntryData> dataMap = new HashMap<String, MatDisAfterEntryData>();
        this.setEntryDataMap(ctx, inWarehsBill, dataMap);
        for (int i = 0; i < inWarehsBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, (InvBillBaseEntryInfo)inWarehsBill.getEntry().get(i), false, dataMap);
        }
        Iterator<MatDisCostObject> it = matCostObjMap.values().iterator();
        MatDisCostObject obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (!obj.isNeedSyncCost()) continue;
            obj.calculateCost();
            obj.updateInWarehsEntryCost();
        }
    }

    @Override
    protected void afterAuditBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.afterAuditBill(ctx, model);
        if (model instanceof OtherInWarehsBillInfo) {
            this.setInWareActualCost(ctx, (InvBillBaseInfo)((OtherInWarehsBillInfo)model));
        }
    }

    private void setInWareActualCost(Context ctx, InvBillBaseInfo inwarehsInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IM_OtherInWarehsBillEntry as t set (FActualCost,FUnitActualCost) = ");
        sql.append("(select isnull(afterEntry.FAmount,0),round(TO_DECIMAL(isnull(afterEntry.FAmount,0) / entry.FQTY, 21,8), m.FPricePrecision) from T_IM_OtherInwarehsbill bill inner join T_IM_OtherInwarehsbillentry entry on bill.fid = entry.fparentid");
        sql.append(" inner join T_IM_MatDisassembleAfterEntry afterEntry on afterEntry.FparentID  = entry.FSourceBillEntryID and entry.FSOURCEBILLENTRYSEQ = afterEntry.FSeq ");
        sql.append(" inner join T_BD_Material m on m.fid = entry.fmaterialID where isnull(afterEntry.FAmount,0) > 0 and t.fid = entry.fid");
        sql.append(" and bill.FID = '").append(inwarehsInfo.getId().toString()).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setEntryDataMap(Context ctx, OtherInWarehsBillInfo inWarehsInfo, Map<String, MatDisAfterEntryData> dataMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FID,afterEntry.FCostRate,afterEntry.FAmount,afterEntry.FProcessCharge from T_IM_OtherInwarehsbill bill inner join T_IM_OtherInwarehsbillentry entry on bill.fid = entry.fparentid");
        sql.append(" inner join T_IM_MatDisassembleAfterEntry afterEntry on afterEntry.FparentID  = entry.FSourceBillEntryID and entry.FSOURCEBILLENTRYSEQ = afterEntry.FSeq ");
        sql.append(" inner join T_BD_Material m on m.fid = entry.fmaterialID ");
        sql.append(" where bill.FID = '").append(inWarehsInfo.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                MatDisAfterEntryData data = new MatDisAfterEntryData();
                data.setCostRate(rs.getBigDecimal("FCostRate"));
                data.setAmount(rs.getBigDecimal("FAmount"));
                data.setProcessCharge(rs.getBigDecimal("FProcessCharge"));
                dataMap.put(rs.getString("FID"), data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void buildMatCostObjectMap(Context ctx, HashMap<String, MatDisCostObject> matCostObjMap, InvBillBaseEntryInfo entries, boolean isIssueEntry, Map<String, MatDisAfterEntryData> dataMap) {
        String sourceEntryID = entries.getSourceBillEntryId();
        MatDisCostObject vo = matCostObjMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatDisCostObject(ctx, sourceEntryID);
        }
        if (isIssueEntry) {
            vo.addIssueEntry(entries);
        } else {
            vo.addAmount(dataMap.get(entries.getId().toString()).getAmount());
            vo.setEntryData(dataMap);
            vo.addInWarehsEntry(entries);
        }
        matCostObjMap.put(sourceEntryID, vo);
    }

    class MatDisAfterEntryData {
        BigDecimal costRate = new BigDecimal("0.00");
        BigDecimal amount = new BigDecimal("0.00");
        BigDecimal processCharge = new BigDecimal("0.00");

        MatDisAfterEntryData() {
        }

        public BigDecimal getCostRate() {
            return this.costRate;
        }

        public void setCostRate(BigDecimal costRate) {
            if (costRate != null) {
                this.costRate = costRate;
            }
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            if (amount != null) {
                this.amount = amount;
            }
        }

        public BigDecimal getProcessCharge() {
            return this.processCharge;
        }

        public void setProcessCharge(BigDecimal processCharge) {
            if (processCharge != null) {
                this.processCharge = processCharge;
            }
        }
    }

    class MatDisCostObject {
        Context ctx;
        String sourceBillEntryID;
        List<InvBillBaseEntryInfo> issueList;
        List<InvBillBaseEntryInfo> inWarehsList;
        Map<String, MatDisAfterEntryData> dataMap;
        BigDecimal amount = new BigDecimal("0.00");

        public MatDisCostObject(Context ctx, String sourceBillEntryID) {
            this.ctx = ctx;
            this.sourceBillEntryID = sourceBillEntryID;
            this.issueList = new ArrayList<InvBillBaseEntryInfo>();
            this.inWarehsList = new ArrayList<InvBillBaseEntryInfo>();
        }

        public void addAmount(BigDecimal amount) {
            this.amount = this.amount.add(amount);
        }

        public void setEntryData(Map<String, MatDisAfterEntryData> dataMap) {
            this.dataMap = dataMap;
        }

        public void addIssueEntry(InvBillBaseEntryInfo entries) {
            this.issueList.add(entries);
        }

        public void addInWarehsEntry(InvBillBaseEntryInfo entries) {
            this.inWarehsList.add(entries);
        }

        public boolean isNeedSyncCost() throws BOSException {
            if (this.inWarehsList.size() <= 0) {
                return false;
            }
            for (int i = this.inWarehsList.size() - 1; i >= 0; --i) {
                String materialId = this.inWarehsList.get(i).getMaterial().getId().toString();
                String couID = this.inWarehsList.get(i).getCompanyOrgUnit().getId().toString();
                MaterialCompanyInfoInfo matComInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, couID);
                if (matComInfo == null || !AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType())) {
                    this.inWarehsList.remove(i);
                    continue;
                }
                if (this.dataMap.get(this.inWarehsList.get(i).getId().toString()).getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                this.inWarehsList.remove(i);
            }
            return this.inWarehsList.size() > 0;
        }

        public void calculateCost() throws BOSException, EASBizException {
            int i;
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            InvBillBaseEntryInfo entries = null;
            BigDecimal costRateSum = new BigDecimal("0");
            for (i = 0; i < this.inWarehsList.size(); ++i) {
                entries = this.inWarehsList.get(i);
                costRateSum = costRateSum.add(this.dataMap.get(entries.getId().toString()).getCostRate());
            }
            for (i = 0; i < this.inWarehsList.size(); ++i) {
                entries = this.inWarehsList.get(i);
                BigDecimal costRate = this.dataMap.get(entries.getId().toString()).getCostRate();
                recentCost = totalCost.multiply(costRate.divide(new BigDecimal("100.00"), 8, 4)).setScale(entries.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                if (costRateSum.compareTo(new BigDecimal("100.00")) == 0 && this.inWarehsList.size() > 1 && i == this.inWarehsList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                if (entries.getInvUpdateType().getStoreType().isIsForwardAmt() && recentCost.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new InvBizException(InvBizException.INWAREHS_ACTCOSTISNULL);
                }
                dealCost = dealCost.add(recentCost);
                recentCost = recentCost.add(this.dataMap.get(entries.getId().toString()).getProcessCharge());
                recentCost = recentCost.setScale(entries.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                entries.setActualCost(recentCost);
                entries.setUnitActualCost(entries.getActualCost().divide(entries.getQty(), entries.getMaterial().getPricePrecision(), 4));
                entries.setBoolean("isNeedUpdate", true);
            }
        }

        public void updateInWarehsEntryCost() throws BOSException {
            String updateSQL = "update t_im_otherinwarehsbillentry set FUnitActualCost = ?, FActualCost = ? where fid = ?";
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                ps = conn.prepareStatement(updateSQL);
                InvBillBaseEntryInfo entries = null;
                for (int i = 0; i < this.inWarehsList.size(); ++i) {
                    entries = this.inWarehsList.get(i);
                    ps.setBigDecimal(1, entries.getUnitActualCost());
                    ps.setBigDecimal(2, entries.getActualCost());
                    ps.setString(3, entries.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.issueList.size(); ++i) {
                InvBillBaseEntryInfo entries = this.issueList.get(i);
                result = result.add(entries.getActualCost());
            }
            result = result.subtract(this.amount);
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                InvBillBaseEntryInfo entries = this.inWarehsList.get(i);
                result = result.add(entries.getQty());
            }
            return result;
        }
    }
}

