/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.materialreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class MaterialReqBillAuditCheckProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 8467746305100029029L;
    private static final String RESOURCE_CLASS_NAME = "com.kingdee.eas.scm.im.inv.InvAddResource";
    private static final String SP = "\r\n";

    public MaterialReqBillAuditCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MaterialReqBillAuditCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MaterialReqBillAuditCheckProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.checkEntryMaterial(collection.getObject(i));
        }
    }

    private void checkEntryMaterial(IObjectValue model) throws BOSException, InvBizException {
        if (model == null) {
            return;
        }
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        boolean flag = info.getTransactionType().isIsCalculate();
        String companyOrgUnitID = "";
        if (flag) {
            if (info.getDemandCompanyOrgUnit() != null && info.getDemandCompanyOrgUnit().getId() != null) {
                companyOrgUnitID = info.getDemandCompanyOrgUnit().getId().toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" select entry.FSeq, material.FNumber as materialNumber from T_IM_MATERIALREQBILLENTRY entry ");
            sb.append(" inner join T_BD_MATERIAL material on material.FId = entry.FMaterialId ");
            sb.append(" inner join T_IM_InvUpdateType updateType on entry.FInvUpdateTypeID = updateType.fid ");
            sb.append(" inner join T_IM_STORETYPE storeType on updateType.FStoreTypePreID = storeType.fid ");
            sb.append(" inner join T_BD_MATERIALCOMPANYINFO company ");
            sb.append(" on entry.FMaterialID = company.FMaterialID and company.FCompanyID  = '" + companyOrgUnitID + "' ");
            sb.append(" where entry.Fparentid = '").append(info.getId().toString()).append("' and company.FAccountType = 1 ");
            sb.append(" and entry.FActualCost = 0 and storeType.FIsForwardAmt = 1 and entry.fqty != 0 order by entry.FSeq");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            StringBuffer msg = new StringBuffer();
            try {
                while (rs.next()) {
                    int seq = rs.getInt("FSeq");
                    String materialNumber = rs.getString("materialNumber");
                    msg.append(ResourceUtils.getMessage((String)RESOURCE_CLASS_NAME, (String)"MATERIAL_COST_EQUALS_ZERO", (String[])new String[]{String.valueOf(seq), materialNumber})).append(SP);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (msg.length() > 0) {
                throw new InvBizException(InvBizException.COMMON, new Object[]{msg});
            }
        }
    }
}

