/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvBizDataCheckProcessor;
import com.kingdee.eas.scm.util.string.StringUtil;

public class PurInBizDataCheckProcessor
extends InvBizDataCheckProcessor {
    private static final long serialVersionUID = 759884931312053477L;

    public PurInBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    public PurInBizDataCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            if (vo == null) continue;
            PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)vo;
            PurInWarehsEntryCollection entries = purInWarehsBillInfo.getEntry();
            boolean isForwardAmt = false;
            if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                if (purInWarehsBillInfo.getSupplier() == null) {
                    throw new InvBizException(InvBizException.SUPPLIERNOTNULL);
                }
                TransactionTypeInfo transactionType = purInWarehsBillInfo.getTransactionType();
                if (purInWarehsBillInfo.getExchangeRate() == null || purInWarehsBillInfo.getExchangeRate().setScale(10, 4).compareTo(SysConstant.BIGZERO) == 0) {
                    throw new InvBizException(InvBizException.ERROR_EXCHANGERATE_ZERO, new Object[]{purInWarehsBillInfo.getNumber()});
                }
                if (entries == null) continue;
                int len = entries.size();
                for (int j = 0; j < len; ++j) {
                    StoreTypeInfo storeTypeInfo;
                    PurInWarehsEntryInfo entry = entries.get(j);
                    if (entry == null) continue;
                    InvUpdateTypeInfo invUpdateTypeInfo = entry.getInvUpdateType();
                    boolean isExistingQtyPre = invUpdateTypeInfo != null && invUpdateTypeInfo.isExistingQtyPre();
                    isForwardAmt = false;
                    if (invUpdateTypeInfo != null && invUpdateTypeInfo.getStoreType() != null && invUpdateTypeInfo.getStoreType().getId() != null && (storeTypeInfo = this.getStoreTypeInfoById(this.ctx, invUpdateTypeInfo.getStoreType().getId().toString())).isIsForwardAmt()) {
                        isForwardAmt = true;
                    }
                    if (entry.getSourceBillType() != null && isExistingQtyPre) {
                        WarehouseInfo outWarehouse = entry.getOutWarehouse();
                        if (outWarehouse == null) {
                            throw new InvBizException(InvBizException.WAREHOUSE_CANNOT_NULL, (Object[])new String[]{this.stringNo + (j + 1) + this.stringRow});
                        }
                        if (outWarehouse.isHasLocation() && entry.getOutLocation() == null) {
                            throw new InvBizException(InvBizException.LOCATION_CANNOT_NULL, (Object[])new String[]{this.stringNo + (j + 1) + this.stringRow});
                        }
                    }
                    MaterialInventoryInfo miInfo = (MaterialInventoryInfo)this.matInventoryMap.get(entry.getMaterial().getId().toString() + purInWarehsBillInfo.getStorageOrgUnit().getId().toString());
                    if (purInWarehsBillInfo.getStorageOrgUnit() != null && miInfo != null && miInfo.isIsBatchNo() && (entry.getSupplierLotNo() == null || entry.getSupplierLotNo().trim().length() == 0)) {
                        throw new InvBizException(InvBizException.SUPPLIERLOT_CANNOT_NULL, (Object[])new String[]{this.stringNo + (j + 1) + this.stringRow});
                    }
                    MaterialCompanyInfoInfo mcInfo = (MaterialCompanyInfoInfo)this.matCompanyMap.get(entry.getMaterial().getId().toString() + entry.getCompanyOrgUnit().getId().toString());
                    if (mcInfo == null || !mcInfo.getAccountType().equals((Object)AccountType.MOVE_ADD_AVERAGE) || entry.isIsPresent() || !isForwardAmt || !transactionType.isIsCalculate() || purInWarehsBillInfo.isIsInitBill()) continue;
                    if (entry.getUnitPurchaseCost() == null || entry.getUnitPurchaseCost().compareTo(SysConstant.BIGZERO) <= 0) {
                        throw new InvBizException(InvBizException.UNITPURCHASECOST_IS_NOT_NULL, (Object[])new String[]{this.stringNo + (j + 1) + this.stringRow});
                    }
                    if (entry.getPurchaseCost() != null && entry.getPurchaseCost().compareTo(SysConstant.BIGZERO) != 0) continue;
                    throw new InvBizException(InvBizException.PURCHASECOST_IS_NOT_NULL, (Object[])new String[]{this.stringNo + (j + 1) + this.stringRow});
                }
                continue;
            }
            if (this.batchAction.equals((Object)BatchActionEnum.AUDIT) || !this.batchAction.equals((Object)BatchActionEnum.UNAUDIT) || purInWarehsBillInfo.getBizType() == null || !"bsBvQE5PP4DgQKjAYj0d/CQHQ1w=".equals(purInWarehsBillInfo.getBizTypeId())) continue;
            throw new InvBizException(InvBizException.CANUNAUDIT_MATERIALREQFORMM);
        }
    }

    private StoreTypeInfo getStoreTypeInfoById(Context ctx, String storeTypeId) throws EASBizException, BOSException {
        StoreTypeInfo storeTypeInfo = null;
        if (!StringUtil.isEmpty((String)storeTypeId)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("storeFlag"));
            sic.add(new SelectorItemInfo("isForwardAmt"));
            storeTypeInfo = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK(storeTypeId), sic);
        }
        return storeTypeInfo;
    }

    @Override
    protected boolean checkEntryCoreBillType(InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)aInvBillBaseInfo;
        PurInWarehsEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || CoreBillTypeid == null) continue;
            return false;
        }
        return true;
    }
}

