/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.im.inv.DischargeTypeEnum;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class PurInDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = 1L;
    public static final String PAYTYPEID = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";

    public PurInDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurInDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        return SCMSelectorFactory.getPurInWarehsBillSelector((boolean)true);
    }

    protected void setBillDischargeType(PurInWarehsBillInfo info) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        PurInWarehsBillInfo hsInfo = info;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        if (hsInfo != null && hsInfo.getEntry() != null && hsInfo.getEntry().size() > 0 && (company = hsInfo.getEntry().get(0).getCompanyOrgUnit()) != null) {
            String dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_001");
            if (dischargeType.equals("1") && hsInfo.isIsInitBill()) {
                dischargeType = "2";
            }
            if (dischargeType.equals("1")) {
                hsInfo.setDischargeType(DischargeTypeEnum.BeginPeriodClear);
            } else if (dischargeType.equals("2")) {
                hsInfo.setDischargeType(DischargeTypeEnum.BillComeClear);
            } else {
                hsInfo.setDischargeType(DischargeTypeEnum.UnClear);
            }
        }
    }

    @Override
    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Save(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)vo;
            this.setBillDischargeType(info);
            this.copySupplierToEntry(this.ctx, (IObjectValue)info);
            this.setValue4Entry(info);
        }
    }

    @Override
    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Submit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        boolean isFromGui = false;
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)vo;
            this.setBillDischargeType(info);
            if (i == 0 && info.get("isFromGui") == null) {
                isFromGui = true;
                info.remove("isFromGui");
            }
            PurInWarehsEntryCollection entrys = (PurInWarehsEntryCollection)info.get("entry");
            for (int j = 0; j < entrys.size(); ++j) {
                if (entrys.get(j).getReceiveStorageOrgUnit() != null) continue;
                entrys.get(j).setReceiveStorageOrgUnit(info.getStorageOrgUnit());
            }
            if (info.getPaymentType() == null) {
                PaymentTypeInfo payInfo = new PaymentTypeInfo();
                payInfo.setId(BOSUuid.read((String)PAYTYPEID));
                info.setPaymentType(payInfo);
            }
            this.setValue4Entry(info);
        }
        BigDecimal qty = null;
        BigDecimal totalLocalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < collection.size(); ++i) {
            int j;
            IObjectValue vo = collection.getObject(i);
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)vo;
            qty = SysConstant.BIGZERO;
            PurInWarehsEntryCollection entrys = (PurInWarehsEntryCollection)info.get("entry");
            BigDecimal localAmount = SysConstant.BIGZERO;
            HashMap<String, CompanyOrgUnitInfo> companyOrgBaseCurPcsMap = new HashMap<String, CompanyOrgUnitInfo>();
            for (j = 0; j < entrys.size(); ++j) {
                BigDecimal amount;
                if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
                    this.setQtyForSubContract(entrys.get(j));
                }
                if (entrys.get(j).getBalanceSupplier() == null) {
                    entrys.get(j).setBalanceSupplier(info.getSupplier());
                }
                qty = qty.add(entrys.get(j).getQty() == null ? SysConstant.BIGZERO : entrys.get(j).getQty());
                BigDecimal bigDecimal = amount = entrys.get(j).getAmount() == null ? SysConstant.BIGZERO : entrys.get(j).getAmount();
                if (info.getExchangeRate() == null || entrys.get(j).getLocalTaxAmount() == null) continue;
                int scale = entrys.get(j).getLocalTaxAmount().scale();
                if (entrys.get(j).getCompanyOrgUnit() != null) {
                    String orgId = entrys.get(j).getCompanyOrgUnit().getId().toString();
                    CompanyOrgUnitInfo companyOrgUnit = companyOrgBaseCurPcsMap.containsKey(orgId) ? (CompanyOrgUnitInfo)companyOrgBaseCurPcsMap.get(orgId) : CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + orgId + "'");
                    companyOrgBaseCurPcsMap.put(orgId, companyOrgUnit);
                    scale = companyOrgUnit.getBaseCurrency().getPrecision();
                }
                localAmount = info.getConvertMode() != null && info.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? amount.multiply(info.getExchangeRate()) : amount.divide(info.getExchangeRate(), scale, 4);
                localAmount = localAmount.setScale(scale, 4);
                entrys.get(j).setLocalAmount(localAmount);
                totalLocalAmount = totalLocalAmount.add(localAmount);
            }
            info.setTotalLocalAmount(totalLocalAmount);
            info.setTotalQty(qty);
            if (info.getConvertMode() == null) {
                info.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            }
            if (info.getPurchaseType() != null && info.getPurchaseType() == PurchaseTypeEnum.SUBCONTRACT && !info.isIsReversed()) {
                for (j = 0; j < entrys.size(); ++j) {
                    if (info.getId() == null || entrys.get(j).getPurOrder() != null) continue;
                    entrys.get(j).setPurOrder(info.getId().toString());
                }
            }
            if (isFromGui) continue;
            try {
                new PurInAlgorithmForInfo(info, this.ctx).revalue();
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void setQtyForSubContract(PurInWarehsEntryInfo entry) {
        DosingTypeEnum dosingType = entry.getDosingType();
        if (DosingTypeEnum.NONE.equals((Object)dosingType)) {
            entry.setScWrittenOffQty(entry.getQty());
            entry.setScWrittenOffBaseQty(entry.getBaseQty());
            entry.setScUnWrittenOffBaseQty(SysConstant.BIGZERO);
            entry.setScUnWrittenOffQty(SysConstant.BIGZERO);
        } else {
            entry.setScUnWrittenOffQty(entry.getQty());
            entry.setScUnWrittenOffBaseQty(entry.getBaseQty());
            entry.setScWrittenOffQty(SysConstant.BIGZERO);
            entry.setScWrittenOffBaseQty(SysConstant.BIGZERO);
        }
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
        info.setNumber("103");
        return info;
    }

    @Override
    protected List<String> getEntryNumberFields() {
        List<String> fields = super.getEntryNumberFields();
        fields.add("purchaseFee");
        fields.add("imputedCost");
        fields.add("receiveAmount");
        fields.add("drewQty");
        fields.add("drewBaseQty");
        fields.add("orderPrice");
        fields.add("totalMoveQty");
        fields.add("taxRate");
        fields.add("discountRate");
        fields.add("scUnWrittenOffQty");
        fields.add("scUnWrittenOffBaseQty");
        fields.add("scWrittenOffQty");
        fields.add("scWrittenOffBaseQty");
        return fields;
    }

    @Override
    protected String getEntryName() {
        return "entry";
    }

    private void copySupplierToEntry(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        if (pi == null || pi.getEntry() == null) {
            return;
        }
        SupplierInfo supply = pi.getSupplier();
        BigDecimal amount = SysConstant.BIGZERO;
        BigDecimal localAmount = SysConstant.BIGZERO;
        BigDecimal totalLocalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < pi.getEntry().size(); ++i) {
            PurInWarehsEntryInfo piEntry = pi.getEntry().get(i);
            if (piEntry.getBalanceSupplier() == null) {
                piEntry.setBalanceSupplier(supply);
            }
            piEntry.setStorageOrgUnit(pi.getStorageOrgUnit());
            BigDecimal bigDecimal = amount = piEntry.getAmount() == null ? SysConstant.BIGZERO : piEntry.getAmount();
            if (pi.getExchangeRate() == null || piEntry.getLocalTaxAmount() == null) continue;
            int scale = piEntry.getLocalTaxAmount().scale();
            localAmount = pi.getConvertMode() != null && pi.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE ? amount.multiply(pi.getExchangeRate()) : amount.divide(pi.getExchangeRate(), scale, 4);
            localAmount = localAmount.setScale(scale, 4);
            piEntry.setLocalAmount(localAmount);
            totalLocalAmount = totalLocalAmount.add(localAmount);
        }
        pi.setTotalLocalAmount(totalLocalAmount);
    }

    private void setValue4Entry(PurInWarehsBillInfo info) throws BOSException {
        if (info.getEntry() == null || info.getEntry().size() == 0) {
            return;
        }
        String paramValue = "false";
        CompanyOrgUnitInfo company = info.getEntry().get(0).getCompanyOrgUnit();
        try {
            if (company != null) {
                IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.ctx);
                paramValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "AP_032");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isPresentToAp = false;
        if ("true".equals(paramValue)) {
            isPresentToAp = true;
        }
        PurInWarehsEntryCollection entrys = info.getEntry();
        PurInWarehsEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            entry.setUnReturnedBaseQty(entry.getBaseQty().abs());
            entry.setCanDirectReqQty(entry.getQty().abs());
            entry.setCanDirectReqBaseQty(entry.getBaseQty().abs());
            entry.setHasSameCou(false);
            if (entrys.get(i).get("isPresent") == null) {
                entrys.get(i).setIsPresent(false);
            }
            if (entry.getDiscountAmount() == null) {
                entry.setDiscountAmount(BigDecimal.ZERO);
            }
            if (!entry.isIsPresent() || isPresentToAp) {
                entry.setUnWriteOffQty(entry.getQty());
                entry.setUnWriteOffBaseQty(entry.getBaseQty());
                entry.setUnWriteOffAmount(entry.getPurchaseCost());
                entry.setWrittenOffQty(SysConstant.BIGZERO);
                entry.setWrittenOffBaseQty(SysConstant.BIGZERO);
                entry.setWrittenOffAmount(SysConstant.BIGZERO);
                continue;
            }
            entry.setUnWriteOffQty(SysConstant.BIGZERO);
            entry.setUnWriteOffBaseQty(SysConstant.BIGZERO);
            entry.setUnWriteOffAmount(SysConstant.BIGZERO);
            entry.setWrittenOffQty(entry.getQty());
            entry.setWrittenOffBaseQty(entry.getBaseQty());
            entry.setWrittenOffAmount(entry.getActualCost());
        }
    }
}

