/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.purin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;

public class PurInSetSourceStatusProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 3326615534637510088L;

    public PurInSetSourceStatusProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurInSetSourceStatusProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurInSetSourceStatusProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        boolean isAudit;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isAudit = false;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = objCol.getObject(i);
            this.setSourceBillStatus(this.ctx, model, isAudit);
        }
    }

    private void setSourceBillStatus(Context ctx, IObjectValue model, boolean isAudit) throws BOSException {
        int i;
        int size;
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)"T_IM_PurInWarehsEntry") && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)"T_IM_PurInWarehsEntry", (String)info.getId().toString())) {
            return;
        }
        if (info.getEntry().get(0).getSourceBillId() == null) {
            return;
        }
        String bizTypeID = info.getBizType().getId().toString();
        if (!this.isReturnBiz(bizTypeID)) {
            return;
        }
        ArrayList<String> closeList = new ArrayList<String>();
        ArrayList<String> auditList = new ArrayList<String>();
        HashSet<String> sourceIds = new HashSet<String>();
        String sourceBIllID = "";
        if (info.isIsReversed()) {
            size = info.getEntry().size();
            for (i = 0; i < size; ++i) {
                sourceBIllID = info.getEntry().get(i).getPurOrder();
                sourceIds.add(sourceBIllID);
            }
        } else {
            size = info.getEntry().size();
            for (i = 0; i < size; ++i) {
                sourceBIllID = info.getEntry().get(i).getSourceBillId();
                sourceIds.add(sourceBIllID);
            }
        }
        StringBuffer str = new StringBuffer();
        str.append(" select t2.fid as fid , ");
        str.append(" case when ");
        str.append("  (t2.FTotalSaleReturnBaseQty <= round(decimal( t2.FBaseQty * round(decimal(1 - ISNULL(t2.FQtyLackRate,0)/100,21,8),4) ,21,8) ,b.FQtyPrecision)  ");
        str.append("  and t2.FTotalPurReturnBaseQty <= round(decimal( t2.FBaseQty * round(decimal(1 - ISNULL(t2.FQtyLackRate,0)/100,21,8),4) ,21,8) ,b.FQtyPrecision) )");
        str.append("  then '1' ");
        str.append("  else '2'  end  as isClose ");
        str.append("  from T_IM_TransferOrderBillEntry t2 inner join  T_IM_TransferOrderBill t1 on t1.fid = t2.fparentid ");
        str.append("inner join t_bd_multimeasureunit b on t2.fmaterialid = b.fmaterialid and t2.fbaseunitid = b.fmeasureunitid ");
        str.append("  where t1.fid in ").append(SCMServerUtils.getInStringFromSet(sourceIds)).append(" ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rs.next()) {
                String isClose = rs.getString("isClose");
                String fid = rs.getString("fid");
                if (isClose.equals("1")) {
                    closeList.add(fid);
                    continue;
                }
                auditList.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        String auditids = InvServerUtils.getInStringFromList(auditList);
        String coloseids = InvServerUtils.getInStringFromList(closeList);
        if (auditids != null && auditids.length() > 0) {
            String str2 = "UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID in " + auditids;
            String str4 = "UPDATE T_IM_TransferOrderBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID in " + SCMServerUtils.getInStringFromSet(sourceIds) + "";
            DbUtil.execute((Context)ctx, (String)str2);
            DbUtil.execute((Context)ctx, (String)str4);
        } else {
            String str3 = "UPDATE T_IM_TransferOrderBill SET FBaseStatus = 7  WHERE FID in " + SCMServerUtils.getInStringFromSet(sourceIds) + "";
            DbUtil.execute((Context)ctx, (String)str3);
            String upSNSql = "update t_iv_materialserialnumber set fbillbasestatus = 7 where fbillid in " + SCMServerUtils.getInStringFromSet(sourceIds);
            DbUtil.execute((Context)ctx, (String)upSNSql);
        }
        if (coloseids != null && coloseids.length() > 0) {
            String str1 = "UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 7  WHERE FID in " + coloseids;
            DbUtil.execute((Context)ctx, (String)str1);
        }
        StringBuffer sql = new StringBuffer();
        String billIds = SCMServerUtils.getInStringFromSet(sourceIds);
        sql.append(" update T_IM_TransferOrderBill set fbasestatus = ").append(7);
        sql.append(" where fid in ").append(billIds);
        sql.append(" and fid not in (select fparentid from T_IM_TransferOrderBillEntry where fbasestatus <> 7 and fparentid in");
        sql.append(billIds).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer upSNSqlBuff = new StringBuffer();
        upSNSqlBuff.append(" update t_iv_materialserialnumber set fbillbasestatus = ").append(7);
        upSNSqlBuff.append(" where fbillid in ").append(billIds);
        upSNSqlBuff.append(" and fbillid not in (select fparentid from T_IM_TransferOrderBillEntry where fbasestatus <> 7 and fparentid in");
        upSNSqlBuff.append(billIds).append(")");
        DbUtil.execute((Context)ctx, (String)upSNSqlBuff.toString());
    }

    private boolean isReturnBiz(String bizTypeID) {
        boolean flag = false;
        if (bizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=") || bizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=") || bizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            flag = true;
        }
        return flag;
    }
}

