/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.bizprocess.processor.InvDefaultValueProcessor;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;

public class SaleIssueDefaultValueProcessor
extends InvDefaultValueProcessor {
    private static final long serialVersionUID = 1L;

    public SaleIssueDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleIssueDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleIssueDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected void doProcess4Save(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Save(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        int len = collection.size();
        for (int i = 0; i < len; ++i) {
            SaleIssueBillInfo info = (SaleIssueBillInfo)collection.getObject(i);
            CompanyOrgUnitInfo company = this.getSouDelegateCou(this.ctx, info.getStorageOrgUnit().getId().toString());
            SaleIssueEntryCollection entries = info.getEntry();
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                SaleIssueEntryInfo entryInfo = entries.get(j);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                this.setDefaultZero((InvBillBaseInfo)info, (InvBillBaseEntryInfo)entryInfo);
                this.setDefaultValueOfEntry(info, entryInfo);
                if (entryInfo.getCompanyOrgUnit() != null) continue;
                entryInfo.setCompanyOrgUnit(company);
            }
            this.setValue4Entry(info);
        }
    }

    @Override
    protected void doProcess4Submit(BatchActionResults batchResults) throws EASBizException, BOSException {
        super.doProcess4Submit(batchResults);
        if (batchResults == null || batchResults.getObjCollection() == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        boolean isFromGui = false;
        int len = collection.size();
        for (int i = 0; i < len; ++i) {
            SaleIssueBillInfo info = (SaleIssueBillInfo)collection.getObject(i);
            if (i == 0 && info.get("isFromGui") == null) {
                isFromGui = true;
                info.remove("isFromGui");
            }
            CompanyOrgUnitInfo company = this.getSouDelegateCou(this.ctx, info.getStorageOrgUnit().getId().toString());
            if (info.getCurrency() == null) {
                info.setCurrency(company.getBaseCurrency());
            }
            ObjectUuidPK localCurrencyPK = new ObjectUuidPK(company.getBaseCurrency().getId());
            ObjectUuidPK currentCurrencyPk = new ObjectUuidPK(info.getCurrency().getId());
            if (localCurrencyPK.toString().equals(currentCurrencyPk.toString())) {
                info.setExchangeRate(BigDecimal.ONE);
            }
            ExchangeRateInfo exchangeRateInfo = null;
            if (info.getExchangeRate() == null) {
                exchangeRateInfo = this.getExchangeRate(this.ctx, company, (IObjectPK)currentCurrencyPk, (IObjectPK)localCurrencyPK);
                if (exchangeRateInfo != null) {
                    info.setExchangeRate(exchangeRateInfo.getConvertRate());
                } else {
                    info.setExchangeRate(new BigDecimal("1.00"));
                }
            }
            if (info.getConvertMode() == null) {
                if (info.getSourceBillType() != null) {
                    if (exchangeRateInfo == null) {
                        exchangeRateInfo = this.getExchangeRate(this.ctx, company, (IObjectPK)currentCurrencyPk, (IObjectPK)localCurrencyPK);
                    }
                    info.setConvertMode(exchangeRateInfo.getConvertMode());
                } else {
                    info.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                }
            }
            if (info.get("isSysBill") == null) {
                info.setIsSysBill(false);
            }
            SaleIssueEntryCollection entries = info.getEntry();
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                SaleIssueEntryInfo entryInfo = entries.get(j);
                if (entryInfo.getDiscountType() == null) {
                    entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
                }
                if (entryInfo.get("isBetweenCompanySend") == null) {
                    entryInfo.setIsBetweenCompanySend(false);
                }
                if (entryInfo.get("isCenterBalance") == null) {
                    entryInfo.setIsCenterBalance(false);
                }
                if (entryInfo.get("isLocked") == null) {
                    entryInfo.setIsLocked(false);
                }
                if (entryInfo.get("isSquareBalance") == null) {
                    entryInfo.setIsSquareBalance(false);
                }
                this.setDefaultValueOfEntry(info, entryInfo);
            }
            if (!isFromGui) {
                try {
                    new SaleIssueAlgorithmForInfo(info, this.ctx).revalue();
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            this.setValue4Entry(info);
        }
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        info.setNumber("102");
        return info;
    }

    public void setDefaultZero(InvBillBaseInfo info, InvBillBaseEntryInfo entryInfo) {
        SaleIssueEntryInfo entry = (SaleIssueEntryInfo)entryInfo;
        if (entry.getActualPrice() == null) {
            entry.setActualPrice(SysConstant.BIGZERO);
        }
        if (entry.getBaseUnitActualCost() == null) {
            entry.setBaseUnitActualCost(SysConstant.BIGZERO);
        }
        if (entry.getConfirmBaseQty() == null) {
            entry.setConfirmBaseQty(SysConstant.BIGZERO);
        }
        if (entry.getConfirmQty() == null) {
            entry.setConfirmQty(SysConstant.BIGZERO);
        }
        if (entry.getDiscount() == null) {
            entry.setDiscount(SysConstant.BIGZERO);
        }
        if (entry.getDrewBaseQty() == null) {
            entry.setDrewBaseQty(SysConstant.BIGZERO);
        }
        if (entry.getDrewQty() == null) {
            entry.setDrewQty(SysConstant.BIGZERO);
        }
        if (entry.getLocalAmount() == null) {
            entry.setLocalAmount(SysConstant.BIGZERO);
        }
        if (entry.getLocalNonTaxAmount() == null) {
            entry.setLocalNonTaxAmount(SysConstant.BIGZERO);
        }
        if (entry.getLocalPrice() == null) {
            entry.setLocalPrice(SysConstant.BIGZERO);
        }
        if (entry.getLocalTax() == null) {
            entry.setLocalTax(SysConstant.BIGZERO);
        }
        if (entry.getNonTaxAmount() == null) {
            entry.setNonTaxAmount(SysConstant.BIGZERO);
        }
        if (entry.getOrderPrice() == null) {
            entry.setOrderPrice(SysConstant.BIGZERO);
        }
        if (entry.getPrice() == null) {
            entry.setPrice(SysConstant.BIGZERO);
        }
        if (entry.getSalePrice() == null) {
            entry.setSalePrice(SysConstant.BIGZERO);
        }
        if (entry.getTax() == null) {
            entry.setTax(SysConstant.BIGZERO);
        }
        if (entry.getTaxPrice() == null) {
            entry.setTaxPrice(SysConstant.BIGZERO);
        }
        if (entry.getTaxRate() == null) {
            entry.setTaxRate(SysConstant.BIGZERO);
        }
        if (entry.getTotalInWarehsQty() == null) {
            entry.setTotalInWarehsQty(SysConstant.BIGZERO);
        }
    }

    private void setDefaultValueOfEntry(SaleIssueBillInfo info, SaleIssueEntryInfo entry) throws BOSException, EASBizException {
        CustomerInfo customer = info.getCustomer();
        if (entry.getBalanceCustomer() == null) {
            entry.setBalanceCustomer(customer);
        }
        if (entry.getPaymentCustomer() == null) {
            entry.setPaymentCustomer(entry.getBalanceCustomer());
        }
        if (entry.getOrderCustomer() == null) {
            entry.setOrderCustomer(entry.getBalanceCustomer());
        }
        if (entry.getAssociateBaseQty() == null) {
            entry.setAssociateBaseQty(entry.getBaseQty());
        }
        if (entry.getUndeliverBaseQty() == null) {
            entry.setUndeliverBaseQty(entry.getBaseQty());
        }
        if (entry.getUndeliverQty() == null) {
            entry.setUndeliverQty(entry.getQty());
        }
        if (entry.getUnInBaseQty() == null) {
            entry.setUnInBaseQty(entry.getBaseQty());
        }
        if (entry.getUnInQty() == null) {
            entry.setUnInQty(entry.getQty());
        }
        if (entry.getUnReturnedBaseQty() == null || entry.getUnReturnedBaseQty().signum() == 0) {
            entry.setUnReturnedBaseQty(entry.getBaseQty());
        }
        if (entry.getUnWriteOffAmount() == null) {
            entry.setUnWriteOffAmount(entry.isIsPresent() ? SysConstant.BIGZERO : entry.getActualCost());
        }
        if (entry.getUnWriteOffBaseQty() == null || entry.getUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) == 0) {
            entry.setUnWriteOffBaseQty(entry.isIsPresent() ? SysConstant.BIGZERO : entry.getBaseQty());
        }
        if (entry.getUnWriteOffQty() == null || entry.getUnWriteOffQty().compareTo(BigDecimal.ZERO) == 0) {
            entry.setUnWriteOffQty(entry.isIsPresent() ? SysConstant.BIGZERO : entry.getQty());
        }
        if (entry.getWrittenOffAmount() == null) {
            entry.setWrittenOffAmount(entry.isIsPresent() ? entry.getActualCost() : SysConstant.BIGZERO);
        }
        if (entry.getWrittenOffBaseQty() == null) {
            entry.setWrittenOffBaseQty(entry.isIsPresent() ? entry.getBaseQty() : SysConstant.BIGZERO);
        }
        if (entry.getWrittenOffQty() == null) {
            entry.setWrittenOffQty(entry.isIsPresent() ? entry.getQty() : SysConstant.BIGZERO);
        }
    }

    protected void doProcess4UnAudit(IObjectCollection collection) throws EASBizException, BOSException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.setUnSettleQtyToZero(this.ctx, collection.getObject(i));
            this.updateWriteenOffQty(this.ctx, collection.getObject(i));
        }
    }

    private CompanyOrgUnitInfo getSouDelegateCou(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = null;
        if (StringUtils.isEmpty((String)souId)) {
            return cou;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iOrgUnitRelation.getToUnit(souId, 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return cou;
    }

    private void setUnSettleQtyToZero(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        boolean isConsOut = SCMBaseCommonUtil.isConsOutSaleIssueBill((BizTypeInfo)info.getBizType(), (TransactionTypeInfo)info.getTransactionType());
        boolean isConsReturn = SCMBaseCommonUtil.isConsRtSaleIssueBill((BizTypeInfo)info.getBizType(), (TransactionTypeInfo)info.getTransactionType());
        if (isConsOut || isConsReturn && info.getSourceBillType() == null) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_IM_SaleIssueEntry set FUnSettleQty=0, FUnSettleBaseQty=0 where FParentID = ?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{model.getUuid("id").toString()});
        }
    }

    private void updateWriteenOffQty(Context ctx, IObjectValue model) throws BOSException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_SaleIssueEntry SET FWrittenOffQty = 0, FWrittenOffBaseQty = 0,FWrittenOffAmount = 0, ");
        sql.append("                                FUnWriteOffQty = fqty, FUnWriteOffBaseQty = FBaseQty, FUnWriteOffAmount = 0 ");
        sql.append(" WHERE FParentID = '").append(info.getId().toString()).append("' AND FIsPresent = 1 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    @Override
    protected String getEntryName() {
        return "entry";
    }

    private void setValue4Entry(SaleIssueBillInfo info) {
        if (info == null || info.getEntry() == null || info.getEntry().size() <= 0) {
            return;
        }
        String paramValue = "false";
        CompanyOrgUnitInfo company = info.getEntry().get(0).getCompanyOrgUnit();
        try {
            if (company != null) {
                IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.ctx);
                paramValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "AR_032");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean paramResult = false;
        if ("true".equals(paramValue)) {
            paramResult = true;
        }
        BigDecimal zero = BigDecimal.ZERO;
        SaleIssueEntryCollection entrys = info.getEntry();
        SaleIssueEntryInfo entry = null;
        BigDecimal qty = null;
        BigDecimal baseQty = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            qty = entry.getQty();
            baseQty = entry.getBaseQty();
            if (entry.isIsPresent()) {
                if (paramResult) {
                    entry.setUnWriteOffQty(qty);
                    entry.setUnWriteOffBaseQty(baseQty);
                    entry.setWrittenOffQty(zero);
                    entry.setWrittenOffBaseQty(zero);
                } else {
                    entry.setUnWriteOffQty(zero);
                    entry.setUnWriteOffBaseQty(zero);
                    entry.setWrittenOffQty(qty);
                    entry.setWrittenOffBaseQty(baseQty);
                }
            } else {
                entry.setUnWriteOffQty(qty);
                entry.setUnWriteOffBaseQty(baseQty);
                entry.setWrittenOffQty(zero);
                entry.setWrittenOffBaseQty(zero);
            }
            entry.setUnReturnedBaseQty(baseQty.abs());
            entry.setUndeliverQty(qty.abs());
            entry.setUndeliverBaseQty(baseQty.abs());
            entry.setUnInQty(qty.abs());
            entry.setUnInBaseQty(baseQty.abs());
            entry.setAssociateQty(qty.abs());
            entry.setAssociateBaseQty(baseQty.abs());
        }
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        return SCMSelectorFactory.getSaleIssueBillSelector((boolean)true);
    }
}

