/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WriteBackPostRequisitionProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 7603137538919029664L;
    private Map<String, SaleOrderInfo> saleOrderMap = new HashMap<String, SaleOrderInfo>();

    public WriteBackPostRequisitionProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public WriteBackPostRequisitionProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public WriteBackPostRequisitionProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            this.writeBack((SaleIssueBillInfo)objCol.getObject(i));
        }
    }

    private void writeBack(SaleIssueBillInfo invBillBaseInfo) throws EASBizException, BOSException {
        String coreType;
        SaleIssueEntryCollection entryCollection = invBillBaseInfo.getEntry();
        if (!BillBaseStatusEnum.AUDITED.equals((Object)invBillBaseInfo.getBaseStatus())) {
            return;
        }
        ArrayList<String> postRequisitionIDList = new ArrayList<String>();
        SaleIssueEntryInfo entry = null;
        BillTypeInfo sourceTypeInfo = invBillBaseInfo.getSourceBillType();
        if (sourceTypeInfo == null) {
            return;
        }
        boolean SALEORDER005 = false;
        if (entryCollection.size() > 0 && entryCollection.get(0).getSaleOrgUnit() != null) {
            String saleOrgUnit = entryCollection.get(0).getSaleOrgUnit().getId().toString();
            String paramValue = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(saleOrgUnit), (String)"SALEORDER005");
            SALEORDER005 = Boolean.valueOf(paramValue);
        }
        String sourceType = sourceTypeInfo.getId().toString();
        SaleOrderInfo saleOrderInfo = null;
        int size = entryCollection.size();
        for (int i = 0; i < size && (entry = entryCollection.get(i)).getCoreBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreType = entry.getCoreBillType().getId().toString()) && "510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(sourceType); ++i) {
            if (entry.getSaleOrder() == null || entry.getSaleOrgUnit() == null || BillBaseStatusEnum.CLOSED.equals((Object)(saleOrderInfo = this.getSaleOrderInfo(entry.getSaleOrder())).getBaseStatus()) || !SALEORDER005) continue;
            postRequisitionIDList.add(entry.getSourceBillEntryId());
        }
        if (postRequisitionIDList.size() > 0) {
            IObjectPK[] pks = new IObjectPK[postRequisitionIDList.size()];
            int size2 = postRequisitionIDList.size();
            for (int i = 0; i < size2; ++i) {
                pks[i] = new ObjectUuidPK((String)postRequisitionIDList.get(i));
            }
            PostRequisitionEntryFactory.getLocalInstance((Context)this.ctx).updateOrderByPostRequisition(pks);
        }
    }

    private SaleOrderInfo getSaleOrderInfo(String saleOrderId) throws BOSException, EASBizException {
        SaleOrderInfo result = this.saleOrderMap.get(saleOrderId);
        if (result == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseStatus"));
            result = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(saleOrderId), sic);
            this.saleOrderMap.put(saleOrderId, result);
        }
        return result;
    }
}

