/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.saleissue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;

public class WriteBackTransferOrderProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 2641231867151445744L;

    public WriteBackTransferOrderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public WriteBackTransferOrderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public WriteBackTransferOrderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        assert (batchResults.getObjCollection() != null);
        boolean isAudit = false;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            isAudit = true;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            isAudit = false;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            this.writeBackTotalqty(this.ctx, objCol.getObject(i), isAudit);
        }
    }

    private void writeBackTotalqty(Context ctx, IObjectValue model, boolean isAudit) throws BOSException, SCMBillException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        String tableName = this.getTableName(ctx, info);
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)info.getId().toString())) {
            return;
        }
        HashSet<String> sourceIds = new HashSet<String>();
        SaleIssueEntryCollection entryCollection = info.getEntry();
        if (entryCollection.get(0).getSourceBillId() != null) {
            for (int i = 0; i < entryCollection.size(); ++i) {
                String billtype = entryCollection.get(i).getCoreBillTypeId();
                if (billtype == null || !billtype.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) continue;
                String coreId = entryCollection.get(i).getSourceBillEntryId();
                sourceIds.add(coreId);
            }
            if (!sourceIds.isEmpty()) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", sourceIds, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("baseStatus"));
                viewInfo.setSelector(selector);
                TransferOrderBillEntryCollection entryInfoCol = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx).getTransferOrderBillEntryCollection(viewInfo);
                for (int j = 0; j < entryInfoCol.size(); ++j) {
                    TransferOrderBillEntryInfo transferBillentryInfo = entryInfoCol.get(j);
                    if (transferBillentryInfo.getBaseStatus() != EntryBaseStatusEnum.CLOSED || !isAudit) continue;
                    throw new SCMBillException(SCMBillException.CLOSE_NOT_AUDIT);
                }
            }
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)"T_IM_SaleIssueEntry") && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)"T_IM_SaleIssueEntry", (String)info.getId().toString())) {
            return;
        }
        String bizTypeID = info.getBizType().getId().toString();
        if (!this.isReturnBiz(bizTypeID)) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        SaleIssueEntryInfo entry = null;
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            entry = info.getEntry().get(i);
            ids.add(entry.getSourceBillEntryId());
            if (entry.getCoreBillType() == null) continue;
            ids.add(entry.getSaleOrderEntry());
        }
        if (ids.size() <= 0) {
            return;
        }
        String tranOrderEntryIds = InvServerUtils.getSqlIdsStrForColl(ids);
        String sign = " + ";
        if (!isAudit) {
            sign = " - ";
        } else if (isAudit && info.isIsReversed()) {
            sign = " + ";
        }
        StringBuffer writeBack = new StringBuffer();
        writeBack.append("update T_IM_TransferOrderBillEntry as t10 set (FTotalSaleReturnQty,FTotalSaleReturnBaseQty,FAssociateQty,FArAssociateBaseQty) = ( ");
        writeBack.append("  select isnull(t3.FTotalSaleReturnQty, 0) ").append(sign).append(" t11.FTQty,");
        writeBack.append("   isnull(t3.FTotalSaleReturnBaseQty, 0) ").append(sign).append(" t11.FTBaseQty, ");
        writeBack.append("   isnull(t3.FTotalSaleReturnBaseQty, 0) ").append(sign).append(" t11.FTBaseQty,");
        writeBack.append("   case when isnull(t3.FBaseQty,0) - isnull(t3.FSaleInvoiceQty,0) > 0 ");
        writeBack.append("     then isnull(t3.FBaseQty,0) - isnull(t3.FSaleInvoiceQty,0) ");
        writeBack.append("     else isnull(t3.FTotalSaleReturnBaseQty,0) ").append(sign).append(" isnull(t11.FTBaseQty,0) - isnull(t3.FSaleInvoiceQty,0) ");
        writeBack.append("   end ");
        writeBack.append("from T_IM_TransferOrderBillEntry t3 inner join ( ");
        writeBack.append(" select t3.fid as FTID, sum(round(decimal( isnull(t1.FQty,0) * t5.FBaseConvsRate / t6.FBaseConvsRate,21,8), t6.FQtyPrecision)) FTQty, sum(isnull(t1.FBaseQty,0)) FTBaseQty ");
        writeBack.append(" from T_IM_SaleIssueEntry t1 ");
        writeBack.append(" inner join T_IM_SaleIssueBill t2 on t1.fparentid = t2.fid ");
        writeBack.append(" inner join  T_IM_TransferOrderBillEntry t3 on (t1.fsourcebillentryid = t3.fid or t1.FSaleOrderEntryID = t3.fid) ");
        writeBack.append(" inner join t_bd_multimeasureunit t5 on t1.FMaterialID = t5.FMaterialID and t1.FUnitID = t5.fmeasureunitid ");
        writeBack.append(" inner join t_bd_multimeasureunit t6 on t3.FMaterialID = t6.FMaterialID and t3.FUnitID = t6.fmeasureunitid ");
        writeBack.append(" where t3.fid in (" + tranOrderEntryIds + ") and t2.fid = '" + info.getId().toString() + "' group by t3.fid ");
        writeBack.append(") t11 on t11.FTID =t3.fid ");
        writeBack.append("where t3.fid in (" + tranOrderEntryIds + ") and t3.fid = t10.fid )");
        DbUtil.execute((Context)ctx, (String)writeBack.toString());
    }

    private String getTableName(Context ctx, SaleIssueBillInfo info) {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(info.getEntry().get(0).getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    private boolean isReturnBiz(String bizTypeID) {
        boolean flag = false;
        if (bizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=") || bizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=") || bizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            flag = true;
        }
        return flag;
    }
}

