/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.stocktransfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRelationCollection;
import com.kingdee.eas.basedata.scm.common.SettlementRelationFactory;
import com.kingdee.eas.basedata.scm.common.SettlementRelationInfo;
import com.kingdee.eas.basedata.scm.common.SettlementRuleInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class StockTransferBillAfterSubmitProcessor
extends AbstractBusinessProcessor {
    private static final String LINE = "\n";

    public StockTransferBillAfterSubmitProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public StockTransferBillAfterSubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public StockTransferBillAfterSubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    private void setEntryPrice(StockTransferBillInfo info) throws BOSException, EASBizException {
        if (this.checkComForProCen((IObjectValue)info)) {
            this.setPriceForProCen((IObjectValue)info);
        }
    }

    private boolean checkComForProCen(IObjectValue model) throws BOSException, EASBizException {
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        if ("d8e80652-0118-1000-e000-04c5c0a812202407435C".equals(info.getBizType().getId().toString())) {
            OrgUnitCollection reqProCenOrgCollection;
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
            StorageOrgUnitInfo supStoOrg = info.getIssueStorageOrgUnit();
            StorageOrgUnitInfo reqStoOrg = info.getReceiptStorageOrgUnit();
            ProfitCenterOrgUnitInfo supProCenOrgInfo = null;
            ProfitCenterOrgUnitInfo reqProCenOrgInfo = null;
            OrgUnitCollection supProCenOrgCollection = iOrgUnitRelation.getToUnit(supStoOrg.getId().toString(), 4, 6);
            if (supProCenOrgCollection.size() > 0) {
                supProCenOrgInfo = (ProfitCenterOrgUnitInfo)supProCenOrgCollection.get(0);
            }
            if ((reqProCenOrgCollection = iOrgUnitRelation.getToUnit(reqStoOrg.getId().toString(), 4, 6)).size() > 0) {
                reqProCenOrgInfo = (ProfitCenterOrgUnitInfo)reqProCenOrgCollection.get(0);
            }
            if (supProCenOrgInfo == null || reqProCenOrgInfo == null) {
                throw new InvBizException(InvBizException.STORAGE_HAVE_NO_PROCEN);
            }
            if (supProCenOrgInfo.getId().toString().equals(reqProCenOrgInfo.getId().toString())) {
                return false;
            }
            OrgUnitCollection supComOrgUnitCollection = iOrgUnitRelation.getToUnit(supProCenOrgInfo.getId().toString(), 6, 1);
            CompanyOrgUnitInfo supComOrgInfo = (CompanyOrgUnitInfo)supComOrgUnitCollection.get(0);
            OrgUnitCollection reqComOrgUnitCollection = iOrgUnitRelation.getToUnit(reqProCenOrgInfo.getId().toString(), 6, 1);
            CompanyOrgUnitInfo reqComOrgInfo = (CompanyOrgUnitInfo)reqComOrgUnitCollection.get(0);
            if (!supComOrgInfo.getId().toString().equals(reqComOrgInfo.getId().toString())) {
                throw new InvBizException(InvBizException.PROCEN_NOT_SAME_COMPANY);
            }
            return true;
        }
        return false;
    }

    private void setPriceForProCen(IObjectValue model) throws BOSException, EASBizException {
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        SettlementRelationInfo relationInfo = this.getSettlementRelationInfo(this.ctx, info);
        if (relationInfo != null) {
            this.setPrice(this.ctx, info, relationInfo);
        }
    }

    private SettlementRelationInfo getSettlementRelationInfo(Context ctx, StockTransferBillInfo info) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitInfo supStoOrg = info.getIssueStorageOrgUnit();
        StorageOrgUnitInfo reqStoOrg = info.getReceiptStorageOrgUnit();
        ProfitCenterOrgUnitInfo supProCenOrgInfo = null;
        ProfitCenterOrgUnitInfo reqProCenOrgInfo = null;
        OrgUnitCollection supProCenOrgCollection = iOrgUnitRelation.getToUnit(supStoOrg.getId().toString(), 4, 6);
        supProCenOrgInfo = (ProfitCenterOrgUnitInfo)supProCenOrgCollection.get(0);
        OrgUnitCollection reqProCenOrgCollection = iOrgUnitRelation.getToUnit(reqStoOrg.getId().toString(), 4, 6);
        reqProCenOrgInfo = (ProfitCenterOrgUnitInfo)reqProCenOrgCollection.get(0);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("supCompanyOrg"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.settlementRule.id"));
        sic.add(new SelectorItemInfo("entries.settlementRule.name"));
        sic.add(new SelectorItemInfo("entries.settlementRule.number"));
        sic.add(new SelectorItemInfo("entries.settlementRule.materialGroupStandard"));
        view.setSelector(sic);
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("supProfitCenter.id", (Object)supProCenOrgInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("reqProfitCenter.id", (Object)reqProCenOrgInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizRelationType", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(2)));
        filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0118-1000-e000-04c5c0a812202407435C"));
        SettlementRelationCollection settlementRelationCollection = SettlementRelationFactory.getLocalInstance((Context)ctx).getSettlementRelationCollection(view);
        if (settlementRelationCollection.size() > 0) {
            return settlementRelationCollection.get(0);
        }
        return null;
    }

    private void setPrice(Context ctx, StockTransferBillInfo info, SettlementRelationInfo relationInfo) throws BOSException, EASBizException {
        SettlementRuleInfo ruleInfo = relationInfo.getEntries().get(0).getSettlementRule();
        boolean isMaterialGroup = false;
        if (ruleInfo.getMaterialGroupStandard() != null) {
            isMaterialGroup = true;
        }
        String tempTable = "";
        try {
            tempTable = this.createTempTable(ctx);
            this.insertDataToTable(ctx, tempTable, info.getId().toString(), ruleInfo.getId().toString(), isMaterialGroup);
            List<ResultTo> toList = this.putDataToResultToList(ctx, tempTable, relationInfo, info);
            this.handleListPrice(ctx, toList);
            this.updateTableForPrice(ctx, toList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    private String createTempTable(Context ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("create table tempTable ( ").append(LINE);
        sql.append("FStockTransferBillEntryID varchar(44),").append(LINE);
        sql.append("FMaterialID varchar(44),").append(LINE);
        sql.append("FUnitID varchar(44),").append(LINE);
        sql.append("FCurrencyID varchar(44),").append(LINE);
        sql.append("FAssistPropertyID varchar(44),").append(LINE);
        sql.append("FQty numeric(21,8) default 0,").append(LINE);
        sql.append("FRuleEntryID varchar(44),").append(LINE);
        sql.append("FAddRate numeric(21,8) default 0,").append(LINE);
        sql.append("FAddPrice numeric(21,8) default 0").append(LINE);
        sql.append(")");
        String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        return tempTable;
    }

    private void insertDataToTable(Context ctx, String tempTable, String infoId, String ruleId, boolean isMaterialGroup) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tempTable).append(" (FStockTransferBillEntryID,FMaterialID,FUnitID,").append(LINE);
        sql.append("FCurrencyID,FAssistPropertyID,FQty,FRuleEntryID,FAddRate,FAddPrice)").append(LINE);
        sql.append("select stbe.FID as FStockTransferBillentryID,stbe.FMaterialID,stbe.FUnitID,stb.FCurrencyID,").append(LINE);
        sql.append(" stbe.FAssistPropertyID,stbe.FQty,sre.FID as FRuleEntryID,sre.FAdditionRate,sre.FAddConstantPrice").append(LINE);
        sql.append(" from T_IM_StockTransferBillEntry stbe inner join T_IM_StockTransferBill stb on stbe.FParentID=stb.FID").append(LINE);
        if (!isMaterialGroup) {
            sql.append(" inner join T_SCM_SettlementRuleEntry sre on sre.FMaterialID=stbe.FMaterialID").append(LINE);
            sql.append(" inner join T_SCM_SettlementRule sr on sr.FID=sre.FParentID").append(LINE);
            sql.append(" where stb.FID= '").append(infoId);
        } else {
            sql.append(" inner join T_BD_MaterialGroupDetial mgd on mgd.FMaterialID = stbe.FMaterialID ");
            sql.append(" inner join T_SCM_SettlementRule sr on sr.FMaterialGroupStandardID = mgd.FMaterialGroupStandardID").append(LINE);
            sql.append(" inner join T_SCM_SettlementRuleEntry sre on sr.FID=sre.FParentID").append(LINE);
            sql.append(" inner join T_BD_MATERIALGROUP mg on mg.fid = sre.FMaterialGroupID").append(LINE);
            sql.append(" inner join T_BD_MATERIALGROUP mg1 on mg1.fid = mgd.FMATERIALGROUPID ");
            sql.append(" where (mg.flongnumber=mg1.FLONGNUMBER or charindex(mg.flongnumber || '!',mg1.FLONGNUMBER)>0)").append(LINE);
            sql.append(" and stb.FID= '").append(infoId);
        }
        sql.append("' and sr.FID= '").append(ruleId);
        sql.append("' and sre.FPriceRule=0 and sre.FCurrencySource=1").append(LINE);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private List<ResultTo> putDataToResultToList(Context ctx, String tempTable, SettlementRelationInfo relationInfo, StockTransferBillInfo info) throws BOSException, EASBizException, SQLException {
        ArrayList<ResultTo> list = new ArrayList<ResultTo>();
        StringBuilder sql = new StringBuilder();
        SaleOrgUnitInfo saleOrg = this.getDefaultSaleOrg(ctx, relationInfo, info);
        if (saleOrg == null) {
            return list;
        }
        ProfitCenterOrgUnitInfo reqProfitCenter = relationInfo.getReqProfitCenter();
        CompanyOrgUnitInfo companyOrgUnitInfo = relationInfo.getSupCompanyOrg();
        sql.append("select temp.FStockTransferBillEntryID,temp.FMaterialID,temp.FUnitID,").append(LINE);
        sql.append("temp.FAssistPropertyID,temp.FQty,temp.FRuleEntryID,temp.FAddRate,m.FBaseUnit,").append(LINE);
        sql.append(" temp.FAddPrice,temp.FCurrencyID,m.FPricePrecision,c.FID FCustomerId,cur.FPrecision FAmountPrecison from ").append(LINE);
        sql.append(tempTable).append(" as temp inner join T_BD_Material m on m.FID=temp.FMaterialID").append(LINE);
        sql.append(" inner join T_BD_Customer c on c.FIsInternalCompany=1 and c.FInternalCustomerType=1").append(LINE);
        sql.append(" and c.FUSEDSTATUS=1 and c.FInternalProfitCenter = '");
        sql.append(reqProfitCenter.getId().toString()).append("'").append(LINE);
        sql.append(" inner join T_BD_Currency cur on cur.FID=temp.FCurrencyID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            ResultTo to = new ResultTo();
            to.entryId = rs.getString("FStockTransferBillEntryID");
            to.pricePrecision = rs.getInt("FPricePrecision");
            to.assistPropertyID = rs.getString("FAssistPropertyID");
            to.customerId = rs.getString("FCustomerId");
            to.materialId = rs.getString("FMaterialID");
            to.unitId = rs.getString("FUnitID");
            to.baseUnitId = rs.getString("FBaseUnit");
            to.qty = rs.getBigDecimal("FQty");
            to.saleOrgID = saleOrg.getId().toString();
            to.addRate = rs.getBigDecimal("FAddRate");
            to.addPrice = rs.getBigDecimal("FAddPrice");
            to.priceRule = 0;
            to.ruleEntryID = rs.getString("FRuleEntryID");
            to.ruleCurrencyID = rs.getString("FCurrencyID");
            to.companyOrgId = companyOrgUnitInfo.getId().toString();
            to.amountPrecision = rs.getInt("FAmountPrecison");
            list.add(to);
        }
        return list;
    }

    private SaleOrgUnitInfo getDefaultSaleOrg(Context ctx, SettlementRelationInfo relationInfo, StockTransferBillInfo info) throws BOSException, EASBizException {
        SaleOrgUnitInfo saleOrg = relationInfo.getEntries().get(0).getSaleOrgUnit();
        if (saleOrg == null) {
            String storageOrg = info.getIssueStorageOrgUnit().getId().toString();
            saleOrg = (SaleOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getDefaultToUnit(storageOrg, 4, 2);
        }
        return saleOrg;
    }

    private void handleListPrice(Context ctx, List<ResultTo> toList) throws BOSException, EASBizException {
        ResultTo to = null;
        PriceCondition[] priceConditions = new PriceCondition[toList.size()];
        IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        for (int i = 0; i < toList.size(); ++i) {
            to = toList.get(i);
            if (StringUtils.isEmpty((String)to.materialId) || to.priceRule != 0 || StringUtils.isEmpty((String)to.saleOrgID)) continue;
            PriceCondition priceCondition = new PriceCondition();
            SaleOrgUnitInfo sou = new SaleOrgUnitInfo();
            sou.setId(BOSUuid.read((String)to.saleOrgID));
            priceCondition.setSaleOrg(sou);
            CustomerInfo customerInfo = new CustomerInfo();
            customerInfo.setId(BOSUuid.read((String)to.customerId));
            priceCondition.setCustomerInfo(customerInfo);
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)to.materialId));
            MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
            baseUnitInfo.setId(BOSUuid.read((String)to.baseUnitId));
            materialInfo.setBaseUnit(baseUnitInfo);
            priceCondition.setMaterialInfo(materialInfo);
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            companyOrgInfo.setId(BOSUuid.read((String)to.companyOrgId));
            priceCondition.setCompanyOrg(companyOrgInfo);
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)to.ruleCurrencyID));
            priceCondition.setCurrencyInfo(currencyInfo);
            priceCondition.setOrderQty(to.qty);
            priceCondition.setMeasureUnit(to.unitId);
            priceCondition.setCurDate((Date)ts);
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            if (!StringUtils.isEmpty((String)to.assistPropertyID)) {
                AsstAttrValueInfo asstValueInfo = new AsstAttrValueInfo();
                asstValueInfo.setId(BOSUuid.read((String)to.assistPropertyID));
                priceCondition.setAssiProperty(asstValueInfo);
            }
            priceConditions[i] = priceCondition;
        }
        List[] priceArr = iProvider.getPrices(priceConditions);
        ArrayList priceList = new ArrayList();
        if (priceArr != null) {
            for (int i = 0; i < priceArr.length; ++i) {
                if (priceArr[i] == null) continue;
                priceList.addAll(priceArr[i]);
            }
        }
        this.setResultPrice(ctx, priceList, toList);
    }

    private void setResultPrice(Context ctx, List priceList, List<ResultTo> toList) throws BOSException, EASBizException {
        ResultTo to = null;
        BigDecimal price = BigDecimal.ZERO;
        int precision = 2;
        for (int i = 0; i < toList.size(); ++i) {
            to = toList.get(i);
            precision = to.pricePrecision;
            SalePriceTO priceTo = this.matchPriceByList(ctx, priceList, to);
            if (priceTo != null) {
                price = priceTo.price;
                if (to.addRate != null && to.addRate.compareTo(BigDecimal.ZERO) != 0) {
                    price = price.multiply(BigDecimal.ONE.add(to.addRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(precision, 4);
                }
                if (to.addPrice != null && to.addPrice.compareTo(BigDecimal.ZERO) != 0) {
                    price = price.add(to.addPrice).setScale(precision, 4);
                }
                to.price = price;
                to.amount = to.qty.multiply(price).setScale(to.amountPrecision, 4);
                to.isGetPrice = true;
                continue;
            }
            to.isGetPrice = false;
        }
    }

    private SalePriceTO matchPriceByList(Context ctx, List priceList, ResultTo to) throws BOSException, EASBizException {
        boolean found = false;
        Iterator it = priceList.iterator();
        while (it.hasNext()) {
            found = true;
            SalePriceTO priceTo = (SalePriceTO)it.next();
            if (priceTo.material != null && !priceTo.material.equals(to.materialId)) {
                found = false;
                continue;
            }
            if (priceTo.measureUnit != null && !priceTo.measureUnit.equals(to.unitId)) {
                found = false;
                continue;
            }
            if (priceTo.assistProperty != null && to.assistPropertyID != null && !priceTo.assistProperty.equals(to.assistPropertyID)) {
                found = false;
                continue;
            }
            if (found && to.qty != null) {
                BigDecimal entryQty = to.qty;
                BigDecimal qty1 = priceTo.qtyFrom;
                BigDecimal qty2 = priceTo.qtyTo;
                if (qty1 != null && entryQty.compareTo(qty1) < 0 || qty2 != null && entryQty.compareTo(qty2) > 0) {
                    found = false;
                    continue;
                }
            }
            if (!found) continue;
            return priceTo;
        }
        return null;
    }

    private void updateTableForPrice(Context ctx, List<ResultTo> toList) throws BOSException, EASBizException {
        ResultTo to = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < toList.size(); ++i) {
            StringBuilder sql = new StringBuilder();
            to = toList.get(i);
            if (!to.isGetPrice) continue;
            sql.append(" update T_IM_StockTransferBillEntry set FPrice=").append(to.price).append(LINE);
            sql.append(", FAmount=").append(to.amount).append(LINE);
            sql.append(", FIsSalePrice=1").append(LINE);
            sql.append(" where FID= '").append(to.entryId).append("'").append(LINE);
            sqlList.add(sql.toString());
        }
        this.batchExecuteSql(ctx, sqlList);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchExecuteSql(Context ctx, List<String> sqlList) throws BOSException {
        if (sqlList == null) return;
        if (sqlList.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = conn.createStatement();
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                statement.addBatch(sqlList.get(i));
            }
            statement.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private class ResultTo {
        public String entryId;
        public int pricePrecision;
        public String assistPropertyID;
        public String customerId;
        public String materialId;
        public String companyOrgId;
        public String unitId;
        public String baseUnitId;
        public BigDecimal qty;
        public String saleOrgID;
        public BigDecimal addRate;
        public BigDecimal addPrice;
        public int priceRule;
        public String ruleEntryID;
        public String ruleCurrencyID;
        public BigDecimal price;
        public BigDecimal amount;
        public int amountPrecision;
        public boolean isGetPrice;

        private ResultTo() {
        }
    }
}

