/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.stocktransfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPriceFacade;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrices;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import java.util.ArrayList;
import java.util.List;

public class StockTransferInnerBizPricesProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -8625008523026882361L;

    public StockTransferInnerBizPricesProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public StockTransferInnerBizPricesProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public StockTransferInnerBizPricesProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block4: {
            IObjectCollection objCol;
            block3: {
                objCol = batchResults.getObjCollection();
                if (null == objCol || objCol.size() == 0) {
                    return;
                }
                if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) break block3;
                int size = objCol.size();
                for (int i = 0; i < size; ++i) {
                    this.setInnerBizPrices(this.ctx, (StockTransferBillInfo)objCol.getObject(i));
                }
                break block4;
            }
            if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) break block4;
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                this.delInnerBizPrices(this.ctx, (StockTransferBillInfo)objCol.getObject(i));
            }
        }
    }

    private void setInnerBizPrices(Context ctx, StockTransferBillInfo billInfo) throws EASBizException, BOSException {
        BizRoleTypeEnum bizRoleType = null;
        String bizType = billInfo.getBizType().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.IssueSide;
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        }
        if (bizRoleType == null) {
            return;
        }
        StockTransferBillEntryCollection stb = billInfo.getEntry();
        StockTransferBillEntryInfo entryInfo = null;
        IMultiSidesTransferPriceFacade ims = MultiSidesTransferPriceFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<List> listPrice = new ArrayList<List>();
        PriceInfo priceInfo = null;
        ArrayList<PriceInfo> list = new ArrayList<PriceInfo>();
        for (int i = 0; i < stb.size(); ++i) {
            entryInfo = stb.get(i);
            if (entryInfo.isIsPresent()) continue;
            priceInfo = this.getPriceInfoByBill(billInfo, entryInfo, bizRoleType);
            list.add(priceInfo);
        }
        listPrice.add(list);
        if (("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) && stb != null && stb.size() > 0) {
            PriceParamInfo[] priceParamInfos3 = new PriceParamInfo[stb.size()];
            PriceParamInfo[] priceParamInfos4 = new PriceParamInfo[stb.size()];
            for (int i = 0; i < stb.size(); ++i) {
                entryInfo = stb.get(i);
                if (entryInfo.isIsPresent()) continue;
                priceParamInfos3[i] = this.getPriceParamInfo(billInfo, entryInfo, BizRoleTypeEnum.IssueSide);
                if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(billInfo.getBizType().getId().toString())) {
                    priceParamInfos4[i] = this.getPriceParamInfo(billInfo, entryInfo, BizRoleTypeEnum.RequireSide);
                }
                List list3 = ims.getPriceCollection(priceParamInfos3);
                listPrice.add(list3);
                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(billInfo.getBizType().getId().toString())) continue;
                List list4 = ims.getPriceCollection(priceParamInfos4);
                listPrice.add(list4);
            }
        }
    }

    private void delInnerBizPrices(Context ctx, StockTransferBillInfo billInfo) throws EASBizException, BOSException {
        String bizType = billInfo.getBizType().getId().toString();
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            IMultiSidesTransferPrices imss = MultiSidesTransferPricesFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("transferBill.id", (Object)billInfo.getId().toString()));
            imss.delete(filter);
        }
    }

    private PriceParamInfo getPriceParamInfo(StockTransferBillInfo billInfo, StockTransferBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType) {
        PriceParamInfo priceParamInfo = new PriceParamInfo();
        priceParamInfo.setStockTransferID(billInfo.getId().toString());
        priceParamInfo.setStockTransferEntryID(entryInfo.getId().toString());
        priceParamInfo.setBizTypeInfo(billInfo.getBizType());
        priceParamInfo.setCompanyOrgUnit(billInfo.getIssueCompanyOrgUnit());
        priceParamInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
        priceParamInfo.setIssueCompanyOrgUnitInfo(entryInfo.getIssueCompanyOrgUnit());
        priceParamInfo.setMateial(entryInfo.getMaterial());
        priceParamInfo.setCurrencyInfo(billInfo.getCurrency());
        priceParamInfo.setTransferOrderBillTaxRate(entryInfo.getTaxRate());
        priceParamInfo.setQty(entryInfo.getQty());
        priceParamInfo.setUnit(entryInfo.getUnit());
        priceParamInfo.setBaseUnit(entryInfo.getBaseUnit());
        priceParamInfo.setSupplyRelation(entryInfo.getSupplyRelation());
        priceParamInfo.setBizRole(bizRoleType);
        priceParamInfo.setIssueSaleOrgUnitInfo(entryInfo.getIssueSaleOrgUnit());
        priceParamInfo.setSupplySaleOrgUnitInfo(entryInfo.getSupplySaleOrgUnit());
        priceParamInfo.setRequireSaleOrgUnitInfo(entryInfo.getRequireSaleOrgUnit());
        return priceParamInfo;
    }

    private PriceInfo getPriceInfoByBill(StockTransferBillInfo billInfo, StockTransferBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType) {
        PriceInfo priceInfo = new PriceInfo();
        priceInfo.setBizRoleType(bizRoleType);
        priceInfo.setStockTransferID(billInfo.getId().toString());
        priceInfo.setStockTransferEntryID(entryInfo.getId().toString());
        priceInfo.setPricePrecision(entryInfo.getMaterial().getPricePrecision());
        priceInfo.setPrice(entryInfo.getPrice());
        priceInfo.setTaxPrice(entryInfo.getTaxPrice());
        priceInfo.setTaxRate(entryInfo.getTaxRate());
        priceInfo.setActualPrice(entryInfo.getActualPrice());
        priceInfo.setDiscountType(entryInfo.getDiscountType());
        priceInfo.setDiscountRate(entryInfo.getDiscountRate());
        priceInfo.setActualTaxPrice(entryInfo.getActualTaxPrice());
        return priceInfo;
    }
}

