/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.transferorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoCloseStockReqEntryProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -992583090554239780L;

    public AutoCloseStockReqEntryProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public AutoCloseStockReqEntryProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public AutoCloseStockReqEntryProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizActionEnum bizAction = null;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.AUDIT;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (null == objCol || objCol.size() == 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            this.writeBack((SCMBillBaseInfo)objCol.getObject(i), bizAction);
        }
    }

    private void writeBack(SCMBillBaseInfo billInfo, BizActionEnum action) throws EASBizException, BOSException {
        String entryTabName = this.getEntryTableName(billInfo);
        if (StringUtils.isEmpty((String)entryTabName)) {
            throw new BOSException("Config error  or  not supported !");
        }
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)entryTabName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)entryTabName, (String)pk.toString())) {
            return;
        }
        StringBuffer sql = new StringBuffer("select distinct FSourceBillId,FSourceBillEntryId,FID ");
        sql.append("from ").append(entryTabName).append(" where FParentID = '").append(pk.toString()).append("'");
        ArrayList<String> srcEntryIds = new ArrayList<String>();
        IRowSet rs = null;
        HashMap<String, String> destSrcEntryMap = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                srcEntryIds.add(rs.getString(2));
                destSrcEntryMap.put(rs.getString(3), rs.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        BillTypeInfo srcBillType = billInfo.getSourceBillType();
        if (srcBillType != null && "MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(srcBillType.getId().toString()) && srcEntryIds != null && srcEntryIds.size() > 0) {
            if (action == BizActionEnum.UNAUDIT) {
                StockReqEntryFactory.getLocalInstance((Context)this.ctx).autoUnClose(destSrcEntryMap, entryTabName);
            } else {
                StockReqEntryFactory.getLocalInstance((Context)this.ctx).autoClose(destSrcEntryMap, entryTabName);
            }
        }
    }

    private String getEntryTableName(SCMBillBaseInfo info) {
        if (info instanceof TransferOrderBillInfo) {
            return "T_IM_TransferOrderBillEntry";
        }
        if (info instanceof StockReqInfo) {
            return "T_IM_StockReqEntry";
        }
        return null;
    }
}

