/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.transferorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.SupplyRelationServerUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class SupplyRelation4TransferOrderProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -5878135159177280504L;

    public SupplyRelation4TransferOrderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public SupplyRelation4TransferOrderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SupplyRelation4TransferOrderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (null == objCol || objCol.size() == 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            this.generate((TransferOrderBillInfo)objCol.getObject(i));
        }
    }

    private void generate(TransferOrderBillInfo billInfo) throws BOSException, EASBizException {
        Map newSRMap = SupplyRelationServerUtils.generateSupplyRelationByTransferOrder((Context)this.ctx, (TransferOrderBillInfo)billInfo);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.prepareStatement("update T_IM_TransferOrderBillEntry set FSupplyRelationID = ? where FId = ?");
            for (Object key : newSRMap.keySet()) {
                if (key == null) continue;
                stmt.setString(1, newSRMap.get(key).toString());
                stmt.setString(2, key.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }
}

