/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.transferorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransferOrderDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -845584135982751406L;
    private static String[] fields = new String[]{"isPresent", "qty", "baseQty", "price", "amount", "taxAmount", "saleInvoiceQty", "taxPrice", "tax", "issueQty", "receiptQty", "taxRate", "assistQty", "purInvoiceQty", "issueBaseQty", "receiptBaseQty", "saleInvoiceBaseQty", "purInvoiceBaseQty", "unIssueBaseQty", "purInvoiceAmount", "saleInvoiceAmount", "totalAccountPayable", "totalAccountReceivable", "totalIssueQty", "balanceCostPrice", "balanceCostRate", "actualPrice", "discountRate", "actualTaxPrice", "localAmount", "localTax", "localTaxAmount", "discountAmount", "localDiscountAmount", "arAssociateBaseQty", "apAssociateBaseQty", "assCoefficient", "baseStatus", "associateQty", "qtyOverRate", "qtyLackRate", "notControlQty", "totalPurReturnBaseQty", "totalPurReturnQty", "totalSaleReturnBaseQty", "totalSaleReturnQty"};
    private static String[] subFields = new String[]{"discountAmount", "tax", "discountRate", "taxRate", "totalIssueQty", "planDeliveryQty"};
    private static String[] headFields = new String[]{"hasEffected", "baseStatus", "year", "period", "isshipment", "exchangeRate", "isInitBill", "isInTax"};

    public TransferOrderDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public TransferOrderDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public TransferOrderDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"Eg5BUQEVEADgAAABwKgOEEY+1VI="));
        billType.setNumber("141");
        return billType;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected String getEntryName() {
        return "entry";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection col = batchResults.getObjCollection();
        if (col == null || col.size() <= 0) {
            return;
        }
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            this.doProcess4Save(col);
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            this.doProcess4Submit(col);
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction) || BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            // empty if block
        }
    }

    private void doProcess4Submit(IObjectCollection col) {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            TransferOrderBillInfo billInfo = (TransferOrderBillInfo)col.getObject(index);
            this.setNULLToZERO((IObjectValue)billInfo);
            billInfo.setVersion(1);
            billInfo.setAlterDate(null);
            billInfo.setAlterPerson(null);
            billInfo.setOldBillID(null);
            billInfo.setOldBillStatus(BillBaseStatusEnum.ADD);
            if (billInfo.getBillType() == null) {
                billInfo.setBillType(this.getBillType());
            }
            TransferOrderBillEntryCollection entryCol = billInfo.getEntry();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                TransferOrderBillEntryInfo entry = entryCol.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                if (entry.getAssistQty() == null) {
                    entry.setAssistQty(new BigDecimal("0.00"));
                }
                entry.setUnIssueBaseQty(entry.getBaseQty());
                entry.setArAssociateBaseQty(entry.getBaseQty());
                entry.setApAssociateBaseQty(entry.getBaseQty());
                entry.setVersion(1);
                entry.setOldBillEntryID(null);
                entry.setOldBillEntryStatus(EntryBaseStatusEnum.ADD);
            }
        }
    }

    protected Map<String, String> getDelegateToUnitMap(Context ctx, Set<String> fromUnitIDSet, int fromType, int toType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("fromUnit"));
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        view.getSelector().add(new SelectorItemInfo("isDefault"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", fromUnitIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        OrgUnitRelationCollection ourCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        HashMap<String, String> delegateToUnitMap = new HashMap<String, String>(ourCollection.size() * 2 + 1);
        OrgUnitRelationInfo orgUnitRelationInfo = null;
        int n = ourCollection.size();
        for (int i = 0; i < n; ++i) {
            orgUnitRelationInfo = ourCollection.get(i);
            String fromUnitID = orgUnitRelationInfo.getFromUnit().getId().toString();
            String toUnitID = orgUnitRelationInfo.getToUnit().getId().toString();
            if (delegateToUnitMap.containsKey(fromUnitID) && !orgUnitRelationInfo.isIsDefault()) continue;
            delegateToUnitMap.put(fromUnitID, toUnitID);
        }
        return delegateToUnitMap;
    }

    private void doProcess4Save(IObjectCollection col) throws EASBizException, BOSException {
        int len = col.size();
        for (int index = 0; index < len; ++index) {
            TransferOrderBillEntryInfo entry;
            TransferOrderBillInfo billInfo = (TransferOrderBillInfo)col.getObject(index);
            billInfo.setVersion(1);
            billInfo.setAlterDate(null);
            billInfo.setAlterPerson(null);
            billInfo.setOldBillID(null);
            billInfo.setOldBillStatus(BillBaseStatusEnum.ADD);
            TransferOrderBillEntryCollection entrys = billInfo.getEntry();
            HashSet<String> storageOrgUnitIDSet = new HashSet<String>();
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entry = entrys.get(i);
                if (entry != null && entry.getReceiveCompanyOrgUnit() == null && entry.getReceiveStorageOrgUnit() != null && entry.getReceiveStorageOrgUnit().getId() != null) {
                    storageOrgUnitIDSet.add(entry.getReceiveStorageOrgUnit().getId().toString());
                }
                if (entry == null || entry.getIssueCompanyOrgUnit() != null || entry.getIssueStorageOrgUnit() == null || entry.getIssueStorageOrgUnit().getId() == null) continue;
                storageOrgUnitIDSet.add(entry.getIssueStorageOrgUnit().getId().toString());
            }
            Map<Object, Object> delegateToUnitMap = null;
            delegateToUnitMap = storageOrgUnitIDSet.size() > 0 ? this.getDelegateToUnitMap(this.ctx, storageOrgUnitIDSet, 4, 1) : new HashMap();
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            String companyOrgUnitID = null;
            int size2 = entrys.size();
            for (int i = 0; i < size2; ++i) {
                entry = entrys.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                entry.setUnIssueBaseQty(entry.getBaseQty());
                entry.setArAssociateBaseQty(entry.getBaseQty());
                entry.setApAssociateBaseQty(entry.getBaseQty());
                entry.setVersion(1);
                entry.setOldBillEntryID(null);
                entry.setOldBillEntryStatus(EntryBaseStatusEnum.ADD);
                if (entry != null && entry.getReceiveCompanyOrgUnit() == null && entry.getReceiveStorageOrgUnit() != null && entry.getReceiveStorageOrgUnit().getId() != null && (companyOrgUnitID = (String)delegateToUnitMap.get(entry.getReceiveStorageOrgUnit().getId().toString())) != null && companyOrgUnitID.trim().length() > 0) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)companyOrgUnitInfo.clone();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyOrgUnitID));
                    entry.setReceiveCompanyOrgUnit(companyOrgUnitInfo);
                }
                if (entry == null || entry.getIssueCompanyOrgUnit() != null || entry.getIssueStorageOrgUnit() == null || entry.getIssueStorageOrgUnit().getId() == null || (companyOrgUnitID = (String)delegateToUnitMap.get(entry.getIssueStorageOrgUnit().getId().toString())) == null || companyOrgUnitID.trim().length() <= 0) continue;
                companyOrgUnitInfo = (CompanyOrgUnitInfo)companyOrgUnitInfo.clone();
                companyOrgUnitInfo.setId(BOSUuid.read((String)companyOrgUnitID));
                entry.setIssueCompanyOrgUnit(companyOrgUnitInfo);
            }
            this.setNULLToZERO((IObjectValue)billInfo);
        }
    }

    private void setNULLToZERO(IObjectValue invBill) {
        int headSize = headFields.length;
        for (int i = 0; i < headSize; ++i) {
            if (invBill.get(headFields[i]) != null) continue;
            invBill.setBigDecimal(headFields[i], SCMConstant.BIGDECIMAL_ZERO);
        }
        TransferOrderBillInfo TransferOrderBillInfo2 = (TransferOrderBillInfo)invBill;
        IObjectCollection entrys = null;
        entrys = (IObjectCollection)TransferOrderBillInfo2.get("entry");
        if (entrys != null) {
            TransferOrderBillEntryInfo entry = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                int j;
                entry = (TransferOrderBillEntryInfo)entrys.getObject(i);
                for (j = 0; j < fields.length; ++j) {
                    if (entry.get(fields[j]) != null) continue;
                    entry.setBigDecimal(fields[j], SCMConstant.BIGDECIMAL_ZERO);
                }
                for (j = 0; j < subFields.length; ++j) {
                    if (!entry.containsKey(subFields[j]) || entry.get(subFields[j]) != null) continue;
                    entry.setBigDecimal(subFields[j], SCMConstant.BIGDECIMAL_ZERO);
                }
            }
        }
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        String action = "";
        if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
            action = "save";
        } else if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            action = "submit";
        } else if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            action = "audit";
        } else if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            action = "unaudit";
        }
        IObjectCollection collection = batchResults.getObjCollection();
        BillTypeInfo billTypeInfo = this.getBillType();
        if (collection == null && billTypeInfo != null) {
            BusinessProcessorHelper.batchLoadBizObjectsManual((Context)this.ctx, (BOSObjectType)this.bosType, (String)action, (String)billTypeInfo.getId().toString(), (BatchActionResults)batchResults);
            collection = batchResults.getObjCollection();
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        return super.check(batchResults);
    }
}

