/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.bizprocess.processor.transferorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransferOrderInnerBizPricesProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -3008184931375656288L;
    private Map<String, String> paramMap = new HashMap<String, String>();

    public TransferOrderInnerBizPricesProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public TransferOrderInnerBizPricesProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public TransferOrderInnerBizPricesProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block4: {
            IObjectCollection objCol;
            block3: {
                objCol = batchResults.getObjCollection();
                if (null == objCol || objCol.size() == 0) {
                    return;
                }
                if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) break block3;
                int size = objCol.size();
                for (int i = 0; i < size; ++i) {
                    this.setInnerBizPrices((TransferOrderBillInfo)objCol.getObject(i));
                }
                break block4;
            }
            if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) break block4;
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                this.delInnerBizPrices((TransferOrderBillInfo)objCol.getObject(i));
            }
        }
    }

    private void delInnerBizPrices(TransferOrderBillInfo billInfo) throws EASBizException, BOSException {
        String bizType = billInfo.getBizType().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType) || "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("transferBill.id", (Object)billInfo.getId().toString());
            MultiSidesTransferPricesFactory.getLocalInstance((Context)this.ctx).delete(filter);
        }
    }

    private void setInnerBizPrices(TransferOrderBillInfo billInfo) throws EASBizException, BOSException {
        BizRoleTypeEnum bizRoleType = null;
        String bizType = billInfo.getBizType().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.IssueSide;
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        }
        if (bizRoleType == null) {
            return;
        }
        TransferOrderBillEntryCollection stb = billInfo.getEntry();
        TransferOrderBillEntryInfo entryInfo = null;
        int size = stb.size();
        ArrayList<Object> listPrice = new ArrayList<Object>(3 * size);
        for (int i = 0; i < size; ++i) {
            entryInfo = stb.get(i);
            BigDecimal qty = entryInfo.getQty();
            if (qty == null || qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
                listPrice.add(i, null);
                continue;
            }
            listPrice.add(i, entryInfo.isIsPresent() ? null : this.getPriceInfoByBill(billInfo, stb.get(i), bizRoleType));
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            CompanyOrgUnitInfo supplyCouInfo = billInfo.getIssueCompanyOrgUnit();
            ExchangeRateInfo exchangeRateInfo = this.getExchangeRate(this.ctx, supplyCouInfo, (IObjectPK)new ObjectUuidPK(billInfo.getCurrency().getId()));
            if (exchangeRateInfo != null) {
                exchangeRateInfo.setConvertRate(billInfo.getExchangeRate());
            }
            PriceParamInfo[] paramInfos = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) ? new PriceParamInfo[size] : new PriceParamInfo[2 * size];
            Map<String, MaterialCompanyInfoInfo> matCouMap = this.getMaterialCouMap(stb, this.ctx);
            for (int i = 0; i < size; ++i) {
                entryInfo = stb.get(i);
                BigDecimal qty = entryInfo.getQty();
                if (qty == null || qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
                    paramInfos[i] = null;
                } else {
                    PriceParamInfo priceParamInfo = paramInfos[i] = entryInfo.isIsPresent() ? null : this.getPriceParamInfo(this.ctx, billInfo, entryInfo, BizRoleTypeEnum.IssueSide, matCouMap, exchangeRateInfo);
                }
                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(billInfo.getBizType().getId().toString()) && !"ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(billInfo.getBizType().getId().toString())) continue;
                paramInfos[size + i] = qty == null || qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0 ? null : (entryInfo.isIsPresent() ? null : this.getPriceParamInfo(this.ctx, billInfo, entryInfo, BizRoleTypeEnum.RequireSide, matCouMap, exchangeRateInfo));
            }
            List list = MultiSidesTransferPriceFacadeFactory.getLocalInstance((Context)this.ctx).getPriceCollection(paramInfos);
            int length = paramInfos.length;
            for (int i = 0; i < length; ++i) {
                listPrice.add(size + i, list.get(i));
            }
        }
        MultiSidesTransferPricesFactory.getLocalInstance((Context)this.ctx).saveByPriceInfo(listPrice, billInfo);
    }

    private Map<String, MaterialCompanyInfoInfo> getMaterialCouMap(TransferOrderBillEntryCollection entryCol, Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            TransferOrderBillEntryInfo entryInfo = entryCol.get(i);
            filter.appendFilterItem("Mateial", (Object)entryInfo.getMaterial().getId().toString());
            filter.appendFilterItem("Company", (Object)entryInfo.getIssueCompanyOrgUnit().getId().toString());
        }
        StringBuffer maskString = new StringBuffer();
        int size2 = filter.getFilterItems().size();
        for (int i = 0; i < size2; i += 2) {
            maskString.append("#").append(i).append(" and ").append("#").append(i + 1);
            if (i >= size2 - 2) continue;
            maskString.append(" or ");
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("Mateial"));
        view.getSelector().add(new SelectorItemInfo("Company"));
        view.getSelector().add(new SelectorItemInfo("AccountType"));
        MaterialCompanyInfoCollection matCouCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
        HashMap<String, MaterialCompanyInfoInfo> result = new HashMap<String, MaterialCompanyInfoInfo>(matCouCol.size());
        int size3 = matCouCol.size();
        for (int i = 0; i < size3; ++i) {
            MaterialCompanyInfoInfo matCouInfo = matCouCol.get(i);
            result.put(matCouInfo.getMateial().getId().toString() + matCouInfo.getCompany().getId().toString(), matCouInfo);
        }
        return result;
    }

    private PriceInfo getPriceInfoByBill(TransferOrderBillInfo billInfo, TransferOrderBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType) {
        PriceInfo priceInfo = new PriceInfo();
        priceInfo.setBizRoleType(bizRoleType);
        priceInfo.setStockTransferID(billInfo.getId().toString());
        priceInfo.setStockTransferEntryID(entryInfo.getId().toString());
        priceInfo.setPricePrecision(entryInfo.getMaterial().getPricePrecision());
        priceInfo.setPrice(entryInfo.getPrice());
        priceInfo.setTaxPrice(entryInfo.getTaxPrice());
        priceInfo.setTaxRate(entryInfo.getTaxRate());
        priceInfo.setActualPrice(entryInfo.getActualPrice());
        priceInfo.setDiscountType(entryInfo.getDiscountType());
        priceInfo.setDiscountRate(entryInfo.getDiscountRate());
        priceInfo.setActualTaxPrice(entryInfo.getActualTaxPrice());
        return priceInfo;
    }

    private PriceParamInfo getPriceParamInfo(Context ctx, TransferOrderBillInfo billInfo, TransferOrderBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType, Map<String, MaterialCompanyInfoInfo> matCouMap, ExchangeRateInfo exchangeRateInfo) throws EASBizException, BOSException {
        PriceParamInfo paramInfo = new PriceParamInfo();
        StorageOrgUnitInfo issueSou = entryInfo.getIssueStorageOrgUnit();
        paramInfo.setStockTransferID(billInfo.getId().toString());
        paramInfo.setStockTransferEntryID(entryInfo.getId().toString());
        String tempBizTypeID = billInfo.getBizType().getId().toString();
        if (tempBizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            tempBizTypeID = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (tempBizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            tempBizTypeID = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (tempBizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            tempBizTypeID = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        BizTypeInfo tempBiztypeInfo = new BizTypeInfo();
        tempBiztypeInfo.setId(BOSUuid.read((String)tempBizTypeID));
        paramInfo.setBizTypeInfo(tempBiztypeInfo);
        paramInfo.setCompanyOrgUnit(billInfo.getIssueCompanyOrgUnit());
        paramInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
        paramInfo.setRequireCompanyOrgUnitInfo(billInfo.getReceiptCompanyOrgUnit());
        paramInfo.setRequireStorageOrgUnitInfo(billInfo.getReceiptStorageOrgUnit());
        paramInfo.setIssueCompanyOrgUnitInfo(entryInfo.getIssueCompanyOrgUnit());
        paramInfo.setMateial(entryInfo.getMaterial());
        paramInfo.setCurrencyInfo(billInfo.getCurrency());
        paramInfo.setTransferOrderBillTaxRate(entryInfo.getTaxRate());
        paramInfo.setQty(entryInfo.getQty());
        paramInfo.setUnit(entryInfo.getUnit());
        paramInfo.setBaseUnit(entryInfo.getBaseUnit());
        paramInfo.setSupplyRelation(entryInfo.getSupplyRelation());
        paramInfo.setBizRole(bizRoleType);
        paramInfo.setCostBizRole(bizRoleType);
        paramInfo.setIssueSaleOrgUnitInfo(entryInfo.getIssueSaleOrgUnit());
        paramInfo.setSupplySaleOrgUnitInfo(entryInfo.getSupplySaleOrgUnit());
        paramInfo.setRequireSaleOrgUnitInfo(entryInfo.getRequireSaleOrgUnit());
        paramInfo.setIssueStorageOrgUnitInfo(issueSou);
        paramInfo.setIssueWarehsInfo(entryInfo.getIssueWarehouse());
        paramInfo.setExchangeRageInfo(exchangeRateInfo);
        if (issueSou == null) {
            paramInfo.setCalType(null);
            paramInfo.setMoveAverage(false);
        } else {
            AccountType accType = matCouMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getIssueCompanyOrgUnit().getId().toString()).getAccountType();
            paramInfo.setMoveAverage(accType == null ? false : accType.equals((Object)AccountType.MOVE_ADD_AVERAGE));
            paramInfo.setCalType(this.getCalType(entryInfo.getIssueCompanyOrgUnit(), ctx));
        }
        paramInfo.setBizDate(billInfo.getBizDate());
        this.setLotCalculate(entryInfo, paramInfo, entryInfo.getMaterial().getId().toString(), matCouMap);
        return paramInfo;
    }

    private String getCalType(CompanyOrgUnitInfo issueCou, Context ctx) throws BOSException, EASBizException {
        String key = "SCM_CAL_002" + issueCou.getId().toString();
        if (!this.paramMap.containsKey(key)) {
            this.paramMap.put(key, ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(issueCou.getId()), "SCM_CAL_002"));
        }
        return this.paramMap.get(key);
    }

    private ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK) throws EASBizException, BOSException {
        if (companyOrgUnitInfo.getBaseCurrency() == null || companyOrgUnitInfo.getBaseExchangeTable() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()), sic);
        }
        ObjectUuidPK destCurrPK = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId());
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, (IObjectPK)destCurrPK);
        return exchangeRateInfo;
    }

    private void setLotCalculate(TransferOrderBillEntryInfo entry, PriceParamInfo priceParamInfo, String materialId, Map<String, MaterialCompanyInfoInfo> matCouMap) throws BOSException {
        String companyOrgUnitID = null;
        if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
            companyOrgUnitID = priceParamInfo.getCompanyOrgUnit().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
            companyOrgUnitID = priceParamInfo.getIssueCompanyOrgUnitInfo().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
            companyOrgUnitID = priceParamInfo.getRequireCompanyOrgUnitInfo().getId().toString();
        }
        MaterialCompanyInfoInfo matCouInfo = matCouMap.get(materialId + companyOrgUnitID);
        if (matCouInfo != null && AccountType.SPECIAL_ACCT.equals((Object)matCouInfo.getAccountType())) {
            AsstAttrValueInfo info;
            priceParamInfo.setSpecialAcct(true);
            priceParamInfo.setLot(matCouInfo.isIsLot());
            priceParamInfo.setAssistProperty(matCouInfo.isIsAssistProperty());
            priceParamInfo.setProject(matCouInfo.isIsProject());
            priceParamInfo.setTrackNumber(matCouInfo.isIsTrackNumber());
            if (entry.getLot() != null) {
                priceParamInfo.setLot(entry.getLot());
            }
            if (entry.getAssistProperty() != null) {
                info = entry.getAssistProperty();
                priceParamInfo.setAssistProperty(info.getId().toString());
            }
            if (entry.getProject() != null) {
                info = entry.getProject();
                priceParamInfo.setProject(info.getId().toString());
            }
            if (entry.getTrackNumber() != null) {
                info = entry.getTrackNumber();
                priceParamInfo.setTrackNumber(info.getId().toString());
            }
        }
    }
}

