/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.kd.ltpa.LtpaTokenManager;
import com.kingdee.eas.csinterface.webservice.model.util.ServcieURLInfo;
import com.kingdee.eas.csinterface.webservice.model.util.WSServiceHelper;
import com.kingdee.eas.scm.nsrm.app.AbstractFetchFacadeControllerBean;
import com.kingdee.eas.scm.nsrm.app.frombiz.ISendFromBizService;
import com.kingdee.eas.scm.nsrm.app.frombiz.SendFromBizUtil;
import com.kingdee.eas.scm.nsrm.app.util.ISCHelper;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmTempParamUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FetchFacadeControllerBean
extends AbstractFetchFacadeControllerBean {
    private static final long serialVersionUID = -8538440016830355447L;
    private static Logger logger = Logger.getLogger(FetchFacadeControllerBean.class);

    @Override
    protected Map _getOpenParam(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String userId = ctx.getCaller().toString();
        String phone = LtpaTokenManager.getPhoneByUseID((Context)ctx, (String)userId);
        String token = null;
        if (phone != null) {
            token = LtpaTokenManager.generate((String)phone);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM004", cu);
        retMap.put("paramValue", paramValue);
        if ("1".equals(paramValue)) {
            retMap.put("user", phone);
            retMap.put("token", token);
        } else {
            retMap.put("user1", phone);
            retMap.put("token1", token);
            Map<String, String> map1 = ISCHelper.getLoginInfo(ctx.getAIS());
            String str = ISCHelper.getAccessToken(map1);
            retMap.putAll(map1);
        }
        return retMap;
    }

    @Override
    protected Map _getWSServiceURL(Context ctx) throws BOSException, EASBizException {
        String remoteService = SrmTempParamUtil.getRemoteService(ctx);
        ServcieURLInfo servcieURLInfo = WSServiceHelper.getServiceInfo((Context)ctx, (String)remoteService, null, null);
        HashMap<String, String> retMap = new HashMap<String, String>();
        String url = servcieURLInfo.getUrl();
        String bodyStr = servcieURLInfo.getBodyStr();
        String serviceMethod = servcieURLInfo.getImpMethod();
        Map bodyMap = ConvertUtil.convertJsonToMap(ctx, bodyStr);
        if (bodyMap.get("tenantid") == null) {
            throw new BOSException("\u96c6\u6210\u5e73\u53f0\u8fdc\u7a0b\u670d\u52a1\u7f16\u7801IERP_Login\u6a21\u677f\u914d\u7f6e\u7684tenantid\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u662f\u5426\u5b58\u5728\u95ee\u9898\uff01");
        }
        String accountId = "";
        if (bodyMap.get("accountId") != null) {
            accountId = bodyMap.get("accountId").toString();
        }
        String tenantId = bodyMap.get("tenantid").toString();
        retMap.put("url", url);
        retMap.put("tenantId", tenantId);
        retMap.put("accountId", accountId);
        return retMap;
    }

    @Override
    protected Map _getSysFilePath(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String homePath = System.getProperty("EAS_HOME");
        String instancePath = System.getProperty("EAS_INSTANCE_HOME");
        ArrayList<String> logsList = new ArrayList<String>();
        File f2 = null;
        File file = new File(instancePath + "//logs");
        if (file.exists()) {
            for (File f2 : file.listFiles()) {
                if (f2.isDirectory()) continue;
                logsList.add(f2.getName());
            }
        }
        ArrayList<String> instanceList = new ArrayList<String>();
        File instanceFile = new File(homePath + "//server//profiles");
        if (instanceFile.exists()) {
            for (File f2 : instanceFile.listFiles()) {
                if (!f2.isDirectory()) continue;
                instanceList.add(f2.getName());
            }
        }
        retMap.put("logsList", logsList);
        retMap.put("instanceList", instanceList);
        retMap.put("EAS_HOME", homePath);
        retMap.put("EAS_INSTANCE_HOME", instancePath);
        return retMap;
    }

    @Override
    protected Map _getFileContent(Context ctx, String fileName) throws BOSException, EASBizException {
        String B;
        if (ConvertUtil.isEmpty(fileName)) {
            return null;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String instancePath = System.getProperty("EAS_INSTANCE_HOME");
        String a = instancePath + "/logs";
        String b = fileName.substring(0, fileName.lastIndexOf("/"));
        String A = a.replace(a.substring(a.indexOf("profiles") + 9, a.indexOf("logs")), "");
        if (!A.equals(B = b.replace(b.substring(b.indexOf("profiles") + 9, b.indexOf("logs")), ""))) {
            retMap.put("errorMsg", "\u53ea\u5141\u8bb8\u8bfb\u53d6\u65e5\u5fd7\u6587\u4ef6\u76ee\u5f55\uff01");
            return retMap;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        BufferedReader bReader = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                retMap.put("errorMsg", "\u7cfb\u7edf\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6\uff01");
                HashMap<String, Object> hashMap = retMap;
                return hashMap;
            }
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            double fileB = ((FileChannel)fc).size();
            double fileKB = new BigDecimal(fileB / 1024.0).setScale(2, 1).doubleValue();
            if (fileKB > 30720.0) {
                retMap.put("errorMsg", "\u6587\u4ef6\u4e0d\u5141\u8bb8\u8d85\u8fc730720KB\uff0c\u5f53\u524d\u6587\u4ef6\u5927\u5c0f" + fileKB + "KB\u3002");
                HashMap<String, Object> hashMap = retMap;
                return hashMap;
            }
            bReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String line = null;
            while ((line = bReader.readLine()) != null) {
                fileList.add(line);
            }
            retMap.put("fileList", fileList);
            retMap.put("fileSize", String.valueOf(fileKB));
        }
        catch (FileNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (bReader != null) {
                    bReader.close();
                }
                if (fc != null) {
                    fc.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        return retMap;
    }

    @Override
    protected String _getTempParamValue(Context ctx, String number) throws BOSException, EASBizException {
        return SrmTempParamUtil.getSrmParamValue(ctx, number);
    }

    @Override
    protected void _saveTempParamValue(Context ctx, String number, String value) throws BOSException, EASBizException {
        if (number == null || value == null) {
            return;
        }
        String sql = "update T_SRM_TempParam set FParamValue = '" + value + "' where FNumber = '" + number + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _httpSendService(Context ctx, String interfaceId, IObjectCollection billCol, boolean sync) throws BOSException, EASBizException {
        ISendFromBizService iSend = SendFromBizUtil.getInstance();
        iSend.send(ctx, interfaceId, billCol, sync);
    }

    @Override
    protected void _httpSendService(Context ctx, String interfaceId, IObjectPK pk, boolean sync) throws BOSException, EASBizException {
        ISendFromBizService iSend = SendFromBizUtil.getInstance();
        iSend.send(ctx, interfaceId, pk, sync);
    }

    @Override
    protected void _httpSendService(Context ctx, String interfaceId, Set pkSet, boolean sync) throws BOSException, EASBizException {
        ISendFromBizService iSend = SendFromBizUtil.getInstance();
        iSend.send(ctx, interfaceId, pkSet, sync);
    }
}

