/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.scm.nsrm.SrmCommonLogInfo;
import com.kingdee.eas.scm.nsrm.SrmLogOperationInfo;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendFromBizService;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelpers;
import com.kingdee.eas.scm.nsrm.app.thread.SendSplitThread;
import com.kingdee.eas.scm.nsrm.app.util.SrmLogOprtUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmTempParamUtil;
import com.kingdee.eas.scm.nsrm.constant.SendSplitConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.EipWebServiceUtil;
import com.kingdee.eas.scm.nsrm.util.ISCWebServiceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendFromBizServiceImpl
extends AbstractSendFromBizService {
    private static Logger logger = Logger.getLogger(SendFromBizServiceImpl.class);
    protected static String tempKey = null;
    protected static SrmCommonLogInfo srmLogInfo = null;

    @Override
    public void send(Context ctx, String interfaceId, IObjectValue objectValue, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || objectValue == null) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        String pk = objectValue.get("id").toString();
        String[] str = new String[]{pk};
        String pks = ConvertUtil.divide2Str(str);
        SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
    }

    @Override
    public void send(Context ctx, String interfaceId, IObjectCollection billCol, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || billCol == null || billCol.size() == 0) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        int size = billCol.size();
        if (this.isSplitSend(interfaceId, size, sync)) {
            this.executeSplit(ctx, interfaceId, billCol, IObjectCollection.class, 0);
        } else {
            String[] str = ConvertUtil.col2StrArr(billCol);
            String pks = ConvertUtil.divide2Str(str);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
        }
    }

    @Override
    public void send(Context ctx, String interfaceId, IObjectPK objPK, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || objPK == null) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        String pk = objPK.toString();
        String[] str = new String[]{pk};
        String pks = ConvertUtil.divide2Str(str);
        SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
    }

    @Override
    public void send(Context ctx, String interfaceId, IObjectPK[] objPKs, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || objPKs == null || objPKs.length == 0) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        int size = objPKs.length;
        if (this.isSplitSend(interfaceId, size, sync)) {
            this.executeSplit(ctx, interfaceId, objPKs, IObjectPK[].class, 0);
        } else {
            String[] str = ConvertUtil.objArr2StrArr(objPKs);
            String pks = ConvertUtil.divide2Str(str);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
        }
    }

    @Override
    public void send(Context ctx, String interfaceId, Set<String> pkSet, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || pkSet == null || pkSet.size() == 0) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        int size = pkSet.size();
        if (this.isSplitSend(interfaceId, size, sync)) {
            this.executeSplit(ctx, interfaceId, pkSet, Set.class, 0);
        } else {
            String[] str = ConvertUtil.set2StrArr(pkSet);
            String pks = ConvertUtil.divide2Str(str);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
        }
    }

    @Override
    public void send(Context ctx, String interfaceId, List<String> pkList, boolean sync) throws BOSException, EASBizException {
        if (ctx == null || interfaceId == null || pkList == null || pkList.size() == 0) {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.send():\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u505c\u6b62\u53d1\u9001..............");
            return;
        }
        int size = pkList.size();
        if (this.isSplitSend(interfaceId, size, sync)) {
            this.executeSplit(ctx, interfaceId, pkList, List.class, 0);
        } else {
            String[] str = ConvertUtil.list2StrArr(pkList);
            String pks = ConvertUtil.divide2Str(str);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
        }
    }

    private void executeSplit(Context ctx, String interfaceId, Object data, Class<?> clz, int splitSize) throws BOSException, EASBizException {
        SendSplitThread sst = new SendSplitThread(ctx, interfaceId, data, clz, splitSize);
        sst.start();
    }

    public static void execute(Context ctx, String interfaceId, String data, boolean sync) throws BOSException, EASBizException {
        try {
            logger.debug((Object)"@@@@SendFromBizServiceImpl.execute():\u65b9\u6cd5\u5f00\u59cb................");
            SrmCommonLogInfo srmLogInfo = new SrmCommonLogInfo();
            srmLogInfo.setInterfaceNo(interfaceId);
            SrmLogOperationInfo logOprtInfo = SrmLogOprtUtil.getSrmLogOprtInfo(ctx, interfaceId);
            if (logOprtInfo != null) {
                srmLogInfo.setOprtObject(logOprtInfo.getOprtObject());
                srmLogInfo.setOprtDescription(logOprtInfo.getOprtDescription());
            }
            SrmLoggerHelpers.start(ctx, srmLogInfo);
            data = SrmLoggerHelpers.getTempKey() + ":" + data;
            JSONObject config = SendFromBizServiceImpl.getEIPConfig(ctx, interfaceId, sync);
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM004", cu);
            if ("1".equals(paramValue)) {
                EipWebServiceUtil.httpSendService(ctx, config.toString(), data, sync);
            } else {
                ISCWebServiceUtil.httpSendService(ctx, interfaceId, data, sync);
            }
        }
        catch (BOSException e) {
            SrmLoggerHelpers.setErrorMsg(e.toString());
            logger.error((Object)("@@@@SendFromBizServiceImpl.execute()\u5f02\u5e38\u4fe1\u606f:" + e.getMessage()));
            throw e;
        }
        catch (EASBizException e) {
            SrmLoggerHelpers.setErrorMsg(e.toString());
            logger.error((Object)("@@@@SendFromBizServiceImpl.execute()\u5f02\u5e38\u4fe1\u606f:" + e.getMessage()));
            throw e;
        }
        finally {
            SrmLoggerHelpers.end(ctx);
        }
        logger.debug((Object)"@@@@SendFromBizServiceImpl.execute():\u65b9\u6cd5\u7ed3\u675f................");
    }

    private boolean isSplitSend(String interfaceId, int size, boolean sync) {
        return size > SendSplitConstants.getNeedSplitQty(interfaceId) && !sync;
    }

    private static JSONObject getEIPConfig(Context ctx, String interfaceId, boolean sync) throws EASBizException, BOSException {
        JSONObject config = new JSONObject();
        try {
            config.put("interfaceId", (Object)interfaceId);
            config.put("license", (Object)SrmTempParamUtil.getIDCode(ctx));
            if (sync) {
                config.put("synchronized", (Object)"1");
            } else {
                config.put("synchronized", (Object)"2");
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        return config;
    }

    private static void startLog(Context ctx) {
        tempKey = SrmLoggerHelper.createTempKey();
        srmLogInfo = SrmLoggerHelper.start(ctx, tempKey);
    }
}

