/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.nsrm.BizDealFacadeFactory;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmAttachmentUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.SelectorFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurInWarehsAuditSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurInWarehsAuditSend.class);
    private PurInWarehsBillCollection oldBillCol = null;
    private PurInWarehsBillCollection newBillCol = null;
    private PurInWarehsBillInfo billInfo = null;
    private PurInWarehsEntryCollection entryCol = null;
    private PurInWarehsEntryInfo entryInfo = null;
    private boolean isInstock = true;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entry");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        IObjectPK[] ipks = ConvertUtil.strArr2ObjArr(pks);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        PurInWarehsBillCollection virtualBill = this.getVirtualBill(ctx, ipks);
        Set<String> virIdSet = this.getVirtualIdSet(virtualBill);
        try {
            this.oldBillCol = (PurInWarehsBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(ev);
            this.oldBillCol.addCollection(virtualBill);
            this.setVirualSign(virIdSet, this.oldBillCol);
            this.calBeforeQty(ctx, this.oldBillCol);
            this.setReceive2Inwarehs(ctx, this.oldBillCol);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PurInWarehsAuditSend,errorMsg:" + e.getMessage()));
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purinwarehsbill", "1");
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurInWarehsAuditSend,errorMsg:" + e.getMessage()));
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purinwarehsbill", "1");
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purinwarehsbill", "1");
            logger.debug((Object)"@@@@PurInWarehsAuditSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    private void setReceive2Inwarehs(Context ctx, PurInWarehsBillCollection oldBillCol2) throws BOSException {
        int j;
        int i;
        PurInWarehsBillInfo info = null;
        PurInWarehsEntryInfo entry = null;
        HashSet<String> receivaEntrylIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < oldBillCol2.size(); ++i2) {
            info = oldBillCol2.get(i2);
            for (int j2 = 0; j2 < info.getEntry().size(); ++j2) {
                entry = info.getEntry().get(j2);
                receivaEntrylIdSet.add(entry.getSourceBillEntryId());
            }
        }
        HashMap receivalMap = new HashMap();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("saloutstockEntryID"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("saloutstockID"));
        filter.getFilterItems().add(new FilterItemInfo("id", receivaEntrylIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurReceivalEntryCollection col = PurReceivalEntryFactory.getLocalInstance((Context)ctx).getPurReceivalEntryCollection(evi);
        PurReceivalEntryInfo receEntryInfo = null;
        Map idMap = null;
        for (int i3 = 0; i3 < col.size(); ++i3) {
            receEntryInfo = col.get(i3);
            idMap = new HashMap<String, String>();
            if (null == receEntryInfo.get("saloutstockID") || null == receEntryInfo.get("saloutstockEntryID")) continue;
            idMap.put("saloutstockID", String.valueOf(receEntryInfo.get("saloutstockID")));
            idMap.put("saloutstockEntryID", String.valueOf(receEntryInfo.get("saloutstockEntryID")));
            receivalMap.put(receEntryInfo.getId().toString(), idMap);
        }
        HashMap inWareMap = new HashMap();
        HashMap<String, String> inware_salIdMap = null;
        for (i = 0; i < oldBillCol2.size(); ++i) {
            info = oldBillCol2.get(i);
            for (j = 0; j < info.getEntry().size(); ++j) {
                inware_salIdMap = new HashMap<String, String>();
                entry = info.getEntry().get(j);
                if (null != entry.get("saloutstockID") && null != entry.get("saloutstockEntryID")) {
                    inware_salIdMap.put("saloutstockID", String.valueOf(entry.get("saloutstockID")));
                    inware_salIdMap.put("saloutstockEntryID", String.valueOf(entry.get("saloutstockEntryID")));
                    inWareMap.put(entry.getId().toString(), idMap);
                    continue;
                }
                idMap = (Map)receivalMap.get(entry.getSourceBillEntryId());
                if (null == idMap) continue;
                entry.put("salID", idMap.get("saloutstockID"));
                entry.put("salEntryID", idMap.get("saloutstockEntryID"));
                inware_salIdMap.put("saloutstockID", (String)idMap.get("saloutstockID"));
                inware_salIdMap.put("saloutstockEntryID", (String)idMap.get("saloutstockEntryID"));
                inWareMap.put(entry.getId().toString(), inware_salIdMap);
            }
        }
        for (i = 0; i < oldBillCol2.size(); ++i) {
            info = oldBillCol2.get(i);
            for (j = 0; j < info.getEntry().size(); ++j) {
                entry = info.getEntry().get(j);
                if (null != entry.get("saloutstockID") && null != entry.get("saloutstockEntryID") || null == (idMap = (Map)inWareMap.get(entry.getSourceBillEntryId()))) continue;
                entry.put("salID", idMap.get("saloutstockID"));
                entry.put("salEntryID", idMap.get("saloutstockEntryID"));
            }
        }
    }

    private void setVirualSign(Set<String> virIdSet, PurInWarehsBillCollection oldBillCol2) {
        PurInWarehsBillInfo info = null;
        for (int i = 0; i < oldBillCol2.size(); ++i) {
            info = oldBillCol2.get(i);
            if (virIdSet.contains(info.getId().toString())) {
                info.put("hasvirtual", (Object)1);
                continue;
            }
            info.put("hasvirtual", (Object)0);
        }
    }

    private Set<String> getVirtualIdSet(PurInWarehsBillCollection virtualBill) {
        HashSet<String> idSet = new HashSet<String>();
        PurInWarehsBillInfo info = null;
        PurInWarehsEntryInfo entry = null;
        for (int i = 0; i < virtualBill.size(); ++i) {
            info = virtualBill.get(i);
            for (int j = 0; j < info.getEntry().size(); ++j) {
                entry = info.getEntry().get(j);
                idSet.add(entry.getSourceBillId());
            }
        }
        return idSet;
    }

    private void calBeforeQty(Context ctx, PurInWarehsBillCollection oldBillCol2) throws EASBizException, BOSException {
        PurInWarehsBillInfo info = null;
        Object entry = null;
        BigDecimal beforeQty = BigDecimal.ZERO;
        for (int i = 0; i < oldBillCol2.size(); ++i) {
            info = oldBillCol2.get(i);
            if (info.getTransactionType().getRiType().getRI().getValue() == 1 && info.getTransactionType().getRiType().getBizDirection().getValue() != 1) continue;
        }
    }

    public void checkData(Context ctx) throws Exception {
        PurInWarehsBillInfo purInfo = null;
        PurInWarehsEntryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new PurInWarehsBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        HashSet<String> orderSet = new HashSet<String>();
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            oldSupplierIdSet.add(supplierID);
            for (int j = 0; j < purInfo.getEntry().size(); ++j) {
                if (null == purInfo.getEntry().get(j).getPurOrderNumber()) continue;
                orderSet.add(purInfo.getEntry().get(j).getPurOrderNumber());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("srmProgress"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("number", orderSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        for (int i = 0; i < purOrderCollection.size(); ++i) {
            orderMap.put(purOrderCollection.get(i).getNumber(), purOrderCollection.get(i).get("srmProgress"));
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus((IObjectCollection)this.oldBillCol, "T_IM_purinwarehsbill", "1");
            logger.debug((Object)"@@@@PurInWarehsAuditSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntry().size(); ++j) {
                Object srmPorgress;
                entry = purInfo.getEntry().get(j);
                if (null == entry.getPurOrderNumber() || null != (srmPorgress = orderMap.get(entry.getPurOrderNumber())) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if (!newSupplierIdSet.contains(supplierID) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
        PurInWarehsBillInfo billInfoForAttach = null;
        for (int i = 0; i < this.newBillCol.size(); ++i) {
            billInfoForAttach = this.newBillCol.get(i);
            SrmAttachmentUtil.setAttachmentsForBill(ctx, (CoreBillBaseInfo)billInfoForAttach);
        }
    }

    private PurInWarehsBillCollection getVirtualBill(Context ctx, IObjectPK[] ipks) throws BOSException, EASBizException {
        Set<String> idSet = ConvertUtil.objArr2Set(ipks);
        EntityViewInfo billEv = new EntityViewInfo();
        FilterInfo BillFilter = new FilterInfo();
        BillFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        billEv.setFilter(BillFilter);
        PurInWarehsBillCollection col = (PurInWarehsBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(billEv);
        PurInWarehsBillInfo info = null;
        PurInWarehsEntryInfo srcentryInfo = null;
        HashMap<String, PurInWarehsEntryInfo> entryMap = new HashMap<String, PurInWarehsEntryInfo>();
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            for (int j = 0; j < info.getEntry().size(); ++j) {
                srcentryInfo = info.getEntry().get(j);
                entryMap.put(srcentryInfo.getId().toString(), srcentryInfo);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("sourceBillId", idSet, CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("parent.isSysBill", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter1);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.addObjectCollection((IObjectCollection)SelectorFactory.getPurInWarehsEntrySelector(""));
        ev.setSelector(sic);
        PurInWarehsEntryCollection entry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(ev);
        HashSet<String> pkSet = new HashSet<String>();
        if (entry != null && entry.size() > 0) {
            for (int i = 0; i < entry.size(); ++i) {
                PurInWarehsEntryInfo entryInfo = (PurInWarehsEntryInfo)entry.getObject(i);
                pkSet.add(entryInfo.getParent().getId().toString());
            }
        }
        billEv = new EntityViewInfo();
        BillFilter = new FilterInfo();
        BillFilter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
        billEv.setFilter(BillFilter);
        col = (PurInWarehsBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(billEv);
        info = null;
        PurInWarehsEntryInfo virtualEntryInfo = null;
        PurInWarehsEntryInfo srcEntryInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            info.put("type", (Object)1);
            for (int j = 0; j < info.getEntry().size(); ++j) {
                virtualEntryInfo = info.getEntry().get(j);
                if (!entryMap.keySet().contains(virtualEntryInfo.getSourceBillEntryId())) continue;
                srcEntryInfo = (PurInWarehsEntryInfo)entryMap.get(virtualEntryInfo.getSourceBillEntryId());
                virtualEntryInfo.put("salEntryID", srcEntryInfo.get("saloutstockEntryID"));
                virtualEntryInfo.put("salID", srcEntryInfo.get("saloutstockID"));
            }
        }
        return col;
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        HashSet<String> partOrderIdSet;
        HashSet<String> newOrderIdSet;
        if (this.newBillCol != null && this.newBillCol.size() == 0) {
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purinwarehsbill");
            return null;
        }
        if (this.isInstock && data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purinwarehsbill");
                return null;
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purinwarehsbill");
                return null;
            }
            if (!"200".equals(dataMap.get("code"))) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purinwarehsbill");
                return null;
            }
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "2", "T_IM_purinwarehsbill");
            HashSet<String> orderIdSet = new HashSet<String>();
            int size = this.newBillCol.size();
            for (int i = 0; i < size; ++i) {
                this.billInfo = this.newBillCol.get(i);
                this.entryCol = (PurInWarehsEntryCollection)this.billInfo.getEntries();
                int length = this.entryCol.size();
                for (int j = 0; j < length; ++j) {
                    this.entryInfo = this.entryCol.get(j);
                    if (this.entryInfo == null || this.entryInfo.getCoreBillType() == null || !"510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(this.entryInfo.getCoreBillType().getId().toString()) || this.entryInfo.getPurOrder() == null) continue;
                    orderIdSet.add(this.entryInfo.getPurOrder());
                }
            }
            if (orderIdSet == null || orderIdSet.size() == 0) {
                logger.debug((Object)"@@@@PurInWarehsAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u6536\u8d27\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
                return null;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("baseStatus"));
            sic.add(new SelectorItemInfo("srmProgress"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orderIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("srmProgress", null, CompareType.NOTEQUALS));
            view.setFilter(filter);
            PurOrderCollection purCol = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
            if (purCol == null || purCol.size() == 0) {
                logger.debug((Object)"@@@@PurInWarehsAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u5165\u5e93\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
                return null;
            }
            PurOrderInfo purInfo = null;
            String purOrderId = null;
            newOrderIdSet = new HashSet<String>();
            partOrderIdSet = new HashSet<String>();
            int size2 = purCol.size();
            for (int i = 0; i < size2; ++i) {
                purInfo = purCol.get(i);
                if (purInfo == null) continue;
                purOrderId = purInfo.getId().toString();
                if (BillBaseStatusEnum.CLOSED.equals((Object)purInfo.getBaseStatus())) {
                    newOrderIdSet.add(purOrderId);
                    continue;
                }
                partOrderIdSet.add(purOrderId);
            }
        } else {
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purinwarehsbill");
            return null;
        }
        SrmProgressUpdateUtil.updateSrmProgressForSet(ctx, newOrderIdSet, "10");
        SrmProgressUpdateUtil.updateSrmProgressForSet(ctx, partOrderIdSet, "9");
        return null;
    }
}

