/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.util.EIPAttachmentUtil;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class PurOrderAlertSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurOrderAlertSend.class);
    private PurOrderCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entries");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = JudgeSupplierIsSrmUtil.getIsSrmFilterEVI(pks, null);
        try {
            this.newBillCol = (PurOrderCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurOrderCollection(ev);
        }
        catch (EASBizException e) {
            logger.error((Object)("@@@@PurOrderAlertSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurOrderAlertSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            logger.debug((Object)"@@@@PurOrderAlertSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
    }

    public void checkData(Context ctx) throws Exception {
        for (int i = 0; i < this.newBillCol.size(); ++i) {
            PurOrderInfo purOrderInfo = this.newBillCol.get(i);
            String id = purOrderInfo.getId().toString();
            AttachmentCollection attachmentCollection = EIPAttachmentUtil.getAttachmentsByBOId((Context)ctx, (String)id);
            if (attachmentCollection == null || attachmentCollection.size() < 0) {
                purOrderInfo.put("attachment", (Object)"");
                continue;
            }
            ArrayList attList = new ArrayList();
            for (int j = 0; j < attachmentCollection.size(); ++j) {
                AttachmentInfo attachmentInfo = attachmentCollection.get(j);
                HashMap<String, Object> fileMap = new HashMap<String, Object>();
                fileMap.put("id", attachmentInfo.getId().toString());
                fileMap.put("name", attachmentInfo.getName().toString());
                fileMap.put("simpleName", attachmentInfo.getSimpleName());
                fileMap.put("size", attachmentInfo.getSize());
                fileMap.put("sizeInByte", attachmentInfo.getSizeInByte());
                fileMap.put("beizhu", attachmentInfo.getBeizhu());
                fileMap.put("description", attachmentInfo.getDescription());
                attList.add(fileMap);
            }
            JSONArray jsonObject = JSONArray.fromObject(attList);
            purOrderInfo.put("attachment", (Object)jsonObject.toString());
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                return null;
            }
            Map dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            if (!"200".equals(dataMap.get("code"))) {
                return null;
            }
        } else {
            return null;
        }
        SrmProgressUpdateUtil.updateExecuteStatusForCol(ctx, (IObjectCollection)this.newBillCol, "2");
        return null;
    }
}

