/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.frombiz.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.nsrm.BizDealFacadeFactory;
import com.kingdee.eas.scm.nsrm.FetchEntityDataFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMAbortException;
import com.kingdee.eas.scm.nsrm.app.frombiz.AbstractSendHandler;
import com.kingdee.eas.scm.nsrm.app.logger.SrmLoggerHelper;
import com.kingdee.eas.scm.nsrm.app.util.JudgeSupplierIsSrmUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmParamUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmProgressUpdateUtil;
import com.kingdee.eas.scm.nsrm.app.util.SyncStatusUpdateUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurReceivalAuditSend
extends AbstractSendHandler {
    private static Logger logger = Logger.getLogger(PurReceivalAuditSend.class);
    private PurReceivalBillCollection oldBillCol = null;
    private PurReceivalBillCollection newBillCol = null;

    @Override
    public Object handleBizOriginal(Context ctx, Object data) throws Exception {
        this.loadData(ctx, data);
        this.checkData(ctx);
        SrmLoggerHelper.calBillAndEntryCount(this.srmLogInfo, (IObjectCollection)this.newBillCol, "entry");
        return this.newBillCol;
    }

    public void loadData(Context ctx, Object data) throws Exception {
        String str = data.toString();
        String[] pks = ConvertUtil.merge2StrArr(str);
        IObjectPK[] ipks = ConvertUtil.strArr2ObjArr(pks);
        this.srmLogInfo.setEnterBillCount(pks.length);
        EntityViewInfo ev = ConvertUtil.convertStrArray2EVI(pks);
        try {
            this.oldBillCol = (PurReceivalBillCollection)FetchEntityDataFacadeFactory.getLocalInstance(ctx).getPurReceivalBillCollection(ev);
        }
        catch (EASBizException e) {
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purreceivalbill", "1");
            logger.error((Object)("@@@@PurReceivalAuditSend,errorMsg:" + e.getMessage()));
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("@@@@PurReceivalAuditSend,errorMsg:" + e.getMessage()));
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purreceivalbill", "1");
            throw e;
        }
        if (this.oldBillCol == null || this.oldBillCol.size() == 0) {
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus(ipks, "T_IM_purreceivalbill", "1");
            logger.debug((Object)"@@@@PurReceivalAuditSend.loadData():\u6839\u636epkSet\u67e5\u51fa\u6570\u636e\u4e3a\u7a7a.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        PurReceivalBillInfo info = null;
        for (int i = 0; i < this.oldBillCol.size(); ++i) {
            info = this.oldBillCol.get(i);
            if (info.getTransactionType().getRiType().getRI().getValue() == 1 && info.getTransactionType().getRiType().getBizDirection().getValue() == 1) {
                info.put("isreturn", (Object)0);
                continue;
            }
            info.put("isreturn", (Object)1);
        }
    }

    public void checkData(Context ctx) throws Exception {
        PurReceivalBillInfo purInfo = null;
        PurReceivalEntryInfo entry = null;
        String supplierID = null;
        this.newBillCol = new PurReceivalBillCollection();
        HashSet<String> oldSupplierIdSet = new HashSet<String>();
        Set<String> newSupplierIdSet = null;
        int size = this.oldBillCol.size();
        for (int i = 0; i < size; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            oldSupplierIdSet.add(supplierID);
        }
        newSupplierIdSet = JudgeSupplierIsSrmUtil.getSupplierIsSrm(ctx, oldSupplierIdSet);
        if (newSupplierIdSet == null || newSupplierIdSet.size() <= 0) {
            BizDealFacadeFactory.getLocalInstance(ctx).updateSynStatus((IObjectCollection)this.oldBillCol, "T_IM_purreceivalbill", "1");
            logger.debug((Object)"@@@@PurReceivalAuditSend.checkData():\u6ca1\u6709\u534f\u540c\u4f9b\u5e94\u5546\u7684\u5355\u636e\u96c6\u5408.....");
            throw new NSRMAbortException(NSRMAbortException.NULL_QUERYDATA);
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String paramValue = SrmParamUtil.getSrmParamValue(ctx, "SRM003", cu);
        int size2 = this.oldBillCol.size();
        for (int i = 0; i < size2; ++i) {
            purInfo = this.oldBillCol.get(i);
            supplierID = purInfo.getSupplier().getId().toString();
            boolean issync = true;
            for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                Object srmPorgress;
                entry = (PurReceivalEntryInfo)purInfo.getEntries().getObject(j);
                if (null == entry.getPurOrder() || null != (srmPorgress = entry.getPurOrder().get("srmProgress")) && !"0".equals(srmPorgress) && !"3".equals(srmPorgress)) continue;
                issync = false;
                break;
            }
            if (!newSupplierIdSet.contains(supplierID) || (!"0".equals(paramValue) || !issync) && !"1".equals(paramValue)) continue;
            this.newBillCol.add(purInfo);
        }
    }

    @Override
    public List<ReturnModel> handleBizResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException, EASBizException {
        if (this.newBillCol == null || this.newBillCol.size() == 0) {
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purreceivalbill");
            return null;
        }
        if (data instanceof Map) {
            Map retMap = (Map)data;
            String returnData = ConvertUtil.convertObj2Str(retMap.get("data"));
            if (returnData == null) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purreceivalbill");
                return null;
            }
            Map dataMap = null;
            try {
                dataMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)returnData, Map.class);
            }
            catch (Exception e) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purreceivalbill");
                return null;
            }
            if (!"200".equals(dataMap.get("code"))) {
                SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purreceivalbill");
                return null;
            }
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "2", "T_IM_purreceivalbill");
            PurReceivalBillInfo billInfo = null;
            PurReceivalEntryCollection entryCol = null;
            PurReceivalEntryInfo entryInfo = null;
            HashSet<String> orderIdSet = new HashSet<String>();
            int size = this.newBillCol.size();
            for (int i = 0; i < size; ++i) {
                billInfo = this.newBillCol.get(i);
                entryCol = (PurReceivalEntryCollection)billInfo.getEntries();
                int length = entryCol.size();
                for (int j = 0; j < length; ++j) {
                    entryInfo = entryCol.get(j);
                    if (entryInfo == null || entryInfo.getPurOrder() == null) continue;
                    orderIdSet.add(entryInfo.getPurOrder().getId().toString());
                }
            }
            if (orderIdSet == null || orderIdSet.size() == 0) {
                logger.debug((Object)"@@@@PurReceivalAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u6536\u8d27\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
                return null;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("srmProgress"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.qty"));
            sic.add(new SelectorItemInfo("entries.quantityUnCtrl"));
            sic.add(new SelectorItemInfo("entries.totalReceiveQty"));
            sic.add(new SelectorItemInfo("entries.receiveOwingRate"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orderIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("srmProgress", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("srmProgress", (Object)"8", CompareType.LESS_EQUALS));
            view.setFilter(filter);
            PurOrderCollection purCol = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
            if (purCol == null || purCol.size() == 0) {
                logger.debug((Object)"@@@@PurReceivalAuditSend.handleResult,errorMsg:\u91c7\u8d2d\u6536\u8d27\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u7684ID\u96c6\u5408\u4e3a\u7a7a\uff01");
                return null;
            }
            PurOrderInfo purInfo = null;
            PurOrderEntryCollection purEntryCol = null;
            PurOrderEntryInfo purEntryInfo = null;
            HashSet<String> newOrderIdSet = new HashSet<String>();
            HashSet<String> partOrderIdSet = new HashSet<String>();
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal totalReceiveQty = BigDecimal.ZERO;
            BigDecimal receiveOwingRate = BigDecimal.ZERO;
            int condition = 0;
            String purOrderId = null;
            boolean isNeedUpdate = true;
            int size2 = purCol.size();
            for (int i = 0; i < size2; ++i) {
                purInfo = purCol.get(i);
                if (purInfo == null) continue;
                isNeedUpdate = true;
                purOrderId = purInfo.getId().toString();
                purEntryCol = purInfo.getEntries();
                int length = purEntryCol.size();
                for (int j = 0; j < length; ++j) {
                    purEntryInfo = purEntryCol.get(j);
                    qty = ConvertUtil.defaultBigDecimal(purEntryInfo.getQty());
                    totalReceiveQty = ConvertUtil.defaultBigDecimal(purEntryInfo.getTotalReceiveQty());
                    receiveOwingRate = ConvertUtil.defaultBigDecimal(purEntryInfo.getReceiveOwingRate());
                    if (purEntryInfo.isQuantityUnCtrl()) {
                        condition = BigDecimal.ZERO.compareTo(totalReceiveQty.subtract(qty));
                        if (condition <= 0) continue;
                        isNeedUpdate = false;
                        break;
                    }
                    condition = BigDecimal.ZERO.compareTo(totalReceiveQty.subtract(BigDecimal.ONE.subtract(receiveOwingRate).multiply(qty)));
                    if (condition <= 0) continue;
                    isNeedUpdate = false;
                    break;
                }
                if (isNeedUpdate) {
                    newOrderIdSet.add(purOrderId);
                    continue;
                }
                partOrderIdSet.add(purOrderId);
            }
            SrmProgressUpdateUtil.updateSrmProgressForSet(ctx, newOrderIdSet, "8");
            SrmProgressUpdateUtil.updateSrmProgressForSet(ctx, partOrderIdSet, "7");
        } else {
            SyncStatusUpdateUtil.updateSynStatusForCol(ctx, (IObjectCollection)this.newBillCol, "1", "T_IM_purreceivalbill");
        }
        return null;
    }
}

