/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class BotpQueryReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(BotpQueryReceive.class);

    @Override
    protected Object handleReceive(Context ctx, Object data) throws Exception {
        BOSObjectType bosType;
        int i;
        ArrayList<Object> msgList = new ArrayList<Object>();
        if (msgList != null || msgList.size() > 0) {
            msgList.clear();
        }
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        Map returnData = (Map)retMap.get("data");
        List<String> billIdList = ConvertUtil.convertObj2StrArr(returnData.get("billId"));
        List<String> billEntryIdList = ConvertUtil.convertObj2StrArr(returnData.get("entryId"));
        HashSet<String> bosTypeSet = new HashSet<String>();
        try {
            for (i = 0; i < billIdList.size(); ++i) {
                bosType = BOSUuid.read((String)billIdList.get(i)).getType();
                bosTypeSet.add(bosType.toString());
            }
        }
        catch (Exception e) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "id\u4e0d\u5408\u6cd5\uff01");
            msgList.add(errMap);
            return msgList;
        }
        try {
            for (i = 0; i < billEntryIdList.size(); ++i) {
                bosType = BOSUuid.read((String)billEntryIdList.get(i)).getType();
            }
        }
        catch (Exception e) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u5206\u5f55id\u4e0d\u5408\u6cd5\uff01");
            msgList.add(errMap);
            return msgList;
        }
        if (bosTypeSet.size() > 1) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u539f\u5355\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4");
            msgList.add(errMap);
            return msgList;
        }
        String srcBillType = BOSUuid.read((String)billIdList.get(0)).getType().toString();
        if ("783061E3".equals(srcBillType)) {
            this.filterPurInwares(ctx, billIdList, billEntryIdList, msgList);
            if (billIdList == null || billIdList.size() <= 0) {
                HashMap<String, String> errMap = new HashMap<String, String>();
                errMap.put("error", "\u5355\u636e\u5df2\u5168\u90e8\u6838\u9500\uff01");
                msgList.add(errMap);
            }
        }
        String[] srcBillIDs = new String[billIdList.size()];
        for (int i2 = 0; i2 < billIdList.size(); ++i2) {
            srcBillIDs[i2] = billIdList.get(i2);
        }
        String[] entrieNames = new String[1];
        if ((entrieNames = this.getentrieNames(ctx, entrieNames, billIdList, srcBillType, msgList)) == null) {
            return msgList;
        }
        String targetBillType = ConvertUtil.convertObj2Str(returnData.get("targetBillType"));
        String targetBosType = this.getTargetBosType(targetBillType);
        if (targetBosType == null || targetBillType == null) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u76ee\u6807\u5355\u636e\u53c2\u6570\u672a\u4f20");
            msgList.add(errMap);
            return msgList;
        }
        CompanyOrgUnitInfo orgUnit = null;
        orgUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap<String, CompanyOrgUnitInfo> transmitContext = new HashMap<String, CompanyOrgUnitInfo>();
        transmitContext.put("TRANSMITCU", orgUnit);
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCols = botMapping.getMappingCollectionForSelectUseRuleFilter(srcBillType, targetBosType, DefineSysEnum.BTP, transmitContext, srcBillIDs, entrieNames, billEntryIdList, null);
        for (int i3 = 0; i3 < botMappingCols.size(); ++i3) {
            BOTMappingInfo info = botMappingCols.get(i3);
            HashMap<String, String> successMap = new HashMap<String, String>();
            successMap.put("id", info.getId().toString());
            successMap.put("name", info.getName());
            successMap.put("number", info.getName());
            successMap.put("alias", info.getAlias());
            successMap.put("error", "");
            msgList.add(JSONObject.fromObject(successMap).toString());
        }
        JSONArray json = JSONArray.fromObject(msgList);
        return json.toString();
    }

    private void filterPurInwares(Context ctx, List<String> billIdList, List<String> billEntryIdList, List<Object> msgList) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entry.unWriteOffQty"));
        sic.add(new SelectorItemInfo("entry.isFullWriteOff"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billIdList.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurInWarehsBillCollection purInWarehsBillCollection = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection(evi);
        Boolean isFilter = true;
        if (purInWarehsBillCollection == null || purInWarehsBillCollection.size() < 0) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6e90\u5355\u636e\u4e0d\u5b58\u5728");
            msgList.add(errMap);
        } else {
            for (int i = 0; i < purInWarehsBillCollection.size(); ++i) {
                PurInWarehsEntryInfo entry;
                int j;
                PurInWarehsBillInfo info = purInWarehsBillCollection.get(i);
                isFilter = true;
                for (j = 0; j < info.getEntry().size(); ++j) {
                    entry = info.getEntry().get(j);
                    if (entry.getUnWriteOffQty().compareTo(BigDecimal.ZERO) == 0 || entry.getUnWriteOffQty() == null) continue;
                    isFilter = false;
                    break;
                }
                if (!isFilter.booleanValue()) continue;
                billIdList.remove(info.getId().toString());
                for (j = 0; j < info.getEntry().size(); ++j) {
                    entry = info.getEntry().get(j);
                    billEntryIdList.remove(entry.getId().toString());
                }
            }
        }
    }

    private String[] getentrieNames(Context ctx, String[] entrieNames, List<String> billIdList, String srcBillType, List<Object> msgList) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billIdList.toString(), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        IObjectCollection iCol = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(new BOSObjectType(srcBillType), evi);
        if (iCol == null || iCol.size() <= 0) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6e90\u5355\u636e\u4e0d\u5b58\u5728");
            msgList.add(errMap);
            return null;
        }
        entrieNames[0] = "entries";
        return entrieNames;
    }

    private String getTargetBosType(String targetBillType) {
        if (targetBillType.equals("inware")) {
            return "783061E3";
        }
        if (targetBillType.equals("receive")) {
            return "15F2BD83";
        }
        if (targetBillType.equals("otherbill")) {
            return "48DA3A71";
        }
        if ("order".equals(targetBillType)) {
            return "3171BFAD";
        }
        if ("contract".equals(targetBillType)) {
            return "78B50853";
        }
        return null;
    }

    private BOTMappingCollection getBTPMappingCollection(Context ctx, List<String> idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() <= 0) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("cu.id"));
        PurRequestInfo info = this.getPurRequestInfo(ctx, idList, selector);
        if (info != null && info.getCU() != null) {
            BOSObjectType sourceBosType = new BOSObjectType("25428F2E");
            BOSObjectType destBosType = new BOSObjectType("3171BFAD");
            String cuID = info.getCU().getId().toString();
            BOTMappingCollection botMappingCol = SCMUtil.getBotpMappingCollection(null, (BOSObjectType)sourceBosType, (BOSObjectType)destBosType, (String)cuID);
            if (botMappingCol == null || botMappingCol.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            return botMappingCol;
        }
        return null;
    }

    private PurRequestInfo getPurRequestInfo(Context ctx, List<String> idList, SelectorItemCollection selector) throws BOSException {
        HashSet<String> idSet = new HashSet<String>(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(selector);
        PurRequestCollection purePurRequestCollection = PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestCollection(evi);
        if (purePurRequestCollection == null || purePurRequestCollection.size() <= 0) {
            return null;
        }
        return purePurRequestCollection.get(0);
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_BOTP_Query_Rec";
    }
}

