/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceCollection;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IContrace;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.app.util.QtyChangeCalUtil;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractTermCollection;
import com.kingdee.eas.scm.sm.pur.PurContractTermInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;

public class DecisionToPurContract
extends AbstractReceiveHandler {
    private Set<String> purOrgSet = new HashSet<String>();
    private Set<String> supplierSet = new HashSet<String>();
    private Set<String> userSet = new HashSet<String>();
    private Set<String> materialSet = new HashSet<String>();
    private Map<String, IObjectValue> purOrgMap = new HashMap<String, IObjectValue>();
    private Map<String, IObjectValue> supplierMap = new HashMap<String, IObjectValue>();
    private Map<String, IObjectValue> userMap = new HashMap<String, IObjectValue>();
    private Map<String, IObjectValue> materialMap = new HashMap<String, IObjectValue>();
    Map<String, Map<String, Object>> retMap = new HashMap<String, Map<String, Object>>();

    @Override
    protected Object handleReceive(Context ctx, Object data) throws Exception {
        com.alibaba.fastjson.JSONObject purInfo;
        int i;
        HashMap<String, ICoreBase> f7Map = new HashMap<String, ICoreBase>();
        f7Map.put("org", (ICoreBase)PurchaseOrgUnitFactory.getLocalInstance((Context)ctx));
        f7Map.put("supplier", (ICoreBase)SupplierFactory.getLocalInstance((Context)ctx));
        f7Map.put("user", (ICoreBase)UserFactory.getLocalInstance((Context)ctx));
        f7Map.put("material", (ICoreBase)MaterialFactory.getLocalInstance((Context)ctx));
        com.alibaba.fastjson.JSONObject jsonData = com.alibaba.fastjson.JSONObject.parseObject((String)((String)data));
        JSONArray purSendArray = (JSONArray)jsonData.get((Object)"data");
        HashMap<String, List> supfinaldetailMap = new HashMap<String, List>();
        HashMap<String, com.alibaba.fastjson.JSONObject> supplierMap = new HashMap<String, com.alibaba.fastjson.JSONObject>();
        for (i = 0; i < purSendArray.size(); ++i) {
            purInfo = (com.alibaba.fastjson.JSONObject)purSendArray.get(i);
            this.initInfoSet(purInfo);
            JSONArray bidsectionArray = (JSONArray)purInfo.get((Object)"bidsection");
            String suppliernumber = null;
            List<Object> supfinaldetailList = new ArrayList<com.alibaba.fastjson.JSONObject>();
            String bidsectionid = null;
            for (int j = 0; j < bidsectionArray.size(); ++j) {
                com.alibaba.fastjson.JSONObject bidsectionEntry = (com.alibaba.fastjson.JSONObject)bidsectionArray.get(j);
                bidsectionid = bidsectionEntry.getString("id");
                JSONArray pursupplierArray = (JSONArray)bidsectionEntry.get((Object)"supplierentry");
                for (int k = 0; k < pursupplierArray.size(); ++k) {
                    com.alibaba.fastjson.JSONObject supplierEntry = (com.alibaba.fastjson.JSONObject)pursupplierArray.get(k);
                    if (!supplierEntry.getBoolean("isrecommended").booleanValue()) continue;
                    suppliernumber = this.getNumberFromJsonObject(supplierEntry, "supplier");
                    this.supplierSet.add(suppliernumber);
                    supplierMap.put(suppliernumber + bidsectionid, supplierEntry);
                }
                JSONArray supfinaldetailArray = (JSONArray)bidsectionEntry.get((Object)"supfinaldetail");
                for (int k = 0; k < supfinaldetailArray.size(); ++k) {
                    com.alibaba.fastjson.JSONObject supfinaldetailEntry = (com.alibaba.fastjson.JSONObject)supfinaldetailArray.get(k);
                    this.supplierSet.add(this.getNumberFromJsonObject(supfinaldetailEntry, "lpursupplier"));
                    this.materialSet.add(this.getNumberFromJsonObject(supfinaldetailEntry, "lmaterialid"));
                    suppliernumber = this.getNumberFromJsonObject(supfinaldetailEntry, "lpursupplier");
                    supfinaldetailList = supfinaldetailMap.containsKey(suppliernumber + bidsectionid) ? (List)supfinaldetailMap.get(suppliernumber + bidsectionid) : new ArrayList();
                    supfinaldetailList.add(supfinaldetailEntry);
                    supfinaldetailMap.put(suppliernumber + bidsectionid, supfinaldetailList);
                }
            }
        }
        this.initInfoF7(ctx, f7Map);
        for (i = 0; i < purSendArray.size(); ++i) {
            purInfo = (com.alibaba.fastjson.JSONObject)purSendArray.get(i);
            Set supplieridSet = supplierMap.keySet();
            for (String key : supplieridSet) {
                com.alibaba.fastjson.JSONObject supplierEntry = (com.alibaba.fastjson.JSONObject)supplierMap.get(key);
                this.createEasPurcontract(ctx, purInfo, supplierEntry, supfinaldetailMap, key);
            }
        }
        JSONObject jsonObject = JSONObject.fromObject(this.retMap);
        return jsonObject.toString();
    }

    private void createEasPurcontract(Context ctx, com.alibaba.fastjson.JSONObject purInfo, com.alibaba.fastjson.JSONObject supplierEntry, Map<String, List> supfinaldetailMap, String key) throws BOSException, EASBizException {
        PurContractInfo info = (PurContractInfo)PurContractFactory.getLocalInstance((Context)ctx).createNewData(false);
        this.setHeadDefaultValue(ctx, info, purInfo, supplierEntry);
        info.getTerms().addCollection(this.getContractTerm(ctx, info.getContractType()));
        PurContractEntryInfo entry = null;
        com.alibaba.fastjson.JSONObject supfinaldetailEntry = null;
        String id = this.getStringFromJsonObject(purInfo, "id");
        List entryList = supfinaldetailMap.get(key);
        if (entryList != null && entryList.size() > 0) {
            for (int j = 0; j < entryList.size(); ++j) {
                supfinaldetailEntry = (com.alibaba.fastjson.JSONObject)entryList.get(j);
                entry = new PurContractEntryInfo();
                this.setEntryDefaultValue(ctx, info, entry, purInfo, supfinaldetailEntry);
                info.getEntries().add(entry);
            }
        } else {
            entry = new PurContractEntryInfo();
            this.setEntryNoMaterial(ctx, info, entry, purInfo, supplierEntry);
            info.getEntries().add(entry);
        }
        try {
            PurContractFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            this.setMsgMap(id, "500", e.getMessage(), 0);
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        catch (BOSException e) {
            this.setMsgMap(id, "500", e.getMessage(), 0);
            throw new BOSException("save bill error " + e.getMessage() + e.getStackTrace());
        }
        this.setMsgMap(id, "200", "\u4fdd\u5b58", 1);
    }

    private void setHeadDefaultValue(Context ctx, PurContractInfo info, com.alibaba.fastjson.JSONObject purInfo, com.alibaba.fastjson.JSONObject supplierEntry) throws BOSException, EASBizException {
        String usernumber = this.getNumberFromJsonObject(purInfo, "creator");
        UserInfo userInfo = (UserInfo)this.userMap.get(usernumber);
        info.setCreator(userInfo);
        String orgnumber = this.getNumberFromJsonObject(purInfo, "org");
        PurchaseOrgUnitInfo org = (PurchaseOrgUnitInfo)this.purOrgMap.get(orgnumber);
        info.setPurOrgUnit(org);
        CompanyOrgUnitInfo company = this.getCompanyInfo(ctx, org);
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
        info.setCompanyOrgUnit(company);
        info.setCurrency(company.getBaseCurrency());
        info.setExchangeRate(BigDecimal.ONE);
        ContraceTreeInfo contractType = ContraceTreeFactory.getLocalInstance((Context)ctx).getContraceTreeInfo((IObjectPK)new ObjectUuidPK("hK8AAAAEv3YXH0iX"));
        info.setContractType(contractType);
        info.setSupplier((SupplierInfo)this.supplierMap.get(this.getNumberFromJsonObject(supplierEntry, "supplier")));
        info.setIsInTax(true);
        String bidproject = this.getNameFromJsonObject(purInfo, "bidproject");
        if (bidproject != null) {
            com.alibaba.fastjson.JSONObject jsonData = com.alibaba.fastjson.JSONObject.parseObject((String)bidproject.toString());
            bidproject = ctx.getLocale().equals("L2") ? jsonData.getString("zh_CN") : jsonData.getString("zh_TW");
        }
        info.setDescription(bidproject);
        String number = PurContractFactory.getLocalInstance((Context)ctx).getNewNumber((IObjectValue)info, info.getPurOrgUnit().getId().toString(), null);
        info.setNumber(number + this.getKeyFromJsonObject(purInfo, "bidproject", "billno"));
    }

    private void setEntryNoMaterial(Context ctx, PurContractInfo info, PurContractEntryInfo entry, com.alibaba.fastjson.JSONObject purInfo, com.alibaba.fastjson.JSONObject supplierEntry) throws BOSException, EASBizException {
        entry.setMaterialName(this.getNameFromJsonObject(purInfo, "bidproject"));
        MeasureUnitInfo unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK("hK8AAAAAKaJbglxX"));
        entry.setUnit(unit);
        entry.setBaseUnit(unit);
        RowTypeInfo rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK("hK8AAAAEyT98fcSj"));
        entry.setRowType(rowType);
        entry.setQty(BigDecimal.ONE);
        entry.setBaseQty(BigDecimal.ONE);
        BigDecimal amount = this.getBigDecimalFromJsonObject(supplierEntry, "finalexceptvat");
        BigDecimal taxamount = this.getBigDecimalFromJsonObject(supplierEntry, "finalprice");
        BigDecimal tax = this.getBigDecimalFromJsonObject(supplierEntry, "finalvat");
        entry.setTaxPrice(taxamount);
        entry.setPrice(amount);
        entry.setTaxRate(tax.divide(amount, 4, 4).movePointRight(2));
        entry.setTax(tax);
        entry.setTaxAmount(taxamount);
        entry.setAmount(amount);
        entry.setLocalAmount(amount);
        entry.setLocalTax(tax);
        entry.setLocalTaxAmount(taxamount);
        StorageOrgUnitInfo storageorg = (StorageOrgUnitInfo)this.getFromOrgInfo(ctx, (OrgUnitInfo)info.getPurOrgUnit(), 4, 3);
        entry.setStorageOrgUnit(storageorg);
        AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.getFromOrgInfo(ctx, (OrgUnitInfo)info.getPurOrgUnit(), 0, 3);
        entry.setAdminOrgUnit(adminOrg);
        entry.setConsignDate(new Date());
        entry.setDeliveryDate(info.getEffectedDate());
        entry.setQualityUnCtrl(true);
        entry.setTimeUnCtrl(true);
        entry.setAmountUnCtrl(true);
        entry.setTotalReqPayAmt(BigDecimal.ZERO);
        this.calEntryPrice((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entry);
        QtyChangeCalUtil.calByEntryTaxPriceChange(info, entry);
    }

    private void setEntryDefaultValue(Context ctx, PurContractInfo info, PurContractEntryInfo entry, com.alibaba.fastjson.JSONObject purInfo, com.alibaba.fastjson.JSONObject supfinaldetailEntry) throws BOSException, EASBizException {
        MaterialInfo material = (MaterialInfo)this.materialMap.get(this.getNumberFromJsonObject(supfinaldetailEntry, "lmaterialid"));
        if (material != null) {
            entry.setMaterial(material);
            entry.setMaterialName(material.getName());
            entry.setUnit(material.getBaseUnit());
            entry.setBaseUnit(material.getBaseUnit());
            RowTypeInfo rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
            entry.setRowType(rowType);
            entry.setQty(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "lqty"));
            entry.setBaseQty(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "lqty"));
            BigDecimal taxprice = this.getBigDecimalFromJsonObject(supfinaldetailEntry, "linclutaxprice");
            entry.setTaxPrice(taxprice);
            BigDecimal taxRate = this.getBigDecimalFromJsonObject(supfinaldetailEntry, "ltaxrate");
            if (taxRate != null) {
                taxRate = taxRate.movePointRight(2);
            }
            entry.setTaxRate(taxRate);
            entry.setTax(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "ltaxamount"));
            entry.setTaxAmount(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "linclutaxamount"));
            entry.setAmount(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "lexcepttaxamount"));
            entry.setLocalAmount(entry.getAmount());
            entry.setLocalTax(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "ltaxamount"));
            entry.setLocalTaxAmount(this.getBigDecimalFromJsonObject(supfinaldetailEntry, "linclutaxamount"));
            entry.setDiscount(BigDecimal.ZERO);
            entry.setDiscountAmount(BigDecimal.ZERO);
        } else {
            entry.setMaterialName(this.getMulStringFromJsonObject(ctx, supfinaldetailEntry, "lpurentrycontent"));
            MeasureUnitInfo unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK("hK8AAAAAKaJbglxX"));
            entry.setUnit(unit);
            entry.setBaseUnit(unit);
            RowTypeInfo rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK("hK8AAAAEyT98fcSj"));
            entry.setRowType(rowType);
            entry.setQty(BigDecimal.ONE);
            entry.setBaseQty(BigDecimal.ONE);
            BigDecimal taxamount = this.getBigDecimalFromJsonObject(supfinaldetailEntry, "linclutaxamount");
            BigDecimal tax = this.getBigDecimalFromJsonObject(supfinaldetailEntry, "ltaxamount");
            BigDecimal taxRate = this.getBigDecimalFromJsonObject(supfinaldetailEntry, "ltaxrate");
            if (taxRate != null) {
                taxRate = taxRate.movePointRight(2);
            }
            entry.setTaxPrice(taxamount);
            entry.setTax(tax);
            entry.setTaxRate(taxRate);
            entry.setTaxAmount(taxamount);
            entry.setLocalTax(tax);
            entry.setLocalTaxAmount(taxamount);
            entry.setDiscount(BigDecimal.ZERO);
            entry.setDiscountAmount(BigDecimal.ZERO);
        }
        StorageOrgUnitInfo storageorg = (StorageOrgUnitInfo)this.getFromOrgInfo(ctx, (OrgUnitInfo)info.getPurOrgUnit(), 4, 3);
        entry.setStorageOrgUnit(storageorg);
        AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)this.getFromOrgInfo(ctx, (OrgUnitInfo)info.getPurOrgUnit(), 0, 3);
        entry.setAdminOrgUnit(adminOrg);
        entry.setConsignDate(new Date());
        entry.setDeliveryDate(info.getEffectedDate());
        entry.setQualityUnCtrl(true);
        entry.setTimeUnCtrl(true);
        entry.setAmountUnCtrl(true);
        entry.setTotalReqPayAmt(BigDecimal.ZERO);
        entry.setPrice(this.calEntryPrice((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entry));
        BigDecimal taxprice = entry.getTaxRate();
        if (taxprice != null && taxprice.compareTo(BigDecimal.ZERO) > 0) {
            QtyChangeCalUtil.calByEntryTaxPriceChange(info, entry);
        }
        entry.setTotalOrderAmount(BigDecimal.ZERO);
        entry.setTotalOrderQty(BigDecimal.ZERO);
        entry.setTotalPaidAmount(BigDecimal.ZERO);
        entry.setTotalReqPayAmt(BigDecimal.ZERO);
        entry.put("ctrlAmount", (Object)BigDecimal.ZERO);
        entry.put("unOrderAmount", (Object)BigDecimal.ZERO);
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_DECISION_PURCONTRACT_REC";
    }

    public CompanyOrgUnitInfo getCompanyInfo(Context ctx, PurchaseOrgUnitInfo purOrg) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(purOrg.getId().toString(), 3, 1);
        return (CompanyOrgUnitInfo)orgCol.get(0);
    }

    public OrgUnitInfo getFromOrgInfo(Context ctx, OrgUnitInfo purOrg, int fromType, int toType) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getFromUnit(purOrg.getId().toString(), toType, fromType);
        return orgCol.get(0);
    }

    public OrgUnitInfo getToOrgInfo(Context ctx, OrgUnitInfo purOrg, int fromType, int toType) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(purOrg.getId().toString(), fromType, toType);
        return orgCol.get(0);
    }

    private void initInfoSet(com.alibaba.fastjson.JSONObject purInfo) {
        this.purOrgSet.add(this.getNumberFromJsonObject(purInfo, "org"));
        this.purOrgSet.add("102000");
        this.userSet.add(this.getNumberFromJsonObject(purInfo, "creator"));
        this.userSet.add("zqtest");
    }

    private void initInfoF7(Context ctx, Map<String, ICoreBase> f7Map) throws BOSException {
        this.purOrgMap = this.getMap(ctx, this.purOrgSet, "org", f7Map);
        this.supplierMap = this.getMap(ctx, this.supplierSet, "supplier", f7Map);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("person"));
        this.userMap = this.getMap(ctx, this.userSet, "user", f7Map, sic);
        sic.clear();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseunit"));
        this.materialMap = this.getMap(ctx, this.materialSet, "material", f7Map, sic);
    }

    private void setMsgMap(String id, String status, String message, int i) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put("status", status);
        errorMap.put("message", message);
        errorMap.put("billstatus", i);
        this.retMap.put(id, errorMap);
    }

    protected String getNameFromJsonObject(com.alibaba.fastjson.JSONObject json, String name) {
        if (json == null) {
            return null;
        }
        Object ob = json.get((Object)name);
        if (ob instanceof com.alibaba.fastjson.JSONObject) {
            return String.valueOf(((com.alibaba.fastjson.JSONObject)ob).get((Object)"name"));
        }
        return null;
    }

    public BigDecimal calEntryPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = Boolean.valueOf(info.get("isInTax").toString());
        if (!containTax) {
            return BigDecimal.ZERO;
        }
        BigDecimal taxPrice = new BigDecimal(entryInfo.get("taxPrice").toString());
        BigDecimal taxRate = new BigDecimal(entryInfo.get("taxRate").toString());
        int scale = taxPrice.scale();
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale);
        return price;
    }

    protected String getKeyFromJsonObject(com.alibaba.fastjson.JSONObject json, String name, String key) {
        if (json == null) {
            return null;
        }
        Object ob = json.get((Object)name);
        if (ob instanceof com.alibaba.fastjson.JSONObject) {
            return String.valueOf(((com.alibaba.fastjson.JSONObject)ob).get((Object)key));
        }
        return null;
    }

    protected String getMulStringFromJsonObject(Context ctx, com.alibaba.fastjson.JSONObject json, String name) {
        if (json == null) {
            return null;
        }
        Object ob = json.get((Object)name);
        if (ob != null) {
            com.alibaba.fastjson.JSONObject jsonData = com.alibaba.fastjson.JSONObject.parseObject((String)ob.toString());
            if (ctx.getLocale().equals("L2")) {
                return jsonData.getString("zh_CN");
            }
            return jsonData.getString("zh_CN");
        }
        return null;
    }

    private PurContractTermCollection getContractTerm(Context ctx, ContraceTreeInfo contractTreeInfo) throws BOSException {
        PurContractTermCollection purContractTermCollection = new PurContractTermCollection();
        IContrace contrace = ContraceFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        String billid = contractTreeInfo.getId().toString();
        FilterItemInfo billidFilter = new FilterItemInfo("treeid", (Object)billid, CompareType.EQUALS);
        filter.getFilterItems().add(billidFilter);
        filter.getFilterItems().add(new FilterItemInfo("FStart", (Object)true, CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("FSeq");
        sortItem.setSortType(SortType.ASCEND);
        ev.getSorter().add(sortItem);
        ContraceCollection contraceCollection = contrace.getContraceCollection(ev);
        int n = contraceCollection.size();
        for (int i = 0; i < n; ++i) {
            ContraceInfo contraceInfo = (ContraceInfo)contraceCollection.getObject(i);
            PurContractTermInfo purContractTermInfo = new PurContractTermInfo();
            purContractTermInfo.setTermContent(contraceInfo.getName());
            purContractTermCollection.add(purContractTermInfo);
        }
        return purContractTermCollection;
    }
}

