/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.app.fromeip.impl.PurBatchReturnToInwareReceive;
import com.kingdee.eas.scm.nsrm.app.fromeip.impl.PurSaloutStocktoInwareReceive;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class IerpToInwareReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(IerpToInwareReceive.class);
    private static Map<String, Map<String, String>> msgMap = new HashMap<String, Map<String, String>>();

    @Override
    public Object handleReceive(Context ctx, Object data) throws Exception {
        if (msgMap != null && msgMap.size() > 0) {
            msgMap.clear();
        }
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        long startTime = System.currentTimeMillis();
        Map dataMap = (Map)retMap.get("data");
        try {
            this.dealIerpData(ctx, dataMap);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("@@@@IerpToInwareReceive.execute():IllegalArgumentException,errorMsg:" + e.getMessage()));
        }
        long currentTime = System.currentTimeMillis();
        logger.debug((Object)("IerpToInwareReceive.handleReceive() \u6536\u8d27\u52a9\u624b\u751f\u6210\u5165\u5e93\u5355\u8017\u65f6" + (currentTime - startTime)));
        JSONObject jsonObject = JSONObject.fromObject(msgMap);
        return jsonObject.toString();
    }

    private Object dealIerpData(Context ctx, Map<String, Object> dataMap) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        Object botpnumber = this.getBotpNumber(dataMap);
        if (botpnumber == null) {
            return null;
        }
        dataMap.remove("botpNumber");
        Object source = dataMap.get("source");
        dataMap.remove("source");
        Object billstatus = dataMap.get("billstatus");
        dataMap.remove("billstatus");
        Object billstatus1 = dataMap.get("billstatus1");
        dataMap.remove("billstatus1");
        if ("batchReturn".equals(source)) {
            PurBatchReturnToInwareReceive.getInstance().dealIerpData(ctx, dataMap, botpnumber, msgMap);
        } else {
            PurSaloutStocktoInwareReceive.getInstance().dealIerpData(ctx, dataMap, botpnumber, msgMap, billstatus, billstatus1);
        }
        return null;
    }

    private Object getBotpNumber(Map<String, Object> dataMap) {
        if (null == dataMap.get("botpNumber")) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6ca1\u6709\u5bf9\u5e94\u7684BOTP\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5");
            errMap.put("billtype", "");
            errMap.put("billnumber", "");
            errMap.put("billstatus", "");
            msgMap.put("error", errMap);
            return null;
        }
        return dataMap.get("botpNumber");
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_PurSalout_toInWare_Rec";
    }
}

