/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderConfirmReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(PurOrderConfirmReceive.class);

    @Override
    public Object handleReceive(Context ctx, Object data) throws Exception {
        Map retMap = ConvertUtil.convertJsonToMap(ctx, data);
        Map returnData = (Map)retMap.get("data");
        Object autoConfirm = retMap.get("autoConfirm");
        List<String> billno = ConvertUtil.convertObj2StrArr(returnData.get("billno"));
        String cmfstatus = "4";
        ArrayList<String> newBillno = new ArrayList<String>();
        if (billno != null && billno.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("srmProgress"));
            sic.add(new SelectorItemInfo("number"));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billno.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("basestatus", (Object)-3, CompareType.NOTEQUALS));
            evi.setFilter(filter);
            evi.setSelector(sic);
            PurOrderCollection purOrderCollection = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(evi);
            for (int i = 0; i < purOrderCollection.size(); ++i) {
                PurOrderInfo info = purOrderCollection.get(i);
                String srmProgress = ConvertUtil.convertObj2Str(info.get("srmProgress"));
                if (srmProgress != null && !"0".equals(srmProgress) && !"1".equals(srmProgress) && !"4".equals(srmProgress)) continue;
                newBillno.add(info.getNumber());
            }
        }
        if (newBillno != null && newBillno.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String tableField = "CFSrmProgress";
            sql.append("update T_SM_PurOrder set ").append(tableField).append(" = ").append(cmfstatus);
            if (autoConfirm != null) {
                sql.append(",cfAutoConfirm = 1");
            } else {
                sql.append(",cfAutoConfirm = 0");
            }
            sql.append(" where ").append("FNumber").append(ConvertUtil.list2StrBuf(newBillno));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return true;
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_PurOrder_Confirm_Rec";
    }
}

