/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.fromeip.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.nsrm.app.fromeip.AbstractReceiveHandler;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SupplierOperateReceive
extends AbstractReceiveHandler {
    private static Logger logger = Logger.getLogger(SupplierOperateReceive.class);

    @Override
    protected Object handleReceive(Context ctx, Object data) throws Exception {
        Map returnData;
        Map retMap = returnData = ConvertUtil.convertJsonToMap(ctx, data);
        if (null != returnData.get("data")) {
            retMap = (Map)returnData.get("data");
        }
        HashSet numberSet = null;
        numberSet = new HashSet((List)retMap.get("numbers"));
        Object operate = retMap.get("operate");
        Object quit = retMap.get("quit");
        HashSet<String> orgSet = null;
        if (!"1".equals(quit) && null != retMap.get("org")) {
            orgSet = new HashSet<String>((List)retMap.get("org"));
        }
        ctx.put((Object)"quit", quit);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("usedStatus"));
        sic.add(new SelectorItemInfo("CU"));
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        SupplierCollection supplierCollection = iSupplier.getSupplierCollection(evi);
        SupplierInfo supplierInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> msgMap = new HashMap<String, String>();
        for (int i = 0; i < supplierCollection.size(); ++i) {
            supplierInfo = supplierCollection.get(i);
            idSet.add(supplierInfo.getId().toString());
            numberSet.remove(supplierInfo.getNumber());
            IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
            HashMap map = iSwitch.getOrgs(supplierInfo.getCU().getId().toString());
            ctx.put((Object)"OrgUnits", (Object)map);
            iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            try {
                if ("disable".equals(operate) || "blacklist".equals(operate)) {
                    if (2 == supplierInfo.getUsedStatus().getValue()) {
                        msgMap.put(supplierInfo.getNumber(), "200");
                        continue;
                    }
                    if (null == quit || null != quit && !quit.equals("0")) {
                        iSupplier.freezed((IObjectPK)new ObjectUuidPK(supplierInfo.getId().toString()), true);
                    }
                } else if ("quit".equals(operate)) {
                    if (0 == supplierInfo.getUsedStatus().getValue()) {
                        msgMap.put(supplierInfo.getNumber(), "200");
                        continue;
                    }
                    iSupplier.unApprove((IObjectPK)new ObjectUuidPK(supplierInfo.getId().toString()), true);
                } else if ("enable".equals(operate)) {
                    if (1 == supplierInfo.getUsedStatus().getValue()) {
                        msgMap.put(supplierInfo.getNumber(), "200");
                        continue;
                    }
                    iSupplier.unFreezed((IObjectPK)new ObjectUuidPK(supplierInfo.getId().toString()), true);
                } else {
                    if (1 == supplierInfo.getUsedStatus().getValue()) {
                        msgMap.put(supplierInfo.getNumber(), "200");
                        continue;
                    }
                    iSupplier.approve((IObjectPK)new ObjectUuidPK(supplierInfo.getId().toString()));
                }
                msgMap.put(supplierInfo.getNumber(), "200");
                continue;
            }
            catch (Exception e) {
                msgMap.put(supplierInfo.getNumber(), e.getMessage());
            }
        }
        if (null != quit && "1".equals(quit)) {
            this.allSupplierPurCancel(ctx, idSet);
        } else if (null != quit && "0".equals(quit)) {
            this.partSupplierPurCancel(ctx, idSet, orgSet, operate);
        }
        ctx.remove((Object)"quit");
        String success = "true";
        for (String key : msgMap.keySet()) {
            if ("200".equals(msgMap.get(key))) continue;
            success = (String)msgMap.get(key);
        }
        return success;
    }

    private void allSupplierPurCancel(Context ctx, Set<String> idSet) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("usingStatus"));
        sic.add(new SelectorItemInfo("CU"));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        ISupplierPurchaseInfo isSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        SupplierPurchaseInfoCollection supPurs = isSupplierPurchaseInfo.getSupplierPurchaseInfoCollection(evi);
        SupplierPurchaseInfoInfo info = null;
        if (supPurs.size() <= 0) {
            return;
        }
        ObjectUuidPK[] pks = new ObjectUuidPK[supPurs.size()];
        for (int i = 0; i < supPurs.size(); ++i) {
            info = supPurs.get(i);
            pks[i] = new ObjectUuidPK(info.getId());
        }
        try {
            isSupplierPurchaseInfo.cancel((IObjectPK[])pks);
        }
        catch (Exception e) {
            logger.error((Object)("@@@\u4f9b\u5e94\u5546\u64cd\u4f5c" + e.getMessage()));
        }
    }

    private void partSupplierPurCancel(Context ctx, Set<String> idSet, Set<String> orgSet, Object operate) throws EASBizException, BOSException {
        if (null == orgSet || orgSet.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("usingStatus"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.number", orgSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        ISupplierPurchaseInfo isSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        SupplierPurchaseInfoCollection supPurs = isSupplierPurchaseInfo.getSupplierPurchaseInfoCollection(evi);
        SupplierPurchaseInfoInfo info = null;
        if (supPurs.size() <= 0) {
            return;
        }
        IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
        HashMap map = iSwitch.getOrgs(supPurs.get(0).getPurchaseOrgUnit().getId().toString());
        ctx.put((Object)"OrgUnits", (Object)map);
        isSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < supPurs.size(); ++i) {
            info = supPurs.get(i);
            if ("disable".equals(operate)) {
                if (1 == info.getUsingStatus().getValue()) continue;
                try {
                    isSupplierPurchaseInfo.cancel((IObjectPK)new ObjectUuidPK(info.getId()));
                }
                catch (Exception e) {
                    logger.error((Object)("@@@\u4f9b\u5e94\u5546\u64cd\u4f5c" + e.getMessage()));
                }
                continue;
            }
            if (!"enable".equals(operate) || 0 == info.getUsingStatus().getValue()) continue;
            try {
                isSupplierPurchaseInfo.cancelCancel((IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("@@@\u4f9b\u5e94\u5546\u64cd\u4f5c" + e.getMessage()));
            }
        }
    }

    @Override
    protected String getInterfaceNumber() {
        return "NEXT_Supplier_Operate_Rec";
    }
}

