/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.logger;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.nsrm.OprtStatusEnum;
import com.kingdee.eas.scm.nsrm.SrmCommonLogFactory;
import com.kingdee.eas.scm.nsrm.SrmCommonLogInfo;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SrmLoggerHelpers {
    private static final ThreadLocal<SrmCommonLogInfo> LOGGERINFO = new ThreadLocal();
    private static final Logger logger = Logger.getLogger(SrmLoggerHelpers.class);

    public static void start(Context ctx, SrmCommonLogInfo srmCommonLogInfo) {
        CompanyOrgUnitInfo companyInfo;
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            srmCommonLogInfo.setUser(userInfo);
            srmCommonLogInfo.setUserName(userInfo.getName());
            srmCommonLogInfo.setUserType(userInfo.getType().toString());
        }
        if ((companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company)) != null) {
            srmCommonLogInfo.setCompanyName(companyInfo.getName());
        }
        srmCommonLogInfo.setClientIP(ctx.getClientHostIP());
        srmCommonLogInfo.setClientName(ctx.getClientHostName());
        srmCommonLogInfo.setOprtStatus(OprtStatusEnum.PROCESS);
        srmCommonLogInfo.setOprtObject(srmCommonLogInfo.getOprtObject());
        srmCommonLogInfo.setOprtDescription(srmCommonLogInfo.getOprtDescription());
        srmCommonLogInfo.setEnterBillCount(0);
        srmCommonLogInfo.setBillCount(0);
        srmCommonLogInfo.setBillCount(0);
        srmCommonLogInfo.setStartTime(SrmLoggerHelpers.getCurrentTimestamp());
        srmCommonLogInfo.setEndTime(null);
        srmCommonLogInfo.setTotalTime(null);
        srmCommonLogInfo.setTempKey(SrmLoggerHelpers.createTempKey());
        LOGGERINFO.set(srmCommonLogInfo);
        SrmLoggerHelpers.setBizRemark("execute start.............");
    }

    public static void end(Context ctx) {
        SrmCommonLogInfo info = LOGGERINFO.get();
        Timestamp endTime = SrmLoggerHelpers.getCurrentTimestamp();
        Timestamp startTime = info.getStartTime();
        info.setEndTime(endTime);
        String totalTime = SrmLoggerHelpers.getFormatTime(endTime.getTime() - startTime.getTime());
        info.setTotalTime(totalTime);
        SrmLoggerHelpers.save(ctx);
        LOGGERINFO.remove();
    }

    public static void save(Context ctx) {
        try {
            SrmCommonLogInfo info = LOGGERINFO.get();
            if (info != null && info.getErrorMsg() != null || info.getException() != null) {
                info.setOprtStatus(OprtStatusEnum.FAIL);
            }
            SrmCommonLogFactory.getLocalInstance(ctx).save(info);
        }
        catch (Exception e) {
            logger.error((Object)("@@@@SrmLoggerHelper.save(),\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25\uff01" + e.getMessage()));
        }
    }

    public static void setBizRemark(String str) {
        SrmCommonLogInfo info = LOGGERINFO.get();
        String preStr = info.getBizRemark();
        if (preStr != null) {
            String separator = System.getProperty("line.separator") == null ? "/n" : System.getProperty("line.separator");
            str = preStr + separator + "@@" + str;
        } else {
            str = "@@" + str;
        }
        if (str != null && str.length() > 2000) {
            str = str.substring(0, 1999);
        }
        info.setBizRemark(str);
    }

    public static void setRelationBill(String billId) {
        SrmCommonLogInfo info = LOGGERINFO.get();
        info.setRelationBill(billId);
    }

    public static void setErrorMsg(String str) {
        if (str != null && str.length() > 1024) {
            str = str.substring(0, 1023);
        }
        LOGGERINFO.get().setErrorMsg(str);
    }

    private static void setException(String str) {
        if (str != null && str.length() > 2000) {
            str = str.substring(0, 1999);
        }
        LOGGERINFO.get().setException(str);
    }

    public static void calBillAndEntryCount(SrmCommonLogInfo srmLogInfo, IObjectCollection objCol, String entryID) {
        int billCount = 0;
        int entryCount = 0;
        int size = objCol == null || objCol.size() == 0 ? 0 : objCol.size();
        String numberMsg = "\u5b9e\u9645\u53d1\u9001\u7684\u5355\u636e\u7f16\u7801\uff1a";
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                numberMsg = numberMsg + objCol.getObject(i).getString("number");
            } else if (i > 0 && i < 5) {
                numberMsg = numberMsg + "," + objCol.getObject(i).getString("number");
            }
            ++billCount;
            if (objCol.getObject(i) == null || objCol.getObject(i).get(entryID == null ? "entries" : entryID) == null) continue;
            entryCount += ((IObjectCollection)objCol.getObject(i).get(entryID == null ? "entries" : entryID)).size();
        }
        if (size > 0) {
            if (size < 5) {
                SrmLoggerHelpers.setBizRemark(numberMsg);
            } else {
                SrmLoggerHelpers.setBizRemark(numberMsg + "\u7b49");
            }
        }
        srmLogInfo.setBillCount(billCount);
        srmLogInfo.setEntryCount(entryCount);
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getFormatTime(long t) {
        long hour = t / 3600000L;
        long left = t % 3600000L;
        long minus = left / 60000L;
        long second = (left %= 60000L) / 1000L;
        return hour + "\u65f6" + minus + "\u5206" + second + "\u79d2" + (left %= 1000L) + "\u6beb\u79d2";
    }

    private static String createTempKey() {
        return "TK" + SrmLoggerHelpers.getCurrentTimestamp().toString().replace("-", "").replace(":", "").replace(".", "").replace(" ", "") + SrmLoggerHelpers.random3Str();
    }

    private static String random3Str() {
        return String.valueOf((int)(Math.random() * 900.0) + 100);
    }

    public static String getTempKey() {
        return LOGGERINFO.get().getTempKey();
    }
}

