/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.nsrm.app.frombiz.SendFromBizServiceImpl;
import com.kingdee.eas.scm.nsrm.constant.SendSplitConstants;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendSplitThread
extends Thread {
    private static Logger logger = Logger.getLogger(SendSplitThread.class);
    private Context ctx;
    private String interfaceId;
    private Object data;
    private Class<?> clz;
    private int splitSize;

    public SendSplitThread(Context ctx, String interfaceId, Object data, Class<?> clz, int splitSize) {
        this.ctx = ctx;
        this.interfaceId = interfaceId;
        this.data = data;
        this.clz = clz;
        this.splitSize = splitSize;
    }

    @Override
    public void run() {
        logger.error((Object)("@@\u6570\u636e\u53d1\u9001\u6570\u636e\u91cf\u8f83\u5927,\u91c7\u7528\u5f02\u6b65\u5206\u6279\u53d1\u9001,\u8c03\u7528\u63a5\u53e3\uff1a" + this.interfaceId + "\u5f00\u59cb\u6267\u884c................"));
        try {
            if (this.clz == IObjectCollection.class) {
                String[] str = ConvertUtil.col2StrArr((IObjectCollection)this.data);
                this.process(this.ctx, this.interfaceId, str, false);
            } else if (this.clz == Set.class) {
                String[] str = ConvertUtil.set2StrArr((Set)this.data);
                this.process(this.ctx, this.interfaceId, str, false);
            } else if (this.clz == List.class) {
                String[] str = ConvertUtil.list2StrArr((List)this.data);
                this.process(this.ctx, this.interfaceId, str, false);
            } else if (this.clz == IObjectPK[].class) {
                String[] str = ConvertUtil.objArr2StrArr((IObjectPK[])this.data);
                this.process(this.ctx, this.interfaceId, str, false);
            } else {
                logger.error((Object)("\u5f02\u6b65\u5206\u6279\u53d1\u9001\u62a5\u9519,\u8c03\u7528\u63a5\u53e3\uff1a" + this.interfaceId + ":\u672a\u77e5\u7c7b\u578b\u4f20\u5165\u6570\u636e\u4e3a\uff1a" + this.clz));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5f02\u6b65\u5206\u6279\u53d1\u9001\u62a5\u9519,\u8c03\u7528\u63a5\u53e3\uff1a" + this.interfaceId));
            logger.error((Object)("\u5f02\u6b65\u5206\u6279\u53d1\u9001\u62a5\u9519,\u9519\u8bef\u4fe1\u606f\uff1a" + ExceptionHelper.toString(e)));
        }
    }

    private void process(Context ctx, String interfaceId, String[] data, boolean sync) throws EASBizException, BOSException {
        int splitQty = 0;
        splitQty = this.splitSize == 0 ? SendSplitConstants.getNeedSplitQty(interfaceId) : this.splitSize;
        ArrayList<String> isList = new ArrayList<String>();
        String pks = null;
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            isList.add(data[i]);
            if (i == 0 || (i + 1) % splitQty != 0) continue;
            pks = ConvertUtil.divide2Str(isList);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
            isList = new ArrayList();
        }
        if (isList.size() > 0) {
            pks = ConvertUtil.divide2Str(isList);
            SendFromBizServiceImpl.execute(ctx, interfaceId, pks, sync);
        }
    }
}

