/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.im.inv.IPurReceivalBill;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.nsrm.app.fromeip.impl.PurSaloutStocktoReceiveReceive;
import com.kingdee.eas.scm.nsrm.app.util.QtyChangeCalUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmCommonUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IerpToReceiveUtil {
    private static Logger logger = Logger.getLogger(PurSaloutStocktoReceiveReceive.class);
    private final String SAVE = "1";
    private final String SUBMIT = "2";
    private final String AUDIT = "3";
    private final String TORECEIVE = "toReceive";
    private static IerpToReceiveUtil single = null;

    public Map<String, MeasureUnitInfo> getUnitMap(Context ctx, Set<String> baseUnitNumberSet) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo unitev = ConvertUtil.convertNumSet2EVI(baseUnitNumberSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitev);
        for (int i = 0; i < measureUnitCollection.size(); ++i) {
            MeasureUnitInfo info = measureUnitCollection.get(i);
            unitMap.put(info.getNumber().toString(), info);
        }
        return unitMap;
    }

    private Object getBotpNumber(Map<String, Object> dataMap, Map<String, Map<String, String>> msgMap) {
        if (null == dataMap.get("botpNumber")) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6ca1\u6709\u5bf9\u5e94\u7684BOTP\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5");
            errMap.put("billtype", "");
            errMap.put("billnumber", "");
            errMap.put("billstatus", "");
            msgMap.put("error", errMap);
            return null;
        }
        return dataMap.get("botpNumber");
    }

    private void dealEntryDetailData(Map<String, Map<String, Object>> entryDetailMap, Map<String, Object> map) {
        for (String entryId : map.keySet()) {
            Map entrymap = (Map)map.get(entryId);
            entryDetailMap.put(entryId, entrymap);
        }
    }

    public void addPurOrderEntry(PurOrderEntryCollection entrycol, PurOrderEntryInfo entry) {
        if (entry.getBaseStatus().getValue() == 4) {
            entrycol.add(entry);
        }
    }

    private BTPTransformResult buidNewPurReceival(Context ctx, IObjectCollection col, String botpnumber) throws BOSException, EASBizException, UuidException, SQLException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        cbc.addObjectCollection(col);
        String purQuotBosType = "15F2BD83";
        StringBuffer sb = new StringBuffer();
        sb.append("select mapping.fid fid, ext.FIsEffected FIsEffected from T_BOT_MAPPING mapping ").append(" left outer join T_BOT_ExtMapping ext on mapping.FExtMappingID = ext.fid").append(" where mapping.fName = '").append(botpnumber).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean hasRule = false;
        boolean isEffected = false;
        String botpID = null;
        try {
            if (rs.next()) {
                botpID = rs.getString("fid");
                isEffected = rs.getBoolean("FIsEffected");
                hasRule = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (!hasRule) {
            logger.error((Object)"@@@@PurSaloutStocktoReceiveHandle,errorMsg:\u6ca1\u6709\u5b9a\u4e49BOTP\u89c4\u5219");
            return null;
        }
        if (!isEffected) {
            logger.error((Object)"@@@@PurSaloutStocktoReceiveHandle,errorMsg:BOTP\u89c4\u5219\u672a\u542f\u7528");
        }
        return iBTPManager.transformForBotp(cbc, purQuotBosType, (IObjectPK)new ObjectUuidPK(botpID));
    }

    public void updateBill(Context ctx, IObjectCollection col, Map<String, Map<String, Object>> entryDetailMap, String botpnumber, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws BOSException, EASBizException {
        String entryId;
        Map<String, Object> entryMap;
        int i;
        long startTime = System.currentTimeMillis();
        BTPTransformResult btpTransformResult = new BTPTransformResult();
        try {
            BTPTransformResult newBtpTransformResult = this.buidNewPurReceival(ctx, col, botpnumber);
            if (newBtpTransformResult == null) {
                logger.error((Object)"@@@@PurSaloutStocktoReceiveReceive.buidNewPurReceival():errorMsg:BOTP\u8f6c\u6362\u5931\u8d25");
                this.setPurOrderReturnMsg(entryDetailMap, "BOTP\u8f6c\u6362\u5931\u8d25", "", "", "", msgMap);
            } else {
                IObjectCollection iObjectCollection = newBtpTransformResult.getBills();
                btpTransformResult.addBills(iObjectCollection);
            }
        }
        catch (Exception e) {
            logger.error((Object)("@@@@PurSaloutStocktoReceiveReceive.buidNewPurReceival():errorMsg:" + e.getMessage()));
            this.setPurOrderReturnMsg(entryDetailMap, e.getMessage(), "", "", "", msgMap);
        }
        long currentTime = System.currentTimeMillis();
        logger.debug((Object)("@@@@PurSaloutStocktoReceiveReceive.updateBill() botp\u65b9\u6cd5\u6267\u884c\u8017\u65f62+" + (currentTime - startTime)));
        if (btpTransformResult == null || btpTransformResult.getBills() == null || btpTransformResult.getBills().size() <= 0) {
            return;
        }
        long startTime1 = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> datatomap = new HashMap<String, Map<String, Object>>();
        HashSet<String> warehouseSet = new HashSet<String>();
        HashSet<String> projectSet = new HashSet<String>();
        HashSet<String> locationSet = new HashSet<String>();
        HashSet<String> trackSet = new HashSet<String>();
        HashMap<String, String> idwarehouseMap = new HashMap<String, String>();
        HashMap<String, String> idprojectMap = new HashMap<String, String>();
        HashMap<String, String> idlocationMap = new HashMap<String, String>();
        HashMap<String, String> idtrackMap = new HashMap<String, String>();
        Set<String> entryidSet = entryDetailMap.keySet();
        for (String key : entryidSet) {
            Map<String, Object> entryMap2 = entryDetailMap.get(key);
            String entryId2 = entryMap2.get("entryId").toString();
            if (entryMap2.get("warehouse") != null) {
                warehouseSet.add(entryMap2.get("warehouse").toString());
            }
            if (entryMap2.get("location") != null) {
                locationSet.add(entryMap2.get("location").toString());
            }
            if (entryMap2.get("project") != null) {
                projectSet.add(entryMap2.get("project").toString());
            }
            if (entryMap2.get("trace") == null) continue;
            trackSet.add(entryMap2.get("trace").toString());
        }
        HashMap<String, Object> warehouseMap = new HashMap<String, Object>();
        HashMap<String, String> projectMap = new HashMap<String, String>();
        HashMap<String, String> locationMap = new HashMap<String, String>();
        HashMap<String, Object> trackMap = new HashMap<String, Object>();
        EntityViewInfo warehouseev = ConvertUtil.convertNumSet2EVI(warehouseSet);
        EntityViewInfo projectev = ConvertUtil.convertNumSet2EVI(projectSet);
        EntityViewInfo locationev = ConvertUtil.convertNumSet2EVI(locationSet);
        EntityViewInfo trackev = ConvertUtil.convertNumSet2EVI(trackSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        warehouseev.setSelector(sic);
        projectev.setSelector(sic);
        locationev.setSelector(sic);
        trackev.setSelector(sic);
        WarehouseCollection warehouseCollection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(warehouseev);
        ProjectCollection projectCollection = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(projectev);
        LocationCollection locationCollection = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(locationev);
        TrackNumberCollection trackNumberCollection = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection(trackev);
        for (i = 0; i < warehouseCollection.size(); ++i) {
            WarehouseInfo warehouseInfo = warehouseCollection.get(i);
            warehouseMap.put(warehouseInfo.getId().toString(), warehouseInfo);
            warehouseMap.put(warehouseInfo.getNumber().toString(), warehouseInfo.getId().toString());
        }
        for (i = 0; i < projectCollection.size(); ++i) {
            ProjectInfo projectInfo = projectCollection.get(i);
            projectMap.put(projectInfo.getNumber().toString(), projectInfo.getId().toString());
            projectMap.put(projectInfo.getId().toString(), (String)projectInfo);
        }
        for (i = 0; i < locationCollection.size(); ++i) {
            LocationInfo locationInfo = locationCollection.get(i);
            locationMap.put(locationInfo.getNumber().toString(), locationInfo.getId().toString());
            locationMap.put(locationInfo.getId().toString(), (String)locationInfo);
        }
        for (i = 0; i < trackNumberCollection.size(); ++i) {
            TrackNumberInfo trackNumberInfo = trackNumberCollection.get(i);
            trackMap.put(trackNumberInfo.getNumber().toString(), trackNumberInfo.getId());
            trackMap.put(trackNumberInfo.getId().toString(), trackNumberInfo);
        }
        Map objectMap = new HashMap();
        for (String key : entryidSet) {
            Object exp;
            Object mfg;
            String id;
            String number;
            entryMap = entryDetailMap.get(key);
            entryId = entryMap.get("entryId").toString();
            if (entryMap.get("warehouse") != null && warehouseMap.get(entryMap.get("warehouse")) != null) {
                objectMap = (Map)warehouseMap.clone();
                number = entryMap.get("warehouse").toString();
                id = warehouseMap.get(number).toString();
                entryMap.put("warehouse", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("location") != null && locationMap.get(entryMap.get("location")) != null) {
                number = entryMap.get("location").toString();
                objectMap = (Map)locationMap.clone();
                id = locationMap.get(number).toString();
                entryMap.put("location", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("project") != null && projectMap.get(entryMap.get("project")) != null) {
                number = entryMap.get("project").toString();
                objectMap = (Map)projectMap.clone();
                id = projectMap.get(number).toString();
                entryMap.put("project", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("trace") != null && trackMap.get(entryMap.get("trace")) != null) {
                objectMap = (Map)trackMap.clone();
                number = entryMap.get("trace").toString();
                id = trackMap.get(number).toString();
                entryMap.put("trace", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("lot") != null) {
                HashMap<String, String> lotMap = new HashMap<String, String>();
                lotMap.put("lot", entryMap.get("lot").toString());
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, lotMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(lotMap);
                }
            }
            if ((mfg = entryMap.get("mfg")) != null) {
                HashMap<String, Date> mfgMap = new HashMap<String, Date>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                try {
                    date = simpleDateFormat.parse(mfg.toString());
                }
                catch (ParseException e) {
                    logger.error((Object)("\u751f\u4ea7\u65e5\u671f" + mfg + " \u65f6\u95f4\u89e3\u6790\u9519\u8bef"), (Throwable)e);
                }
                mfgMap.put("mfg", date);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, mfgMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(mfgMap);
                }
            }
            if ((exp = entryMap.get("exp")) != null) {
                HashMap<String, Date> expMap = new HashMap<String, Date>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                try {
                    date = simpleDateFormat.parse(exp.toString());
                }
                catch (ParseException e) {
                    logger.error((Object)("\u5230\u671f\u65e5\u671f\uff1a" + exp + " \u65f6\u95f4\u89e3\u6790\u9519\u8bef"), (Throwable)e);
                }
                expMap.put("exp", date);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, expMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(expMap);
                }
            }
            if (entryMap.get("supplierlot") != null) {
                HashMap<String, String> supplierlotMap = new HashMap<String, String>();
                supplierlotMap.put("supplierlot", entryMap.get("supplierlot").toString());
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, supplierlotMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(supplierlotMap);
                }
            }
            entryDetailMap.put(key, entryMap);
        }
        for (String key : entryidSet) {
            entryMap = entryDetailMap.get(key);
            entryId = entryMap.get("entryId").toString();
            if (entryMap.get("warehouse") != null) {
                idwarehouseMap.put(entryId, entryMap.get("warehouse").toString());
            }
            if (entryMap.get("location") != null) {
                idlocationMap.put(entryId, entryMap.get("location").toString());
            }
            if (entryMap.get("project") != null) {
                idprojectMap.put(entryId, entryMap.get("project").toString());
            }
            if (entryMap.get("trace") == null) continue;
            idtrackMap.put(entryId, entryMap.get("trace").toString());
        }
        HashMap<String, Map<String, String>> parmsMap = new HashMap<String, Map<String, String>>();
        parmsMap.put("warehouse", idwarehouseMap);
        parmsMap.put("location", idlocationMap);
        parmsMap.put("trace", idtrackMap);
        parmsMap.put("project", idprojectMap);
        long currentTime1 = System.currentTimeMillis();
        logger.debug((Object)("PurSaloutStocktoReceiveReceive.updateBill() \u4fdd\u5b58\u4f20\u503c\u8fc7\u6765\u57fa\u7840\u8d44\u6599\u8017\u65f6" + (currentTime1 - startTime1)));
        PurReceivalBillCollection purReceivalBillCollection = (PurReceivalBillCollection)btpTransformResult.getBills();
        this.createBillAfterDeal(ctx, purReceivalBillCollection, parmsMap, entryDetailMap, datatomap, msgMap, billstatus, billstatus1);
        long currentTime2 = System.currentTimeMillis();
        logger.debug((Object)("PurSaloutStocktoReceiveReceive.updateBill() \u751f\u6210\u65b0\u5355\u636e\u64cd\u4f5c\u8017\u65f6" + (currentTime2 - currentTime1)));
    }

    private void createBillAfterDeal(Context ctx, PurReceivalBillCollection purReceivalBillCollection, Map<String, Map<String, String>> parmsMap, Map<String, Map<String, Object>> entryDetailMap, Map<String, Map<String, Object>> datatomap, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws EASBizException, BOSException {
        if (purReceivalBillCollection == null || purReceivalBillCollection.size() == 0) {
            return;
        }
        Map<String, Object> detailDataMap = null;
        ArrayList<String> headExtFieldList = null;
        HashMap<String, ICoreBase> iCoreMap = new HashMap();
        ArrayList<String> extFieldList = null;
        Map<String, ICoreBase> headICoreMap = new HashMap<String, ICoreBase>();
        for (int i = 0; i < purReceivalBillCollection.size(); ++i) {
            PurReceivalBillInfo purReceivalBillInfo = purReceivalBillCollection.get(i);
            purReceivalBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            purReceivalBillInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            for (int j = 0; j < purReceivalBillInfo.getEntries().size(); ++j) {
                String unitId;
                String materialId;
                PurReceivalEntryInfo entry = purReceivalBillInfo.getEntry().get(j);
                String orderentryid = entry.getSourceBillEntryId().toString();
                String warehousenum = parmsMap.get("warehouse").get(orderentryid);
                String locationnum = parmsMap.get("location").get(orderentryid);
                String projectnum = parmsMap.get("project").get(orderentryid);
                String tracknum = parmsMap.get("trace").get(orderentryid);
                detailDataMap = entryDetailMap.get(entry.getSourceBillEntryId().toString());
                if (extFieldList == null) {
                    extFieldList = (ArrayList<String>)detailDataMap.get("extFieldSet");
                    if (extFieldList == null) {
                        extFieldList = new ArrayList<String>();
                    } else {
                        iCoreMap = SrmCommonUtil.getExtICoreMap(ctx, extFieldList, entry.getBOSType().toString());
                    }
                }
                String srcEntryId = detailDataMap.get("srcEntryId").toString();
                String srcbillId = detailDataMap.get("srcBillId").toString();
                if (detailDataMap.get("note") != null) {
                    String note = detailDataMap.get("note").toString();
                    entry.setRemark(note);
                }
                Object srcBillNum = detailDataMap.get("srcBillNum");
                if (null == detailDataMap.get("source")) {
                    entry.put("saloutstockEntryID", (Object)srcEntryId);
                    entry.put("saloutstockID", (Object)srcbillId);
                    if (srcBillNum != null) {
                        entry.put("salOutStockNum", (Object)srcBillNum.toString());
                    }
                }
                if (datatomap.get(orderentryid) == null || entryDetailMap.size() <= 0) continue;
                if (warehousenum != null && datatomap.get(orderentryid).get(warehousenum) != null) {
                    WarehouseInfo warehouseInfo = (WarehouseInfo)datatomap.get(orderentryid).get(warehousenum);
                    entry.setWarehouse(warehouseInfo);
                }
                if (locationnum != null && datatomap.get(orderentryid).get(locationnum) != null) {
                    LocationInfo locationInfo = (LocationInfo)datatomap.get(orderentryid).get(locationnum);
                    entry.setLocation(locationInfo);
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("lot") != null) {
                    entry.setLot(datatomap.get(orderentryid).get("lot").toString());
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("mfg") != null) {
                    entry.setMfg((Date)datatomap.get(orderentryid).get("mfg"));
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("exp") != null) {
                    entry.setExp((Date)datatomap.get(orderentryid).get("exp"));
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("supplierlot") != null) {
                    entry.setSupplierLotNo(datatomap.get(orderentryid).get("supplierlot").toString());
                }
                if (projectnum != null && datatomap.get(orderentryid).get(projectnum) != null) {
                    ProjectInfo projectInfo = (ProjectInfo)datatomap.get(orderentryid).get(projectnum);
                    entry.setProject(projectInfo);
                }
                if (tracknum != null && datatomap.get(orderentryid).get(tracknum) != null) {
                    TrackNumberInfo trackNumberInfo = (TrackNumberInfo)datatomap.get(orderentryid).get(tracknum);
                    entry.setTrackNumber(trackNumberInfo);
                }
                if (entry.getQty().compareTo(BigDecimal.ZERO) == 0 || entry.getQty() == null) {
                    BigDecimal qty = new BigDecimal(String.valueOf(detailDataMap.get("qty")));
                    entry.setQty(qty);
                }
                BigDecimal baseqty = BigDecimal.ZERO;
                if (null != entry.getMaterial()) {
                    materialId = entry.getMaterial().getId().toString();
                    String baseUnit = entry.getBaseUnit().getId().toString();
                    unitId = entry.getUnit().getId().toString();
                    baseqty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialId, unitId, baseUnit, entry.getQty());
                } else {
                    baseqty = entry.getQty();
                }
                entry.setBaseQty(baseqty);
                QtyChangeCalUtil.qtyChange(ctx, entry);
                if (entry.getAssistUnit() != null && entry.getAssistUnit().getId() != null) {
                    materialId = entry.getMaterial().getId().toString();
                    String assistUnitId = entry.getAssistUnit().getId().toString();
                    unitId = entry.getUnit().getId().toString();
                    BigDecimal assist = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialId, unitId, assistUnitId, entry.getQty());
                    entry.setAssistQty(assist);
                }
                SrmCommonUtil.setExtFiledValue(extFieldList, iCoreMap, (CoreBaseInfo)entry, detailDataMap);
            }
            if (headExtFieldList == null) {
                headExtFieldList = (ArrayList<String>)detailDataMap.get("extFieldSet");
                if (headExtFieldList == null) {
                    headExtFieldList = new ArrayList<String>();
                } else {
                    headICoreMap = SrmCommonUtil.getExtICoreMap(ctx, headExtFieldList, purReceivalBillInfo.getBOSType().toString());
                }
            }
            SrmCommonUtil.setExtFiledValue((List<String>)headExtFieldList, headICoreMap, (CoreBaseInfo)purReceivalBillInfo, detailDataMap);
            long startTime = System.currentTimeMillis();
            this.afterDealNewBill(ctx, purReceivalBillInfo, entryDetailMap, msgMap, billstatus, billstatus1);
            long currentTime1 = System.currentTimeMillis();
            logger.debug((Object)("@@@@PurSaloutStocktoReceiveReceive.createBillAfterDeal() \u5904\u7406\u540e\u7684\u5355\u636e\u8fdb\u884c\u63d0\u4ea4\uff0c\u5ba1\u68385+" + (currentTime1 - startTime)));
        }
    }

    private void afterDealNewBill(Context ctx, PurReceivalBillInfo purReceivalBillInfo, Map<String, Map<String, Object>> entryDetailMap, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws EASBizException, BOSException {
        PurReceivalBillInfo newInfo;
        boolean isOk = true;
        IPurReceivalBill iPurReceivalBill = PurReceivalBillFactory.getLocalInstance((Context)ctx);
        String errorMsg = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        String status = null;
        if (null != billstatus1) {
            if (billstatus1 instanceof Map) {
                Map billstatusMap = (Map)billstatus1;
                status = (String)billstatusMap.get(purReceivalBillInfo.getStorageOrgUnit().getNumber());
            } else {
                status = String.valueOf(billstatus1);
            }
        }
        try {
            iPurReceivalBill.save((CoreBaseInfo)purReceivalBillInfo);
            if (null != status && "A".equals(status)) {
                newInfo = iPurReceivalBill.getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()), sic);
                this.setPurInReturnMsg(entryDetailMap, "", "toReceive", purReceivalBillInfo.getNumber().toString(), newInfo.getBaseStatus().getValue() == 4 ? "3" : "2", newInfo, msgMap);
            }
            if (null != status && "B".equals(status)) {
                iPurReceivalBill.submit(purReceivalBillInfo.getId().toString());
                newInfo = iPurReceivalBill.getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()), sic);
                this.setPurInReturnMsg(entryDetailMap, "", "toReceive", purReceivalBillInfo.getNumber().toString(), newInfo.getBaseStatus().getValue() == 4 ? "3" : "2", newInfo, msgMap);
            }
            if ("".equals(status) || null == status || null != status && "C".equals(status)) {
                iPurReceivalBill.submit((CoreBaseInfo)purReceivalBillInfo);
                newInfo = iPurReceivalBill.getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()), sic);
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
                IObjectPK caller = ctx.getCaller();
                String procDef = service.findProcDef(caller.toString(), (IObjectValue)purReceivalBillInfo, "com.kingdee.eas.scm.im.inv.PurReceiveFunction", "ActionSubmit");
                if (service.billIsInProcessQueueOrHasProcessInst(purReceivalBillInfo.getId().toString()) && procDef != null) {
                    this.setPurInReturnMsg(entryDetailMap, "\u5355\u636e\u5df2\u7ecf\u8fdb\u5165\u5de5\u4f5c\u6d41", "toReceive", purReceivalBillInfo.getNumber().toString(), "2", newInfo, msgMap);
                } else {
                    if (newInfo.getBaseStatus().getValue() != 4) {
                        PurReceivalBillFactory.getLocalInstance((Context)ctx).audit((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()));
                    }
                    this.setPurInReturnMsg(entryDetailMap, "", "toReceive", purReceivalBillInfo.getNumber().toString(), "3", newInfo, msgMap);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("@@@@PurSaloutStocktoReceiveHandle.updateBill():errorMsg:" + e.getMessage()));
            isOk = false;
            errorMsg = e.getMessage();
        }
        if (!isOk) {
            newInfo = iPurReceivalBill.getPurReceivalBillInfo((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()), sic);
            errorMsg = errorMsg.replace("\n", "");
            errorMsg = errorMsg.replace("\\", "").replace(newInfo.getNumber(), "");
            if (newInfo.getBaseStatus().getValue() == 2) {
                this.setPurInReturnMsg(entryDetailMap, errorMsg, "toReceive", purReceivalBillInfo.getNumber().toString(), "", newInfo, msgMap);
            } else if (newInfo.getBaseStatus().getValue() == 1) {
                this.setPurInReturnMsg(entryDetailMap, errorMsg, "toReceive", purReceivalBillInfo.getNumber().toString(), "", newInfo, msgMap);
            }
            iPurReceivalBill.delete((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()));
        }
    }

    private void deleteOtherPurInwarehs(Context ctx, PurReceivalBillInfo newInfo, String id) throws BOSException, EASBizException {
        HashSet<Integer> statusList = new HashSet<Integer>();
        statusList.add(1);
        statusList.add(2);
        StringBuilder strId = new StringBuilder();
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            String srcId = newInfo.getEntry().getObject(i).get("sourceBillEntryId").toString();
            strId.append(srcId);
            if (i == newInfo.getEntries().size() - 1) continue;
            strId.append(",");
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", (Object)strId.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", statusList, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurReceivalEntryCollection purReceivalEntryCollection = PurReceivalEntryFactory.getLocalInstance((Context)ctx).getPurReceivalEntryCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < purReceivalEntryCollection.size(); ++i) {
            PurReceivalEntryInfo info = purReceivalEntryCollection.get(i);
            idSet.add(info.getParent().getId().toString());
        }
        idSet.remove(id);
        IObjectPK[] arrayPK = new IObjectPK[idSet.size()];
        int n = 0;
        for (String key : idSet) {
            arrayPK[n] = new ObjectUuidPK(BOSUuid.read((String)key));
            ++n;
        }
        PurInWarehsBillFactory.getLocalInstance((Context)ctx).delete(arrayPK);
    }

    public void setEntryReturnMsg(Map<String, Object> returnMsgMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        HashMap<String, String> errMap = new HashMap<String, String>();
        errMap.put("error", error);
        errMap.put("billtype", billtype);
        errMap.put("billnumber", number);
        errMap.put("billstatus", billstatus);
        String srcEntryId = returnMsgMap.get("srcEntryId").toString();
        msgMap.put(srcEntryId, errMap);
    }

    public void setPurOrderReturnMsg(Map<String, Map<String, Object>> entryDetailMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        for (String entryid : entryDetailMap.keySet()) {
            this.setPurInReturnMsg(entryDetailMap.get(entryid), error, billtype, number, billstatus, msgMap);
        }
    }

    public void setPurInReturnMsg(Map<String, Map<String, Object>> entryDetailMap, String error, String billtype, String number, String billstatus, PurReceivalBillInfo newInfo, Map<String, Map<String, String>> msgMap) {
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            Map<String, Object> obj;
            PurReceivalEntryInfo entry = newInfo.getEntry().get(i);
            if (entryDetailMap.keySet().contains(entry.getSourceBillEntryId().toString())) {
                obj = entryDetailMap.get(entry.getSourceBillEntryId().toString());
                this.setPurInReturnMsg(obj, error, billtype, number, billstatus, msgMap);
                continue;
            }
            if (entry.get("saloutstockEntryID") == null || !entryDetailMap.keySet().contains(entry.get("saloutstockEntryID").toString())) continue;
            obj = entryDetailMap.get(entry.get("saloutstockEntryID").toString());
            this.setPurInReturnMsg(obj, error, billtype, number, billstatus, msgMap);
        }
    }

    public void setPurInReturnMsg(Object entryMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        Map returnMsgMap = (Map)entryMap;
        HashMap<String, String> errMap = new HashMap<String, String>();
        errMap.put("error", error);
        errMap.put("billtype", billtype);
        errMap.put("billnumber", number);
        errMap.put("billstatus", billstatus);
        String srcEntryId = returnMsgMap.get("srcEntryId").toString();
        msgMap.put(srcEntryId, errMap);
    }

    private IerpToReceiveUtil() {
    }

    public static IerpToReceiveUtil getInstance() {
        if (single == null) {
            single = new IerpToReceiveUtil();
        }
        return single;
    }
}

