/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryCollection;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleException;
import com.kingdee.eas.scm.sd.sale.SaleInvBizException;
import com.kingdee.eas.scm.sd.sale.app.AbstractConsignSaleBillControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConsignSaleBillControllerBean
extends AbstractConsignSaleBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.ConsignSaleBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsignSaleBillInfo consignSaleInfo = (ConsignSaleBillInfo)model;
        ctx.put((Object)"curSettleDate", (Object)consignSaleInfo.getBizDate());
        CoreBaseCollection consignSaleColl = this.getConsignSaleOutInfo(ctx, consignSaleInfo);
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        ConsignSaleBillEntryCollection entryColl = consignSaleInfo.getEntrys();
        ConsignSaleBillEntryInfo consignEntryInfo = null;
        List snList = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            consignEntryInfo = entryColl.get(i);
            if (!consignEntryInfo.getBoolean("isSN") || (snList = (List)consignEntryInfo.get("snList")) != null && snList.size() == consignEntryInfo.getWriteOffQty().intValue()) continue;
            throw new ConsignSaleException(ConsignSaleException.SN_NOT_ENOUGH, new Integer[]{consignEntryInfo.getSeq()});
        }
        HashSet<String> billIDSet = new HashSet<String>();
        HashMap<String, ConsignSaleBillEntryInfo> billEntryIDMap = new HashMap<String, ConsignSaleBillEntryInfo>();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            consignEntryInfo = entryColl.get(i);
            billIDSet.add(consignEntryInfo.getSourceBillMID());
            billEntryIDMap.put(consignEntryInfo.getSourceBillEntryMID(), consignEntryInfo);
        }
        ctx.put((Object)"bizDate", (Object)consignSaleInfo.getBizDate());
        IObjectCollection saleIssueBillColl = iSaleIssueBill.createNewAuditBillBySettle(billEntryIDMap, billIDSet);
        ArrayList<IObjectValue> destBillList = new ArrayList<IObjectValue>();
        int count = saleIssueBillColl.size();
        for (int i = 0; i < count; ++i) {
            destBillList.add(saleIssueBillColl.getObject(i));
        }
        this.insertConsignedData(ctx, destBillList, consignSaleColl);
        IObjectPK[] ObjectPKs = this._submitBatchData(ctx, (IObjectCollection)consignSaleColl);
        this.checkUnsettleQty(ctx, ObjectPKs[0].toString());
        return ObjectPKs[0];
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsignSaleBillInfo consignSaleInfo = (ConsignSaleBillInfo)model;
        SaleIssueBillCollection saleIssueBillColl = this.getSaleIssueBillByConsign(ctx, consignSaleInfo);
        CoreBaseCollection consignSaleColl = this.getConsignSaleReturnInfo(ctx, consignSaleInfo);
        ConsignSaleBillEntryCollection colEntrys = (ConsignSaleBillEntryCollection)((Object)consignSaleColl.get(0).get("entrys"));
        HashMap<String, Object> baseQtyMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> baseQtyList = new ArrayList<HashMap<String, Object>>();
        BigDecimal baseQty = BigDecimal.ZERO;
        String sourceEntryId = "";
        for (int i = 0; i < colEntrys.size(); ++i) {
            baseQtyMap = new HashMap();
            ConsignSaleBillEntryInfo entry = colEntrys.get(i);
            if (entry.get("baseqtytop") != null) {
                baseQty = (BigDecimal)entry.get("baseqtytop");
                sourceEntryId = (String)entry.get("sourcebillentrymid");
                baseQty = baseQty.abs();
                baseQtyMap.put("sourceEntryId", sourceEntryId);
                baseQtyMap.put("baseQty", baseQty);
            } else {
                baseQty = (BigDecimal)entry.get("baseQtysum");
                sourceEntryId = (String)entry.get("sourcebillentrymid");
                baseQtyMap.put("sourceEntryId", sourceEntryId);
                baseQtyMap.put("baseQty", baseQty);
            }
            baseQtyList.add(baseQtyMap);
        }
        IObjectPK[] ObjectPKs = this._submitBatchData(ctx, (IObjectCollection)consignSaleColl);
        if (ObjectPKs.length > 0) {
            this.writeSourceUnSettleQty(ctx, ObjectPKs[0].toString(), true);
            this.writeSourceUnsettleBaseQty(ctx, baseQtyList);
        }
        this.checkUnsettleQty(ctx, ObjectPKs[0].toString());
        return ObjectPKs[0];
    }

    private void writeSourceUnsettleBaseQty(Context ctx, List baseQtyList) throws BOSException {
        String sign = null;
        String unSign = null;
        sign = "-";
        unSign = "+";
        StringBuffer sql = new StringBuffer("");
        sql.append("update t_im_saleissueentry set FTotalSettleBaseQty = FTotalSettleBaseQty ").append(unSign).append("? , ");
        sql.append(" FUnSettleBaseQty = FUnSettleBaseQty").append(sign).append("? where fid = ?");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        BigDecimal baseQty = BigDecimal.ZERO;
        String sourceEntryid = "";
        Object[] params = null;
        Map qtyMap = new HashMap();
        for (int i = 0; i < baseQtyList.size(); ++i) {
            qtyMap = (Map)baseQtyList.get(i);
            baseQty = (BigDecimal)qtyMap.get("baseQty");
            sourceEntryid = (String)qtyMap.get("sourceEntryId");
            params = new Object[]{baseQty, baseQty, sourceEntryid};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private void checkUnsettleQty(Context ctx, String consignSaleID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sign(FUnSettleQty)+ sign(FQty) as QTY ,sign(FUnSettleBaseQty) + sign(FBaseQty) as BASEQTY from T_im_saleIssueEntry where  fid in (");
        sql.append("select FSourceBillEMID from T_SD_ConsignSaleBillEntry ");
        sql.append(" where fparentid = '").append(consignSaleID).append("') ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal baseQty = BigDecimal.ZERO;
        try {
            while (rs.next()) {
                qty = rs.getBigDecimal("QTY");
                baseQty = rs.getBigDecimal("BASEQTY");
                if (qty.compareTo(BigDecimal.ZERO) != 0 && baseQty.compareTo(BigDecimal.ZERO) != 0) continue;
                throw new ConsignSaleException(ConsignSaleException.REWRITE_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
    }

    private SaleIssueBillCollection getSaleIssueBillByConsign(Context ctx, ConsignSaleBillInfo consignSaleInfo) throws BOSException {
        ConsignSaleBillEntryInfo consignEntryInfo = null;
        HashSet<String> saleissueIDSet = new HashSet<String>();
        HashSet<String> saleissueEnryIDSet = new HashSet<String>();
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        ConsignSaleBillEntryCollection cosignSaleEntryColl = consignSaleInfo.getEntrys();
        int size = cosignSaleEntryColl.size();
        for (int i = 0; i < size; ++i) {
            consignEntryInfo = cosignSaleEntryColl.get(i);
            saleissueIDSet.add(consignEntryInfo.getSourceBillMID());
            saleissueEnryIDSet.add(consignEntryInfo.getSourceBillEntryMID());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", saleissueIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SaleIssueBillCollection saleIssueBillColl = iSaleIssueBill.getSaleIssueBillCollection(viewInfo);
        return saleIssueBillColl;
    }

    private void writeSourceUnSettleQty(Context ctx, String consignSaleID, List matList, boolean isVerify) throws BOSException {
        String sign = null;
        String unSign = null;
        if (isVerify) {
            sign = "-";
            unSign = "+";
        } else {
            sign = "+";
            unSign = "-";
        }
        StringBuffer sql = new StringBuffer("");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        sql.append("update t_im_saleissueentry sale set (FTotalSettleQty,FTotalSettleBaseQty,FUnSettleQty,FUnSettleBaseQty) =");
        sql.append("(select issuentry.FTotalSettleQty ").append(unSign).append(" ? ,");
        sql.append(" issuentry.FTotalSettleBaseQty ").append(unSign).append("round( ? ,MULTIUNIT.FQtyPrecision),");
        sql.append(" issuentry.FUnSettleQty ").append(sign).append(" ? ,");
        sql.append(" issuentry.FUnSettleBaseQty ").append(sign);
        sql.append(" round( ? ,MULTIUNIT.FQtyPrecision)");
        sql.append(" from (select ");
        sql.append(" FSourceBillEMID as FEntryId,FTRANSACTIONTYPE from T_SD_ConsignSaleBillEntry ");
        sql.append(" where fparentid = ? ").append(" and FSourceBillEMID = ? ");
        sql.append(" group by FSourceBillEMID,FTRANSACTIONTYPE");
        sql.append(") as a ");
        sql.append(" inner join t_im_saleissueentry issuentry on issuentry.fid = a.FEntryId ");
        sql.append(" left join T_BD_MultiMeasureUnit AS MULTIUNIT on issuentry.FMaterialID = MULTIUNIT.FMaterialID and  issuentry.FBaseUnitID = MULTIUNIT.FMeasureUnitID");
        sql.append(" where sale.fid = issuentry.fid)");
        Map matMap = new HashMap();
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal baseQty = BigDecimal.ZERO;
        String sourceEntryid = "";
        Object[] params = null;
        for (int i = 0; i < matList.size(); ++i) {
            matMap = (Map)matList.get(i);
            sourceEntryid = (String)matMap.get("sourceEntryid");
            baseQty = (BigDecimal)matMap.get("baseQty");
            qty = (BigDecimal)matMap.get("Qty");
            params = new Object[]{qty, baseQty, qty, baseQty, consignSaleID, sourceEntryid};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private CoreBaseCollection getConsignSaleReturnInfo(Context ctx, ConsignSaleBillInfo consignSaleBillInfo) throws BOSException, EASBizException {
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        ISaleIssueEntry iSaleIssueEntry = SaleIssueEntryFactory.getLocalInstance((Context)ctx);
        HashSet<String> saleissueIDSet = new HashSet<String>();
        HashSet<String> saleissueEnryIDSet = new HashSet<String>();
        ArrayList<BOSUuid> storageIDList = new ArrayList<BOSUuid>();
        ConsignSaleBillInfo consignBillInfo = null;
        ConsignSaleBillEntryInfo consignEntryInfo = null;
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryInfo saleIssueEntryInfo = null;
        CoreBaseCollection consignSaleColl = new CoreBaseCollection();
        ConsignSaleBillEntryCollection cosignSaleEntryColl = consignSaleBillInfo.getEntrys();
        int size = cosignSaleEntryColl.size();
        for (int i = 0; i < size; ++i) {
            consignEntryInfo = cosignSaleEntryColl.get(i);
            saleissueIDSet.add(consignEntryInfo.getSourceBillMID());
            saleissueEnryIDSet.add(consignEntryInfo.getSourceBillEntryMID());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", saleissueIDSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("customer.id"));
        selector.add(new SelectorItemInfo("customer.number"));
        selector.add(new SelectorItemInfo("customer.name"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getTransactionTypeSelector((boolean)true));
        viewInfo.setSelector(selector);
        viewInfo.setFilter(filterInfo);
        SaleIssueBillCollection saleIssueBillColl = iSaleIssueBill.getSaleIssueBillCollection(viewInfo);
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", saleissueEnryIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SaleIssueEntryCollection saleIssueEntryColl = iSaleIssueEntry.getSaleIssueEntryCollection(viewInfo);
        StorageOrgUnitInfo storageOrgUnitInfo = saleIssueBillColl.get(0) != null ? saleIssueBillColl.get(0).getStorageOrgUnit() : null;
        String storageID = storageOrgUnitInfo != null ? storageOrgUnitInfo.getId().toString() : null;
        OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)storageID);
        PeriodInfo periodInfo = null;
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)consignSaleBillInfo.getBizDate(), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)orgUnitCollection.get(0)));
        }
        if (periodInfo == null) {
            throw new SaleInvBizException(SaleInvBizException.BIZDATENOTMATCHERPERIOD);
        }
        consignSaleBillInfo.setYear(periodInfo.getPeriodYear());
        consignSaleBillInfo.setPeriod(periodInfo.getPeriodNumber());
        String balanceNumber = this.getBillNumber(ctx);
        consignSaleBillInfo.setNumber(balanceNumber);
        storageIDList.add(saleIssueBillColl.get(0).getStorageOrgUnit().getId());
        int length = storageIDList.size();
        for (int k = 0; k < length; ++k) {
            consignBillInfo = new ConsignSaleBillInfo();
            storageID = storageIDList.get(k).toString();
            consignBillInfo.setBizDate(consignSaleBillInfo.getBizDate());
            consignBillInfo.setLastUpdateUser(consignSaleBillInfo.getLastUpdateUser());
            consignBillInfo.setYear(consignSaleBillInfo.getYear());
            consignBillInfo.setPeriod(consignSaleBillInfo.getPeriod());
            consignBillInfo.setNumber(consignSaleBillInfo.getNumber());
            int size2 = cosignSaleEntryColl.size();
            block2: for (int i = 0; i < size2; ++i) {
                int j;
                consignEntryInfo = cosignSaleEntryColl.get(i);
                CurrencyInfo curreny = null;
                int precision = 2;
                int count = saleIssueBillColl.size();
                for (j = 0; j < count; ++j) {
                    saleIssueBillInfo = saleIssueBillColl.get(j);
                    if (!saleIssueBillInfo.getId().toString().equals(consignEntryInfo.getSourceBillMID()) || !storageID.equals(saleIssueBillInfo.getStorageOrgUnit().getId().toString())) continue;
                    consignEntryInfo.setCustomer(saleIssueBillInfo.getCustomer());
                    consignEntryInfo.setTransactionType(saleIssueBillInfo.getTransactionType());
                    consignEntryInfo.setBillNumber(saleIssueBillInfo.getNumber());
                    consignBillInfo.setStorageOrgUnit(saleIssueBillInfo.getStorageOrgUnit());
                    curreny = saleIssueBillInfo.getCurrency();
                    precision = curreny.getPrecision();
                    break;
                }
                int entryCount = saleIssueEntryColl.size();
                for (j = 0; j < entryCount; ++j) {
                    saleIssueEntryInfo = saleIssueEntryColl.get(j);
                    if (!saleIssueEntryInfo.getId().toString().equals(consignEntryInfo.getSourceBillEntryMID()) || !storageID.equals(saleIssueEntryInfo.getStorageOrgUnit().getId().toString())) continue;
                    consignEntryInfo.setWriteOffPrice(saleIssueEntryInfo.getPrice());
                    consignEntryInfo.setWriteOffAmount(saleIssueEntryInfo.getPrice().multiply(consignEntryInfo.getWriteOffQty()).setScale(precision, 4));
                    consignEntryInfo.setSourceBillEntrySeq(saleIssueEntryInfo.getSaleOrderEntrySeq());
                    consignEntryInfo.setBillSeq(saleIssueEntryInfo.getSeq());
                    consignEntryInfo.setMaterial(saleIssueEntryInfo.getMaterial());
                    consignEntryInfo.setBaseUnit(saleIssueEntryInfo.getBaseUnit());
                    consignEntryInfo.setAssistProperty(saleIssueEntryInfo.getAssistProperty());
                    consignEntryInfo.setUnit(saleIssueEntryInfo.getUnit());
                    consignEntryInfo.setCoreBillNumber(saleIssueEntryInfo.getSaleOrderNumber());
                    consignEntryInfo.setSaleOrgUnit(saleIssueEntryInfo.getSaleOrgUnit());
                    consignEntryInfo.setCompanyOrgUnit(saleIssueEntryInfo.getCompanyOrgUnit());
                    consignEntryInfo.setLot(saleIssueEntryInfo.getLot());
                    consignEntryInfo.setUnWriteOffQty(saleIssueEntryInfo.getUnSettleQty().subtract(consignEntryInfo.getWriteOffQty()));
                    if (consignEntryInfo.get("baseqtytop") != null && ((BigDecimal)consignEntryInfo.get("baseqtytop")).compareTo(saleIssueEntryInfo.getUnSettleBaseQty()) == 0) {
                        consignEntryInfo.setWriteOffQty(saleIssueEntryInfo.getUnSettleQty());
                    }
                    consignBillInfo.getEntrys().add(consignEntryInfo);
                    continue block2;
                }
            }
            consignSaleColl.add((CoreBaseInfo)consignBillInfo);
        }
        return consignSaleColl;
    }

    private void writeSourceUnSettleQty(Context ctx, String consignSaleID, boolean isVerify) throws BOSException {
        String sign = null;
        String unSign = null;
        if (isVerify) {
            sign = "-";
            unSign = "+";
        } else {
            sign = "+";
            unSign = "-";
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("update t_im_saleissueentry set (FTotalSettleQty,FUnSettleQty) =");
        sql.append("(select t_im_saleissueentry.FTotalSettleQty ").append(unSign).append(" a.fwriteOffQty,");
        sql.append(" t_im_saleissueentry.FUnSettleQty ").append(sign).append(" a.fwriteOffQty");
        sql.append(" from (select decimal(sum(fwriteOffQty),21,8) as fwriteOffQty,");
        sql.append("FSourceBillEMID as FEntryId from T_SD_ConsignSaleBillEntry ");
        sql.append(" where fparentid = '").append(consignSaleID).append("' ");
        sql.append("group by FSourceBillEMID");
        sql.append(") as a , T_BD_MultiMeasureUnit AS MULTIUNIT, T_BD_MultiMeasureUnit AS MULTIBASEUNIT ");
        sql.append(" where t_im_saleissueentry.fid = a.FEntryId and ");
        sql.append(" t_im_saleissueentry.FMaterialID = MULTIUNIT.FMaterialID AND t_im_saleissueentry.FUnitID = MULTIUNIT.FMeasureUnitID ");
        sql.append(" and t_im_saleissueentry.FMaterialID = MULTIBASEUNIT.FMaterialID AND t_im_saleissueentry.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID");
        sql.append(") where t_im_saleissueentry.fid in (");
        sql.append(" select FSourceBillEMID as FEntryId from T_SD_ConsignSaleBillEntry where fparentid = '").append(consignSaleID).append("' ");
        sql.append(" group by FSourceBillEMID )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getBillNumber(Context ctx) throws BOSException {
        int balanceNumber;
        StringBuffer yearMonth;
        block16: {
            Calendar calendar = Calendar.getInstance();
            yearMonth = new StringBuffer();
            if (calendar.get(2) >= 9) {
                yearMonth.append(calendar.get(1)).append(calendar.get(2) + 1);
            } else {
                yearMonth.append(calendar.get(1)).append("0").append(calendar.get(2) + 1);
            }
            String querySql = "select FSeq from T_SD_ConsignNumber where FYearMonth = '" + yearMonth.toString() + "'";
            String insertSql = "insert into T_SD_ConsignNumber values(?,?)";
            String updateSql = "update T_SD_ConsignNumber set FSeq = ? where FYearMonth = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            IRowSet rowSet1 = null;
            balanceNumber = 1;
            try {
                if (rowSet != null && rowSet.next()) {
                    String updateLockSql = "update T_SD_ConsignNumber set FYearMonth = ? where FYearMonth = ?";
                    DbUtil.execute((Context)ctx, (String)updateLockSql, (Object[])new Object[]{yearMonth.toString(), yearMonth.toString()});
                    rowSet1 = DbUtil.executeQuery((Context)ctx, (String)querySql);
                    if (rowSet1.next()) {
                        balanceNumber = rowSet1.getInt("FSeq");
                        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{String.valueOf(balanceNumber + 1), yearMonth.toString()});
                    }
                    break block16;
                }
                try {
                    DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{yearMonth.toString(), String.valueOf(balanceNumber + 1)});
                }
                catch (BOSException e1) {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
                    try {
                        if (rs.next()) {
                            balanceNumber = rs.getInt("FSeq");
                            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{String.valueOf(balanceNumber + 1), yearMonth.toString()});
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs);
                    }
                }
            }
            catch (SQLException e) {
                logger.info((Object)("sql is :" + querySql + "\r\n" + insertSql + "\r\n" + updateSql + e));
                throw new BOSException("sql is :" + querySql + "\r\n" + insertSql + "\r\n" + updateSql, (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowSet);
                SQLUtils.cleanup(rowSet1);
            }
        }
        int length = 6 - String.valueOf(balanceNumber).length();
        for (int i = 0; i < length; ++i) {
            yearMonth.append("0");
        }
        yearMonth.append(balanceNumber);
        return yearMonth.toString();
    }

    private CoreBaseCollection getConsignSaleOutInfo(Context ctx, ConsignSaleBillInfo consignSaleBillInfo) throws BOSException, EASBizException {
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        ISaleIssueEntry iSaleIssueEntry = SaleIssueEntryFactory.getLocalInstance((Context)ctx);
        HashSet<String> saleissueIDSet = new HashSet<String>();
        HashSet<String> saleissueEnryIDSet = new HashSet<String>();
        ArrayList<BOSUuid> storageIDList = new ArrayList<BOSUuid>();
        ConsignSaleBillInfo consignBillInfo = null;
        ConsignSaleBillEntryInfo consignEntryInfo = null;
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryInfo saleIssueEntryInfo = null;
        CoreBaseCollection consignSaleColl = new CoreBaseCollection();
        ConsignSaleBillEntryCollection cosignSaleEntryColl = consignSaleBillInfo.getEntrys();
        int size = cosignSaleEntryColl.size();
        for (int i = 0; i < size; ++i) {
            consignEntryInfo = cosignSaleEntryColl.get(i);
            saleissueIDSet.add(consignEntryInfo.getSourceBillMID());
            saleissueEnryIDSet.add(consignEntryInfo.getSourceBillEntryMID());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", saleissueIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SaleIssueBillCollection saleIssueBillColl = iSaleIssueBill.getSaleIssueBillCollection(viewInfo);
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", saleissueEnryIDSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SaleIssueEntryCollection saleIssueEntryColl = iSaleIssueEntry.getSaleIssueEntryCollection(viewInfo);
        StorageOrgUnitInfo storageOrgUnitInfo = saleIssueBillColl.get(0) != null ? saleIssueBillColl.get(0).getStorageOrgUnit() : null;
        String storageID = storageOrgUnitInfo != null ? storageOrgUnitInfo.getId().toString() : null;
        OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)storageID);
        PeriodInfo periodInfo = null;
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)consignSaleBillInfo.getBizDate(), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)orgUnitCollection.get(0)));
        }
        if (periodInfo == null) {
            throw new SaleInvBizException(SaleInvBizException.BIZDATENOTMATCHERPERIOD);
        }
        consignSaleBillInfo.setYear(periodInfo.getPeriodYear());
        consignSaleBillInfo.setPeriod(periodInfo.getPeriodNumber());
        String balanceNumber = this.getBillNumber(ctx);
        consignSaleBillInfo.setNumber(balanceNumber);
        int count = saleIssueBillColl.size();
        for (int j = 0; j < count; ++j) {
            if (storageIDList.contains(saleIssueBillColl.get(j).getStorageOrgUnit().getId())) continue;
            storageIDList.add(saleIssueBillColl.get(j).getStorageOrgUnit().getId());
        }
        int length = storageIDList.size();
        for (int k = 0; k < length; ++k) {
            consignBillInfo = new ConsignSaleBillInfo();
            storageID = storageIDList.get(k).toString();
            consignBillInfo.setBizDate(consignSaleBillInfo.getBizDate());
            consignBillInfo.setLastUpdateUser(consignSaleBillInfo.getLastUpdateUser());
            consignBillInfo.setYear(consignSaleBillInfo.getYear());
            consignBillInfo.setPeriod(consignSaleBillInfo.getPeriod());
            consignBillInfo.setNumber(consignSaleBillInfo.getNumber());
            int size2 = cosignSaleEntryColl.size();
            for (int i = 0; i < size2; ++i) {
                int j;
                consignEntryInfo = cosignSaleEntryColl.get(i);
                int count2 = saleIssueBillColl.size();
                for (j = 0; j < count2; ++j) {
                    saleIssueBillInfo = saleIssueBillColl.get(j);
                    if (!saleIssueBillInfo.getId().toString().equals(consignEntryInfo.getSourceBillMID()) || !storageID.equals(saleIssueBillInfo.getStorageOrgUnit().getId().toString())) continue;
                    consignEntryInfo.setCustomer(saleIssueBillInfo.getCustomer());
                    consignEntryInfo.setTransactionType(saleIssueBillInfo.getTransactionType());
                    consignEntryInfo.setBillNumber(saleIssueBillInfo.getNumber());
                    consignBillInfo.setStorageOrgUnit(saleIssueBillInfo.getStorageOrgUnit());
                }
                int entryCount = saleIssueEntryColl.size();
                for (j = 0; j < entryCount; ++j) {
                    saleIssueEntryInfo = saleIssueEntryColl.get(j);
                    if (!saleIssueEntryInfo.getId().toString().equals(consignEntryInfo.getSourceBillEntryMID()) || !storageID.equals(saleIssueEntryInfo.getStorageOrgUnit().getId().toString())) continue;
                    int amountPrecision = (Integer)consignEntryInfo.get("amountPrecision");
                    consignEntryInfo.setWriteOffPrice(saleIssueEntryInfo.getPrice());
                    consignEntryInfo.setWriteOffAmount(saleIssueEntryInfo.getPrice().multiply(consignEntryInfo.getWriteOffQty()).setScale(amountPrecision, 4));
                    consignEntryInfo.setSourceBillEntrySeq(saleIssueEntryInfo.getSaleOrderEntrySeq());
                    consignEntryInfo.setBillSeq(saleIssueEntryInfo.getSeq());
                    consignEntryInfo.setMaterial(saleIssueEntryInfo.getMaterial());
                    consignEntryInfo.setBaseUnit(saleIssueEntryInfo.getBaseUnit());
                    consignEntryInfo.setAssistProperty(saleIssueEntryInfo.getAssistProperty());
                    consignEntryInfo.setUnit(saleIssueEntryInfo.getUnit());
                    consignEntryInfo.setCoreBillNumber(saleIssueEntryInfo.getSaleOrderNumber());
                    consignEntryInfo.setSaleOrgUnit(saleIssueEntryInfo.getSaleOrgUnit());
                    consignEntryInfo.setCompanyOrgUnit(saleIssueEntryInfo.getCompanyOrgUnit());
                    consignEntryInfo.setLot(saleIssueEntryInfo.getLot());
                    consignEntryInfo.setIsPresent(saleIssueEntryInfo.isIsPresent());
                    consignBillInfo.getEntrys().add(consignEntryInfo);
                }
            }
            consignSaleColl.add((CoreBaseInfo)consignBillInfo);
        }
        return consignSaleColl;
    }

    private void insertConsignedData(Context ctx, List destBillList, CoreBaseCollection consignSaleColl) {
        ConsignSaleBillInfo consignSaleInfo = null;
        ConsignSaleBillEntryCollection consginEntryCollection = null;
        SaleIssueEntryInfo saleIssueEntryInfo = null;
        SaleIssueBillInfo saleIssueBillInfo = null;
        SaleIssueEntryCollection issueEntryCollection = null;
        ConsignSaleBillEntryInfo destConsignEntryInfo = null;
        ConsignSaleBillEntryInfo srcConsignEntryInfo = null;
        int count = consignSaleColl.size();
        for (int k = 0; k < count; ++k) {
            ConsignSaleBillEntryCollection newConsginEntryCollection = new ConsignSaleBillEntryCollection();
            consignSaleInfo = (ConsignSaleBillInfo)consignSaleColl.get(k);
            consginEntryCollection = consignSaleInfo.getEntrys();
            int size = destBillList.size();
            for (int j = 0; j < size; ++j) {
                saleIssueBillInfo = (SaleIssueBillInfo)destBillList.get(j);
                issueEntryCollection = saleIssueBillInfo.getEntry();
                int length = issueEntryCollection.size();
                for (int i = 0; i < length; ++i) {
                    saleIssueEntryInfo = issueEntryCollection.get(i);
                    if (saleIssueEntryInfo.getSourceBillEntryId() == null) continue;
                    int balSize = consginEntryCollection.size();
                    for (int bal = 0; bal < balSize; ++bal) {
                        srcConsignEntryInfo = consginEntryCollection.get(bal);
                        if (!saleIssueEntryInfo.getSourceBillEntryId().equals(srcConsignEntryInfo.getSourceBillEntryMID())) continue;
                        int amountPrecision = (Integer)srcConsignEntryInfo.get("amountPrecision");
                        destConsignEntryInfo = new ConsignSaleBillEntryInfo();
                        destConsignEntryInfo.setTransactionType(saleIssueBillInfo.getTransactionType());
                        destConsignEntryInfo.setSourceBillMID(saleIssueBillInfo.getId().toString());
                        destConsignEntryInfo.setWriteOffPrice(saleIssueEntryInfo.getPrice());
                        destConsignEntryInfo.setLot(saleIssueEntryInfo.getLot());
                        destConsignEntryInfo.setWriteOffAmount(saleIssueEntryInfo.getPrice().multiply(saleIssueEntryInfo.getQty()).setScale(amountPrecision, 4));
                        destConsignEntryInfo.setWriteOffQty(saleIssueEntryInfo.getQty());
                        destConsignEntryInfo.setIsPresent(saleIssueEntryInfo.isIsPresent());
                        destConsignEntryInfo.setSourceBillEntryMID(srcConsignEntryInfo.getSourceBillEntryMID());
                        destConsignEntryInfo.setSourceBillEntrySeq(srcConsignEntryInfo.getSourceBillEntrySeq());
                        destConsignEntryInfo.setBillSeq(saleIssueEntryInfo.getSeq());
                        destConsignEntryInfo.setMaterial(srcConsignEntryInfo.getMaterial());
                        destConsignEntryInfo.setBaseUnit(srcConsignEntryInfo.getBaseUnit());
                        destConsignEntryInfo.setAssistProperty(srcConsignEntryInfo.getAssistProperty());
                        destConsignEntryInfo.setCoreBillNumber(srcConsignEntryInfo.getCoreBillNumber());
                        destConsignEntryInfo.setUnit(srcConsignEntryInfo.getUnit());
                        destConsignEntryInfo.setCompanyOrgUnit(saleIssueEntryInfo.getCompanyOrgUnit());
                        destConsignEntryInfo.setSaleOrgUnit(srcConsignEntryInfo.getSaleOrgUnit());
                        destConsignEntryInfo.setCustomer(srcConsignEntryInfo.getCustomer());
                        destConsignEntryInfo.setBillNumber(saleIssueBillInfo.getNumber());
                        newConsginEntryCollection.add(destConsignEntryInfo);
                    }
                }
            }
            consignSaleInfo.getEntrys().addCollection(newConsginEntryCollection);
        }
    }

    @Override
    protected void _updateVerify(Context ctx, List list) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        Connection conn = null;
        Statement pstmt = null;
        int size = list.size();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < size; ++i) {
                sql.setLength(0);
                String[] array = new String[]{};
                if (list.get(i) instanceof Object[]) {
                    array = (String[])list.get(i);
                }
                sql.append(" update T_SD_ConsignSaleBillEntry ");
                sql.append(" set FSourceBillSID = ?, ");
                sql.append(" FSourceBillESID = ? ");
                sql.append(" where fid = ?");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, array[2]);
                pstmt.setString(2, array[3]);
                pstmt.setString(3, array[1]);
                pstmt.addBatch();
            }
            if (null != pstmt) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((ConsignSaleBillInfo)model).getStorageOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _chechData(Context ctx, List billIDList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        int size = billIDList.size();
        for (int i = 0; i < size; ++i) {
            String id = billIDList.get(i).toString();
            SelectorItemCollection siCollection = new SelectorItemCollection();
            siCollection.add("*");
            siCollection.add("transactionType.*");
            SaleIssueBillInfo info = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(id), siCollection);
            if (SCMBaseCommonUtil.isConsOutSaleIssueBill((BizTypeInfo)info.getBizType(), (TransactionTypeInfo)info.getTransactionType())) {
                if (!info.isFiVouchered()) continue;
                throw new ConsignSaleException(ConsignSaleException.SALEISSUE_BILL_HAS_VOUCHERED);
            }
            sql.setLength(0);
            sql.append("select fid from t_bot_relation where FDestEntityID = 'FC910EF3' and FSrcObjectID='").append(id).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rs.next()) continue;
                throw new ConsignSaleException(ConsignSaleException.SALEISSUE_BILL_HAS_OTHERBILL);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _unVerify(Context ctx, List billIDList, List verifyIDList) throws BOSException, EASBizException {
        if (billIDList != null && billIDList.size() > 0) {
            ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
            HashSet saleIssueIDSet = new HashSet();
            int size = billIDList.size();
            for (int i = 0; i < size; ++i) {
                saleIssueIDSet.add(billIDList.get(i));
            }
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("SRCOBJECTID", saleIssueIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("DESTENTITYID", (Object)"FC910EF3", CompareType.EQUALS));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("DESTOBJECTID"));
            BOTRelationCollection relationColl = iBOTRelation.getCollection(view);
            if (relationColl != null && relationColl.size() > 0) {
                throw new ConsignSaleException(ConsignSaleException.SALEISSUE_BILL_HAS_OTHERBILL);
            }
            iSaleIssueBill.deleteBillByUnSettle(saleIssueIDSet);
        }
        String isHaveReturnsSql = this.isConsignIssueReturns(ctx, verifyIDList);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)isHaveReturnsSql);
        ArrayList<String> returnsIDList = new ArrayList<String>();
        boolean isReturns = false;
        try {
            while (rowSet != null && rowSet.next()) {
                returnsIDList.add(rowSet.getString("FID"));
                isReturns = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        if (isReturns && returnsIDList.size() > 0) {
            String sign = "+";
            String unSign = "-";
            StringBuffer consignOql = new StringBuffer("");
            int length = returnsIDList.size();
            for (int count = 0; count < length; ++count) {
                if (count > 0) {
                    consignOql.append(",");
                }
                consignOql.append("'").append((String)returnsIDList.get(count)).append("'");
            }
            StringBuffer sql = new StringBuffer("");
            sql.append("update t_im_saleissueentry entry set (FTotalSettleQty,FTotalSettleBaseQty,FUnSettleQty,FUnSettleBaseQty) =");
            sql.append(" ( select issuentry.FTotalSettleQty ").append(unSign).append(" a.fwriteOffQty,");
            sql.append("issuentry.FTotalSettleBaseQty ").append(unSign).append(" round(decimal(fWriteOffBaseQty,21,8),MULTIBASEUNIT.FQtyPrecision),");
            sql.append("issuentry.FUnSettleQty").append(sign).append(" a.fwriteOffQty,");
            sql.append("issuentry.FUnSettleBaseQty").append(sign).append(" round(decimal(fWriteOffBaseQty,21,8),MULTIBASEUNIT.FQtyPrecision) from (");
            sql.append("select decimal(sum(fwriteOffQty),21,8) as fwriteOffQty,decimal(sum(FWriteOffBaseQty),21,8) as fWriteOffBaseQty, FSourceBillEMID as FEntryId from T_SD_ConsignSaleBillEntry where fparentid in ");
            sql.append("  (").append(consignOql.toString()).append(") ");
            sql.append("  group by FSourceBillEMID) as a ");
            sql.append(" inner join t_im_saleissueentry issuentry on issuentry.fid = a.FEntryId ");
            sql.append(" left join T_BD_MultiMeasureUnit MULTIUNIT on (MULTIUNIT.FMaterialID = issuentry.FMaterialID ");
            sql.append(" and issuentry.FUnitID = MULTIUNIT.FMeasureUnitID) ");
            sql.append(" left join T_BD_MultiMeasureUnit MULTIBASEUNIT on (MULTIBASEUNIT.FMaterialID = issuentry.FMaterialID ");
            sql.append(" and issuentry.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID) ");
            sql.append(" where issuentry.fid = entry.fid ) ");
            sql.append(" where entry.fid in ( select FSourceBillEMID from T_SD_ConsignSaleBillEntry ");
            sql.append(" where fparentid in (").append(consignOql.toString()).append(")) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        StringBuffer idBuf = new StringBuffer("(");
        int size = verifyIDList.size();
        for (int i = 0; i < size; ++i) {
            String id = verifyIDList.get(i).toString();
            idBuf.append("'").append(id);
            if (i < size - 1) {
                idBuf.append("',");
                continue;
            }
            idBuf.append("'");
        }
        idBuf.append(")");
        if (idBuf.toString().length() > 10) {
            StringBuffer sql = new StringBuffer("");
            sql.append(" delete T_SD_ConsignSaleBillEntry where fparentid in ").append(idBuf.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete T_SD_ConsignSaleBill where fid in ").append(idBuf.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected List _getSaleIssueBillList(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer consignOql = new StringBuffer("");
        int length = ids.length;
        for (int count = 0; count < length; ++count) {
            if (count > 0) {
                consignOql.append(",");
            }
            consignOql.append("'").append(ids[count]).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select issue.fid as fid from t_im_saleissuebill issue ");
        sql.append(" inner join t_im_saleissueentry ise on ise.fparentid = issue.fid ");
        sql.append(" where issue.fid in (");
        sql.append("   select consign.fsourceBillMID from t_sd_consignsalebillentry consign ");
        sql.append("    where consign.fparentid in (").append(consignOql.toString()).append(")");
        sql.append(") and issue.ftransactiontypeid in (");
        sql.append("   select trans.fid from t_scm_transactiontype trans where trans.FRITypeID = ");
        sql.append("'").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("'");
        sql.append(") and issue.fbiztypeid = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> idList = new ArrayList<String>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    idList.add(rowSet.getString("fid"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return idList;
    }

    protected String isConsignIssueReturns(Context ctx, List verifyIDList) throws BOSException, EASBizException {
        StringBuffer consignOql = new StringBuffer("");
        int length = verifyIDList.size();
        for (int count = 0; count < length; ++count) {
            if (count > 0) {
                consignOql.append(",");
            }
            consignOql.append("'").append(verifyIDList.get(count)).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct a.fid as FID from t_sd_consignsalebill a ");
        sql.append(" inner join t_sd_consignsalebillentry b on a.fid = b.fparentid ");
        sql.append(" inner join t_im_saleissuebill issue on b.fsourceBillMID = issue.fid ");
        sql.append(" where a.fid in (").append(consignOql.toString()).append(") ");
        sql.append(" and issue.ftransactiontypeid in (");
        sql.append("   select trans.fid from t_scm_transactiontype trans where trans.FRITypeID = ");
        sql.append("'").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("')");
        return sql.toString();
    }
}

