/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.sd.sale.CheckedStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustCollection;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustEntryCollection;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustEntryInfo;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustFactory;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustInfo;
import com.kingdee.eas.scm.sd.sale.MaterialPriceAdjustException;
import com.kingdee.eas.scm.sd.sale.app.AbstractMaterialBasePriceAdjustControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class MaterialBasePriceAdjustControllerBean
extends AbstractMaterialBasePriceAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.MaterialBasePriceAdjustControllerBean");

    @Override
    protected void _submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        MaterialBasePriceAdjustEntryCollection coll = materialBasePriceAdjustInfo.getEntries();
        if (coll.size() < 1) {
            throw new MaterialPriceAdjustException(MaterialPriceAdjustException.ENTRY_CANNOT_EMPTY);
        }
        materialBasePriceAdjustInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        materialBasePriceAdjustInfo.setBizDate(new Date());
        IObjectPK pk = super._submit(ctx, (IObjectValue)materialBasePriceAdjustInfo);
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        this.removeEmptyEntry((IObjectValue)materialBasePriceAdjustInfo, "");
        materialBasePriceAdjustInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        super._submit(ctx, pk, (IObjectValue)materialBasePriceAdjustInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        materialBasePriceAdjustInfo.setBizDate(new Date());
        return super._save(ctx, (IObjectValue)materialBasePriceAdjustInfo);
    }

    @Override
    protected void _batchSubmit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(pk.toString())};
        this._batchAudit(ctx, (IObjectPK[])pks);
    }

    @Override
    protected void _batchAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < pks.length; ++i) {
            idList.add(pks[i].toString());
        }
        IMutexServiceControl iMutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMutexService.batchRequestObjIDForUpdate(idList);
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            String params = this.convertToString(pks);
            StringBuffer sb = new StringBuffer(1024);
            sb.append("select FNumber from T_SD_BasePriceAdjust where FID in(").append(params).append(") and FBaseStatus<>2");
            rs = statement.executeQuery(sb.toString());
            if (rs.next() && rs.getString(1) != null) {
                throw new MaterialPriceAdjustException(MaterialPriceAdjustException.NOSUBMITED_CANNOTAUDIT);
            }
            String updateSql = "update T_SD_BasePriceAdjust set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = getDate() where fid in(" + params.toString() + ")";
            batchStatement.addBatch(updateSql);
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                iMutexService.batchReleaseObjIDForUpdate(idList);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        iMutexService.batchReleaseObjIDForUpdate(idList);
        for (int i = 0; i < pks.length; ++i) {
            this.wirteToMaterialPriceInfo(ctx, pks[i]);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.removeEmptyEntry(model);
        return super._addnew(ctx, model);
    }

    private void removeEmptyEntry(IObjectValue model, String type) {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        int rowCount = materialBasePriceAdjustInfo.getEntries().size();
        MaterialBasePriceAdjustEntryCollection coll = materialBasePriceAdjustInfo.getEntries();
        if (rowCount > 0) {
            for (int i = 0; i < materialBasePriceAdjustInfo.getEntries().size(); ++i) {
                MaterialBasePriceAdjustEntryInfo entryInfo = coll.get(i);
                if (this.checkEntryCanSubmit(entryInfo)) continue;
                coll.remove(entryInfo);
                entryInfo.setParent(null);
                this.removeEmptyEntry(model, type);
                break;
            }
        }
    }

    private void removeEmptyEntry(IObjectValue model) {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        int rowCount = materialBasePriceAdjustInfo.getEntries().size();
        MaterialBasePriceAdjustEntryCollection coll = materialBasePriceAdjustInfo.getEntries();
        if (rowCount > 0) {
            for (int i = 0; i < materialBasePriceAdjustInfo.getEntries().size(); ++i) {
                MaterialBasePriceAdjustEntryInfo entryInfo = coll.get(i);
                if (this.checkEntryCanSave(entryInfo)) continue;
                coll.remove(entryInfo);
                entryInfo.setParent(null);
                this.removeEmptyEntry(model);
                break;
            }
        }
    }

    private boolean checkEntryCanSubmit(MaterialBasePriceAdjustEntryInfo entryInfo) {
        if (entryInfo == null || entryInfo.getMaterial() == null) {
            return false;
        }
        return entryInfo.getNewEffectDate() != null || entryInfo.getNewExpDate() != null || entryInfo.getNewHighestPrice() != null || entryInfo.getNewLowestPrice() != null || entryInfo.getNewPrice() != null;
    }

    private boolean checkEntryCanSave(MaterialBasePriceAdjustEntryInfo entryInfo) {
        return entryInfo != null && entryInfo.getMaterial() != null;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.removeEmptyEntry(model);
        super._update(ctx, pk, model);
    }

    @Override
    public IObjectPK addnew(Context ctx, MaterialBasePriceAdjustInfo model) throws BOSException, EASBizException {
        int rowCount = model.getEntries().size();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                MaterialBasePriceAdjustEntryInfo entryInfo = model.getEntries().get(i);
                if (entryInfo != null) continue;
                model.getEntries().removeObject(i);
            }
        }
        return super.addnew(ctx, model);
    }

    @Override
    public void update(Context ctx, IObjectPK pk, MaterialBasePriceAdjustInfo model) throws BOSException, EASBizException {
        super.update(ctx, pk, model);
    }

    @Override
    public void submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.submit(ctx, pk);
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = (MaterialBasePriceAdjustInfo)model;
        MaterialBasePriceAdjustEntryCollection coll = materialBasePriceAdjustInfo.getEntries();
        if (coll.size() < 1) {
            throw new MaterialPriceAdjustException(MaterialPriceAdjustException.ENTRY_CANNOT_EMPTY);
        }
        if (materialBasePriceAdjustInfo.getId() == null) {
            materialBasePriceAdjustInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            this._addnew(ctx, (IObjectValue)materialBasePriceAdjustInfo);
            pk = new ObjectUuidPK(materialBasePriceAdjustInfo.getId());
        }
        super.submit(ctx, pk, (CoreBaseInfo)materialBasePriceAdjustInfo);
    }

    private void wirteToMaterialPriceInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRowSet rs = null;
        try {
            MaterialBasePriceAdjustInfo mbpaInfo = (MaterialBasePriceAdjustInfo)this.getValue(ctx, pk);
            MaterialBasePriceAdjustEntryCollection coll = mbpaInfo.getEntries();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                UserInfo user;
                MaterialBasePriceAdjustEntryInfo mbpaEntryInfo = coll.get(i);
                StringBuffer sb = new StringBuffer(1024);
                sb.append("select FID from T_SD_MaterialBasePrice where 1=1 ");
                sb.append(" and FMaterialID = '" + mbpaEntryInfo.getMaterial().getId().toString()).append("'");
                sb.append(" and FCurrencyID = '" + mbpaEntryInfo.getCurrency().getId().toString()).append("'");
                sb.append(" and FUnitID = '" + mbpaEntryInfo.getUnit().getId().toString()).append("'");
                sb.append(" and FPriceTypeID = '" + mbpaEntryInfo.getPriceType().getId().toString()).append("'");
                PriceTypeInfo ptInfo = PriceTypeFactory.getLocalInstance((Context)ctx).getPriceTypeInfo((IObjectPK)new ObjectUuidPK(mbpaEntryInfo.getPriceType().getId()));
                if ("04".equals(ptInfo.getNumber())) {
                    sb.append(" and FChannelTypeID = '" + mbpaEntryInfo.getChannelType().getId().toString()).append("'");
                }
                if (mbpaEntryInfo.getAssistProperty() != null && mbpaEntryInfo.getAssistProperty().getId() != null) {
                    sb.append(" and FAssistPropertyID = '" + mbpaEntryInfo.getAssistProperty().getId().toString()).append("'");
                }
                if (mbpaInfo.getCU() != null) {
                    sb.append(" and FControlUnitID = '" + mbpaInfo.getCU().getId().toString() + "'");
                }
                sb.append(" order by FPriority asc");
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next() && rs.getString(1) != null) {
                    String id = rs.getString(1);
                    MaterialBasePriceInfo materialBasePriceInfo = MaterialBasePriceFactory.getLocalInstance((Context)ctx).getMaterialBasePriceInfo((IObjectPK)new ObjectUuidPK(id));
                    materialBasePriceInfo.setPrice(mbpaEntryInfo.getNewPrice());
                    materialBasePriceInfo.setMaxPrice(mbpaEntryInfo.getNewHighestPrice());
                    materialBasePriceInfo.setFloorPrice(mbpaEntryInfo.getNewLowestPrice());
                    materialBasePriceInfo.setEffectiveDate(mbpaEntryInfo.getNewEffectDate());
                    materialBasePriceInfo.setExpireDate(mbpaEntryInfo.getNewExpDate());
                    materialBasePriceInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                    materialBasePriceInfo.setCheckedFlag(true);
                    user = (UserInfo)ctx.get((Object)"UserInfo");
                    materialBasePriceInfo.setAuditor(user);
                    materialBasePriceInfo.setAuditDate(new Date());
                    materialBasePriceInfo.setCU(mbpaInfo.getCU());
                    materialBasePriceInfo.setAdminCU(mbpaInfo.getCU());
                    if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null || !ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString().equals(mbpaInfo.getCU().getId().toString())) {
                        ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)mbpaInfo.getCU());
                    }
                    MaterialBasePriceFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(materialBasePriceInfo.getId().toString()), (CoreBaseInfo)materialBasePriceInfo);
                    continue;
                }
                MaterialBasePriceInfo materialBasePriceInfo = new MaterialBasePriceInfo();
                materialBasePriceInfo.setAdminCU(mbpaInfo.getCU());
                materialBasePriceInfo.setCU(mbpaInfo.getCU());
                materialBasePriceInfo.setPriceType(mbpaEntryInfo.getPriceType());
                PriceTypeInfo priceTypeInfo = (PriceTypeInfo)PriceTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(mbpaEntryInfo.getPriceType().getId().toString()));
                materialBasePriceInfo.setPriority(priceTypeInfo.getPriority());
                materialBasePriceInfo.setChannelType(mbpaEntryInfo.getChannelType());
                materialBasePriceInfo.setMaterial(mbpaEntryInfo.getMaterial());
                materialBasePriceInfo.setAssistProperty(mbpaEntryInfo.getAssistProperty());
                materialBasePriceInfo.setUnit(mbpaEntryInfo.getUnit());
                materialBasePriceInfo.setCurrency(mbpaEntryInfo.getCurrency());
                materialBasePriceInfo.setPrice(mbpaEntryInfo.getNewPrice());
                materialBasePriceInfo.setMaxPrice(mbpaEntryInfo.getNewHighestPrice());
                materialBasePriceInfo.setFloorPrice(mbpaEntryInfo.getNewLowestPrice());
                user = (UserInfo)ctx.get((Object)"UserInfo");
                materialBasePriceInfo.setAuditor(user);
                materialBasePriceInfo.setAuditDate(new Date(System.currentTimeMillis()));
                materialBasePriceInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                materialBasePriceInfo.setCheckedFlag(true);
                materialBasePriceInfo.setCreateTime(new Timestamp(new Date().getTime()));
                materialBasePriceInfo.setCreator(mbpaInfo.getCreator());
                materialBasePriceInfo.setCU(mbpaInfo.getCU());
                MaterialBasePriceFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)materialBasePriceInfo);
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._delete(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.checkCanDelete(ctx, arrayPK);
        StringBuffer ids = new StringBuffer();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < arrayPK.length; ++i) {
            idList.add(arrayPK[i].toString());
            if (i > 0) {
                ids.append(",");
            }
            ids.append(arrayPK[i].toString());
        }
        IMutexServiceControl iMutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMutexService.batchRequestObjIDForUpdate(idList);
        Connection con = null;
        Statement batchStatement = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            viewInfo.setSelector(sic);
            MaterialBasePriceAdjustCollection mbpaCol = MaterialBasePriceAdjustFactory.getLocalInstance(ctx).getMaterialBasePriceAdjustCollection(viewInfo);
            if (mbpaCol != null) {
                int size = mbpaCol.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.isAutoNum()) continue;
                    this.rolbackNumber(ctx, (IObjectValue)mbpaCol.get(i));
                }
            }
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            StringBuffer sb = new StringBuffer(1024);
            String params = this.convertToString(arrayPK);
            sb.append(" delete from T_SD_BasePriceAdjustEntry where FParentID in (").append(params).append(")");
            batchStatement.addBatch(sb.toString());
            sb.delete(0, sb.length());
            sb.append(" delete from T_SD_BasePriceAdjust where FID in (").append(params).append(")");
            batchStatement.addBatch(sb.toString());
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                iMutexService.batchReleaseObjIDForUpdate(idList);
                SQLUtils.cleanup(batchStatement, con);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        iMutexService.batchReleaseObjIDForUpdate(idList);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void checkCanDelete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String params = this.convertToString(arrayPK);
            StringBuffer sb = new StringBuffer(1024);
            sb.append("select FNumber from T_SD_BasePriceAdjust where FID in(").append(params).append(") and FBaseStatus = 4 ");
            rs = statement.executeQuery(sb.toString());
            if (rs.next() && rs.getString(1) != null) {
                throw new MaterialPriceAdjustException(MaterialPriceAdjustException.AUDIT_CAN_NOT_DELETE);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }
}

