/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.IDeliveryType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BillRelationOptionEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.ITransferOrderBillEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.reservation.impl.ReservationBillUnAuditCheckImpl;
import com.kingdee.eas.scm.im.reservation.service.BillAutoReservationService;
import com.kingdee.eas.scm.im.reservation.service.BillReservationCancelService;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.scm.sd.sale.IPostRequisitionEntry;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractPostRequisitionControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PostRequisitionControllerBean
extends AbstractPostRequisitionControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.PostRequisitionControllerBean");
    private final String res = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private Map<String, BigDecimal> soBaseQtyMap = null;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    private boolean checkReverse(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        PostRequisitionInfo srcPostRequisitionInfo = null;
        if (postRequisitionInfo.getSourceBillType() != null && postRequisitionInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") && postRequisitionInfo.getSourceBillId() != null && (srcPostRequisitionInfo = this.getPostRequisitionInfo(ctx, "select baseStatus where id='" + postRequisitionInfo.getSourceBillId() + "'")).getBaseStatus() != null && srcPostRequisitionInfo.getBaseStatus().getValue() != 4) {
            throw new PostRequisitionException(PostRequisitionException.ORDER_CANNOT_REVERSE);
        }
        PostRequisitionEntryCollection preCollection = postRequisitionInfo.getEntries();
        PostRequisitionEntryInfo prEntryInfo = null;
        PostRequisitionEntryInfo srcPREntryInfo = null;
        SaleOrderEntryInfo srcSOEntryInfo = null;
        SaleContractEntryInfo srcSCEntryInfo = null;
        IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getLocalInstance(ctx);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getLocalInstance(ctx);
        HashSet<String> postBillEID = new HashSet<String>();
        int num = preCollection.size();
        for (int i = 0; i < num; ++i) {
            prEntryInfo = preCollection.get(i);
            if (prEntryInfo.getSourceBillType() == null || !prEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") || prEntryInfo.getSourceBillEntryId() == null) continue;
            postBillEID.add(prEntryInfo.getSourceBillEntryId());
        }
        PostRequisitionEntryCollection postEColl = null;
        SaleOrderEntryCollection saleOrderEColl = null;
        if (postBillEID.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("baseStatus"));
            view.getSelector().add(new SelectorItemInfo("sourceBillType.id"));
            view.getSelector().add(new SelectorItemInfo("sourceBillEntryId"));
            view.getSelector().add(new SelectorItemInfo("qty"));
            view.getSelector().add(new SelectorItemInfo("totalReversedQty"));
            view.getSelector().add(new SelectorItemInfo("shippedQty"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", postBillEID, CompareType.INCLUDE));
            view.setFilter(filter);
            postEColl = iPostRequisitionEntry.getPostRequisitionEntryCollection(view);
            HashSet<String> soBillEID = new HashSet<String>();
            int size = postEColl.size();
            for (int i = 0; i < size; ++i) {
                srcPREntryInfo = postEColl.get(i);
                if (srcPREntryInfo.getSourceBillType() == null || !srcPREntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") || srcPREntryInfo.getSourceBillEntryId() == null) continue;
                soBillEID.add(srcPREntryInfo.getSourceBillEntryId());
            }
            if (soBillEID.size() > 0) {
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("baseStatus"));
                view.getSelector().add(new SelectorItemInfo("isLocked"));
                view.getSelector().add(new SelectorItemInfo("sourceBillType.id"));
                view.getSelector().add(new SelectorItemInfo("sourceBillEntryId"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", soBillEID, CompareType.INCLUDE));
                view.setFilter(filter);
                saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            }
        }
        int num2 = preCollection.size();
        for (int i = 0; i < num2; ++i) {
            prEntryInfo = preCollection.get(i);
            if (prEntryInfo.getSourceBillType() == null || !prEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552") || prEntryInfo.getSourceBillEntryId() == null || postEColl == null) continue;
            int size = postEColl.size();
            for (int j = 0; j < size; ++j) {
                srcPREntryInfo = postEColl.get(j);
                if (!srcPREntryInfo.getId().toString().equals(prEntryInfo.getSourceBillEntryId())) continue;
                if (srcPREntryInfo.getBaseStatus() != null && srcPREntryInfo.getBaseStatus().getValue() != 4) {
                    throw new PostRequisitionException(PostRequisitionException.POST_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                }
                if (srcPREntryInfo.getSourceBillType() != null && srcPREntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") && srcPREntryInfo.getSourceBillEntryId() != null && saleOrderEColl != null) {
                    int count = saleOrderEColl.size();
                    for (int k = 0; k < count; ++k) {
                        EntryBaseStatusEnum srcSCEntryBaseStatus;
                        srcSOEntryInfo = saleOrderEColl.get(k);
                        if (!srcSOEntryInfo.getId().toString().equals(srcPREntryInfo.getSourceBillEntryId())) continue;
                        EntryBaseStatusEnum srcSOEntryBaseStatus = srcSOEntryInfo.getBaseStatus();
                        if (srcSOEntryInfo != null && srcSOEntryBaseStatus.getValue() != 4) {
                            throw new PostRequisitionException(PostRequisitionException.ORDER_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                        }
                        if (srcSOEntryInfo.isIsLocked()) {
                            throw new PostRequisitionException(PostRequisitionException.ORDER_SRC_ENTRY_LOCKED_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                        }
                        if (srcSOEntryInfo.getSourceBillType() == null || !srcSOEntryInfo.getSourceBillType().getId().toString().equals("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=") || srcSOEntryInfo.getSourceBillEntryId() == null || (srcSCEntryBaseStatus = (srcSCEntryInfo = iSaleContractEntry.getSaleContractEntryInfo((IObjectPK)new ObjectUuidPK(srcSOEntryInfo.getSourceBillEntryId()))).getBaseStatus()) == null || srcSCEntryBaseStatus.getValue() == 4 || srcSCEntryBaseStatus.getValue() == 7) continue;
                        throw new OrderException(OrderException.CANTRACT_SRC_ENTRY_CANNOT_REVERSE, new String[]{String.valueOf(i + 1)});
                    }
                }
                BigDecimal reverseQty = SCMUtils.effectualNumeric((BigDecimal)prEntryInfo.getQty()).abs();
                BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getQty());
                BigDecimal totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getTotalReversedQty());
                BigDecimal shippedQty = SCMUtils.effectualNumeric((BigDecimal)srcPREntryInfo.getShippedQty());
                BigDecimal availReverseQty = qty.subtract(totalReversedQty).subtract(shippedQty);
                if (reverseQty.compareTo(availReverseQty) <= 0) continue;
                throw new SCMBillException(SCMBillException.REVERSE_QTY_TOO_BIG, (Object[])new String[]{String.valueOf(i + 1)});
            }
        }
        return true;
    }

    private boolean checkReverse(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        boolean result = true;
        if (pks != null) {
            PostRequisitionInfo postRequisitionInfo = null;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("sourceBillType.id"));
            selector.add(new SelectorItemInfo("sourceBillId"));
            selector.add(new SelectorItemInfo("entries.sourceBillEntryId"));
            selector.add(new SelectorItemInfo("entries.sourceBillType.id"));
            selector.add(new SelectorItemInfo("entries.qty"));
            int count = pks.length;
            for (int i = 0; i < count && (pks[i] == null || (result = this.checkReverse(ctx, (IObjectValue)(postRequisitionInfo = this.getPostRequisitionInfo(ctx, pks[i], selector))))); ++i) {
            }
        }
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("baseStatus"));
        sc.add(new SelectorItemInfo("number"));
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)super._getValue(ctx, pk, sc);
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PostRequisitionException(PostRequisitionException.REVOKE_NOTDELETE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PostRequisitionException(PostRequisitionException.AUDIT_NOTDELETE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.BLOCK_NOTDELETE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.DELETE);
        }
        try {
            BillReservationCancelService service = BillReservationCancelService.getInstance();
            service.doBillReservationCancel(ctx, this._getValue(ctx, pk));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks, IObjectPK reasonCodePK) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.cancelBill(ctx, pks, reasonCodePK.toString());
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks, String reason) throws BOSException, EASBizException {
        this.cancelBill(ctx, pks, reason);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._cancel(ctx, new IObjectPK[]{pk}, reason);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        Map<String, PostRequisitionInfo> prMap = this.getPostRequisitionMap(ctx, pks, sic);
        PostRequisitionInfo saleInfo = null;
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            saleInfo = prMap.get(pks[j].toString());
            if (saleInfo == null) {
                saleInfo = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionInfo(pks[j], sic);
            }
            this.isSamePerson4Audit(ctx, saleInfo);
        }
        Set hasBizFlowValueIDs = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)"t_sd_postrequisitionentry", (IObjectPK[])pks);
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        IRowSet rset = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            String params = this.convertToString(pks);
            this.doAuditCheck(ctx, pks, hasBizFlowValueIDs);
            String updateSql = "update T_SD_PostRequisition set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = ? where fid in(" + params.toString() + ")";
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 4 where FParentID in(" + params.toString() + ")";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
            DbUtil.execute((Context)ctx, (String)updateEntrySql);
            ArrayList<ObjectUuidPK> arrayList1 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> arrayList2 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> fsourcebillidList = new ArrayList<ObjectUuidPK>();
            rset = DbUtil.executeQuery((Context)ctx, (String)("select FID, FISREVERSE,FSOURCEBILLID from T_SD_PostRequisition where fid in(" + params.toString() + ")"));
            while (rset.next()) {
                String fid = rset.getString("FID");
                String fsourcebillid = rset.getString("FSOURCEBILLID");
                boolean fisreverse = rset.getBoolean("FISREVERSE");
                if (!fisreverse) {
                    arrayList1.add(new ObjectUuidPK(fid));
                    continue;
                }
                arrayList2.add(new ObjectUuidPK(fid));
                fsourcebillidList.add(new ObjectUuidPK(fsourcebillid));
            }
            IObjectPK[] pks1 = arrayList1.toArray(new IObjectPK[arrayList1.size()]);
            Object[] pks2 = arrayList2.toArray(new IObjectPK[arrayList2.size()]);
            IObjectPK[] fsourcebillPKS = fsourcebillidList.toArray(new IObjectPK[fsourcebillidList.size()]);
            if (pks1.length > 0) {
                this._writeSourceBill(ctx, pks1, "+", prMap, hasBizFlowValueIDs);
            }
            if (pks2.length > 0) {
                this.checkReverse(ctx, (IObjectPK[])pks2);
                this.writeSourceBillByReverse(ctx, this.convertToString(pks2));
                this.updateSourceBillStatus(ctx, fsourcebillPKS);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.AUDIT);
        WriteBackNetOrderHandleFactory.headHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.AUDIT, (IObjectPK[])pks);
        WriteBackNetOrderHandleFactory.headHandleB2C((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.AUDIT, (IObjectPK[])pks);
        HashSet<String> idSet = new HashSet<String>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(pks[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PostRequisitionCollection billCollection = this.getPostRequisitionCollection(ctx, view);
        BillAutoReservationService autoReservationService = BillAutoReservationService.getInstance();
        List list = autoReservationService.doBillAutoReservation(ctx, (IObjectCollection)billCollection);
        ctx.put((Object)"CTX_BATCHACTION", (Object)list);
    }

    private void updateSourceBillStatus(Context ctx, IObjectPK[] pks) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 7 where FParentID in(" + this.convertToString(pks).toString() + ") and fbaseqty - (FTotalReversedBaseQty + fshippedbaseqty) <= 0 ";
            statement.executeUpdate(updateEntrySql);
            String updateSql = " update T_SD_PostRequisition set FBaseStatus = 7 where fid in ( " + this.convertToString(pks).toString() + ") and not exists(select * from t_sd_postrequisitionentry where fbasestatus <> 7 and fparentid =T_SD_PostRequisition.fid ) ";
            statement.executeUpdate(updateSql);
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    protected void _isAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
    }

    private void doAuditCheck(Context ctx, IObjectPK[] pks, Set hasBizFlowValueIDs) throws BOSException, EASBizException {
        StringBuffer sqlSB = new StringBuffer(1024);
        String sql = null;
        IRowSet rs = null;
        String params = this.convertToString(pks);
        try {
            sqlSB.append("select FNumber from T_SD_PostRequisition where FID in(").append(params).append(") and FBaseStatus<>2");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getString(1) != null) {
                throw new PostRequisitionException(PostRequisitionException.NOSUBMITED_CANNOTAUDIT);
            }
            sqlSB.delete(0, sqlSB.length());
            sqlSB.append("select pr.FNumber from T_SD_PostRequisition pr");
            sqlSB.append(" inner join T_SD_PostRequisitionEntry pre on pre.FParentID = pr.FID");
            sqlSB.append(" where pr.FID in(").append(params).append(")");
            sqlSB.append(" and pr.FIsReverse=0 and (pre.FSourceBillEntryID is null or len(pre.FSourceBillEntryID)=0)");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && rs.getString(1) != null) {
                throw new PostRequisitionException(PostRequisitionException.ERROR_NOTRELATECREATE);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (hasBizFlowValueIDs.contains(pks[i].toString())) continue;
            ids.add(pks[i]);
        }
        if (ids.size() > 0) {
            params = SCMServerUtils.getInStringFromSet(ids);
            this.isAudit(ctx, params);
        }
    }

    private void isAudit(Context ctx, String params) throws BOSException, EASBizException {
        StringBuffer sqlSB = new StringBuffer(1024);
        String sql = null;
        IRowSet rs = null;
        IRowSet rs2 = null;
        try {
            sqlSB.append("select pre.FSourceBillTypeID, pre.FSourceBillEntryID, pr.FNumber, pre.FSeq, pre.FQty, mmu.FQtyPrecision,pre.FUnitID");
            sqlSB.append(" from T_SD_PostRequisition pr");
            sqlSB.append(" inner join T_SD_PostRequisitionEntry pre on pre.FParentID = pr.FID");
            sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = pre.FMaterialID and mmu.FMeasureUnitID = pre.FUnitID");
            sqlSB.append(" where pr.FID in(").append(params).append(")");
            sqlSB.append(" and pr.FIsReverse=0 and (pre.FSourceBillEntryID is not null and len(pre.FSourceBillEntryID)>0)");
            sqlSB.append(" order by pre.FSeq,pre.FSourceBillEntryID");
            sql = sqlSB.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean isQtyUnCtrl = true;
            BigDecimal availQty = SysConstant.BIGZERO;
            BigDecimal totalQty = SysConstant.BIGZERO;
            HashMap<String, BigDecimal> totalQtyMap = new HashMap<String, BigDecimal>();
            HashMap<String, String> postNumberMap = new HashMap<String, String>();
            HashMap<String, String> postSeqMap = new HashMap<String, String>();
            StringBuffer soEntryIDs = new StringBuffer("");
            StringBuffer toEntryIDs = new StringBuffer("");
            String sourceBillTypeID = null;
            String sourceBillEntryID = null;
            String number = null;
            int seq = 0;
            BigDecimal qty = null;
            int qtyPrecision = 0;
            StringBuffer multiUnitIDs = new StringBuffer("");
            while (rs.next()) {
                BigDecimal overQty;
                String soEID;
                sourceBillTypeID = rs.getString(1);
                sourceBillEntryID = rs.getString(2);
                number = rs.getString(3);
                seq = rs.getInt(4);
                qty = rs.getBigDecimal(5);
                qtyPrecision = rs.getInt(6);
                postNumberMap.put(sourceBillEntryID, number);
                postSeqMap.put(sourceBillEntryID, String.valueOf(seq));
                if (totalQtyMap.containsKey(sourceBillEntryID)) {
                    totalQty = ((BigDecimal)totalQtyMap.get(sourceBillEntryID)).add(qty);
                    totalQtyMap.put(sourceBillEntryID, totalQty);
                } else {
                    if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID)) {
                        soEntryIDs.append("'").append(sourceBillEntryID).append("',");
                    } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sourceBillTypeID)) {
                        toEntryIDs.append("'").append(sourceBillEntryID).append("',");
                    }
                    totalQtyMap.put(sourceBillEntryID, qty);
                }
                if (rs.getString(7) != null) {
                    multiUnitIDs.append("'").append(rs.getString(7)).append("',");
                }
                if (soEntryIDs.length() > 0) {
                    soEntryIDs = soEntryIDs.deleteCharAt(soEntryIDs.length() - 1);
                    sqlSB.setLength(0);
                    sqlSB.append("select soe.FID, soe.FQuantityUnCtrl, mmu.FQtyPrecision, ");
                    sqlSB.append(" to_decimal(to_decimal(to_decimal(soe.FQty,21,8)*(100.000000+ISNULL(soe.FSendOverRate,0.0000)),21,8)/100,21,8)-to_decimal(soe.FTotalReversedQty,21,8)+to_decimal(soe.FTotalSupplyStockQty,21,8)-to_decimal(soe.FTotalShippingQty,21,8)  availQty");
                    sqlSB.append(" from T_SD_SaleOrderEntry soe");
                    sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = soe.FMaterialID and mmu.FMeasureUnitID = soe.FUnitID");
                    sqlSB.append(" where soe.FID in (").append(soEntryIDs).append(")");
                    if (multiUnitIDs.length() > 0) {
                        multiUnitIDs = multiUnitIDs.deleteCharAt(multiUnitIDs.length() - 1);
                        sqlSB.append(" and mmu.FMeasureUnitID in (").append(multiUnitIDs).append(")");
                    }
                    sqlSB.append(" order by soe.fseq asc ");
                    sql = sqlSB.toString();
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                    soEID = null;
                    overQty = null;
                    while (rs2.next()) {
                        soEID = rs2.getString(1);
                        if (soEID == null) continue;
                        isQtyUnCtrl = rs2.getBoolean(2);
                        qtyPrecision = rs2.getInt(3);
                        availQty = rs2.getBigDecimal(4);
                        if (isQtyUnCtrl || (totalQty = (BigDecimal)totalQtyMap.get(soEID)).compareTo(availQty) <= 0) continue;
                        overQty = totalQty.subtract(availQty);
                        overQty = overQty.setScale(qtyPrecision, 4);
                        throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH, new String[]{postNumberMap.get(soEID).toString(), postSeqMap.get(soEID).toString(), SCMServerUtils.formatNumberMultiLang((Context)ctx, (BigDecimal)overQty)});
                    }
                }
                if (toEntryIDs.length() <= 0) continue;
                toEntryIDs = toEntryIDs.deleteCharAt(toEntryIDs.length() - 1);
                sqlSB.setLength(0);
                sqlSB.append("select toe.FID, toe.FNotControlQty, mmu.FQtyPrecision,");
                sqlSB.append(" round(toe.FQty*((100.000000+ISNULL(toe.FQtyOverRate,0.0000))/100),mmu.FQtyPrecision)-toe.FTotalIssueQty availQty");
                sqlSB.append(" from T_IM_TransferOrderBillEntry toe");
                sqlSB.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = toe.FMaterialID and mmu.FMeasureUnitID = toe.FUnitID");
                sqlSB.append(" where toe.FID in (").append(toEntryIDs).append(")");
                if (multiUnitIDs.length() > 0) {
                    multiUnitIDs = multiUnitIDs.deleteCharAt(multiUnitIDs.length() - 1);
                    sqlSB.append(" and mmu.FMeasureUnitID in (").append(multiUnitIDs).append(")");
                }
                sqlSB.append(" order by toe.fseq asc ");
                sql = sqlSB.toString();
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                soEID = null;
                overQty = null;
                while (rs2.next()) {
                    soEID = rs2.getString(1);
                    if (soEID == null) continue;
                    isQtyUnCtrl = rs2.getBoolean(2);
                    qtyPrecision = rs2.getInt(3);
                    availQty = rs2.getBigDecimal(4);
                    if (isQtyUnCtrl || (totalQty = (BigDecimal)totalQtyMap.get(soEID)).compareTo(availQty) <= 0) continue;
                    overQty = totalQty.subtract(availQty);
                    overQty = overQty.setScale(qtyPrecision, 4);
                    throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH, new String[]{postNumberMap.get(soEID).toString(), postSeqMap.get(soEID).toString(), SCMServerUtils.formatNumberMultiLang((Context)ctx, (BigDecimal)overQty)});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
    }

    private void isReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            String selectSql = new StringBuffer().append("select pre.FID, pre.FSeq, pr.FNumber ").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisition pr on pr.FID = pre.FParentID ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" inner join T_SD_SaleOrderEntry soe on soe.FID = pre2.FSourceBillEntryId ").append(" where pre.FParentID in(").append(params).append(") ").append(" and pr.FIsReverse = 1 and soe.FQuantityUnCtrl = 0 and (soe.FQty - soe.FTotalReversedQty) * decimal(100.00+ISNULL(soe.FSendOverRate,0))/100.00 - soe.FTotalShippingQty < (0 - pre.FQty) ").toString();
            rs = stmt.executeQuery(selectSql);
            if (rs.next() && rs.getString("FID") != null) {
                throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH_UNAUDIT, new String[]{rs.getString("FNumber"), String.valueOf(rs.getInt("FSeq"))});
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, IObjectPK reasonCodePK, boolean isEntry) throws BOSException, EASBizException {
        StringBuffer strParameter = new StringBuffer();
        String[] parameterList = new String[pks.length + 1];
        parameterList[0] = String.valueOf(6);
        if (!isEntry) {
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                PostRequisitionInfo postRequisitionInfo = this.getPostRequisitionInfo(ctx, pks[i]);
                this.isFreezed(postRequisitionInfo, false);
                if (i < c - 1) {
                    strParameter.append("?,");
                } else {
                    strParameter.append("?");
                }
                parameterList[i + 1] = pks[i].toString();
            }
            this.changePostRequisitionStatus(ctx, parameterList, strParameter.toString(), reasonCodePK.toString(), true, false);
        }
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK[] pks, boolean isEntry) throws BOSException, EASBizException {
        StringBuffer strParameter = new StringBuffer();
        String[] parameterList = new String[pks.length + 1];
        parameterList[0] = String.valueOf(4);
        if (isEntry) {
            IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getLocalInstance(ctx);
            iPostRequisitionEntry.unFreezed(pks);
        } else {
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                PostRequisitionInfo postRequisitionInfo = this.getPostRequisitionInfo(ctx, pks[i]);
                this.isUnFreezed(postRequisitionInfo);
                if (i < c - 1) {
                    strParameter.append("?,");
                } else {
                    strParameter.append("?");
                }
                parameterList[i + 1] = pks[i].toString();
            }
            this.changePostRequisitionStatus(ctx, parameterList, strParameter.toString(), "", true, false);
        }
    }

    protected void changePostRequisitionStatus(Context ctx, String[] parameterList, String strParameter, String reasonCodeID, boolean isUpdateEntry, boolean isAudit) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String auditTime = "{ts'" + sdf.format(new Date()) + "'}";
        if (isAudit) {
            strSQL.append("update T_SD_PostRequisition set FBaseStatus = ?, FAuditorID = ?,FAuditTime=" + auditTime + "  Where FID").append(" in (").append(strParameter).append(")");
        } else {
            strSQL.append("update T_SD_PostRequisition set FBaseStatus = ? Where FID").append(" in (").append(strParameter).append(")");
        }
        this.execute(ctx, strSQL.toString(), parameterList);
        if (isUpdateEntry) {
            strSQL.delete(0, strSQL.capacity());
            strSQL.append("update T_SD_PostRequisitionEntry set FBaseStatus = ?,FReason = ?  Where FParentID").append(" in (").append(strParameter).append(")");
            Object[] parameterEntryList = new String[strParameter.length() + 2];
            parameterEntryList[0] = parameterList[0];
            ReasonCodeInfo reasonInfo = ReasonCodeFactory.getLocalInstance((Context)ctx).getReasonCodeInfo((IObjectPK)new ObjectStringPK(reasonCodeID));
            parameterEntryList[1] = reasonCodeID.trim().length() == 0 ? null : reasonInfo.getName();
            if (isAudit) {
                int c = strParameter.length();
                for (int i = 0; i < c; ++i) {
                    parameterEntryList[i + 2] = parameterList[i + 2];
                }
            } else {
                int c = strParameter.length();
                for (int i = 0; i < c; ++i) {
                    parameterEntryList[i + 2] = parameterList[i + 1];
                }
            }
            this.execute(ctx, strSQL.toString(), parameterEntryList);
        }
    }

    protected void changePostRequisitionStatus_reason(Context ctx, Object[] parameterList, String strParameter, String reason, boolean isUpdateEntry, boolean isAudit) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String auditTime = "{ts'" + sdf.format(new Date()) + "'}";
        if (isAudit) {
            strSQL.append("update T_SD_PostRequisition set FBaseStatus = ?, FAuditorID = ?,FAuditTime=" + auditTime + " Where FID").append(" in (").append(strParameter).append(")");
        } else {
            strSQL.append("update T_SD_PostRequisition set FBaseStatus = ? Where FID").append(" in (").append(strParameter).append(")");
        }
        this.execute(ctx, strSQL.toString(), parameterList);
        if (isUpdateEntry) {
            strSQL.delete(0, strSQL.capacity());
            strSQL.append("update T_SD_PostRequisitionEntry set FBaseStatus = ?,FReason = ?  Where FParentID").append(" in (").append(strParameter).append(")");
            Object[] parameterEntryList = new Object[strParameter.length() + 2];
            parameterEntryList[0] = parameterList[0];
            parameterEntryList[1] = reason.trim().length() == 0 ? null : reason;
            if (isAudit) {
                int c = strParameter.length();
                for (int i = 0; i < c; ++i) {
                    parameterEntryList[i + 2] = parameterList[i + 2];
                }
            } else {
                int c = strParameter.length();
                for (int i = 0; i < c; ++i) {
                    parameterEntryList[i + 2] = parameterList[i + 1];
                }
            }
            this.execute(ctx, strSQL.toString(), parameterEntryList);
        }
    }

    private void isCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = this.getPostRequisitionInfo(ctx, pk);
        if (postRequisitionInfo.isIsReverse()) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_REVOKE);
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PostRequisitionException(PostRequisitionException.ISREVOKE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PostRequisitionException(PostRequisitionException.AUDIT_NOTCANCEL, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.BLOCK_NOTCANCEL, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PostRequisitionException(PostRequisitionException.CLOSE_NOTCANCEL, new String[]{postRequisitionInfo.getNumber()});
        }
    }

    private void isFreezed(PostRequisitionInfo postRequisitionInfo, boolean isCreateBill) throws BOSException, EASBizException {
        if (postRequisitionInfo.isIsReverse()) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_FREEZE);
        }
        if (!postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || !isCreateBill) {
            // empty if block
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PostRequisitionException(PostRequisitionException.ISREVOKE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.ISBLOCK, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTFREEZED, new String[]{postRequisitionInfo.getNumber()});
        }
    }

    private void isUnFreezed(PostRequisitionInfo postRequisitionInfo) throws BOSException, EASBizException {
        if (!postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTUNFREEZED, new String[]{postRequisitionInfo.getNumber()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)postRequisitionInfo.getNumber().trim(), CompareType.EQUALS));
        if (postRequisitionInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)postRequisitionInfo.getId().toString().trim(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        evi.setFilter(filter);
        if (this.exists(ctx, filter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{postRequisitionInfo.getNumber()});
        }
    }

    private void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    ps.setObject(i + 1, params[i]);
                    continue;
                }
                ps.setNull(i + 1, 12);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PostRequisitionInfo info = this.getPostRequisitionInfo(ctx, pk, this.getSelector(true));
        this._passAudit(ctx, pk, (IObjectValue)info);
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getPostRequisitionSelector((boolean)isNeedEntrySelector);
    }

    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getPostRequisitionSelector((boolean)true);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PostRequisitionInfo info = this.getPostRequisitionInfo(ctx, pk, this.getSelector(true));
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        SaleOrgUnitInfo saleOrgUnitInfo = postRequisitionInfo.getSaleOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (saleOrgUnitInfo != null && (orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(saleOrgUnitInfo.getId().toString(), 2, 1)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    @Override
    protected void _isFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = null;
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            postRequisitionInfo = this.getPostRequisitionInfo(ctx, pks[i]);
            this.isFreezed(postRequisitionInfo, false);
        }
    }

    @Override
    protected void _isUnFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = null;
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            postRequisitionInfo = this.getPostRequisitionInfo(ctx, pks[i]);
            this.isUnFreezed(postRequisitionInfo);
        }
    }

    @Override
    protected void _isCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.isCancel(ctx, pks[i]);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk, IObjectPK reasonCodePK) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._cancel(ctx, pks, reasonCodePK);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PostRequisitionInfo)model).getSaleOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("billType.id"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        selectors.add(new SelectorItemInfo("entries.baseStatus"));
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("sourceBillType.id"));
        selectors.add(new SelectorItemInfo("auditor.id"));
        Map<String, PostRequisitionInfo> prMap = this.getPostRequisitionMap(ctx, pks, selectors);
        PostRequisitionInfo saleInfo = null;
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            saleInfo = prMap.get(pks[j].toString());
            if (saleInfo == null) {
                saleInfo = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionInfo(pks[j], selectors);
            }
            SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)saleInfo);
            this.isSamePerson4UnAudit(ctx, saleInfo);
        }
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            String updateSql = "update T_SD_PostRequisition set FBaseStatus = 1,FAuditorId=null,FAuditTime =null where fid in(" + params.toString() + ")";
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 1 where FParentID in(" + params.toString() + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
            DbUtil.execute((Context)ctx, (String)updateEntrySql);
            ArrayList<ObjectUuidPK> arrayList1 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> arrayList2 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> fsourcebillidList = new ArrayList<ObjectUuidPK>();
            IRowSet rset = DbUtil.executeQuery((Context)ctx, (String)("select FID, FISREVERSE,FSOURCEBILLID from T_SD_PostRequisition where fid in(" + params.toString() + ")"));
            while (rset.next()) {
                String fid = rset.getString("FID");
                String fsourcebillid = rset.getString("FSOURCEBILLID");
                boolean fisreverse = rset.getBoolean("FISREVERSE");
                if (!fisreverse) {
                    arrayList1.add(new ObjectUuidPK(fid));
                    continue;
                }
                arrayList2.add(new ObjectUuidPK(fid));
                fsourcebillidList.add(new ObjectUuidPK(fsourcebillid));
            }
            IObjectPK[] pks1 = arrayList1.toArray(new IObjectPK[arrayList1.size()]);
            Object[] pks2 = arrayList2.toArray(new IObjectPK[arrayList2.size()]);
            IObjectPK[] pks3 = fsourcebillidList.toArray(new IObjectPK[fsourcebillidList.size()]);
            if (pks1.length > 0) {
                this.updateSourceBillState(ctx, pks1);
                Set hasBizFlowValueIDs = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)"t_sd_postrequisitionentry", (IObjectPK[])pks);
                this._writeSourceBill(ctx, pks1, "-", prMap, hasBizFlowValueIDs);
            }
            if (pks2.length > 0) {
                this.isReverseBillUnAudit(ctx, this.convertToString(pks2));
                this.writeSourceBillByReverseBillUnAudit(ctx, this.convertToString(pks2));
                this.updateSourceBillStatusWhenUnAudit(ctx, pks3);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.UNAUDIT);
        WriteBackNetOrderHandleFactory.headHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.UNAUDIT, (IObjectPK[])pks);
        WriteBackNetOrderHandleFactory.headHandleB2C((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.UNAUDIT, (IObjectPK[])pks);
        HashSet<String> idSet = new HashSet<String>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            idSet.add(pks[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PostRequisitionCollection col = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionCollection(view);
        ReservationBillUnAuditCheckImpl iReservationBillActionCheck = new ReservationBillUnAuditCheckImpl();
        List list = iReservationBillActionCheck.reservationBillActionCheck(ctx, (IObjectCollection)col);
        if (!CollectionUtil.isEmpty((Collection)list)) {
            throw (EASBizException)((Object)list.get(0));
        }
    }

    private void updateSourceBillStatusWhenUnAudit(Context ctx, IObjectPK[] pks) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 4 where FParentID in(" + this.convertToString(pks).toString() + ") and fbaseqty - FTotalReversedBaseQty > 0 and fbasestatus = 7 ";
            statement.executeUpdate(updateEntrySql);
            String updateSql = " update T_SD_PostRequisition set FBaseStatus = 4 where fid in ( " + this.convertToString(pks).toString() + ") and  exists(select * from t_sd_postrequisitionentry where fbasestatus = 4 and fparentid =T_SD_PostRequisition.fid ) ";
            statement.executeUpdate(updateSql);
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private void updateSourceBillState(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        int cont = pks.length;
        for (int i = 0; i < cont; ++i) {
            PostRequisitionInfo info = this.getPostRequisitionInfo(ctx, "select id,number,entries.sourceBillId,sourceBillType.id where id='" + pks[i].toString() + "'");
            if (info.getSourceBillType() == null || !info.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) continue;
            HashSet<String> srcBotpBillIDSet = new HashSet<String>();
            int size = info.getEntries().size();
            for (int j = 0; j < size; ++j) {
                if (info.getEntries().get(j).getSourceBillId() == null) continue;
                srcBotpBillIDSet.add(info.getEntries().get(j).getSourceBillId());
            }
            SaleOrderInfo srcInfo = null;
            if (srcBotpBillIDSet.size() <= 0) continue;
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", srcBotpBillIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderCollection saleOrderColl = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderCollection(view);
            int size2 = saleOrderColl.size();
            for (int j = 0; j < size2; ++j) {
                srcInfo = saleOrderColl.get(j);
                if (!srcInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) continue;
                throw new SCMBillException(SCMBillException.HASBLOCKED_CANNOTUNAUDIT, new Object[]{info.getNumber()});
            }
        }
    }

    protected void _writeSourceBill(Context ctx, IObjectPK[] pks, String operator, Map<String, PostRequisitionInfo> prMap, Set hasBizFlowValueIDs) throws EASBizException, BOSException {
        PostRequisitionInfo saleInfo = null;
        BatchActionEnum action = "-".equals(operator) ? BatchActionEnum.UNAUDIT : BatchActionEnum.AUDIT;
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (hasBizFlowValueIDs.contains(pks[i].toString())) {
                saleInfo = prMap.get(pks[i].toString());
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleInfo, (BatchActionEnum)action);
                continue;
            }
            pkSet.add(pks[i]);
        }
        if (pkSet.size() > 0) {
            String pkString = SCMServerUtils.getInStringFromSet(pkSet);
            this._writeSourceBill(ctx, pkString, operator);
            if (action == BatchActionEnum.AUDIT) {
                this.writeTransferOrderBill(ctx, pkString);
            } else {
                this.writeSourceBillForTransferOrderByReverseBillUnAudit(ctx, pkString);
            }
        }
    }

    protected void _writeSourceBill(Context ctx, String params, String operator) throws BOSException, EASBizException {
        try {
            StringBuffer valueBuffer = new StringBuffer();
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty,entry.FBaseQty").append(" from T_SD_PostRequisitionEntry entry").append(" where entry.FSourceBillTypeId = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'").append(" and entry.FParentID in(").append(params).append(")");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Object[] dbParams = null;
            if (result.next() && result.getString(1) != null) {
                StringBuffer updateOrderSql = new StringBuffer();
                updateOrderSql.append("update T_SD_SaleOrderEntry ").append(" set FTotalUnIssueQty = (FTotalUnIssueQty - ?)").append(" ,FTotalUnIssueBaseQty = (FTotalUnIssueBaseQty - ?)").append(" ,FTotalShippingQty = FTotalShippingQty + ? ").append(" ,FTotalShipBaseQty = FTotalShipBaseQty +? ").append(",ftotalunshipbaseqty = ftotalunshipbaseqty - ?").append(" where fid = ? ");
                if (operator.equals("-")) {
                    dbParams = new Object[]{result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(3).negate(), result.getString(1)};
                    paramsList.add(dbParams);
                } else {
                    dbParams = new Object[]{result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(3), result.getString(1)};
                    paramsList.add(dbParams);
                }
                while (result.next()) {
                    if (operator.equals("-")) {
                        dbParams = new Object[]{result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(3).negate(), result.getString(1)};
                        paramsList.add(dbParams);
                        continue;
                    }
                    dbParams = new Object[]{result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(3), result.getString(1)};
                    paramsList.add(dbParams);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateOrderSql.toString(), paramsList);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeSourceBillByReverse(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, pre2.FID, pre2.FUnitID as FUnitID2, pre2.FTotalReversedQty, pre2.FTotalReversedBaseQty, ").append(" pre2.FUnShippedQty, pre2.FAssociateQty, mu.FBaseConvsRate ").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = pre2.FMaterialID and mu.FMeasureUnitID = pre2.FUnitID ").append(" where pre.FParentID in(").append(params).append(")").toString();
        String updateSql = new StringBuffer().append("update T_SD_PostRequisitionEntry set FTotalReversedQty = ?, FTotalReversedBaseQty = ?, FUnShippedQty = ?, FAssociateQty = ? where FID = ?").toString();
        ArrayList<String> arrList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fid = rs.getString("FID");
                    arrList.add(fid);
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalReversedQty = rs.getBigDecimal("FTotalReversedQty");
                    BigDecimal totalReversedBaseQty = rs.getBigDecimal("FTotalReversedBaseQty");
                    BigDecimal unShippedQty = rs.getBigDecimal("FUnShippedQty");
                    BigDecimal associateQty = rs.getBigDecimal("FAssociateQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedQty).add(currQty);
                    totalReversedBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedBaseQty).add(currBaseQty);
                    unShippedQty = SCMUtils.effectualNumeric((BigDecimal)unShippedQty).subtract(currQty);
                    associateQty = SCMUtils.effectualNumeric((BigDecimal)associateQty).subtract(currBaseQty);
                    updatePstmt.setBigDecimal(1, totalReversedQty);
                    updatePstmt.setBigDecimal(2, totalReversedBaseQty);
                    updatePstmt.setBigDecimal(3, unShippedQty);
                    updatePstmt.setBigDecimal(4, associateQty);
                    updatePstmt.setString(5, fid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
                this.writeSourceBillForSaleOrderByReverse(ctx, params);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (BOSException e2) {
                    logger.error((Object)e2);
                    throw e2;
                }
                catch (SQLException e3) {
                    logger.error((Object)e3);
                    throw new BOSException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup((Statement)selectStmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Connection)con);
    }

    protected void writeSourceBillForSaleOrderByReverse(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        PreparedStatement updatePstmtBySplit = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, soe.FID, soe.FParentID, soe.FUnitID as FUnitID2, soe.FTotalShippingQty, soe.FTotalShipBaseQty, soe.FTotalUnShipBaseQty, ").append(" soe.FTotalUnIssueQty, soe.FTotalUnIssueBaseQty, mu.FBaseConvsRate, mu2.FBaseConvsRate as FBaseConvsRate2").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" inner join T_SD_SaleOrderEntry soe on soe.FID = pre2.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ").append(" left outer join T_BD_MultiMeasureUnit mu2 on mu2.FMaterialID = soe.FMaterialID and mu2.FMeasureUnitID = soe.FAssistUnitID ").append(" where pre.FParentID in(").append(params).append(") order by soe.FID").toString();
        String updateSql = new StringBuffer().append("update T_SD_SaleOrderEntry set FTotalShippingQty = ?, FTotalShipBaseQty = ?, FTotalUnShipBaseQty = ?, FTotalUnIssueQty = ?, FTotalUnIssueBaseQty = ? where FID = ?").toString();
        String updateSqlBySplit = "update T_SD_SaleOrderEntry set FTotalShippingQty = FTotalShippingQty-?, FTotalShipBaseQty = FTotalShipBaseQty-?, FTotalUnShipBaseQty = FTotalUnShipBaseQty+?, FTotalUnIssueQty = FTotalUnIssueQty+?, FTotalUnIssueBaseQty = FTotalUnIssueBaseQty+? where FID = ?";
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            updatePstmtBySplit = con.prepareStatement(updateSqlBySplit);
            rs = selectStmt.executeQuery(selectSql);
            String tempOrderEntryID = null;
            if (rs.next()) {
                do {
                    boolean isNeedExcuteSplit = false;
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fentryid = rs.getString("FID");
                    String unitID = rs.getString("FUnitID2");
                    if (tempOrderEntryID != null && tempOrderEntryID.equals(fentryid)) {
                        isNeedExcuteSplit = true;
                    }
                    BigDecimal totalShippingQty = rs.getBigDecimal("FTotalShippingQty");
                    BigDecimal totalShipBaseQty = rs.getBigDecimal("FTotalShipBaseQty");
                    BigDecimal totalUnShipBaseQty = rs.getBigDecimal("FTotalUnShipBaseQty");
                    BigDecimal totalUnIssueQty = rs.getBigDecimal("FTotalUnIssueQty");
                    BigDecimal totalUnIssueBaseQty = rs.getBigDecimal("FTotalUnIssueBaseQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    if (isNeedExcuteSplit) {
                        totalShippingQty = currQty;
                        totalShipBaseQty = currBaseQty;
                        totalUnShipBaseQty = currBaseQty;
                        totalUnIssueQty = currQty;
                        totalUnIssueBaseQty = currBaseQty;
                        updatePstmtBySplit.setBigDecimal(1, totalShippingQty);
                        updatePstmtBySplit.setBigDecimal(2, totalShipBaseQty);
                        updatePstmtBySplit.setBigDecimal(3, totalUnShipBaseQty);
                        updatePstmtBySplit.setBigDecimal(4, totalUnIssueQty);
                        updatePstmtBySplit.setBigDecimal(5, totalUnIssueBaseQty);
                        updatePstmtBySplit.setString(6, fentryid);
                        updatePstmtBySplit.addBatch();
                    } else {
                        totalShippingQty = SCMUtils.effectualNumeric((BigDecimal)totalShippingQty).subtract(currQty);
                        totalShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalShipBaseQty).subtract(currBaseQty);
                        totalUnShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnShipBaseQty).add(currBaseQty);
                        totalUnIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueQty).add(currQty);
                        totalUnIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueBaseQty).add(currBaseQty);
                        updatePstmt.setBigDecimal(1, totalShippingQty);
                        updatePstmt.setBigDecimal(2, totalShipBaseQty);
                        updatePstmt.setBigDecimal(3, totalUnShipBaseQty);
                        updatePstmt.setBigDecimal(4, totalUnIssueQty);
                        updatePstmt.setBigDecimal(5, totalUnIssueBaseQty);
                        updatePstmt.setString(6, fentryid);
                        updatePstmt.addBatch();
                    }
                    tempOrderEntryID = rs.getString("FID");
                } while (rs.next());
                updatePstmt.executeBatch();
                updatePstmtBySplit.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, selectStmt, (Connection)con);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(updatePstmtBySplit);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)selectStmt, (Connection)con);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)updatePstmtBySplit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeSourceBillByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, pre2.FID, pre2.FUnitID as FUnitID2, pre2.FTotalReversedQty, pre2.FTotalReversedBaseQty, ").append(" pre2.FUnShippedQty, pre2.FAssociateQty, mu.FBaseConvsRate ").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = pre2.FMaterialID and mu.FMeasureUnitID = pre2.FUnitID ").append(" where pre.FParentID in(").append(params).append(")").toString();
        String updateSql = new StringBuffer().append("update T_SD_PostRequisitionEntry set FTotalReversedQty = ?, FTotalReversedBaseQty = ?, FUnShippedQty = ?, FAssociateQty = ? where FID = ?").toString();
        ArrayList<String> arrList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fid = rs.getString("FID");
                    arrList.add(fid);
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalReversedQty = rs.getBigDecimal("FTotalReversedQty");
                    BigDecimal totalReversedBaseQty = rs.getBigDecimal("FTotalReversedBaseQty");
                    BigDecimal unShippedQty = rs.getBigDecimal("FUnShippedQty");
                    BigDecimal associateQty = rs.getBigDecimal("FAssociateQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedQty).subtract(currQty);
                    totalReversedBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedBaseQty).subtract(currBaseQty);
                    unShippedQty = SCMUtils.effectualNumeric((BigDecimal)unShippedQty).add(currQty);
                    associateQty = SCMUtils.effectualNumeric((BigDecimal)associateQty).add(currBaseQty);
                    updatePstmt.setBigDecimal(1, totalReversedQty);
                    updatePstmt.setBigDecimal(2, totalReversedBaseQty);
                    updatePstmt.setBigDecimal(3, unShippedQty);
                    updatePstmt.setBigDecimal(4, associateQty);
                    updatePstmt.setString(5, fid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
                this.writeSourceBillForSaleOrderByReverseBillUnAudit(ctx, params);
                this.writeSourceBillForTransferOrderByReverseBillUnAudit(ctx, params);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (BOSException e2) {
                    logger.error((Object)e2);
                    throw e2;
                }
                catch (SQLException e3) {
                    logger.error((Object)e3);
                    throw new BOSException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, selectStmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Connection)con);
    }

    private void writeSourceBillForTransferOrderByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        PreparedStatement updatePstmtBySplit = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, soe.FID, soe.FParentID, soe.FUnitID as FUnitID2,  ").append(" soe.FunIssueBaseQty,soe.FtotalIssueQty, soe.FIssueBaseQty, mu.FBaseConvsRate, mu2.FBaseConvsRate as FBaseConvsRate2").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_IM_TransferOrderBillEntry soe on soe.FID = pre.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ").append(" left outer join T_BD_MultiMeasureUnit mu2 on mu2.FMaterialID = soe.FMaterialID and mu2.FMeasureUnitID = soe.FAssistUnitID ").append(" where pre.FParentID in(").append(params).append(") order by soe.FID ").toString();
        String updateSql = new StringBuffer().append("update T_IM_TransferOrderBillEntry set FunIssueBaseQty = ?, FtotalIssueQty = ?  where FID = ?").toString();
        String updateSqlBySplit = "update T_IM_TransferOrderBillEntry set FunIssueBaseQty = FunIssueBaseQty+?, FtotalIssueQty = FtotalIssueQty-?  where FID = ? ";
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            updatePstmtBySplit = con.prepareStatement(updateSqlBySplit);
            rs = selectStmt.executeQuery(selectSql);
            String tempTansferOrderEntryID = null;
            if (rs.next()) {
                do {
                    boolean isNeedExcuteSplit = false;
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fentryid = rs.getString("FID");
                    String unitID = rs.getString("FUnitID2");
                    if (tempTansferOrderEntryID != null && tempTansferOrderEntryID.equals(fentryid)) {
                        isNeedExcuteSplit = true;
                    }
                    BigDecimal unIssueBaseQty = rs.getBigDecimal("FunIssueBaseQty");
                    BigDecimal totalIssueQty = rs.getBigDecimal("FtotalIssueQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    if (isNeedExcuteSplit) {
                        unIssueBaseQty = currBaseQty;
                        totalIssueQty = currQty;
                        updatePstmtBySplit.setBigDecimal(1, unIssueBaseQty);
                        updatePstmtBySplit.setBigDecimal(2, totalIssueQty);
                        updatePstmtBySplit.setString(3, fentryid);
                        updatePstmtBySplit.addBatch();
                    } else {
                        unIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)unIssueBaseQty).add(currBaseQty);
                        totalIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalIssueQty).subtract(currQty);
                        updatePstmt.setBigDecimal(1, unIssueBaseQty);
                        updatePstmt.setBigDecimal(2, totalIssueQty);
                        updatePstmt.setString(3, fentryid);
                        updatePstmt.addBatch();
                    }
                    tempTansferOrderEntryID = rs.getString("FID");
                } while (rs.next());
                updatePstmt.executeBatch();
                updatePstmtBySplit.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(selectStmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(updatePstmtBySplit);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)updatePstmtBySplit);
        SQLUtils.cleanup((Connection)con);
    }

    protected void writeSourceBillForSaleOrderByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, soe.FID, soe.FParentID, soe.FUnitID as FUnitID2, soe.FTotalShippingQty,soe.FTotalShipBaseQty, soe.FTotalUnShipBaseQty, ").append(" soe.FTotalUnIssueQty, soe.FTotalUnIssueBaseQty, mu.FBaseConvsRate, mu2.FBaseConvsRate as FBaseConvsRate2").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" inner join T_SD_SaleOrderEntry soe on soe.FID = pre2.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ").append(" left outer join T_BD_MultiMeasureUnit mu2 on mu2.FMaterialID = soe.FMaterialID and mu2.FMeasureUnitID = soe.FAssistUnitID ").append(" where pre.FParentID in(").append(params).append(") order by soe.FID").toString();
        String updateSql = new StringBuffer().append("update T_SD_SaleOrderEntry set FTotalShippingQty = ?, FTotalShipBaseQty = ?, FTotalUnShipBaseQty = ?, FTotalUnIssueQty = ?, FTotalUnIssueBaseQty = ? where FID = ?").toString();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fentryid = rs.getString("FID");
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalShippingQty = rs.getBigDecimal("FTotalShippingQty");
                    BigDecimal totalShipBaseQty = rs.getBigDecimal("FTotalShipBaseQty");
                    BigDecimal totalUnShipBaseQty = rs.getBigDecimal("FTotalUnShipBaseQty");
                    BigDecimal totalUnIssueQty = rs.getBigDecimal("FTotalUnIssueQty");
                    BigDecimal totalUnIssueBaseQty = rs.getBigDecimal("FTotalUnIssueBaseQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalShippingQty = SCMUtils.effectualNumeric((BigDecimal)totalShippingQty).add(currQty);
                    totalShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalShipBaseQty).add(currBaseQty);
                    totalUnShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnShipBaseQty).subtract(currBaseQty);
                    totalUnIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueQty).subtract(currQty);
                    totalUnIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueBaseQty).subtract(currBaseQty);
                    updatePstmt.setBigDecimal(1, totalShippingQty);
                    updatePstmt.setBigDecimal(2, totalShipBaseQty);
                    updatePstmt.setBigDecimal(3, totalUnShipBaseQty);
                    updatePstmt.setBigDecimal(4, totalUnIssueQty);
                    updatePstmt.setBigDecimal(5, totalUnIssueBaseQty);
                    updatePstmt.setString(6, fentryid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                SQLUtils.cleanup(selectStmt);
                SQLUtils.cleanup(updatePstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
    }

    private void writeTransferOrderBill(Context ctx, String params) throws BOSException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FunIssueBaseQty,FtotalIssueQty) = ");
            sb.append("(SELECT ste.FunIssueBaseQty - are.areBaseQty AS IUNBQ , ste.FtotalIssueQty + are.areFQty AS Qty  FROM T_IM_TransferOrderBillEntry ste ");
            sb.append("INNER JOIN (SELECT FParentID,FsourceBillEntryId,FSourceBillTypeId,sum(FQty) as areFQty,sum(FBaseQty) as areBaseQty  FROM T_SD_PostRequisitionEntry WHERE FParentID=");
            sb.append(params);
            sb.append(" and FSourceBillTypeId  = '");
            sb.append("Eg5BUQEVEADgAAABwKgOEEY+1VI=");
            sb.append("' GROUP BY FParentID,FsourceBillEntryId,FSourceBillTypeId) are ");
            sb.append("ON are.FsourceBillEntryId = ste.Fid WHERE are.FParentID in(");
            sb.append(params);
            sb.append(") AND T1.FID=ste.FID)");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        IParamControl ipc;
        String paramvalue;
        IPostRequisitionEntry ientry = PostRequisitionEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        PostRequisitionEntryInfo entryInfo = ientry.getPostRequisitionEntryInfo(pk, sic);
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTCLOSEDAUDIT, new String[]{entryInfo.getParent().getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        entryInfo.setReason(reason);
        ientry.update(pk, (CoreBaseInfo)entryInfo);
        PostRequisitionInfo info = this.getPostRequisitionInfo(ctx, (IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
        boolean isCloseBill = true;
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            if (info.getEntries().get(i).getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
            isCloseBill = false;
            break;
        }
        if (isCloseBill) {
            info.setBaseStatus(BillBaseStatusEnum.CLOSED);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        if (Boolean.valueOf(paramvalue = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005")).booleanValue()) {
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                sentryInfo.setTotalUnIssueQty(sentryInfo.getTotalUnIssueQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                sentryInfo.setTotalUnIssueBaseQty(sentryInfo.getTotalUnIssueBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().subtract(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
            } else if (entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
                TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                BigDecimal qty = entryInfo.getQty();
                BigDecimal shipQty = entryInfo.getShippedQty();
                BigDecimal baseQty = entryInfo.getBaseQty();
                BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
                if (qty.compareTo(shipQty) > 0) {
                    transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().subtract(qty.subtract(shipQty)));
                    transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().add(baseQty.subtract(baseShipQty)));
                    iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
                }
            }
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.CLOSE);
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws BOSException, EASBizException {
        IRowSet resultset;
        Statement statement;
        Connection conn;
        StringBuffer ids;
        BatchActionResults results;
        block12: {
            results = new BatchActionResults();
            ids = new StringBuffer();
            StringBuffer reason = new StringBuffer();
            StringBuffer successids = new StringBuffer();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'");
                ids.append(entries[i].get(0).toString());
                ids.append("'");
            }
            conn = null;
            statement = null;
            resultset = null;
            try {
                conn = this.getConnection(ctx);
                statement = conn.createStatement();
                StringBuffer sqlStr = new StringBuffer();
                sqlStr.append(" select FSeq seq,Fid id").append(" from ").append(" T_SD_PostRequisitionEntry ").append(" where fid in(").append(ids.toString()).append(") and FBaseStatus = ").append(EntryBaseStatusEnum.AUDITED);
                resultset = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
                while (resultset.next()) {
                    if (successids.length() > 0) {
                        successids.append(",");
                    }
                    successids.append("'");
                    successids.append(resultset.getString("id"));
                    successids.append("'");
                }
                PostRequisitionException PRException = new PostRequisitionException(PostRequisitionException.CANNOTCLOSEDAUDIT);
                int size2 = entries.length;
                for (int i = 0; i < size2; ++i) {
                    if (successids.toString().indexOf(entries[i].get(0).toString()) >= 0) {
                        results.addSuccess(entries[i].get(0).toString());
                        if (reason.length() > 0) {
                            reason.append(",");
                        }
                        reason.append("'");
                        reason.append(entries[i].get(1).toString());
                        reason.append("'");
                        continue;
                    }
                    results.addError(entries[i].get(0).toString(), (Exception)((Object)PRException));
                }
                String[] reasonarray = reason.toString().split(",");
                String[] successidarray = successids.toString().split(",");
                statement.clearBatch();
                int c = successidarray.length;
                for (int i = 0; i < c; ++i) {
                    sqlStr.delete(0, sqlStr.length());
                    sqlStr.append(" update T_SD_PostRequisitionEntry set FBaseStatus = ").append(EntryBaseStatusEnum.CLOSED).append(" FReason = ").append(reasonarray[i]).append(" where fid =").append(successidarray[i]);
                    statement.addBatch(sqlStr.toString());
                }
                statement.executeBatch();
                String paramvalue = "";
                if (!Boolean.valueOf(paramvalue).booleanValue()) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultset);
                    SQLUtils.cleanup(statement);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultset);
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{ids.toString().split(",")}, CreditOperationEnum.CLOSE);
        return results;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_SALEORDER});
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PostRequisitionInfo prInfo = (PostRequisitionInfo)collection.getObject(i);
            this.calByUnitSource(ctx, prInfo, (IObjectCollection)prInfo.getEntries());
            if (!this.isBotpBill(prInfo)) continue;
            String sourceBillType = prInfo.getSourceBillType().getId().toString();
            if (sourceBillType.equals("50957179-0105-1000-e003-3152c0a812fd463ED552") || sourceBillType.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                if (prInfo.getPaymentType() == null) {
                    PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
                    paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
                    prInfo.setPaymentType(paymentTypeInfo);
                }
            } else if (prInfo.getPaymentType() == null && sourceBillType.equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                throw new PostRequisitionException(PostRequisitionException.UNSET_PAYMENTTYPE);
            }
            SCMBizDataVO paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, prInfo);
            SCMBizDataVO resultScmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            this.getSaleOrderEntryQty(prInfo, ctx);
            this.reCalcAmount(ctx, prInfo, resultScmBizDataVO);
            StorageOrgUnitInfo sou = prInfo.getStorageOrgUnit();
            HashSet<String> idsSet = new HashSet<String>();
            IMaterialInventory imaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int row = 0; row < prInfo.getEntries().size(); ++row) {
                idsSet.add(prInfo.getEntries().get(row).getMaterial().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("Material.id"));
            view.getSelector().add(new SelectorItemInfo("defaultWarehouse.*"));
            view.getSelector().add(new SelectorItemInfo("isLotNumber"));
            view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
            view.setFilter(filter);
            MaterialInventoryCollection collections = imaterialInventory.getMaterialInventoryCollection(view);
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
            for (int row = 0; row < prInfo.getEntries().size(); ++row) {
                PostRequisitionEntryInfo entryInfo = prInfo.getEntries().get(row);
                if (sou != null && entryInfo.getWarehouse() == null) {
                    for (int j = 0; j < collections.size(); ++j) {
                        MaterialInventoryInfo materialInventoryInfo = collections.get(j);
                        if (entryInfo.getMaterial().getId().equals((Object)materialInventoryInfo.getMaterial().getId()) && materialInventoryInfo.getDefaultWarehouse() != null && materialInventoryInfo.getDefaultWarehouse().getStorageOrg().getId().toString().equals(prInfo.getStorageOrgUnit().getId().toString())) {
                            entryInfo.setWarehouse(materialInventoryInfo.getDefaultWarehouse());
                        }
                        if (!entryInfo.getMaterial().getId().equals((Object)materialInventoryInfo.getMaterial().getId()) || !materialInventoryInfo.getOrgUnit().getId().toString().equals(prInfo.getStorageOrgUnit().getId().toString()) || entryInfo.getLot() == null || materialInventoryInfo.isIsLotNumber()) continue;
                        entryInfo.setLot(null);
                    }
                }
                entryInfo.setUnShippedQty(entryInfo.getQty());
                if (prInfo.getStorageOrgUnit() == null || entryInfo.getWarehouse() == null) continue;
                StringBuffer oql = new StringBuffer();
                oql.append("select location.id,location.name,location.number ").append("where storageOrg = '").append(prInfo.getStorageOrgUnit().getId().toString()).append("' and ").append("material = '").append(entryInfo.getMaterial().getId().toString()).append("' and ").append("warehouse = '").append(entryInfo.getWarehouse().getId().toString()).append("' and ").append("ISDEFAULTLOCATION = 1 ");
                MaterialStorageAssignCollection materialStorageAssignCollection = imsa.getMaterialStorageAssignCollection(oql.toString());
                if (materialStorageAssignCollection.size() <= 0) continue;
                entryInfo.setLocation(materialStorageAssignCollection.get(0).getLocation());
            }
            if (!sourceBillType.equals("50957179-0105-1000-e003-3152c0a812fd463ED552")) continue;
            IDeliveryType idelivery = DeliveryTypeFactory.getLocalInstance((Context)ctx);
            DeliveryTypeInfo deliveryTypeInfo = idelivery.getDeliveryTypeInfo((IObjectPK)new ObjectStringPK("51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F"));
            int size = prInfo.getEntries().size();
            for (int row = 0; row < size; ++row) {
                if (prInfo.getEntries().get(row).getDeliveryType() != null) continue;
                prInfo.getEntries().get(row).setDeliveryType(deliveryTypeInfo);
            }
        }
        IObjectValue model = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            model = collection.getObject(i);
            SCMUtil.succeedSourceBillReservationInfo((Context)ctx, (IObjectValue)model);
        }
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, PostRequisitionInfo prInfo) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)prInfo), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(this.getBOSType().toString());
        SaleOrderDataVO scmEntryDataVO = new SaleOrderDataVO();
        scmEntryDataVO.setCurrencyInfo(prInfo.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmEntryDataVO.setIsLoadingMou(true);
        scmEntryDataVO.setIsLoadingMmuPrecision(true);
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        this.initSCMBizDataVO(ctx, scmBizDataVO, prInfo.getEntries());
        return scmBizDataVO;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected void reCalcAmount(Context ctx, PostRequisitionInfo prInfo, SCMBizDataVO vo) throws BOSException, EASBizException {
        SaleOrderDataVO scmEntryDataVO = (SaleOrderDataVO)vo.getScmEntryDataVO();
        CurrencyInfo currencyInfo = prInfo.getCurrency();
        BigDecimal ZERO = SysConstant.BIGZERO;
        PostRequisitionEntryCollection preCollection = prInfo.getEntries();
        boolean isFromSaleOrder = this.isBotpBill(prInfo, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
        boolean isFromStockTransfer = this.isBotpBill(prInfo, "50957179-0105-1000-e003-3152c0a812fd463ED552");
        try {
            PostRequisitionControllerBean.formatQtyPrecision((AbstractObjectCollection)preCollection, (Method)PostRequisitionEntryInfo.class.getMethod("getQty", new Class[0]), (Method)PostRequisitionEntryInfo.class.getMethod("setBaseQty", BigDecimal.class), (Method)PostRequisitionEntryInfo.class.getMethod("setAssistQty", BigDecimal.class), (Method)PostRequisitionEntryInfo.class.getMethod("setAssistUnit", MeasureUnitInfo.class), (Method)PostRequisitionEntryInfo.class.getMethod("getAssistQty", new Class[0]), (SCMEntryDataVO)scmEntryDataVO);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal exchangeRate = prInfo.getExchangeRate();
        ExchangeRateInfo exchangeAuxInfo = null;
        CurrencyInfo baseCurrencyInfo = null;
        CompanyOrgUnitInfo ficompanyOrgInfo = prInfo.getCompanyOrgUnit();
        if (ficompanyOrgInfo != null) {
            baseCurrencyInfo = ficompanyOrgInfo.getBaseCurrency();
        }
        if (baseCurrencyInfo != null && prInfo.getCurrency() != null) {
            exchangeAuxInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)ficompanyOrgInfo, (IObjectPK)new ObjectUuidPK(prInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()));
        }
        if (baseCurrencyInfo == null) {
            baseCurrencyInfo = prInfo.getCurrency();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("precision"));
        baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId().toString()), sic);
        int localScale = baseCurrencyInfo.getPrecision();
        Object order = null;
        int m = preCollection.size();
        for (int j = 0; j < m; ++j) {
            PostRequisitionEntryInfo prEntryInfo = preCollection.get(j);
            MaterialInfo materialInfo = prEntryInfo.getMaterial();
            if (materialInfo == null) continue;
            prEntryInfo.setAssociateQty(prEntryInfo.getBaseQty());
            BillTypeInfo sourceBillType = prInfo.getSourceBillType();
            String sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
            boolean isBillRelation = BillRelationOptionEnum.BRINGIN.equals((Object)prInfo.getBillRelationOption());
            String key = prEntryInfo.getSourceBillEntryId();
            BigDecimal baseQty = this.soBaseQtyMap.get(key);
            if (isBillRelation && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID) && baseQty.compareTo(prEntryInfo.getBaseQty()) == 0) {
                this.checkBotp(prEntryInfo, ctx);
            } else {
                int precision = 2;
                if (currencyInfo != null) {
                    precision = currencyInfo.getPrecision();
                }
                BigDecimal amount = ZERO;
                BigDecimal localAmount = ZERO;
                BigDecimal qty = prEntryInfo.getQty();
                BigDecimal price = prEntryInfo.getPrice();
                if (qty != null && price != null) {
                    amount = qty.multiply(price).setScale(precision, 4);
                    localAmount = CalculateUtils.calcByExchangeRate((ExchangeRateInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
                }
                prEntryInfo.setAmount(amount);
                prEntryInfo.setLocalAmount(localAmount);
            }
            if (prEntryInfo.getAssistUnit() != null) continue;
            prEntryInfo.setAssistQty(null);
        }
    }

    private void checkBotp(PostRequisitionEntryInfo prEntryInfo, Context ctx) throws BOSException, EASBizException {
        if (prEntryInfo == null) {
            return;
        }
        if (prEntryInfo.isIsPresent()) {
            return;
        }
        StringBuffer detail = new StringBuffer();
        StringBuffer errorMsg = new StringBuffer();
        if (prEntryInfo.getPrice() == null || BigDecimal.ZERO.compareTo(prEntryInfo.getPrice()) == 0) {
            detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SALEPRICE", (Context)ctx)).append(", ");
        }
        if (prEntryInfo.getAmount() == null || BigDecimal.ZERO.compareTo(prEntryInfo.getAmount()) == 0) {
            detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"NONTAXAMOUNT", (Context)ctx)).append(", ");
        }
        if (detail.length() > 0) {
            errorMsg.append("\n");
            errorMsg.append(detail);
            throw new InvBizException(InvBizException.BILLRELATIONFIELDNOTNULL, (Object[])new String[]{errorMsg.toString()});
        }
    }

    private void getSaleOrderEntryQty(PostRequisitionInfo info, Context ctx) throws EASBizException, BOSException {
        String sourceBillTypeID;
        this.soBaseQtyMap = new HashMap<String, BigDecimal>();
        BillTypeInfo sourceBillType = info.getSourceBillType();
        String string = sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID)) {
            PostRequisitionEntryInfo entry = null;
            PostRequisitionEntryCollection preCollection = info.getEntries();
            HashSet<String> idSet = new HashSet<String>();
            int size = preCollection.size();
            for (int i = 0; i < size; ++i) {
                entry = preCollection.get(i);
                idSet.add(entry.getSourceBillId());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SaleOrderCollection saleOrderCollection = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderCollection(viewInfo);
            int size2 = saleOrderCollection.size();
            for (int i = 0; i < size2; ++i) {
                SaleOrderInfo botpSaleOrderInfo = saleOrderCollection.get(i);
                SaleOrderEntryInfo soEntry = null;
                for (int m = 0; m < botpSaleOrderInfo.getEntries().size(); ++m) {
                    soEntry = botpSaleOrderInfo.getEntries().get(m);
                    this.soBaseQtyMap.put(soEntry.getId().toString(), soEntry.getBaseQty());
                }
            }
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    public String getParamCon4Audit() {
        return "SALEBILL002";
    }

    public String getParamCon4UnAudit() {
        return "SALEBILL003";
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = new PostRequisitionInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        postRequisitionInfo.setBizDate(curDate);
        postRequisitionInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
        postRequisitionInfo.setBillType(aBillTypeInfo);
        return postRequisitionInfo;
    }

    private Map<String, PostRequisitionInfo> getPostRequisitionMap(Context ctx, IObjectPK[] pks, SelectorItemCollection sic) throws BOSException {
        HashMap<String, PostRequisitionInfo> prMap = new HashMap<String, PostRequisitionInfo>();
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>(Arrays.asList(pks));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        PostRequisitionCollection coll = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionCollection(view);
        PostRequisitionInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            prMap.put(info.getId().toString(), info);
        }
        return prMap;
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            return super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PostRequisitionInfo model = null;
        model = this.getPostRequisitionInfo(ctx, (IObjectPK)new ObjectUuidPK(id), SCMSelectorFactory.getPostRequisitionSelector((boolean)true));
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void cancelBill(Context ctx, IObjectPK[] pks, String reason) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.DISCARD);
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.isCancel(ctx, pks[i]);
        }
        String tableName = "T_SD_PostRequisitionEntry";
        Set set = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (set.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            view.setFilter(filter);
            PostRequisitionCollection coll = super.getPostRequisitionCollection(ctx, view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)coll.get(i), (BatchActionEnum)BatchActionEnum.CANCEL);
                }
            }
        }
        StringBuffer strParameter = new StringBuffer();
        Object[] parameterList = new Object[pks.length + 1];
        parameterList[0] = 3;
        int c2 = pks.length;
        for (int i = 0; i < c2; ++i) {
            if (i < c2 - 1) {
                strParameter.append("?,");
            } else {
                strParameter.append("?");
            }
            parameterList[i + 1] = pks[i].toString();
        }
        this.changePostRequisitionStatus_reason(ctx, parameterList, strParameter.toString(), reason, true, false);
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        PostRequisitionEntryInfo postRequisitionEntryInfo = (PostRequisitionEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = postRequisitionEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = postRequisitionEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = postRequisitionEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)postRequisitionEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)postRequisitionEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        postRequisitionEntryInfo.setQty(qty);
        BigDecimal price = null;
        price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)postRequisitionEntryInfo.getPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        postRequisitionEntryInfo.setPrice(price);
    }
}

