/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractPostRequisitionEditUIHandler;

public class PostRequisitionEditUIHandler
extends AbstractPostRequisitionEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            super._handleInit(request, response, context);
            SCMBillCommonFacadeFactory.getLocalInstance((Context)context).getServerDate();
            try {
                CustomizedSchemeFactory.getLocalInstance((Context)context).getCustomizedSchemeInfo("where name = 'WeightedSoulution'");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void loadComplexData(RequestContext request, ResponseContext response, Context context) throws Exception {
        SCMEntryDataVO inVO = this.initSCMEntryDataVO(request);
        SaleOrderDataVO resultVO = SCMGroupFacadeFactory.getLocalInstance((Context)context).loadSaleComplexData((SaleOrderDataVO)inVO);
        Class[] typeClass = new Class[]{inVO.getClass()};
        Object[] paramsValue = new Object[]{inVO};
        String methodName = "loadSaleComplexData";
        BaseFrameService.getMultiKey((ResponseContext)response, ISCMGroupFacade.class, (String)methodName, (Class[])typeClass, (Object[])paramsValue, (Object)resultVO);
    }

    private SCMEntryDataVO initSCMEntryDataVO(RequestContext request) throws Exception {
        IObjectCollection entries;
        SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)request.getValue();
        SCMEntryDataVO vo = (SCMEntryDataVO)request.get("__SCMENTRYDATA");
        if (scmBillInfo == null) {
            return vo;
        }
        OrgUnitInfo mainOrg = (OrgUnitInfo)scmBillInfo.get(scmBillInfo.getBizOrgPropertyName());
        vo.setMainOrg(mainOrg);
        vo.setIsLoadingMou(scmBillInfo.getSourceBillType() != null);
        vo.setIsLoadingMmuPrecision(true);
        if (vo.isLoadingCurrency()) {
            vo.setCurrencyInfo((CurrencyInfo)scmBillInfo.get("currency"));
        }
        if ((entries = (IObjectCollection)scmBillInfo.get(scmBillInfo.getEntryName())) == null || entries.size() == 0) {
            return vo;
        }
        int length = entries.size();
        MaterialInfo[] materialInfos = new MaterialInfo[length];
        MeasureUnitInfo[] measureUnitInfos = null;
        MeasureUnitInfo[] measureBaseUnitInfos = null;
        MeasureUnitInfo[] measureAssistUnitInfos = null;
        StorageOrgUnitInfo[] storageOrgUnitInfos = null;
        if (vo.isLoadingMou() || vo.isLoadingMmuPrecision()) {
            measureUnitInfos = new MeasureUnitInfo[length];
            measureBaseUnitInfos = new MeasureUnitInfo[length];
            measureAssistUnitInfos = new MeasureUnitInfo[length];
        }
        if (vo.isLoadingMaterialInventory() && vo.getStorageOrgUnitInfos() == null) {
            storageOrgUnitInfos = new StorageOrgUnitInfo[length];
        } else if (vo.isLoadingMaterialInventory()) {
            storageOrgUnitInfos = vo.getStorageOrgUnitInfos();
        }
        for (int i = 0; i < length; ++i) {
            SCMBillEntryBaseInfo scmEntryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            materialInfos[i] = scmEntryInfo.getMaterial();
            if (materialInfos[i] == null) continue;
            if (vo.isLoadingMou() || vo.isLoadingMmuPrecision()) {
                measureUnitInfos[i] = scmEntryInfo.getUnit();
                measureBaseUnitInfos[i] = scmEntryInfo.getBaseUnit();
                measureAssistUnitInfos[i] = scmEntryInfo.getAssistUnit();
            }
            if (!vo.isLoadingMaterialInventory() || vo.getStorageOrgUnitInfos() != null) continue;
            storageOrgUnitInfos[i] = (StorageOrgUnitInfo)scmBillInfo.get("storageOrgUnit");
        }
        vo.setMaterialInfos(materialInfos);
        vo.setMeasureUnitInfos(measureUnitInfos);
        vo.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        vo.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        vo.setStorageOrgUnitInfos(storageOrgUnitInfos);
        return vo;
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        Boolean isUseAgent = false;
        if (request.get("isUseAgent") != null) {
            isUseAgent = (Boolean)request.get("isUseAgent");
        }
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)PostRequisitionFactory.getLocalInstance(context).createNewData(isUseAgent);
        postRequisitionInfo.setSaleOrgUnit((SaleOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        return postRequisitionInfo;
    }
}

