/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.BizCheckException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.ITransferOrderBillEntry;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.reservation.service.ReservationBillCloseService;
import com.kingdee.eas.scm.sd.sale.IPostRequisition;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.PostRequisitionCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractPostRequisitionEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PostRequisitionEntryControllerBean
extends AbstractPostRequisitionEntryControllerBean {
    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.scm.common.app.bizprocess.xml.postrequisitionentryconfig";
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, IObjectValue reasonCode) throws BOSException, EASBizException {
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        PostRequisitionInfo postRequisitionInfo = null;
        IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance(ctx);
        this.isFreezed(ctx, pks);
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            postRequisitionEntryInfo = this.getPostRequisitionEntryInfo(ctx, pks[i]);
            postRequisitionEntryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            postRequisitionEntryInfo.setReason(((ReasonCodeInfo)reasonCode).getName());
            this.update(ctx, pks[i], (CoreBaseInfo)postRequisitionEntryInfo);
            postRequisitionInfo = iPostRequisition.getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(postRequisitionEntryInfo.getParent().getId()));
            this.updatePostRequisition(ctx, postRequisitionInfo, EntryBaseStatusEnum.BLOCKED);
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, String reason) throws BOSException, EASBizException {
        int i;
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        PostRequisitionInfo postRequisitionInfo = null;
        PostRequisitionEntryCollection entryColl = null;
        String tableName = "T_SD_PostRequisitionEntry";
        HashSet<String> entryIdSet = new HashSet<String>();
        int c = pks.length;
        for (int i2 = 0; i2 < c; ++i2) {
            entryIdSet.add(pks[i2].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("seq");
        sic.add("baseStatus");
        sic.add("qty");
        sic.add("parent.id");
        sic.add("parent.baseStatus");
        sic.add("number");
        view.setSelector(sic);
        PostRequisitionEntryCollection coll = this.getPostRequisitionEntryCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet<String> billIdSet = new HashSet<String>();
        int size = coll.size();
        for (int i3 = 0; i3 < size; ++i3) {
            postRequisitionEntryInfo = coll.get(i3);
            billIdSet.add(postRequisitionEntryInfo.getParent().getId().toString());
        }
        if (billIdSet.size() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance(ctx);
        PostRequisitionCollection billColl = iPostRequisition.getPostRequisitionCollection(viewInfo);
        HashMap<String, PostRequisitionInfo> billMap = new HashMap<String, PostRequisitionInfo>();
        int size2 = billColl.size();
        for (i = 0; i < size2; ++i) {
            postRequisitionInfo = billColl.get(i);
            billMap.put(postRequisitionInfo.getId().toString(), postRequisitionInfo);
        }
        size2 = coll.size();
        for (i = 0; i < size2; ++i) {
            postRequisitionEntryInfo = coll.get(i);
            postRequisitionInfo = (PostRequisitionInfo)billMap.get(postRequisitionEntryInfo.getParent().getId().toString());
            this.isFreezed(postRequisitionInfo, postRequisitionEntryInfo, this.checkSaleIssue(ctx, postRequisitionEntryInfo.getId().toString(), false), i + 1);
        }
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            for (Map.Entry entry : flowMap.entrySet()) {
                postRequisitionInfo = (PostRequisitionInfo)billMap.get(entry.getValue());
                if (postRequisitionInfo == null) continue;
                entryColl = (PostRequisitionEntryCollection)((Object)postRequisitionInfo.getEntries().clone());
                postRequisitionInfo.getEntries().clear();
                int size3 = entryColl.size();
                for (int i4 = 0; i4 < size3; ++i4) {
                    postRequisitionEntryInfo = entryColl.get(i4);
                    if (!flowMap.containsKey(postRequisitionEntryInfo.getId().toString())) continue;
                    postRequisitionInfo.getEntries().add(postRequisitionEntryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)postRequisitionInfo, (BatchActionEnum)BatchActionEnum.FREEZE);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableName).append(" set FBaseStatus = 6,FReason ='").append(reason).append("' where fid in ");
        sql.append(SCMServerUtils.getInStringFromSet(entryIdSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentId = SCMServerUtils.getInStringFromSet(billIdSet);
        sql.append("update T_SD_PostRequisition Set FBaseStatus = 6 where FID in ").append(parentId);
        sql.append(" and fid not in (select fparentid from ").append(tableName).append(" where fbasestatus<>6 and fparentid in");
        sql.append(parentId).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, String resonCode) throws BOSException, EASBizException {
        this._freezed(ctx, new IObjectPK[]{pk}, resonCode);
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, IObjectValue reason) throws BOSException, EASBizException {
        this._freezed(ctx, new IObjectPK[]{pk}, reason);
    }

    private void updatePostRequisition(Context ctx, PostRequisitionInfo postRequisitionInfo, EntryBaseStatusEnum baseStatusEnum) throws BOSException, EASBizException {
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        int count = 0;
        int c = postRequisitionInfo.getEntries().size();
        for (int i = 0; i < c; ++i) {
            postRequisitionEntryInfo = postRequisitionInfo.getEntries().get(i);
            if (!postRequisitionEntryInfo.getBaseStatus().equals((Object)baseStatusEnum)) continue;
            ++count;
        }
        if (baseStatusEnum.equals((Object)EntryBaseStatusEnum.BLOCKED)) {
            if (count == postRequisitionInfo.getEntries().size()) {
                postRequisitionInfo.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            }
        } else if (baseStatusEnum.equals((Object)EntryBaseStatusEnum.AUDITED)) {
            postRequisitionInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        }
        IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance(ctx);
        iPostRequisition.update((IObjectPK)new ObjectUuidPK(postRequisitionInfo.getId()), (CoreBaseInfo)postRequisitionInfo);
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        PostRequisitionInfo postRequisitionInfo = null;
        PostRequisitionEntryCollection entryColl = null;
        String tableName = "T_SD_PostRequisitionEntry";
        HashSet<String> entryIdSet = new HashSet<String>();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            entryIdSet.add(pks[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("seq");
        sic.add("baseStatus");
        sic.add("qty");
        sic.add("parent.id");
        sic.add("parent.baseStatus");
        sic.add("number");
        view.setSelector(sic);
        PostRequisitionEntryCollection coll = this.getPostRequisitionEntryCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            postRequisitionEntryInfo = coll.get(i);
            this.isUnFreezed(postRequisitionEntryInfo, i + 1);
        }
        HashSet<String> billIdSet = new HashSet<String>();
        int size2 = coll.size();
        for (int i = 0; i < size2; ++i) {
            postRequisitionEntryInfo = coll.get(i);
            billIdSet.add(postRequisitionEntryInfo.getParent().getId().toString());
        }
        if (billIdSet.size() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance(ctx);
        PostRequisitionCollection billColl = iPostRequisition.getPostRequisitionCollection(viewInfo);
        HashMap<String, PostRequisitionInfo> billMap = new HashMap<String, PostRequisitionInfo>();
        int size3 = billColl.size();
        for (int i = 0; i < size3; ++i) {
            postRequisitionInfo = billColl.get(i);
            billMap.put(postRequisitionInfo.getId().toString(), postRequisitionInfo);
        }
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            for (Map.Entry entry : flowMap.entrySet()) {
                postRequisitionInfo = (PostRequisitionInfo)billMap.get(entry.getValue());
                if (postRequisitionInfo == null) continue;
                entryColl = (PostRequisitionEntryCollection)((Object)postRequisitionInfo.getEntries().clone());
                postRequisitionInfo.getEntries().clear();
                int size4 = entryColl.size();
                for (int i = 0; i < size4; ++i) {
                    postRequisitionEntryInfo = entryColl.get(i);
                    if (!flowMap.containsKey(postRequisitionEntryInfo.getId().toString())) continue;
                    postRequisitionInfo.getEntries().add(postRequisitionEntryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)postRequisitionInfo, (BatchActionEnum)BatchActionEnum.UNFREEZE);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableName).append(" set FBaseStatus = 4,FReason ='',FReasonCodeID = ''").append(" where fid in ");
        sql.append(SCMServerUtils.getInStringFromSet(entryIdSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentId = SCMServerUtils.getInStringFromSet(billIdSet);
        sql.append("update T_SD_PostRequisition Set FBaseStatus = 4 where FID in ").append(parentId);
        sql.append(" and fid not in (select fparentid from ").append(tableName).append(" where fbasestatus = -2 and fparentid in");
        sql.append(parentId).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unFreezed(ctx, new IObjectPK[]{pk});
    }

    private void isFreezed(PostRequisitionInfo postRequisitionInfo, PostRequisitionEntryInfo postRequisitionEntryInfo, boolean isCreateBill, int i) throws BOSException, EASBizException {
        if (postRequisitionEntryInfo.getQty().compareTo(SysConstant.BIGZERO) < 0) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_FREEZE);
        }
        if (postRequisitionEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.ISFREEZED, new String[]{String.valueOf(postRequisitionEntryInfo.getSeq())});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.ISFREEZED, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
            throw new PostRequisitionException(PostRequisitionException.ISCLOSE, new String[]{String.valueOf(postRequisitionEntryInfo.getSeq())});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PostRequisitionException(PostRequisitionException.ISREVOKE, new String[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || postRequisitionInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTFREEZED, new String[]{postRequisitionInfo.getNumber()});
        }
    }

    private void isUnFreezed(PostRequisitionEntryInfo postRequisitionEntryInfo, int i) throws BOSException, EASBizException {
        if (!postRequisitionEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.BLOCKED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTUNFREEZED, new String[]{String.valueOf(postRequisitionEntryInfo.getSeq())});
        }
    }

    private boolean checkSaleIssue(Context ctx, String id, boolean isEntry) throws BOSException, EASBizException {
        boolean isCreatedBill = false;
        return isCreatedBill;
    }

    @Override
    protected void _isFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        PostRequisitionInfo postRequisitionInfo = null;
        IPostRequisition iPostRequisition = PostRequisitionFactory.getLocalInstance(ctx);
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            postRequisitionEntryInfo = this.getPostRequisitionEntryInfo(ctx, pks[i]);
            postRequisitionInfo = iPostRequisition.getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(postRequisitionEntryInfo.getParent().getId()));
            this.isFreezed(postRequisitionInfo, postRequisitionEntryInfo, this.checkSaleIssue(ctx, pks[i].toString(), false), i + 1);
        }
    }

    @Override
    protected void _isUnFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.isUnFreezed(this.getPostRequisitionEntryInfo(ctx, pks[i]), i + 1);
        }
    }

    @Override
    protected boolean _checkBusinessRule(Context ctx, String[] pks) throws BOSException, BizCheckException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT ");
        sqlBuff.append("A.FSeq AS FSeq, ");
        sqlBuff.append("A.FUnPrereceivedAmount AS FUnPrereceivedAmount ");
        sqlBuff.append(" FROM T_SD_SaleOrderEntry A  ");
        sqlBuff.append("WHERE A.FUnPrereceivedAmount > 0 ");
        sqlBuff.append("AND a.fid IN (").append(StringUtil.getKeyIdList((Object[])pks)).append(") ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            Object[] infoStr = new String[]{""};
            int errors = 0;
            while (rs.next()) {
                if (rs.getBigDecimal("FUnPrereceivedAmount").signum() != 1) continue;
                infoStr[0] = (String)infoStr[0] + "\n" + InvAppUtils.noStr + rs.getInt("FSeq") + InvAppUtils.rowStr + InvAppUtils.shortMoneyStr + rs.getBigDecimal("FUnPrereceivedAmount");
                ++errors;
            }
            if (errors > 0) {
                throw new BizCheckException(InvUpdateException.SALEORDER_UNPREPAYMENT_OVERZERO_4PR, infoStr);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static StringBuffer insertDelimit(String[] pks, String ch) {
        return new StringBuffer(StringUtil.getKeyIdList((Object[])pks));
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        IParamControl ipc;
        String paramvalue;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        PostRequisitionEntryInfo entryInfo = this.getPostRequisitionEntryInfo(ctx, pk, sic);
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTCLOSEDAUDIT, new String[]{entryInfo.getParent().getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        entryInfo.setReason(reason);
        this.update(ctx, pk, (CoreBaseInfo)entryInfo);
        IPostRequisition ipost = PostRequisitionFactory.getLocalInstance(ctx);
        PostRequisitionInfo info = ipost.getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
        int count = 0;
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            if (!info.getEntries().get(i).getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
            ++count;
        }
        if (count == info.getEntries().size()) {
            info.setBaseStatus(BillBaseStatusEnum.CLOSED);
            ipost.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        if (Boolean.valueOf(paramvalue = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005")).booleanValue()) {
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                if (entryInfo.getQty().compareTo(entryInfo.getShippedQty()) >= 0) {
                    sentryInfo.setTotalUnIssueQty(sentryInfo.getTotalUnIssueQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                    sentryInfo.setTotalUnIssueBaseQty(sentryInfo.getTotalUnIssueBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                    sentryInfo.setTotalUnShipBaseQty(sentryInfo.getTotalUnShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                    sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().subtract(entryInfo.getQty().subtract(entryInfo.getShippedQty()).subtract(entryInfo.getTotalReversedQty())));
                    sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                }
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
            } else if (entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
                TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                BigDecimal qty = entryInfo.getQty();
                BigDecimal shipQty = entryInfo.getShippedQty();
                BigDecimal baseQty = entryInfo.getBaseQty();
                BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
                if (qty.compareTo(shipQty) > 0) {
                    transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().subtract(qty.subtract(shipQty)));
                    transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().add(baseQty.subtract(baseShipQty)));
                    iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
                }
            }
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk.toString());
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.CLOSE);
    }

    public BatchActionResults batchClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        PostRequisitionInfo info = null;
        PostRequisitionEntryInfo entryInfo = null;
        PostRequisitionEntryCollection entryColl = null;
        BatchActionResults batchResults = this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
        Object[] idsArray = batchResults.getToDoIdsArray();
        Set idSet = batchResults.getToDoIdsSet();
        StringBuffer ids = new StringBuffer();
        int length = idsArray.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append(idsArray[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.baseStatus"));
        sic.add(new SelectorItemInfo("parent.saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillEntryId"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("shippedQty"));
        sic.add(new SelectorItemInfo("shippedBaseQty"));
        sic.add(new SelectorItemInfo("totalReversedQty"));
        sic.add(new SelectorItemInfo("totalReversedBaseQty"));
        view.setSelector(sic);
        PostRequisitionEntryCollection entryCol = this.getPostRequisitionEntryCollection(ctx, view);
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        int count = 0;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            if (entryInfo.getQty().compareTo(SysConstant.BIGZERO) >= 0) continue;
            ++count;
            break;
        }
        if (count > 0) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_CLOSE);
        }
        String tableName = "T_SD_PostRequisitionEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (Set)idSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            PostRequisitionCollection coll = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                int size2 = coll.size();
                for (int i = 0; i < size2; ++i) {
                    info = coll.get(i);
                    entryColl = (PostRequisitionEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        int size3 = entryCol.size();
        for (int i = 0; i < size3; ++i) {
            entryInfo = entryCol.get(i);
            if (flowMap != null && flowMap.size() > 0 && flowMap.containsKey(entryInfo.getId().toString())) continue;
            String saleOrgUnitId = entryInfo.getParent().getSaleOrgUnit().getId().toString();
            String paramvalue = paramValueMap.get(saleOrgUnitId) == null ? ipc.getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005") : (String)paramValueMap.get(saleOrgUnitId);
            paramValueMap.put(saleOrgUnitId, paramvalue);
            if (!Boolean.valueOf(paramvalue).booleanValue()) continue;
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                if (entryInfo.getQty().compareTo(entryInfo.getShippedQty()) >= 0) {
                    sentryInfo.setTotalUnIssueQty(sentryInfo.getTotalUnIssueQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                    sentryInfo.setTotalUnIssueBaseQty(sentryInfo.getTotalUnIssueBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                    sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().subtract(entryInfo.getQty().subtract(entryInfo.getShippedQty()).subtract(entryInfo.getTotalReversedQty())));
                    sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                    sentryInfo.setTotalUnShipBaseQty(sentryInfo.getTotalUnShipBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                }
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
                continue;
            }
            if (!entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) continue;
            ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
            TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
            BigDecimal qty = entryInfo.getQty();
            BigDecimal shipQty = entryInfo.getShippedQty();
            BigDecimal baseQty = entryInfo.getBaseQty();
            BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
            if (qty.compareTo(shipQty) <= 0) continue;
            transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().subtract(qty.subtract(shipQty)));
            transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().add(baseQty.subtract(baseShipQty)));
            iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
        }
        ArrayList<String> idList = new ArrayList<String>();
        int length2 = idsArray.length;
        for (int i = 0; i < length2; ++i) {
            idList.add(idsArray[i]);
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(idsArray, CreditOperationEnum.CLOSE);
        try {
            ReservationBillCloseService reservationBillCloseService = ReservationBillCloseService.getInstance();
            reservationBillCloseService.doBillReservationCancel(ctx, (String[])idsArray);
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return batchResults;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PostRequisitionEntryInfo info = (PostRequisitionEntryInfo)this.getValue(ctx, pk);
        PostRequisitionInfo sInfo = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IParamControl ipc;
        String paramvalue;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        PostRequisitionEntryInfo entryInfo = this.getPostRequisitionEntryInfo(ctx, pk, sic);
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
            throw new PostRequisitionException(PostRequisitionException.CANNOTUNCLOSEDAUDIT, new String[]{entryInfo.getParent().getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        entryInfo.setReason(null);
        this.update(ctx, pk, (CoreBaseInfo)entryInfo);
        IPostRequisition ipost = PostRequisitionFactory.getLocalInstance(ctx);
        PostRequisitionInfo info = ipost.getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            ipost.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        if (Boolean.valueOf(paramvalue = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005")).booleanValue()) {
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                if (entryInfo.getQty().compareTo(entryInfo.getShippedQty()) >= 0) {
                    sentryInfo.setTotalUnIssueQty(sentryInfo.getTotalUnIssueQty().subtract(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                    sentryInfo.setTotalUnIssueBaseQty(sentryInfo.getTotalUnIssueBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                    sentryInfo.setTotalUnShipBaseQty(sentryInfo.getTotalUnShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                    sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty()).subtract(entryInfo.getTotalReversedQty())));
                    sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                }
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
            } else if (entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
                TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                BigDecimal qty = entryInfo.getQty();
                BigDecimal shipQty = entryInfo.getShippedQty();
                BigDecimal baseQty = entryInfo.getBaseQty();
                BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
                if (qty.compareTo(shipQty) > 0) {
                    transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().add(qty.subtract(shipQty)));
                    transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().subtract(baseQty.subtract(baseShipQty)));
                    iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
                }
            }
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk.toString());
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.UNCLOSE);
    }

    public BatchActionResults batchUnClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        PostRequisitionInfo info = null;
        PostRequisitionEntryInfo entryInfo = null;
        PostRequisitionEntryCollection entryColl = null;
        BatchActionResults batchResults = this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
        Object[] idsArray = batchResults.getToDoIdsArray();
        Set idSet = batchResults.getToDoIdsSet();
        StringBuffer ids = new StringBuffer();
        int length = idsArray.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append(idsArray[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.baseStatus"));
        sic.add(new SelectorItemInfo("parent.saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillEntryId"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("shippedQty"));
        sic.add(new SelectorItemInfo("shippedBaseQty"));
        sic.add(new SelectorItemInfo("totalReversedQty"));
        sic.add(new SelectorItemInfo("totalReversedBaseQty"));
        view.setSelector(sic);
        PostRequisitionEntryCollection entryCol = this.getPostRequisitionEntryCollection(ctx, view);
        String tableName = "T_SD_PostRequisitionEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (Set)idSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            PostRequisitionCollection coll = PostRequisitionFactory.getLocalInstance(ctx).getPostRequisitionCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PostRequisitionEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            if (flowMap != null && flowMap.size() > 0 && flowMap.containsKey(entryInfo.getId().toString())) continue;
            String saleOrgUnitId = entryInfo.getParent().getSaleOrgUnit().getId().toString();
            String paramvalue = paramValueMap.get(saleOrgUnitId) == null ? ipc.getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005") : (String)paramValueMap.get(saleOrgUnitId);
            paramValueMap.put(saleOrgUnitId, paramvalue);
            if (!Boolean.valueOf(paramvalue).booleanValue()) continue;
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                if (entryInfo.getQty().compareTo(entryInfo.getShippedQty()) >= 0) {
                    sentryInfo.setTotalUnIssueQty(sentryInfo.getTotalUnIssueQty().subtract(entryInfo.getQty().subtract(entryInfo.getShippedQty())));
                    sentryInfo.setTotalUnIssueBaseQty(sentryInfo.getTotalUnIssueBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty())));
                    sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty()).subtract(entryInfo.getTotalReversedQty())));
                    sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                    sentryInfo.setTotalUnShipBaseQty(sentryInfo.getTotalUnShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                }
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
                continue;
            }
            if (!entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) continue;
            ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
            TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
            BigDecimal qty = entryInfo.getQty();
            BigDecimal shipQty = entryInfo.getShippedQty();
            BigDecimal baseQty = entryInfo.getBaseQty();
            BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
            if (qty.compareTo(shipQty) <= 0) continue;
            transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().add(qty.subtract(shipQty)));
            transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().subtract(baseQty.subtract(baseShipQty)));
            iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
        }
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(idsArray, CreditOperationEnum.UNCLOSE);
        return batchResults;
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] pks, String[] reason) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this._close(ctx, pks[i], reason[i]);
        }
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this._unClose(ctx, pks[i]);
        }
    }

    @Override
    protected void _updateOrderByPostRequisition(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append(pks[i].toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        view.setSelector(sic);
        PostRequisitionEntryCollection entryCol = this.getPostRequisitionEntryCollection(ctx, view);
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            PostRequisitionEntryInfo entryInfo = entryCol.get(i);
            String saleOrgUnitId = entryInfo.getParent().getSaleOrgUnit().getId().toString();
            String paramvalue = paramValueMap.get(saleOrgUnitId) == null ? ipc.getParamValue((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getSaleOrgUnit().getId()), "SALEORDER005") : (String)paramValueMap.get(saleOrgUnitId);
            paramValueMap.put(saleOrgUnitId, paramvalue);
            if (!Boolean.valueOf(paramvalue).booleanValue()) continue;
            if (entryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                if (!EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus())) continue;
                ISaleOrderEntry isale = SaleOrderEntryFactory.getLocalInstance(ctx);
                SaleOrderEntryInfo sentryInfo = isale.getSaleOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
                if (entryInfo.getQty().compareTo(entryInfo.getShippedQty()) >= 0) {
                    sentryInfo.setTotalShippingQty(sentryInfo.getTotalShippingQty().add(entryInfo.getQty().subtract(entryInfo.getShippedQty()).subtract(entryInfo.getTotalReversedQty())));
                    sentryInfo.setTotalShipBaseQty(sentryInfo.getTotalShipBaseQty().add(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                    sentryInfo.setTotalUnShipBaseQty(sentryInfo.getTotalUnShipBaseQty().subtract(entryInfo.getBaseQty().subtract(entryInfo.getShippedBaseQty()).subtract(entryInfo.getTotalReversedBaseQty())));
                }
                isale.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)sentryInfo);
                continue;
            }
            if (!entryInfo.getSourceBillType().getId().toString().equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=") || !EntryBaseStatusEnum.CLOSED.equals((Object)entryInfo.getBaseStatus())) continue;
            ITransferOrderBillEntry iTransfer = TransferOrderBillEntryFactory.getLocalInstance((Context)ctx);
            TransferOrderBillEntryInfo transferEntryInfo = iTransfer.getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()));
            BigDecimal qty = entryInfo.getQty();
            BigDecimal shipQty = entryInfo.getShippedQty();
            BigDecimal baseQty = entryInfo.getBaseQty();
            BigDecimal baseShipQty = entryInfo.getShippedBaseQty();
            if (qty.compareTo(shipQty) <= 0) continue;
            transferEntryInfo.setTotalIssueQty(transferEntryInfo.getTotalIssueQty().add(qty.subtract(shipQty)));
            transferEntryInfo.setUnIssueBaseQty(transferEntryInfo.getUnIssueBaseQty().subtract(baseQty.subtract(baseShipQty)));
            iTransfer.update((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), (CoreBaseInfo)transferEntryInfo);
        }
    }
}

