/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectTypeFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.PriceCompDetailEnum;
import com.kingdee.eas.basedata.scm.common.PriceCompositionEnum;
import com.kingdee.eas.basedata.scm.sd.sale.CheckedStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPricePolicy;
import com.kingdee.eas.basedata.scm.sd.sale.IPricePolicyEntry;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCompositionInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.IPricePolicyAdjust;
import com.kingdee.eas.scm.sd.sale.IPricePolicyAdjustEntry;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustEntryCollection;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustEntryFactory;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustEntryInfo;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustException;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustFactory;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractPricePolicyAdjustControllerBean;
import com.kingdee.eas.scm.sd.sale.util.PricePolicyAdjustUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PricePolicyAdjustControllerBean
extends AbstractPricePolicyAdjustControllerBean {
    private static final long serialVersionUID = -4196005090985635204L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.PricePolicyAdjustControllerBean");
    private static final String RESOURCE_PPA = "com.kingdee.eas.scm.sd.sale.PricePolicyAdjustResource";
    private static final String true_str = "1";
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    private PricePolicyAdjustUtil ppAu = new PricePolicyAdjustUtil();

    private void checkAll(Context ctx, PricePolicyAdjustInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.NUMBERISNULL);
        }
        this.checkNumber(ctx, info);
        this.checkIntegrity(info);
    }

    private short getPriceCompositionPriority(Context ctx, PriceCompositionEnum priceComp, String saleid) throws BOSException {
        IPriceParam pp = PriceParamFactory.getLocalInstance((Context)ctx);
        short priValue = -1;
        PriceParamInfo info = null;
        try {
            switch (priceComp.getValue()) {
                case 2: {
                    info = pp.getItemParameter(saleid, "PricePa014");
                    priValue = (short)info.getCusMatPri();
                    break;
                }
                case 1: {
                    info = pp.getItemParameter(saleid, "PricePa016");
                    priValue = (short)info.getCusGrpMatPri();
                    break;
                }
                case 5: {
                    info = pp.getItemParameter(saleid, "PricePa015");
                    priValue = (short)info.getCusMatGrpPri();
                    break;
                }
                case 6: {
                    info = pp.getItemParameter(saleid, "PricePa017");
                    priValue = (short)info.getCusGrpMatGrpPri();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(this.getServerResource("failed_fetch_pricecomp", ctx));
        }
        return priValue;
    }

    private String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)RESOURCE_PPA, (String)key, (Context)ctx);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PricePolicyAdjustInfo pricePolicyAdjustInfo = (PricePolicyAdjustInfo)this.getValue(ctx, pk);
        return pricePolicyAdjustInfo.getNumber();
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PricePolicyAdjustInfo info = (PricePolicyAdjustInfo)model;
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        this.checkAll(ctx, info);
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        PricePolicyInfo info1 = info.getPricePolicy();
        info.setPriority(info1.getPriority());
        info.setPriceCompositionPriority(this.getPriceCompositionPriority(ctx, info.getPriceComposition(), info.getSaleOrgUnit().getId().toString()));
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        info.setId(BOSUuid.read((String)pk.toString()));
        IPricePolicyAdjustEntry ientry = PricePolicyAdjustEntryFactory.getLocalInstance(ctx);
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            PricePolicyAdjustEntryInfo entryInfo = info.getEntries().get(i);
            boolean canSave = true;
            if (entryInfo.getPolicyEntryID() != null) {
                canSave = this.checkCanSave(entryInfo);
            }
            if (!canSave) continue;
            if (info.getEntries().get(i).getId() == null) {
                info.getEntries().get(i).setParent(info);
                ientry.addnew((CoreBaseInfo)info.getEntries().get(i));
                continue;
            }
            ientry.update((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId()), (CoreBaseInfo)info.getEntries().get(i));
        }
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PricePolicyAdjustInfo info = (PricePolicyAdjustInfo)model;
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            PricePolicyAdjustEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getPolicyEntryID() != null || this.checkExistInPricepolicy(ctx, info, entryInfo)) continue;
            throw new PricePolicyAdjustException(PricePolicyAdjustException.REPEAT, new Object[]{i + 1 + ""});
        }
        IObjectPK pk = super._submit(ctx, model);
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        if (this.isParamOpen(ctx, info.getSaleOrgUnit().getId().toString())) {
            IObjectPK[] in = new IObjectPK[]{new ObjectUuidPK(info.getId())};
            this._audit(ctx, in);
        }
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PricePolicyAdjustInfo info = (PricePolicyAdjustInfo)model;
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        PricePolicyInfo info1 = info.getPricePolicy();
        info.setPriority(info1.getPriority());
        this.checkAll(ctx, info);
        info.setPriceCompositionPriority(this.getPriceCompositionPriority(ctx, info.getPriceComposition(), info.getSaleOrgUnit().getId().toString()));
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        IPricePolicyAdjustEntry ientry = PricePolicyAdjustEntryFactory.getLocalInstance(ctx);
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            PricePolicyAdjustEntryInfo entryInfo = info.getEntries().get(i);
            boolean canSave = true;
            if (entryInfo.getPolicyEntryID() != null) {
                canSave = this.checkCanSave(entryInfo);
            }
            if (!canSave) continue;
            if (info.getEntries().get(i).getId() == null) {
                info.getEntries().get(i).setParent(info);
                ientry.addnew((CoreBaseInfo)info.getEntries().get(i));
                continue;
            }
            ientry.update((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId()), (CoreBaseInfo)info.getEntries().get(i));
        }
        return pk;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException, PricePolicyAdjustException {
        int i;
        if (pks == null || pks.length <= 0) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.PKSISNULL);
        }
        PricePolicyAdjustInfo[] infos = new PricePolicyAdjustInfo[pks.length];
        int n = pks.length;
        for (i = 0; i < n; ++i) {
            infos[i] = (PricePolicyAdjustInfo)this._getValue(ctx, pks[i]);
            if (!ForbidStatusEnum.FORBID.equals((Object)infos[i].getBlockedStatus()) && !com.kingdee.eas.framework.CheckedStatusEnum.UNAUDITED.equals((Object)infos[i].getCheckedStatus())) continue;
            throw new PricePolicyAdjustException(PricePolicyAdjustException.CANNOTUNAUDIT);
        }
        int m = pks.length;
        for (i = 0; i < m; ++i) {
            infos[i].setAuditor(null);
            infos[i].setAuditDate(null);
            infos[i].setCheckedStatus(com.kingdee.eas.framework.CheckedStatusEnum.UNAUDITED);
            super._update(ctx, pks[i], (IObjectValue)infos[i]);
        }
    }

    @Override
    protected void _block(Context ctx, IObjectPK[] pks) throws BOSException {
    }

    @Override
    protected void _unBlock(Context ctx, IObjectPK[] pks) throws BOSException {
    }

    @Override
    protected ArrayList _getCustomerCollection(Context ctx, String groupStandardId, String parentId, boolean isCustomerGroup) throws BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _getCustomerCollection(Context ctx, HashMap params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String parentId = null;
        if (params.get("customerparentId") != null) {
            parentId = params.get("customerparentId").toString();
        }
        boolean isCustomerGroup = Boolean.valueOf(params.get("isCustomerGroup").toString());
        String groupStandardId = params.get("customergroupStandardId").toString();
        String saleorgId = null;
        String cuid = null;
        String strS4 = "";
        SaleOrgUnitInfo saleOrgInfo = null;
        if (params.get("saleorgid") != null) {
            saleorgId = params.get("saleorgid").toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isBizUnit"));
            sic.add(new SelectorItemInfo("cu.*"));
            saleOrgInfo = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitInfo((IObjectPK)new ObjectStringPK(saleorgId), sic);
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)saleOrgInfo.getCU().getId().toString(), (String)saleOrgInfo.getCU().getLongNumber());
            StringBuffer buffS4 = new StringBuffer();
            filterInfoCU.output(buffS4);
            cuid = saleOrgInfo.getCU().getId().toString();
            strS4 = this.formatInputStrWithEntityProperty(ctx, buffS4.toString(), "7A2569A2", "CU.");
        }
        String localeFix = ctx.getLocale().toString();
        if (cuid != null) {
            cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        if (isCustomerGroup) {
            sql.append("select csspgroup.fid as id ,csspgroup.FName_").append(localeFix).append(" as name,csspgroup.FNumber as number1,csspgroup.FIsLeaf as isLeaf,0 as customerType,csspgroup.FLongNumber longnumber1 from t_bd_csspgroup csspgroup ").append(" inner join T_ORG_CtrlUnit CU on CU.fid = csspgroup.FControlUnitID ").append("  where csspgroup.FDeletedStatus =1 and  csspgroup.FCSSPGroupStandardID = '").append(groupStandardId).append("'");
            if (parentId == null) {
                sql.append(" and csspgroup.FParentId is null ");
            } else {
                sql.append(" and csspgroup.FParentId = '").append(parentId).append("'");
            }
            if (strS4 != null && !strS4.equals("")) {
                sql.append(" and " + strS4);
            }
            sql.append("order by number1");
        } else {
            sql.append("select csspgroup.fid as id ,csspgroup.FName_").append(localeFix).append(" as name,csspgroup.FNumber as number1,csspgroup.FIsLeaf as isLeaf,0 as customerType,csspgroup.FLongNumber longnumber1 from t_bd_csspgroup csspgroup ").append(" inner join T_ORG_CtrlUnit CU on CU.fid = csspgroup.FControlUnitID ").append("  where csspgroup.FDeletedStatus =1 and  csspgroup.FCSSPGroupStandardID = '").append(groupStandardId).append("'");
            if (parentId == null) {
                sql.append(" and csspgroup.FParentId is null ");
                if (strS4 != null && !strS4.equals("")) {
                    sql.append(" and " + strS4);
                }
            } else {
                String strD = "";
                try {
                    strD = this.getCustomerDFilter(cuid, ctx);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                sql.append(" and csspgroup.FParentId = '").append(parentId).append("'");
                if (strS4 != null && !strS4.equals("")) {
                    sql.append(" and " + strS4);
                }
                sql.append(" union ");
                sql.append(" select a.fid as id,a.FName_").append(localeFix).append(" as name,a.FNumber as number1, 1 as isLeaf,1 as customerType ,null as longnumber1 from T_BD_Customer a ").append(" inner join T_BD_CustomerGroupDetail b on a.FID = b.FCustomerID ");
                if (saleOrgInfo != null && saleOrgInfo.isIsBizUnit()) {
                    sql.append(" inner join T_BD_CustomerSaleInfo customersale on customersale.fcustomerid = a.fid ");
                }
                sql.append(" inner join T_ORG_CtrlUnit adminCU on adminCU.fid = a.FAdminCUId").append(" where b.FCustomerGroupStandardID = '").append(groupStandardId).append("'").append(" and b.FCustomerGroupID = '").append(parentId).append("' ");
                if (saleorgId != null && saleOrgInfo.isIsBizUnit()) {
                    sql.append(" and customersale.FSaleOrgID = '").append(saleorgId).append("' ");
                }
                if (strD != null && !strD.equals("")) {
                    sql.append(" and " + strD);
                }
                sql.append(" order by number1");
            }
        }
        IRowSet rs = null;
        ArrayList<PriceCompositionInfo> result = new ArrayList<PriceCompositionInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            PriceCompositionInfo info = null;
            while (rs.next()) {
                info = new PriceCompositionInfo();
                info.setId(rs.getString("id"));
                String tmp = rs.getString("isLeaf");
                if (true_str.equals(tmp)) {
                    info.setIsLeaf(true);
                } else {
                    info.setIsLeaf(false);
                }
                tmp = rs.getString("customerType");
                if (true_str.equals(tmp)) {
                    info.setCompType(PriceCompDetailEnum.CUSTOMER);
                    info.setIsCustomerGroup(false);
                } else {
                    info.setCompType(PriceCompDetailEnum.CUSTOMERGROUP);
                    info.setIsCustomerGroup(true);
                    info.setGroupLongnumber(rs.getString("longnumber1"));
                }
                info.setName(rs.getString("name"));
                info.setNumber(rs.getString("number1"));
                result.add(info);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _getMaterialCollection(Context ctx, String parentId, boolean isMaterialGroup) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String cuLongNumber = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        PriceCompDetailEnum compType = PriceCompDetailEnum.CUSTOMER;
        String localeFix = ctx.getLocale().toString();
        if (isMaterialGroup) {
            sql.append("select fid as id ,FName_").append(localeFix).append(" as name,FNumber as number1,FIsLeaf as isLeaf,0 as materialType from T_BD_MaterialGroup ").append(" where  FDeletedStatus =1 ");
            if (parentId == null) {
                sql.append(" and FParentId is null ");
            } else {
                sql.append(" and FParentId = '").append(parentId).append("'");
            }
            compType = PriceCompDetailEnum.MATERIALGROUP;
        } else {
            sql.append("select fid as id ,FName_").append(localeFix).append(" as name,FNumber as number1,FIsLeaf as isLeaf,0 as materialType  from T_BD_MaterialGroup ").append(" where  FDeletedStatus = 1 ");
            if (parentId == null) {
                sql.append(" and FParentId is null ");
            } else {
                sql.append(" and FParentId = '").append(parentId).append("'");
                sql.append(" union ");
                sql.append("select a.fid as id ,a.FName_").append(localeFix).append(" as name,a.FNumber as number1,1 as isLeaf,1 as materialType from T_BD_Material a, ").append(this.getCuTableName()).append(" b").append(" where FMaterialGroupID = '").append(parentId).append("'").append(" and ").append(this.getS4Filter("b", "FControlUnitID", cuid, cuLongNumber));
            }
            compType = PriceCompDetailEnum.MATERIAL;
        }
        IRowSet rs = null;
        ArrayList<PriceCompositionInfo> result = new ArrayList<PriceCompositionInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            PriceCompositionInfo info = null;
            while (rs.next()) {
                info = new PriceCompositionInfo();
                info.setId(rs.getString("id"));
                String tmp = rs.getString("isLeaf");
                if (true_str.equals(tmp)) {
                    info.setIsLeaf(true);
                } else {
                    info.setIsLeaf(false);
                }
                tmp = rs.getString("materialType");
                if (true_str.equals(tmp)) {
                    info.setCompType(PriceCompDetailEnum.MATERIAL);
                    info.setIsCustomerGroup(false);
                } else {
                    info.setCompType(PriceCompDetailEnum.MATERIALGROUP);
                    info.setIsCustomerGroup(true);
                }
                info.setName(rs.getString("name"));
                info.setNumber(rs.getString("number1"));
                result.add(info);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArrayList _getMaterialCollection(Context ctx, HashMap params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String parentId = null;
        if (params.get("materialparentId") != null) {
            parentId = params.get("materialparentId").toString();
        }
        boolean isMaterialGroup = Boolean.valueOf(params.get("isMaterialGroup").toString());
        String saleOrgId = null;
        if (params.get("saleorgid") != null) {
            saleOrgId = params.get("saleorgid").toString();
        }
        String saleorgId = null;
        String strS4 = "";
        String cuid = null;
        SaleOrgUnitInfo saleOrgInfo = null;
        if (params.get("saleorgid") != null) {
            saleorgId = params.get("saleorgid").toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("cu.*"));
            saleOrgInfo = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitInfo((IObjectPK)new ObjectStringPK(saleorgId), sic);
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)saleOrgInfo.getCU().getId().toString(), (String)saleOrgInfo.getCU().getLongNumber());
            StringBuffer buffS4 = new StringBuffer();
            filterInfoCU.output(buffS4);
            strS4 = this.formatInputStrWithEntityProperty(ctx, buffS4.toString(), "C79FC042", "CU.");
            cuid = saleOrgInfo.getCU().getId().toString();
        }
        PriceCompDetailEnum compType = PriceCompDetailEnum.CUSTOMER;
        if (cuid != null) {
            cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        String localeFix = ctx.getLocale().toString();
        if (isMaterialGroup) {
            sql.append("select materialgroup.fid as id ,materialgroup.FName_").append(localeFix).append(" as name,materialgroup.FNumber as number1,materialgroup.FIsLeaf as isLeaf,0 as materialType ").append(" from T_BD_MaterialGroup materialgroup ").append(" inner join T_ORG_CtrlUnit CU on CU.fid = materialgroup.FControlUnitID ").append(" where materialgroup.FDeletedStatus =1 ");
            if (parentId == null) {
                sql.append(" and materialgroup.FParentId is null ");
            } else {
                sql.append(" and materialgroup.FParentId = '").append(parentId).append("'");
            }
            if (strS4 != null && !strS4.equals("")) {
                sql.append(" and " + strS4);
            }
            compType = PriceCompDetailEnum.MATERIALGROUP;
            sql.append("order by number1");
        } else {
            sql.append("select materialgroup.fid as id ,materialgroup.FName_").append(localeFix).append(" as name,materialgroup.FNumber as number1,materialgroup.FIsLeaf as isLeaf,0 as materialType ").append("  from T_BD_MaterialGroup materialgroup ").append(" inner join T_ORG_CtrlUnit CU on CU.fid = materialgroup.FControlUnitID ").append(" where materialgroup.FDeletedStatus = 1 ");
            if (parentId == null) {
                sql.append(" and materialgroup.FParentId is null ");
                if (strS4 != null && !strS4.equals("")) {
                    sql.append(" and " + strS4);
                }
            } else {
                String strD = "";
                try {
                    strD = this.getMaterialDFilter(cuid, ctx);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                sql.append(" and materialgroup.FParentId = '").append(parentId).append("'");
                if (strS4 != null && !strS4.equals("")) {
                    sql.append(" and " + strS4);
                }
                sql.append(" union ");
                sql.append("select a.fid as id ,a.FName_").append(localeFix).append(" as name,a.FNumber as number1,1 as isLeaf,1 as materialType from T_BD_Material a ").append(" inner join T_BD_MaterialGroup b on b.fid = a.FMaterialGroupID ").append(" inner join T_ORG_CtrlUnit adminCU on adminCU.fid = a.FAdminCUId");
                if (saleOrgInfo != null && saleOrgInfo.isIsBizUnit()) {
                    sql.append(" inner join T_BD_MaterialSales msale on msale.FMaterialID = a.fid ");
                }
                sql.append(" where b.fid = '").append(parentId).append("'");
                if (saleorgId != null && saleOrgInfo.isIsBizUnit()) {
                    sql.append(" and msale.FOrgUnit = '").append(saleorgId).append("' ");
                }
                if (strD != null && !strD.equals("")) {
                    sql.append(" and " + strD);
                }
            }
            compType = PriceCompDetailEnum.MATERIAL;
            sql.append(" order by number1");
        }
        IRowSet rs = null;
        ArrayList<PriceCompositionInfo> result = new ArrayList<PriceCompositionInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            PriceCompositionInfo info = null;
            while (rs.next()) {
                info = new PriceCompositionInfo();
                info.setId(rs.getString("id"));
                String tmp = rs.getString("isLeaf");
                if (true_str.equals(tmp)) {
                    info.setIsLeaf(true);
                } else {
                    info.setIsLeaf(false);
                }
                tmp = rs.getString("materialType");
                if (true_str.equals(tmp)) {
                    info.setCompType(PriceCompDetailEnum.MATERIAL);
                    info.setIsCustomerGroup(false);
                } else {
                    info.setCompType(PriceCompDetailEnum.MATERIALGROUP);
                    info.setIsCustomerGroup(true);
                }
                info.setName(rs.getString("name"));
                info.setNumber(rs.getString("number1"));
                result.add(info);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    @Override
    protected IObjectCollection _getPriceEntrys(Context ctx, PriceCompDetailEnum priceCompDetail, PriceCompositionInfo priceCompositionInfo, Map params) throws BOSException, EASBizException {
        PriceCompDetailEnum detailEnumInfo;
        SorterItemInfo sort;
        FilterInfo tmpFilter;
        PricePolicyAdjustEntryCollection collection = null;
        ICSSPGroup icsspgroup = CSSPGroupFactory.getLocalInstance((Context)ctx);
        IMaterialGroup imaterialgroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
        IPricePolicyAdjustEntry ipriceentry = PricePolicyAdjustEntryFactory.getLocalInstance(ctx);
        String databaseid = null;
        boolean isIncluded = (Boolean)params.get("isincluded");
        String csspgroupstandardid = params.get("customergroupStandardId").toString();
        EntityViewInfo view = new EntityViewInfo();
        if (isIncluded) {
            databaseid = priceCompositionInfo.getId();
            if (PriceCompDetailEnum.CUSTOMER.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                boolean isgroup = priceCompositionInfo.isCustomerGroup();
                if (params.get("saleorgid") instanceof SaleOrgUnitInfo) {
                    if (isgroup) {
                        String customerids = this._getCustomerIds(ctx, databaseid, csspgroupstandardid, (SaleOrgUnitInfo)params.get("saleorgid"));
                        if (!customerids.equals("")) {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerids, CompareType.INNER));
                        } else {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
                        }
                    } else {
                        tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)databaseid, CompareType.EQUALS));
                    }
                    view.setFilter(tmpFilter);
                }
            } else if (PriceCompDetailEnum.MATERIAL.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                boolean isgroup = priceCompositionInfo.isCustomerGroup();
                if (params.get("saleorgid") instanceof SaleOrgUnitInfo) {
                    if (isgroup) {
                        String materialids = this._getMaterialIds(ctx, databaseid, null, (SaleOrgUnitInfo)params.get("saleorgid"));
                        if (!materialids.equals("")) {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialids, CompareType.INNER));
                        } else {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
                        }
                    } else {
                        tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)databaseid, CompareType.EQUALS));
                    }
                    view.setFilter(tmpFilter);
                }
            } else if (PriceCompDetailEnum.CUSTOMERGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                if (databaseid != null) {
                    CSSPGroupInfo groupInfo = icsspgroup.getCSSPGroupInfo((IObjectPK)new ObjectStringPK(databaseid));
                    tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)(groupInfo.getLongNumber() + "%"), CompareType.LIKE));
                } else {
                    tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)"%", CompareType.LIKE));
                }
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIALGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                if (databaseid != null) {
                    MaterialGroupInfo groupInfo = imaterialgroup.getMaterialGroupInfo((IObjectPK)new ObjectStringPK(databaseid));
                    tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)(groupInfo.getLongNumber() + "%"), CompareType.LIKE));
                } else {
                    tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)"%", CompareType.LIKE));
                }
                view.setFilter(tmpFilter);
            }
        } else {
            databaseid = priceCompositionInfo.getId();
            if (PriceCompDetailEnum.CUSTOMER.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIAL.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.CUSTOMERGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIALGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            }
        }
        String pricepolicyid = null;
        if (params.get("pricepolicyid") != null) {
            pricepolicyid = params.get("pricepolicyid").toString();
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)pricepolicyid, CompareType.EQUALS));
        if (params.get("pricepolicy_customercomp") instanceof PriceCompDetailEnum && (sort = this.getSortItemInfo(detailEnumInfo = (PriceCompDetailEnum)params.get("pricepolicy_customercomp"))) != null) {
            view.getSorter().add(sort);
        }
        if (params.get("pricepolicy_materialcomp") instanceof PriceCompDetailEnum && (sort = this.getSortItemInfo(detailEnumInfo = (PriceCompDetailEnum)params.get("pricepolicy_materialcomp"))) != null) {
            view.getSorter().add(sort);
        }
        collection = this.getPricePolicyEntryCollection(ipriceentry, view);
        return collection;
    }

    @Override
    protected Map _getPriceParam(Context ctx, String saleorgid) throws BOSException {
        return null;
    }

    private String getCustomerDFilter(String cuid, Context ctx) throws Exception {
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(cuid);
        FilterInfo filterInfoD = null;
        StringBuffer buffD = new StringBuffer();
        String strD = "";
        filterInfoD = iCustomer.getDatabaseDFilter((IObjectPK)pk, "a.FID", "a.FAdminCUID");
        if (filterInfoD != null) {
            filterInfoD.output(buffD);
        }
        strD = buffD.toString();
        return strD;
    }

    private PricePolicyAdjustEntryCollection getPricePolicyEntryCollection(IPricePolicyAdjustEntry ipriceentry, EntityViewInfo view) throws BOSException, EASBizException {
        PricePolicyAdjustEntryCollection collection = null;
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("priceType.number"));
        view.getSelector().add(new SelectorItemInfo("priceType.name"));
        view.getSelector().add(new SelectorItemInfo("material.*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.number"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.name"));
        view.getSelector().add(new SelectorItemInfo("customerGroup.number"));
        view.getSelector().add(new SelectorItemInfo("customerGroup.name"));
        view.getSelector().add(new SelectorItemInfo("customer.number"));
        view.getSelector().add(new SelectorItemInfo("customer.name"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.number"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.name"));
        view.getSelector().add(new SelectorItemInfo("asistProperty.number"));
        view.getSelector().add(new SelectorItemInfo("asistProperty.name"));
        collection = ipriceentry.getPricePolicyAdjustEntryCollection(view);
        return collection;
    }

    private SorterItemInfo getSortItemInfo(PriceCompDetailEnum detailEnumInfo) {
        SorterItemInfo sort = null;
        switch (detailEnumInfo.getValue()) {
            case 1: {
                sort = new SorterItemInfo("customer.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 2: {
                sort = new SorterItemInfo("customerGroup.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 4: {
                sort = new SorterItemInfo("materialGroup.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 3: {
                sort = new SorterItemInfo("material.number");
                sort.setSortType(SortType.ASCEND);
            }
        }
        return sort;
    }

    private String getMaterialDFilter(String cuid, Context ctx) throws Exception {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(cuid);
        FilterInfo filterInfoD = null;
        StringBuffer buffD = new StringBuffer();
        String strD = "";
        filterInfoD = iMaterial.getDatabaseDFilter((IObjectPK)pk, "a.FID", "a.FAdminCUID");
        if (filterInfoD != null) {
            filterInfoD.output(buffD);
        }
        strD = buffD.toString();
        return strD;
    }

    private String formatInputStrWithEntityProperty(Context ctx, String str, String bostype, String linkname) {
        IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = metaDataLoader.getEntity(BOSObjectTypeFactory.getBOSType((String)bostype));
        int n = entity.getInheritedProperties().size();
        for (int i = 0; i < n; ++i) {
            str = str.replaceAll(linkname + entity.getInheritedProperties().get(i).getName(), linkname + entity.getInheritedProperties().get(i).getMappingField().getName());
        }
        if (str != null && str.trim().equals("")) {
            str = null;
        }
        return str;
    }

    private String getCuTableName() {
        return "T_ORG_CtrlUnit";
    }

    private String getS4Filter(String tableAlias, String cuFieldName, String cuId, String cuLongNumber) {
        StringBuffer filter = new StringBuffer();
        filter.append(tableAlias).append(".").append(cuFieldName);
        if (cuLongNumber == null || cuLongNumber.equals("")) {
            return filter.append(" = ").append("'").append(cuId).append("'").toString();
        }
        String[] longNumberArray = cuLongNumber.split("!");
        int size = longNumberArray.length;
        if (size > 0) {
            filter.append(" in (").append("'").append(cuId).append("'");
        }
        for (int i = 0; i < size; ++i) {
            filter.append(",").append("'").append(longNumberArray[i]).append("'");
        }
        filter.append(")");
        return filter.toString();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (!this._isCanDelete(ctx, pk.toString())) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.PRICENOTDELETE);
        }
        PricePolicyAdjustInfo info = (PricePolicyAdjustInfo)this.getValue(ctx, pk);
        sql.append(" delete T_SD_PricePolicyAdjustEntry where FParentid = '").append(pk.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        super._delete(ctx, pk);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)info);
        if (iCodingRuleManager.getRuleStatus((IObjectValue)info, strCompanyID).isExist() && iCodingRuleManager.getRuleStatus((IObjectValue)info, strCompanyID).isUseIntermitNumber()) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, strCompanyID, info.getNumber());
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            super.delete(ctx, arrayPK[i]);
        }
    }

    @Override
    protected boolean _isCanDelete(Context ctx, String pricePolicyid) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)pricePolicyid));
        PricePolicyAdjustInfo pp = null;
        try {
            pp = (PricePolicyAdjustInfo)this.getValue(ctx, (IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return !BillBaseStatusEnum.AUDITED.equals((Object)pp.getBaseStatus());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PricePolicyAdjustInfo info = (PricePolicyAdjustInfo)model;
        info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        if (info.getBaseStatus().getValue() == 1 && ((PricePolicyAdjustInfo)this.getValue(ctx, pk)).getBaseStatus().getValue() == 2) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.SUBMITCANNOTSAVE);
        }
        this.checkAll(ctx, info);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        info.setPriceCompositionPriority(this.getPriceCompositionPriority(ctx, info.getPriceComposition(), info.getSaleOrgUnit().getId().toString()));
        IPricePolicyAdjustEntry ientry = PricePolicyAdjustEntryFactory.getLocalInstance(ctx);
        PricePolicyAdjustEntryInfo entryInfo = null;
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            entryInfo = info.getEntries().get(i);
            boolean canSave = true;
            if (entryInfo.getPolicyEntryID() != null) {
                canSave = this.checkCanSave(entryInfo);
            }
            if (!canSave) continue;
            if (info.getEntries().get(i).getId() == null) {
                info.getEntries().get(i).setParent(info);
                ientry.addnew((CoreBaseInfo)info.getEntries().get(i));
                continue;
            }
            ientry.update((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId()), (CoreBaseInfo)info.getEntries().get(i));
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkNumber(Context ctx, PricePolicyAdjustInfo info) throws BOSException, EASBizException {
        if (info.getNumber() == null || info.getNumber().equals("")) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.NUMBERISNULL);
        }
        this._checkNumberDup(ctx, info);
    }

    private void _checkNumberDup(Context ctx, PricePolicyAdjustInfo dataBaseInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getFilterForCheckNumber((CoreBillBaseInfo)dataBaseInfo) != null && this.getFilterForCheckNumber((CoreBillBaseInfo)dataBaseInfo).size() > 0) {
            filter.mergeFilter(this.getFilterForCheckNumber((CoreBillBaseInfo)dataBaseInfo), "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (ObjectBaseInfo)dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private String _getPropertyAlias(Context ctx, ObjectBaseInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    private void checkIntegrity(PricePolicyAdjustInfo info) throws EASBizException {
        if (info.getPriceCompDetailCustomer() == null) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.PRICECOMPDETAILCUSTOMERISNULL);
        }
        if (info.getPriceCompDetailmaterial() == null) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.PRICECOMPDETAILMATERIALISNULL);
        }
        if (info.getEffectiveDate() == null) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.EFFECTIVEDATEISNULL);
        }
        if (info.getExpireDate() == null) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.EXPIREDATEISNULL);
        }
    }

    protected boolean checkBusiEntryOnlyOne(Context ctx, PricePolicyAdjustInfo info, PricePolicyAdjustEntryInfo entryInfo) throws BOSException, EASBizException {
        boolean isExistEntryInfo = false;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        if (info.getId() != null) {
            filterItemInfo = new FilterItemInfo("parent", (Object)info.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemInfo);
        }
        String customer = null;
        String material = null;
        String customerGroup = null;
        String materialGroup = null;
        String priceType = null;
        String measureUnit = null;
        String asistProperty = null;
        String currency = null;
        int discountCondition = -1;
        BigDecimal qtyMin = null;
        BigDecimal qtyMax = null;
        BigDecimal amtMin = null;
        BigDecimal amtMax = null;
        Date effectiveDate = null;
        Date expireDate = null;
        if (entryInfo.getCustomer() != null) {
            customer = entryInfo.getCustomer().getId().toString();
        }
        if (entryInfo.getMaterial() != null) {
            material = entryInfo.getMaterial().getId().toString();
        }
        if (entryInfo.getCustomerGroup() != null) {
            customerGroup = entryInfo.getCustomerGroup().getId().toString();
        }
        if (entryInfo.getMaterialGroup() != null) {
            materialGroup = entryInfo.getMaterialGroup().getId().toString();
        }
        if (entryInfo.getPriceType() != null) {
            priceType = entryInfo.getPriceType().getId().toString();
        }
        if (entryInfo.getDiscountCondition() != null) {
            discountCondition = entryInfo.getDiscountCondition().getValue();
        }
        if (entryInfo.getMeasureUnit() != null) {
            measureUnit = entryInfo.getMeasureUnit().getId().toString();
        }
        if (entryInfo.getAsistProperty() != null) {
            asistProperty = entryInfo.getAsistProperty().getId().toString();
        }
        if (entryInfo.getCurrency() != null) {
            currency = entryInfo.getCurrency().getId().toString();
        }
        if (entryInfo.getNewQtyMin() != null) {
            qtyMin = entryInfo.getNewQtyMin();
        }
        if (entryInfo.getNewQtyMax() != null) {
            qtyMax = entryInfo.getNewQtyMax();
        }
        if (entryInfo.getNewAmountMin() != null) {
            amtMin = entryInfo.getNewAmountMin();
        }
        if (entryInfo.getNewAmountMax() != null) {
            amtMax = entryInfo.getNewAmountMax();
        }
        if (entryInfo.getNewEffectiveDate() != null) {
            effectiveDate = entryInfo.getNewEffectiveDate();
        }
        if (entryInfo.getNewExpireDate() != null) {
            expireDate = entryInfo.getNewExpireDate();
        }
        switch (info.getPriceComposition().getValue()) {
            case 1: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 9: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 2: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 7: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 5: {
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 8: {
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 6: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 10: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
            }
        }
        filterItemInfo = new FilterItemInfo("priceType", (Object)priceType, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("currency.id", (Object)currency, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("discountCondition", (Object)new Integer(discountCondition), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("qtyMin", (Object)qtyMin, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("qtyMax", (Object)qtyMax, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("amtMin", (Object)amtMax, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("amtMax", (Object)amtMax, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("effectiveDate", (Object)this.getFilterDate(effectiveDate, KEY_STARTDATE), CompareType.GREATER_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("effectiveDate", (Object)this.getFilterDate(effectiveDate, KEY_ENDDATE), CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("expireDate", (Object)this.getFilterDate(expireDate, KEY_STARTDATE), CompareType.GREATER_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("expireDate", (Object)this.getFilterDate(expireDate, KEY_ENDDATE), CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        CoreBaseCollection collection = PricePolicyAdjustEntryFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            PricePolicyAdjustEntryInfo tempInfo = (PricePolicyAdjustEntryInfo)collection.get(0);
            if (tempInfo != null) {
                isExistEntryInfo = true;
                entryInfo.setId(tempInfo.getId());
            } else {
                isExistEntryInfo = false;
            }
        } else {
            isExistEntryInfo = false;
        }
        return !isExistEntryInfo;
    }

    public String getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return DateTimeUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ObjectUuidPK[] pks = new ObjectUuidPK[]{pk};
        this._audit(ctx, (IObjectPK[])pks);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int i;
        if (pks == null || pks.length <= 0) {
            throw new PricePolicyAdjustException(PricePolicyAdjustException.PKSISNULL);
        }
        PricePolicyAdjustInfo[] infos = new PricePolicyAdjustInfo[pks.length];
        int n = pks.length;
        for (i = 0; i < n; ++i) {
            infos[i] = (PricePolicyAdjustInfo)this._getValue(ctx, pks[i]);
            if (infos[i].getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) continue;
            throw new PricePolicyAdjustException(PricePolicyAdjustException.SAVENOTAUDIT);
        }
        for (i = 0; i < n; ++i) {
            infos[i].setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            infos[i].setAuditDate(new Date());
            infos[i].setCheckedStatus(com.kingdee.eas.framework.CheckedStatusEnum.AUDITED);
            infos[i].setBaseStatus(BillBaseStatusEnum.AUDITED);
            this._update(ctx, pks[i], (IObjectValue)infos[i]);
            PricePolicyAdjustInfo info = infos[i];
            IPricePolicyAdjust iPricePoAdjust = PricePolicyAdjustFactory.getLocalInstance(ctx);
            PricePolicyAdjustInfo ppinfo = iPricePoAdjust.getPricePolicyAdjustInfo("select id,entries,policyEntryID,PricePolicy.id where id='" + info.getId().toString() + "'");
            PricePolicyAdjustEntryInfo ppEntryInfo = null;
            ppinfo.setPricePolicy(ppinfo.getPricePolicy());
            String policyEntryid = "";
            int j = ppinfo.getEntries().size();
            for (int k = 0; k < j; ++k) {
                policyEntryid = ppinfo.getEntries().get(k).getId().toString();
                ppEntryInfo = PricePolicyAdjustEntryFactory.getLocalInstance(ctx).getPricePolicyAdjustEntryInfo("select id,customer.id,customerGroup.id,material.id,materialGroup.id,newPrice,newPriceMax,newPriceMin,newAmountMax,newAmountMin,newQtyMax,newQtyMin,newSalePrice,newDiscount,disCondition,discountMode,ass,newSaleLeadTime,currency.id,newEffectiveDate,newExpireDate,measureUnit.id,priceType.id,policyEntryID where id='" + policyEntryid + "'");
                if (ppEntryInfo.getMaterial() != null && ppEntryInfo.getMaterial().getId() != null) {
                    ppEntryInfo.setMaterial(MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getMaterial().getId())));
                }
                if (ppEntryInfo.getCustomer() != null && ppEntryInfo.getCustomer().getId() != null) {
                    ppEntryInfo.setCustomer(CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getCustomer().getId())));
                }
                if (ppEntryInfo.getMaterialGroup() != null && ppEntryInfo.getMaterialGroup().getId() != null) {
                    ppEntryInfo.setMaterialGroup(MaterialGroupFactory.getLocalInstance((Context)ctx).getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getMaterialGroup().getId())));
                }
                if (ppEntryInfo.getCustomerGroup() != null && ppEntryInfo.getCustomerGroup().getId() != null) {
                    ppEntryInfo.setCustomerGroup(CSSPGroupFactory.getLocalInstance((Context)ctx).getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getCustomerGroup().getId())));
                }
                if (ppEntryInfo.getCurrency() != null && ppEntryInfo.getCurrency().getId() != null) {
                    ppEntryInfo.setCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getCurrency().getId())));
                }
                if (ppEntryInfo.getPriceType() instanceof PriceTypeInfo && ppEntryInfo.getPriceType().getId() != null) {
                    ppEntryInfo.setPriceType(PriceTypeFactory.getLocalInstance((Context)ctx).getPriceTypeInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getPriceType().getId())));
                }
                if (ppEntryInfo.getMeasureUnit() != null && ppEntryInfo.getMeasureUnit().getId() != null) {
                    ppEntryInfo.setMeasureUnit(MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getMeasureUnit().getId())));
                }
                if (ppEntryInfo.getMainSupp() instanceof SupplierInfo && ppEntryInfo.getMainSupp().getId() != null) {
                    ppEntryInfo.setMainSupp(SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(ppEntryInfo.getMainSupp().getId())));
                }
                this.updatePricePolicy(ctx, ppinfo, ppEntryInfo);
            }
        }
    }

    protected boolean checkExistInPricepolicy(Context ctx, PricePolicyAdjustInfo ppadjust, PricePolicyAdjustEntryInfo ppaEntryInfo) throws BOSException, EASBizException {
        IPricePolicy iPP = PricePolicyFactory.getLocalInstance((Context)ctx);
        PricePolicyInfo ppaInfoFull = ppadjust.getPricePolicy();
        PricePolicyEntryInfo ppeInfo = new PricePolicyEntryInfo();
        ppeInfo.setMaterial(ppaEntryInfo.getMaterial());
        ppeInfo.setCustomer(ppaEntryInfo.getCustomer());
        ppeInfo.setMaterialGroup(ppaEntryInfo.getMaterialGroup());
        ppeInfo.setCustomerGroup(ppaEntryInfo.getCustomerGroup());
        ppeInfo.setMeasureUnit(ppaEntryInfo.getMeasureUnit());
        ppeInfo.setAmtMax(ppaEntryInfo.getNewAmountMax());
        ppeInfo.setAmtMin(ppaEntryInfo.getNewAmountMin());
        ppeInfo.setPrice(ppaEntryInfo.getNewPrice());
        ppeInfo.setPriceMax(ppaEntryInfo.getNewPriceMax());
        ppeInfo.setPriceMin(ppaEntryInfo.getNewPriceMin());
        ppeInfo.setQtyMax(ppaEntryInfo.getNewQtyMax());
        ppeInfo.setQtyMin(ppaEntryInfo.getNewQtyMin());
        ppeInfo.setPriceType(ppaEntryInfo.getPriceType());
        ppeInfo.setAsistProperty(ppaEntryInfo.getAsistProperty());
        ppeInfo.setEffectiveDate(ppaEntryInfo.getNewEffectiveDate());
        ppeInfo.setExpireDate(ppaEntryInfo.getNewExpireDate());
        ppeInfo.setCurrency(ppaEntryInfo.getCurrency());
        ppeInfo.setDiscountCondition(ppaEntryInfo.getDiscountCondition());
        ppeInfo.setDiscountMode(ppaEntryInfo.getDiscountMode());
        return this.ppAu.checkBusiEntryOnlyOne(ctx, ppaInfoFull, ppeInfo);
    }

    protected void updatePricePolicy(Context ctx, PricePolicyAdjustInfo ppadjust, PricePolicyAdjustEntryInfo ppaEntryInfo) throws EASBizException, BOSException {
        IPricePolicyEntry ip = PricePolicyEntryFactory.getLocalInstance((Context)ctx);
        if (ppaEntryInfo.getPolicyEntryID() != null) {
            PricePolicyEntryInfo ppeInfo = ip.getPricePolicyEntryInfo((IObjectPK)new ObjectStringPK(ppaEntryInfo.getPolicyEntryID()));
            ppeInfo.setAmtMax(ppaEntryInfo.getNewAmountMax());
            ppeInfo.setAmtMin(ppaEntryInfo.getNewAmountMin());
            ppeInfo.setPrice(ppaEntryInfo.getNewPrice());
            ppeInfo.setPriceMax(ppaEntryInfo.getNewPriceMax());
            ppeInfo.setPriceMin(ppaEntryInfo.getNewPriceMin());
            ppeInfo.setQtyMax(ppaEntryInfo.getNewQtyMax());
            ppeInfo.setQtyMin(ppaEntryInfo.getNewQtyMin());
            ppeInfo.setEffectiveDate(ppaEntryInfo.getNewEffectiveDate());
            ppeInfo.setExpireDate(ppaEntryInfo.getNewExpireDate());
            ppeInfo.setDiscount(ppaEntryInfo.getNewDiscount());
            ppeInfo.setSaleLeadTime(ppaEntryInfo.getNewSaleLeadTime());
            ip.update((IObjectPK)new ObjectStringPK(ppaEntryInfo.getPolicyEntryID()), (CoreBaseInfo)ppeInfo);
        } else {
            PricePolicyEntryInfo ppeInfo = new PricePolicyEntryInfo();
            ppeInfo.setMaterial(ppaEntryInfo.getMaterial());
            ppeInfo.setCustomer(ppaEntryInfo.getCustomer());
            ppeInfo.setMaterialGroup(ppaEntryInfo.getMaterialGroup());
            ppeInfo.setCustomerGroup(ppaEntryInfo.getCustomerGroup());
            ppeInfo.setAmtMax(ppaEntryInfo.getNewAmountMax());
            ppeInfo.setAmtMin(ppaEntryInfo.getNewAmountMin());
            ppeInfo.setPrice(ppaEntryInfo.getNewPrice());
            ppeInfo.setPriceMax(ppaEntryInfo.getNewPriceMax());
            ppeInfo.setPriceMin(ppaEntryInfo.getNewPriceMin());
            ppeInfo.setQtyMax(ppaEntryInfo.getNewQtyMax());
            ppeInfo.setQtyMin(ppaEntryInfo.getNewQtyMin());
            ppeInfo.setPriceType(ppaEntryInfo.getPriceType());
            ppeInfo.setAsistProperty(ppaEntryInfo.getAsistProperty());
            ppeInfo.setEffectiveDate(ppaEntryInfo.getNewEffectiveDate());
            ppeInfo.setExpireDate(ppaEntryInfo.getNewExpireDate());
            ppeInfo.setCurrency(ppaEntryInfo.getCurrency());
            ppeInfo.setDiscountCondition(ppaEntryInfo.getDiscountCondition());
            ppeInfo.setDiscount(ppaEntryInfo.getNewDiscount() != null ? ppaEntryInfo.getNewDiscount() : SCMConstant.BIGDECIMAL_ZERO);
            ppeInfo.setMeasureUnit(ppaEntryInfo.getMeasureUnit());
            ppeInfo.setDiscountMode(ppaEntryInfo.getDiscountMode());
            ppeInfo.setSaleLeadTime(ppaEntryInfo.getNewSaleLeadTime());
            ppeInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
            ppeInfo.setParent(ppadjust.getPricePolicy());
            ip.addnew((CoreBaseInfo)ppeInfo);
        }
    }

    @Override
    protected Set _getIdSetByNumber(Context ctx, String beginNumber, String endNumber) throws BOSException {
        if (StringUtil.isEmptyString((String)beginNumber) || StringUtil.isEmptyString((String)endNumber)) {
            throw new BOSException(this.getServerResource("illegel_parameter", ctx));
        }
        String begin = null;
        String end = null;
        if (beginNumber.compareTo(endNumber) < 1) {
            begin = beginNumber;
            end = endNumber;
        } else {
            begin = endNumber;
            end = beginNumber;
        }
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_SD_PricePolicyAdjust");
        sql.append(" WHERE FNUMBER >='" + begin + "' AND FNUMBER <='" + end + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fid = rs.getString("FID");
                idSet.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (idSet.size() == 0) {
            idSet.add("");
        }
        return idSet;
    }

    @Override
    protected Set _getIdSetByPerson(Context ctx, String beginNumber, String endNumber) throws BOSException {
        if (StringUtil.isEmptyString((String)beginNumber) || StringUtil.isEmptyString((String)endNumber)) {
            throw new BOSException(this.getServerResource("illegel_parameter", ctx));
        }
        String begin = null;
        String end = null;
        if (beginNumber.compareTo(endNumber) < 1) {
            begin = beginNumber;
            end = endNumber;
        } else {
            begin = endNumber;
            end = beginNumber;
        }
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_PM_User");
        sql.append(" WHERE FNUMBER >='" + begin + "' AND FNUMBER <='" + end + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fid = rs.getString("FID");
                idSet.add(fid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (idSet.size() == 0) {
            idSet.add("");
        }
        return idSet;
    }

    public boolean isParamOpen(Context ctx, String saleOrgID) throws EASBizException, BOSException {
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String item = ipc.getParamValue((IObjectPK)new ObjectStringPK(saleOrgID), "PricePolicyAdjustParam001");
        return item != null && item.trim().length() != 0 && item.trim().equalsIgnoreCase("true");
    }

    protected boolean checkCanSave(PricePolicyAdjustEntryInfo entryInfo) {
        boolean canSave = true;
        if (entryInfo.getNewPrice() == null && entryInfo.getNewPriceMax() == null && entryInfo.getNewPriceMin() == null && entryInfo.getNewAmountMax() == null && entryInfo.getNewAmountMin() == null && entryInfo.getNewQtyMax() == null && entryInfo.getNewQtyMin() == null && entryInfo.getNewDiscount() == null && entryInfo.getNewEffectiveDate() == null && entryInfo.getNewExpireDate() == null && entryInfo.getNewSalePrice() == null && entryInfo.getNewSaleLeadTime() == 0.0f) {
            canSave = false;
        }
        return canSave;
    }

    @Override
    protected String _getMaterialIds(Context ctx, String groupid, String groupstandardid, SaleOrgUnitInfo saleOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid as id  from T_BD_Material a ").append(" inner join T_BD_MaterialGroup b on b.fid = a.FMaterialGroupID ").append(" inner join T_ORG_CtrlUnit adminCU on adminCU.fid = a.FAdminCUId");
        if (saleOrg != null && saleOrg.isIsBizUnit()) {
            sql.append(" inner join T_BD_MaterialSales msale on msale.FMaterialID = a.fid ");
        }
        sql.append(" WHERE ");
        if (groupid != null) {
            IMaterialGroup icsspgroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
            MaterialGroupInfo groupinfo = icsspgroup.getMaterialGroupInfo((IObjectPK)new ObjectStringPK(groupid));
            sql.append(" (b.FLongNumber like '").append(groupinfo.getLongNumber() + "!%' ").append(" or b.FNumber = '").append(groupinfo.getNumber() + "') ");
        } else {
            sql.append(" b.FLongNumber like '%'");
        }
        String strD = "";
        try {
            strD = this.getMaterialDFilter(saleOrg.getCU().getId().toString(), ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (strD != null && !strD.equals("")) {
            sql.append(" and " + strD);
        }
        IRowSet rs = null;
        StringBuffer strBuffer = new StringBuffer();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (strBuffer.length() > 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("'");
                strBuffer.append(rs.getString("id"));
                strBuffer.append("'");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return strBuffer.toString();
    }

    @Override
    protected String _getCustomerIds(Context ctx, String groupid, String csspgroupstandardid, SaleOrgUnitInfo saleOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.fid as id from T_BD_Customer a ").append(" inner join T_BD_CustomerGroupDetail b on a.FID = b.FCustomerID ").append(" inner join T_BD_CSSPGroup csspgroup on csspgroup.FID = b.FCustomerGroupID ").append(" inner join T_ORG_CtrlUnit adminCU on adminCU.fid = a.FAdminCUId");
        if (saleOrg != null && saleOrg.isIsBizUnit()) {
            sql.append(" inner join T_BD_CustomerSaleInfo customersale on customersale.fcustomerid = a.fid ");
        }
        sql.append(" where b.FCustomerGroupStandardID = '").append(csspgroupstandardid).append("'");
        if (groupid != null) {
            ICSSPGroup icsspgroup = CSSPGroupFactory.getLocalInstance((Context)ctx);
            CSSPGroupInfo groupinfo = icsspgroup.getCSSPGroupInfo((IObjectPK)new ObjectStringPK(groupid));
            sql.append(" and (csspgroup.FLongNumber like '").append(groupinfo.getLongNumber() + "!%'").append(" or csspgroup.FNumber ='").append(groupinfo.getNumber() + "') ");
        } else {
            sql.append(" and csspgroup.FLongNumber like '%'");
        }
        if (saleOrg.isIsBizUnit()) {
            sql.append(" and customersale.FSaleOrgID = '").append(saleOrg.getId().toString()).append("' ");
        }
        String strD = "";
        try {
            strD = this.getCustomerDFilter(saleOrg.getCU().getId().toString(), ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (strD != null && !strD.equals("")) {
            sql.append(" and " + strD);
        }
        IRowSet rs = null;
        StringBuffer strBuffer = new StringBuffer();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (strBuffer.length() > 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("'");
                strBuffer.append(rs.getString("id"));
                strBuffer.append("'");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return strBuffer.toString();
    }
}

