/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.sd.sale.PresentLimitEnum;
import com.kingdee.eas.scm.sd.sale.PromotionPolicyInfo;
import com.kingdee.eas.scm.sd.sale.SalePromotionException;
import com.kingdee.eas.scm.sd.sale.app.AbstractPromotionPolicyControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class PromotionPolicyControllerBean
extends AbstractPromotionPolicyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.PromotionPolicyControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PromotionPolicyInfo policyInfo = (PromotionPolicyInfo)model;
        policyInfo.setBizDate(new Date());
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PromotionPolicyInfo policyInfo = (PromotionPolicyInfo)model;
        if (policyInfo.getBizDate() == null) {
            policyInfo.setBizDate(new Date());
        }
        if (policyInfo.getName() == null) {
            throw new SalePromotionException(SalePromotionException.PROMOTIONPOLICYNAMENOTNULL);
        }
        if (policyInfo.getCurrency() == null) {
            throw new SalePromotionException(SalePromotionException.CURRENCYNOTNULL);
        }
        if (policyInfo.getCompanyOrgUnit() == null) {
            throw new SalePromotionException(SalePromotionException.COMPANYNOTNULL);
        }
        if (policyInfo.getPromotionMode() == null) {
            throw new SalePromotionException(SalePromotionException.PROMOTIONMODENOTNULL);
        }
        if (PresentLimitEnum.presentLimit.equals((Object)policyInfo.getPresentLimit()) && policyInfo.getPresentQty() == null) {
            throw new SalePromotionException(SalePromotionException.PRESENTQTYNOTNULL);
        }
        if (policyInfo.getPromotionSaleOrgs().size() == 0) {
            throw new SalePromotionException(SalePromotionException.PROMOTIONSALEORGNOTNULL);
        }
        if (policyInfo.getPromotionCustomers().size() == 0) {
            throw new SalePromotionException(SalePromotionException.PROMOTIONCUSTOMERNOTNULL);
        }
        policyInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        IObjectPK pk = null;
        pk = super._submit(ctx, model);
        String orgUnitID = policyInfo.getCompanyOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, policyInfo, orgUnitID, 1)) {
            this.auditAndLog(ctx, pk, policyInfo.getBOSType(), policyInfo.getNumber(), "promotionpolicy_audit");
        }
        return pk;
    }

    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._audit(ctx, pk, model);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new SalePromotionException(SalePromotionException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        this.update(ctx, pk, billInfo);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SalePromotionException(SalePromotionException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        this.update(ctx, pk, billInfo);
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PromotionPolicyInfo info = new PromotionPolicyInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        info.setCreateTime(ts);
        info.setBizDate(curDate);
        return info;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (billInfo.getBaseStatus().getValue() != 0 && billInfo.getBaseStatus().getValue() != 1 && billInfo.getBaseStatus().getValue() != 2) {
            throw new SalePromotionException(SalePromotionException.CANNOT_DELETE, new String[]{billInfo.getBaseStatus().toString()});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (!billInfo.isIsHandClose()) {
            throw new SalePromotionException(SalePromotionException.ONLYCLOSECANUNCLOSE, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setIsHandClose(false);
        this.update(ctx, pk, billInfo);
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unClose(ctx, pks[i]);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SalePromotionException(SalePromotionException.ONLYAUDITCANCLOSE, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        billInfo.setIsHandClose(true);
        this.update(ctx, pk, billInfo);
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.close(ctx, pks[i], reasons[i]);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.close(ctx, pks[i]);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SalePromotionException(SalePromotionException.ONLYAUDITCANCLOSE, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        billInfo.setIsHandClose(true);
        this.update(ctx, pk, billInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PromotionPolicyInfo billInfo = this.getPromotionPolicyInfo(ctx, pk);
        return billInfo.getNumber();
    }

    public OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        String permItem = SCMGroupServerUtils.getPermissionItem((Context)ctx, (IMetaDataPK)queryPK);
        OrgUnitCollection collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)orgType, (String)permItem);
        return PromotionPolicyControllerBean.getOrgUnitInfosByType(ctx, collection, orgType);
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(PromotionPolicyControllerBean.getOrgInfoSelector(orgType));
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }
}

