/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.IQuotation;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.QuotationCollection;
import com.kingdee.eas.scm.sd.sale.QuotationEntryCollection;
import com.kingdee.eas.scm.sd.sale.QuotationEntryInfo;
import com.kingdee.eas.scm.sd.sale.QuotationException;
import com.kingdee.eas.scm.sd.sale.QuotationFactory;
import com.kingdee.eas.scm.sd.sale.QuotationInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractQuotationControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class QuotationControllerBean
extends AbstractQuotationControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.QuotationControllerBean");

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        QuotationInfo quotationInfo = (QuotationInfo)model;
        SaleOrgUnitInfo saleOrgUnitInfo = quotationInfo.getSaleOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (saleOrgUnitInfo != null && (orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(saleOrgUnitInfo.getId().toString(), 2, 1)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _checkAlert(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IQuotation iQuotation = QuotationFactory.getLocalInstance(ctx);
        QuotationInfo quotationInfo = iQuotation.getQuotationInfo(pk);
        if (quotationInfo.getBaseStatus().getValue() != 4) {
            throw new QuotationException(QuotationException.QUO_CANNOT_ALERT, new String[]{quotationInfo.getBaseStatus().toString()});
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._audit(ctx, pks);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _audit(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            this.checkAudit(ctx, pk);
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            StringBuffer params = new StringBuffer();
            int c = pk.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pk[i].toString());
                params.append("'");
            }
            String updateSql = "update T_SD_Quotation set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = getDate() where fid in(" + params.toString() + ")";
            String updateEntrySql = "update T_SD_QuotationEntry set FBaseStatus = 4 where FParentID in(" + params.toString() + ")";
            batchStatement.addBatch(updateSql);
            batchStatement.addBatch(updateEntrySql);
            batchStatement.executeBatch();
        }
        catch (EASBizException er) {
            try {
                throw er;
                catch (SQLException er2) {
                    throw new BOSException((Throwable)er2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    protected void checkAudit(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IQuotation iQuotation = QuotationFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkAudit(ctx, iQuotation, pks[i]);
                    continue;
                }
                catch (PurOrderException ex) {
                    if (num > 1) {
                        throw new PurReqException(PurReqException.PUR_NOT_SUBMIT);
                    }
                    throw ex;
                }
            }
        }
    }

    private void checkAudit(Context ctx, IQuotation iQuotation, IObjectPK pk) throws EASBizException, BOSException {
        QuotationInfo quotationInfo = iQuotation.getQuotationInfo(pk);
        if (quotationInfo.getBaseStatus().getValue() != 2 && quotationInfo.getBaseStatus().getValue() != -2) {
            throw new QuotationException(QuotationException.QUO_CANNOT_AUDIT_NOTSTATUS, new String[]{quotationInfo.getBaseStatus().toString()});
        }
        this.isSamePerson4Audit(ctx, quotationInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QuotationInfo quotationInfo = (QuotationInfo)model;
        QuotationEntryCollection tmpEntries = quotationInfo.getEntries();
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            this.setZero(tmpEntries.get(i));
        }
        super._update(ctx, pk, (IObjectValue)quotationInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuotationInfo quotationInfo = (QuotationInfo)model;
        boolean isAddNew = true;
        if (this.isAddNew(ctx, (IObjectValue)quotationInfo)) {
            isAddNew = true;
            quotationInfo.setVersion(0);
        } else {
            isAddNew = false;
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(quotationInfo.getId()));
        }
        if (quotationInfo.getBizType() == null) {
            BizTypeInfo bizTypeInfo = new BizTypeInfo();
            bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-010e-1000-e000-04c5c0a812202407435C"));
            quotationInfo.setBizType(bizTypeInfo);
        }
        quotationInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        QuotationEntryCollection tmpEntries = quotationInfo.getEntries();
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            tmpEntries.get(i).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            this.setZero(tmpEntries.get(i));
        }
        this.checkNumber(ctx, isAddNew, quotationInfo);
        IObjectPK pk = super._save(ctx, model);
        if (pk != null) {
            StringBuffer strSQL = new StringBuffer();
            String sp = " \r\n";
            strSQL.append("delete T_SD_QuotationEntry").append(sp);
            strSQL.append("    where  fmaterialid is null and fparentid=?").append(sp);
            String id = pk.toString();
            DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{id});
        }
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String orgUnitID;
        IObjectPK pk;
        QuotationInfo quotationInfo = (QuotationInfo)model;
        if (this.isAddNew(ctx, (IObjectValue)quotationInfo)) {
            quotationInfo.setVersion(0);
        } else {
            this.checkSubmit(ctx, quotationInfo);
        }
        QuotationEntryCollection entryInfos = quotationInfo.getEntries();
        QuotationEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            this.setZero(entry);
        }
        if (quotationInfo.getBizType() == null) {
            BizTypeInfo bizTypeInfo = new BizTypeInfo();
            bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-010e-1000-e000-04c5c0a812202407435C"));
            quotationInfo.setBizType(bizTypeInfo);
        }
        if (quotationInfo.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-9113c0a812fd463ED552"));
            quotationInfo.setBillType(billTypeInfo);
        }
        if ((pk = super._submit(ctx, model)) != null) {
            StringBuffer strSQL = new StringBuffer();
            String sp = " \r\n";
            strSQL.append("delete T_SD_QuotationEntry").append(sp);
            strSQL.append("    where  fmaterialid is null and fparentid=?").append(sp);
            String id = pk.toString();
            DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{id});
        }
        if (this.isAuditAfterSubmit(ctx, quotationInfo, orgUnitID = quotationInfo.getSaleOrgUnit().getId().toString(), 2)) {
            ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
            ServiceStateManager.getInstance().reSetServiceState(ls);
            this.auditAndLog(ctx, pk, quotationInfo.getBOSType(), quotationInfo.getNumber(), "scm_qotation_audit");
            ServiceStateManager.getInstance().reSetServiceState(ls);
        }
        return pk;
    }

    protected void checkValidDataForSubmit(QuotationInfo quotationInfo, Context ctx) throws EASBizException, BOSException {
        if (quotationInfo.getSaleOrgUnit() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("ORDER_FIELD_SALEORGUNIT")});
        }
        if (quotationInfo.getOrderCustomer() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("QUO_FIELD_CUS")});
        }
        if (quotationInfo.getBizDate() == null) {
            throw new OrderException(OrderException.BIZDATE_NOT_NULL);
        }
        if (quotationInfo.getCurrency() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("ORDER_FIELD_CURRENCY")});
        }
        if (quotationInfo.getExchangeRate() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("ORDER_FIELD_EXCHANGERATE")});
        }
        if (quotationInfo.getEnabledDate() != null && quotationInfo.getDisibleDate() != null) {
            Date enableDate = quotationInfo.getEnabledDate();
            enableDate = SaleUtil.getBeginDate(enableDate);
            Date disibleDate = quotationInfo.getDisibleDate();
            if (enableDate.after(disibleDate = SaleUtil.getEndDate(disibleDate))) {
                throw new OrderException(OrderException.EX_MSG_FOR, new Object[]{SaleUtil.getUIResource("EnableDateAfterDisibleDate")});
            }
        }
        QuotationEntryCollection col = quotationInfo.getEntries();
        QuotationEntryInfo entryInfo = null;
        if (col.size() <= 0) {
            throw new OrderException(OrderException.ENTRY_CANNOT_EMPTY);
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String needAsst = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(quotationInfo.getSaleOrgUnit().getId().toString()), "SALEORDER100");
        for (int i = 0; i < col.size(); ++i) {
            entryInfo = col.get(i);
            this.afterRowValid(entryInfo, i, "false".equals(needAsst), ctx);
        }
    }

    public void afterRowValid(QuotationEntryInfo entryInfo, int rowIndex, boolean needAsst, Context ctx) throws OrderException {
        if (entryInfo.getPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
            throw new OrderException(OrderException.EX_MSG_FOR, new Object[]{MessageFormat.format(SaleUtil.getUIResource("ORDERENTRYROWFIELD_CANNOTNULL"), new Integer(rowIndex + 1).toString(), SaleUtil.getUIResource("POST_FIELD_PRICE"))});
        }
        BigDecimal qtyFrom = SCMConstant.BIGDECIMAL_ZERO;
        if (entryInfo.getQtyFrom() != null) {
            qtyFrom = entryInfo.getQtyFrom();
        }
        BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal qtyTo = SCMConstant.BIGDECIMAL_ZERO;
        if (entryInfo.getQtyTo() != null) {
            qtyTo = entryInfo.getQtyTo();
        }
        if ((qtyFrom.compareTo(zero) != 0 || qtyTo.compareTo(zero) != 0) && qtyFrom.compareTo(qtyTo) >= 0) {
            throw new OrderException(OrderException.EX_MSG_FOR, new Object[]{MessageFormat.format(SaleUtil.getUIResource("QUO_QTYTONEEDGREATEQTYTO1"), new Integer(rowIndex + 1).toString())});
        }
        if (entryInfo.getTaxRate() == null) {
            throw new OrderException(OrderException.EX_MSG_FOR, new Object[]{MessageFormat.format(SaleUtil.getUIResource("ORDERENTRYROWFIELD_CANNOTNULL"), new Integer(rowIndex + 1).toString(), SaleUtil.getUIResource("ORDER_FIELD_TAXRATE"))});
        }
        if (needAsst && entryInfo.getMaterial().getAssistAttr() != null && entryInfo.getAssistProperty() == null) {
            String msg = SCMUtils.getResource((String)"com.kingdee.eas.scm.common.validator.beanvalidation.ValidationResource", (String)"Entry_NotNull_AssistProperty", (Context)ctx);
            throw new OrderException(OrderException.EX_MSG_FOR, new Object[]{MessageFormat.format(msg, rowIndex + 1)});
        }
    }

    private void setZero(QuotationEntryInfo entry) {
        String[] fields = new String[]{"qtyFrom", "qtyTo", "baseQtyFrom", "baseQtyTo", "price", "taxRate", "taxPrice", "discount", "actualTaxPrice", "discount"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(QuotationEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = QuotationEntryInfo.class.getMethod(getMethodName, new Class[0]);
                Method setMethod = QuotationEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, new Object[0]) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("baseStatus"));
        QuotationInfo quotationInfo = (QuotationInfo)super._getValue(ctx, pk, sc);
        if (quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1 && quotationInfo.getBaseStatus().getValue() != 2) {
            throw new QuotationException(QuotationException.QUO_CANNOT_DELETE, new String[]{quotationInfo.getBaseStatus().toString()});
        }
        super._canUpdate(ctx, pk);
    }

    protected void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QuotationInfo quotationInfo = this.getQuotationInfo(ctx, pk);
        if (quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1) {
            throw new QuotationException(QuotationException.QUO_ONLYTEMP_CANBE_SAVE);
        }
        super._canUpdate(ctx, pk);
    }

    protected void checkSubmit(Context ctx, QuotationInfo quotationInfo) throws EASBizException, BOSException {
        if (quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1 && quotationInfo.getBaseStatus().getValue() != 2) {
            throw new QuotationException(QuotationException.QUO_CANNOT_UPDATE, new String[]{quotationInfo.getBaseStatus().toString()});
        }
        this.checkValidDataForSubmit(quotationInfo, ctx);
    }

    private void checkNumber(Context ctx, boolean isAddNew, QuotationInfo quotationInfo) throws BOSException, EASBizException {
        SaleOrgUnitInfo saleOrgUnit = quotationInfo.getSaleOrgUnit();
        if (!(this.isRuleAutoNumber(ctx, quotationInfo, saleOrgUnit.getId().toString()) || quotationInfo.getNumber() != null && quotationInfo.getNumber().trim().length() != 0)) {
            throw new QuotationException(QuotationException.FIELD_CANNOT_EMPTY, new String[]{this.getServerResource("QUO_FIELD_NUMBER", ctx)});
        }
    }

    protected boolean isRuleAutoNumber(Context ctx, SCMBillBaseInfo aSCMBillBaseInfo) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        QuotationInfo quotationInfo = (QuotationInfo)aSCMBillBaseInfo;
        SaleOrgUnitInfo saleOrgUnit = quotationInfo.getSaleOrgUnit();
        String strBindProp = this.getBindingProperty(ctx);
        return iCodingRuleManager.getRuleStatus((IObjectValue)quotationInfo, saleOrgUnit.getId().toString(), strBindProp).isAddView();
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key, (Context)ctx);
    }

    private void checkEntriesValidforSubmit(QuotationEntryCollection entries, Context ctx) throws QuotationException {
        StringBuffer errorSb = new StringBuffer();
        boolean isError = false;
        int nrow = entries.size();
        if (nrow <= 0) {
            throw new QuotationException(QuotationException.ENTRY_CANNOT_EMPTY);
        }
        QuotationEntryInfo quotationEntryInfo = null;
        for (int row = 0; row < nrow; ++row) {
            quotationEntryInfo = entries.get(row);
            if (quotationEntryInfo.getMaterial() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_MATERIAL", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getBaseUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_BASEUNIT", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_UNIT", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getPrice() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_PRICE", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getTaxPrice() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_TAXPRICE", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getActualTaxPrice() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_DISCOUNTTAXPRICE", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getTaxRate() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_TAXRATE", ctx));
                isError = true;
            }
            if (!isError) continue;
            throw new QuotationException(QuotationException.ENTRY_FIELD_CANNOT_EMPTY, new String[]{String.valueOf(row + 1), errorSb.toString()});
        }
    }

    protected void checkValidforSubmit(IObjectValue model, Context ctx) throws QuotationException {
        QuotationInfo quotationInfo = (QuotationInfo)model;
        StringBuffer errorSb = new StringBuffer();
        boolean isError = false;
        if (quotationInfo.getBizDate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_ORDERDATE", ctx));
            isError = true;
        }
        if (quotationInfo.getOrderCustomer() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("QUO_FIELD_CUS", ctx));
            isError = true;
        }
        if (quotationInfo.getCurrency() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_CURRENCY", ctx));
            isError = true;
        }
        if (quotationInfo.getExchangeRate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_EXCHANGERATE", ctx));
            isError = true;
        }
        if (quotationInfo.getSaleOrgUnit() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_SALEORGUNIT", ctx));
            isError = true;
        }
        if (isError) {
            throw new QuotationException(QuotationException.FIELD_CANNOT_EMPTY, new String[]{errorSb.toString()});
        }
        this.checkEntriesValidforSubmit(quotationInfo.getEntries(), ctx);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IQuotation iQuotation = QuotationFactory.getLocalInstance(ctx);
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            QuotationInfo saleInfo = iQuotation.getQuotationInfo(pks[j]);
            SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)saleInfo);
            this.isSamePerson4UnAudit(ctx, saleInfo);
        }
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            String updateSql = "update T_SD_Quotation set FBaseStatus = 1,FAuditorId=null,FAuditTime = null where fid in(" + params.toString() + ")";
            batchStatement.addBatch(updateSql);
            String updateEntrySql = "update T_SD_QuotationEntry set FBaseStatus = 1 where FparentID in(" + params.toString() + ")";
            batchStatement.addBatch(updateEntrySql);
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, new IObjectPK[]{pk});
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    public String getParamCon4Audit() {
        return "SALEBILL002";
    }

    public String getParamCon4UnAudit() {
        return "SALEBILL003";
    }

    @Override
    protected void _alter(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkAlert(ctx, pk);
        IQuotation iQuotation = QuotationFactory.getLocalInstance(ctx);
        QuotationInfo newQuotationInfo = (QuotationInfo)model;
        QuotationInfo oldQuotationInfo = iQuotation.getQuotationInfo(pk);
        if (ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)oldQuotationInfo, (AbstractObjectValue)newQuotationInfo)) {
            return;
        }
        newQuotationInfo.setOldStatus(BillBaseStatusEnum.AUDITED);
        newQuotationInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        int oldVersion = oldQuotationInfo.getVersion();
        if (oldQuotationInfo.getBaseStatus().getValue() == 4) {
            newQuotationInfo.setVersion(oldVersion + 1);
        } else if (oldQuotationInfo.getBaseStatus().getValue() == -2) {
            newQuotationInfo.setVersion(oldVersion);
        }
        newQuotationInfo.setModificationTime(new Timestamp(new Date().getTime()));
        newQuotationInfo.setModifier(ContextUtil.getCurrentUserInfo((Context)ctx));
        QuotationEntryCollection newEntries = newQuotationInfo.getEntries();
        QuotationEntryCollection oldEntries = oldQuotationInfo.getEntries();
        QuotationEntryInfo newEntry = null;
        QuotationEntryInfo oldEntry = null;
        int num = newEntries.size();
        for (int i = 0; i < num; ++i) {
            newEntry = newEntries.get(i);
            newEntry.setOldStatus(EntryBaseStatusEnum.AUDITED);
            newEntry.setBaseStatus(EntryBaseStatusEnum.ALTERING);
            this.setZero(newEntry);
        }
        if (oldQuotationInfo.getBaseStatus().getValue() == 4) {
            oldQuotationInfo.setOldId(oldQuotationInfo.getId());
            oldQuotationInfo.setId(null);
            oldQuotationInfo.setVersion(oldVersion);
            oldQuotationInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
            oldQuotationInfo.setAlterDate(new Timestamp(new Date().getTime()));
            oldQuotationInfo.setOldStatus(oldQuotationInfo.getBaseStatus());
            oldQuotationInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
            int oldEntrySize = oldEntries.size();
            for (int i = 0; i < oldEntrySize; ++i) {
                oldEntry = oldEntries.get(i);
                oldEntry.setOldId(oldEntry.getId());
                oldEntry.setId(null);
                oldEntry.setOldStatus(oldEntry.getBaseStatus());
                oldEntry.setBaseStatus(EntryBaseStatusEnum.ALTERING);
            }
            this.innerAddnew(ctx, (IObjectValue)oldQuotationInfo);
            this.innerUpdate(ctx, pk, (IObjectValue)newQuotationInfo);
        } else if (oldQuotationInfo.getBaseStatus().getValue() == -2) {
            this.innerUpdate(ctx, pk, (IObjectValue)newQuotationInfo);
            QuotationInfo lastVerInfo = QuotationFactory.getLocalInstance(ctx).getQuotationInfo("where number='" + oldQuotationInfo.getNumber() + "' and version = " + String.valueOf(oldVersion - 1));
            lastVerInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
            lastVerInfo.setAlterDate(new Timestamp(new Date().getTime()));
            QuotationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(lastVerInfo.getId()), (CoreBaseInfo)lastVerInfo);
        }
    }

    @Override
    protected void _agreeAlter(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        this._audit(ctx, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _disaccordAlter(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        IQuotation iQuotation = QuotationFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("version"));
        selector.add(new SelectorItemInfo("id"));
        QuotationInfo delQuotationInfo = iQuotation.getQuotationInfo(id, selector);
        int version = 1;
        version = delQuotationInfo.getVersion();
        QuotationInfo reQuotation = null;
        Connection con = null;
        Statement statement = null;
        IRowSet checkSet = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String checkSql = "select FID from T_SD_Quotation where FOldID= ? and FVersion = ?";
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{delQuotationInfo.getId().toString(), version - 1});
            if (checkSet.next() && checkSet.getString(1) != null) {
                reQuotation = iQuotation.getQuotationInfo((IObjectPK)new ObjectUuidPK(checkSet.getString(1)));
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(checkSet, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)checkSet, (Statement)statement, (Connection)con);
        if (reQuotation != null) {
            QuotationEntryCollection reQuotationEntries = null;
            QuotationEntryInfo entryInfo = null;
            reQuotation.setAlterDate(null);
            reQuotation.setAlterPerson(null);
            reQuotation.setBaseStatus(reQuotation.getOldStatus());
            reQuotationEntries = reQuotation.getEntries();
            if (reQuotationEntries != null) {
                int pcCount = reQuotationEntries.size();
                for (int pc = 0; pc < pcCount; ++pc) {
                    entryInfo = reQuotationEntries.get(pc);
                    entryInfo.setId(entryInfo.getOldId());
                    entryInfo.setBaseStatus(entryInfo.getOldStatus());
                }
            }
        }
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            if (this.needCache(ctx)) {
                ORMValueCacheService.getInstance().remove(ctx, this.getBOSType(), id);
            }
            this.getDAO(ctx, cn).delete(id);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (reQuotation != null && reQuotation.getId() != null) {
            this.innerDelete(ctx, (IObjectPK)new ObjectUuidPK(reQuotation.getId().toString()));
        }
        if (reQuotation != null && reQuotation.getOldId() != null) {
            this.innerAddnew(ctx, (IObjectPK)new ObjectUuidPK(reQuotation.getOldId().toString()), (IObjectValue)reQuotation);
        }
    }

    @Override
    protected void _revoke(Context ctx, String pk, IObjectValue reason) throws BOSException, EASBizException {
        String[] pks = new String[]{pk};
        this.checkRevoke(ctx, pks);
        this.doRevoke(ctx, pks, ((ReasonCodeInfo)reason).getName());
    }

    @Override
    protected void _revoke(Context ctx, String[] pks, IObjectValue reason) throws BOSException, EASBizException {
        this.checkRevoke(ctx, pks);
        this.doRevoke(ctx, pks, ((ReasonCodeInfo)reason).getName());
    }

    @Override
    protected void _revoke(Context ctx, String pk, String reason) throws BOSException, EASBizException {
        String[] pks = new String[]{pk};
        this.checkRevoke(ctx, pks);
        this.doRevoke(ctx, pks, reason);
    }

    @Override
    protected void _revoke(Context ctx, String[] pks, String reasons) throws BOSException, EASBizException {
        this.checkRevoke(ctx, pks);
        this.doRevoke(ctx, pks, reasons);
    }

    protected void doRevoke(Context ctx, String[] pks, String reason) throws BOSException, EASBizException {
        String questionMark = this.generateQuestionMarkAndCommaBySize(pks.length);
        String doBillSql = "UPDATE T_SD_QUOTATION SET FBASESTATUS = ? WHERE FID IN (" + questionMark + ")";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(3);
        for (String pk : pks) {
            params.add(pk);
        }
        DbUtil.execute((Context)ctx, (String)doBillSql, (Object[])params.toArray());
        params.remove(0);
        params.add(0, 3);
        params.add(1, reason);
        String doEntrySql = "UPDATE T_SD_QUOTATIONENTRY SET FBASESTATUS = ?, FREASON = ? WHERE FPARENTID IN (" + questionMark + ")";
        DbUtil.execute((Context)ctx, (String)doEntrySql, (Object[])params.toArray());
    }

    protected void checkRevoke(Context ctx, String[] pks) throws BOSException, EASBizException {
        if (pks != null && pks.length > 0 && pks[0] != null && !"".equals(pks[0]) && !"null".equals(pks[0])) {
            HashSet<String> idSet = new HashSet<String>(Arrays.asList(pks));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            QuotationCollection coll = this.getQuotationCollection(ctx, view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                QuotationInfo info = coll.get(i);
                if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)info.getBaseStatus()) || BillBaseStatusEnum.SUBMITED.equals((Object)info.getBaseStatus())) continue;
                if (pks.length > 1) {
                    throw new QuotationException(QuotationException.QUO_CANNOT_REVOKE_BY_OTHER_STATUS_PART);
                }
                throw new QuotationException(QuotationException.QUO_CANNOT_REVOKE_BY_OTHER_STATUS);
            }
        }
    }

    private String generateQuestionMarkAndCommaBySize(Integer size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                result.append("?");
                continue;
            }
            result.append("?,");
        }
        return result.toString();
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        QuotationInfo model = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entries.*");
        selector.add("entries.material.assistAttr.id");
        model = this.getQuotationInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        return null;
    }
}

