/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeCollection;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IDeliveryType;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sd.sale.QuotationEntryInfo;
import com.kingdee.eas.scm.sd.sale.QuotationFactory;
import com.kingdee.eas.scm.sd.sale.QuotationInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QuotationImport
extends SCMDataImport {
    private QuotationInfo quotationInfo;
    private String[] priceFields = new String[]{"price", "taxPrice", "actualTaxPrice"};
    private final String[] dateFields = new String[]{"bizDate", "enabledDate", "disibleDate"};
    private final String[] dateCellFields = new String[]{"FBizDate", "FEnabledDate", "FDisibleDate"};
    private final String[] strHeadFields = new String[]{"description", "cusPurNumber"};
    private final String[] strHeadCellFields = new String[]{"FDescription", "FCusPurNumber"};
    private final String[] strEntryFields = new String[]{"remark"};
    private final String[] strEntryCellFields = new String[]{"FEntries_remark"};
    private static final String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private static final int EXCHANGE_RATE_PRECISION = 2;
    private static final int DEFAULT_QTY_PRECISION = 8;
    public static final int DEFAULT_RATE_PRICISION = 4;
    private Map<String, CustomerInfo> cacheCustomer = new HashMap<String, CustomerInfo>();
    private Map<String, DeliveryTypeInfo> cacheDeliveryType = new HashMap<String, DeliveryTypeInfo>();
    private Map<String, CurrencyInfo> cacheCurrency = new HashMap<String, CurrencyInfo>();
    private Map<String, SaleOrgUnitInfo> cacheSaleOrgUnit = new HashMap<String, SaleOrgUnitInfo>();
    private Map<String, SaleGroupInfo> cacheSaleGroup = new HashMap<String, SaleGroupInfo>();
    private Map<String, SalePersonInfo> cacheSalePerson = new HashMap<String, SalePersonInfo>();
    private Map<String, UserInfo> cacheUserInfo = new HashMap<String, UserInfo>();
    private Map<String, MaterialInfo> cacheMaterial = new HashMap<String, MaterialInfo>();
    private Map<String, AsstAttrValueInfo> cacheAsstAttr = new HashMap<String, AsstAttrValueInfo>();
    private Map<String, MeasureUnitInfo> cacheUnit = new HashMap<String, MeasureUnitInfo>();
    private Map<String, MultiMeasureUnitInfo> cacheMaterialUnit = new HashMap<String, MultiMeasureUnitInfo>();
    private Map<String, String> paramMap = new HashMap<String, String>();
    ImportDataCache dataPool = new ImportDataCache();
    SaleOrgUnitInfo sou = null;

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.quotationInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.quotationInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, this.quotationInfo, lineData);
                }
                catch (Exception e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.quotationInfo);
                    break;
                }
                if (this.quotationInfo == null) {
                    return null;
                }
            }
            try {
                QuotationEntryInfo entryInfo = this.transmitEntry(lineData, ctx);
                this.afterBuildEntry(ctx, this.quotationInfo, entryInfo, lineData);
                continue;
            }
            catch (Exception e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.quotationInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.quotationInfo;
    }

    private QuotationEntryInfo transmitEntry(Map lineData, Context ctx) throws BOSException, TaskExternalException {
        QuotationEntryInfo entryInfo = new QuotationEntryInfo();
        this.doEntryMaterial(ctx, lineData, entryInfo);
        this.doEntryAssistProperty(ctx, lineData, entryInfo);
        this.doEntryUnit(ctx, lineData, entryInfo);
        this.doEntriesQtys(ctx, lineData, entryInfo);
        this.doEntriesPricesAndTaxRate(ctx, lineData, entryInfo);
        this.doEntriesProject(ctx, lineData, entryInfo);
        this.doEntriesTrackNumber(ctx, lineData, entryInfo);
        this.doEntriesDiscount(ctx, lineData, entryInfo);
        this.doEntriesStringFields(ctx, lineData, entryInfo);
        return entryInfo;
    }

    private QuotationInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        this.quotationInfo = new QuotationInfo();
        this.doDateFields(ctx, lineData);
        this.doHeadStringFields(ctx, lineData);
        this.doCustomer(ctx, lineData);
        this.doDeliveryType(ctx, lineData);
        this.doSaleOrgUnit(ctx, lineData);
        this.doSaleGroup(ctx, lineData);
        this.doSalePerson(ctx, lineData);
        this.doCurrencyAndExchangeRate(ctx, lineData);
        this.doCreateTime(lineData);
        this.doCreator(ctx, lineData);
        this.doBaseStatus();
        return this.quotationInfo;
    }

    private void doDateFields(Context ctx, Map lineData) throws TaskExternalException {
        String dateField = null;
        String dateCellField = null;
        for (int i = 0; i < this.dateFields.length; ++i) {
            dateField = this.dateFields[i];
            dateCellField = this.dateCellFields[i];
            String dateStr = this.getStringFromData(lineData, dateCellField);
            if (dateStr != null) {
                Date date = ImRptAppUtils.formatNationalDate((Context)ctx, (String)dateStr);
                if (date == null) continue;
                this.quotationInfo.setDate(dateField, date);
                continue;
            }
            if (!dateField.equals("bizDate")) continue;
            throw new TaskExternalException(QuotationImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)resources) + dateStr);
        }
    }

    private void doCustomer(Context ctx, Map lineData) throws BOSException, TaskExternalException {
        CustomerInfo info;
        String customerNumber = this.getStringFromData(lineData, "FOrderCustomer_number");
        if (customerNumber != null) {
            info = null;
            info = this.getCustomer(ctx, customerNumber);
            if (info == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"ORDER_CUS_NOT_EXIST", (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"ORDER_CUS_NULL", (Context)ctx));
        }
        this.quotationInfo.setOrderCustomer(info);
    }

    private void doDeliveryType(Context ctx, Map lineData) throws BOSException {
        String deliveryTypeNumber = this.getStringFromData(lineData, "FDeliveryType_number");
        if (deliveryTypeNumber != null) {
            DeliveryTypeInfo deliveryTypeInfo = null;
            if (this.dataPool.getDeliveryTypeInfo(deliveryTypeNumber) != null) {
                deliveryTypeInfo = this.dataPool.getDeliveryTypeInfo(deliveryTypeNumber);
            } else {
                IDeliveryType iDeliveryType = DeliveryTypeFactory.getLocalInstance((Context)ctx);
                DeliveryTypeCollection collection = iDeliveryType.getDeliveryTypeCollection(this.getFilter(deliveryTypeNumber, "number"));
                if (collection != null && collection.size() > 0) {
                    deliveryTypeInfo = collection.get(0);
                }
                this.dataPool.setDeliveryTypeInfo(deliveryTypeNumber, deliveryTypeInfo);
            }
            this.quotationInfo.setDeliveryType(deliveryTypeInfo);
        }
    }

    private void doSaleOrgUnit(Context ctx, Map lineData) throws BOSException, TaskExternalException {
        SaleOrgUnitInfo saleOrgUnitInfo;
        String saleOrgUnitNumber = this.getStringFromData(lineData, "FSaleOrgUnit_number");
        if (saleOrgUnitNumber != null) {
            saleOrgUnitInfo = null;
            saleOrgUnitInfo = this.getSaleOrgUnit(ctx, "number", saleOrgUnitNumber);
            if (saleOrgUnitInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_EXISTS", (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEORG_NOT_NULL", (Context)ctx));
        }
        this.sou = saleOrgUnitInfo;
        this.quotationInfo.setSaleOrgUnit(saleOrgUnitInfo);
        this.quotationInfo.setCU(saleOrgUnitInfo.getCU());
    }

    private void doSaleGroup(Context ctx, Map lineData) throws BOSException {
        String saleGroupNumber = this.getStringFromData(lineData, "FSaleGroup_number");
        if (saleGroupNumber != null && this.quotationInfo.getSaleOrgUnit() != null) {
            SaleGroupInfo saleGroupInfo = null;
            if (this.dataPool.getSaleGroup(saleGroupNumber) != null) {
                saleGroupInfo = this.dataPool.getSaleGroup(saleGroupNumber);
            } else {
                ISaleGroup iSaleGroup = SaleGroupFactory.getLocalInstance((Context)ctx);
                SaleGroupCollection collection = iSaleGroup.getSaleGroupCollection(this.getFilter(saleGroupNumber, "number"));
                if (collection != null && collection.size() > 0) {
                    saleGroupInfo = collection.get(0);
                }
                this.dataPool.setSaleGroup(saleGroupNumber, saleGroupInfo);
            }
            if (saleGroupInfo != null && (saleGroupInfo.getSaleOrg() != null && !this.quotationInfo.getSaleOrgUnit().getId().equals((Object)saleGroupInfo.getSaleOrg().getId()) || saleGroupInfo.getSaleOrg() == null)) {
                saleGroupInfo = null;
            }
            this.quotationInfo.setSaleGroup(saleGroupInfo);
        }
    }

    private void doSalePerson(Context ctx, Map lineData) throws BOSException, EASBizException {
        String salePersonNumber = this.getStringFromData(lineData, "FSalePerson_number");
        if (salePersonNumber != null) {
            SalePersonInfo salePersonInfo = null;
            String paramValue = this.getParamValueByNumberAndOrg(ctx, "SALE001", this.quotationInfo.getSaleOrgUnit().getId().toString());
            String key = salePersonNumber;
            if ("0".equals(paramValue)) {
                key = this.quotationInfo.getSaleGroup() != null ? this.quotationInfo.getSaleOrgUnit().getId().toString() + this.quotationInfo.getSaleGroup().getId().toString() + salePersonNumber : this.quotationInfo.getSaleOrgUnit().getId().toString() + salePersonNumber;
            }
            if (this.dataPool.getSalePersonInfo(key) != null) {
                salePersonInfo = this.dataPool.getSalePersonInfo(key);
            } else {
                SalePersonCollection collection;
                ISalePerson iSalePerson = SalePersonFactory.getLocalInstance((Context)ctx);
                ArrayList<Object[]> filterItems = new ArrayList<Object[]>();
                filterItems.add(new Object[]{"person.number", salePersonNumber, CompareType.EQUALS});
                if ("0".equals(paramValue)) {
                    if (this.quotationInfo.getSaleGroup() != null) {
                        filterItems.add(new Object[]{"saleGroup.id", this.quotationInfo.getSaleGroup().getId().toString(), CompareType.EQUALS});
                    }
                    filterItems.add(new Object[]{"saleGroup.saleOrg.id", this.quotationInfo.getSaleOrgUnit().getId().toString(), CompareType.EQUALS});
                }
                if ((collection = iSalePerson.getSalePersonCollection(this.getFilter(null, filterItems, null))) != null && collection.size() > 0) {
                    salePersonInfo = collection.get(0);
                }
                this.dataPool.setSalePersonInfo(key, salePersonInfo);
                if (salePersonInfo != null && "0".equals(paramValue)) {
                    this.dataPool.setSalePersonInfo(this.quotationInfo.getSaleOrgUnit().getId().toString() + salePersonNumber, salePersonInfo);
                    if (salePersonInfo.getSaleGroup() != null) {
                        this.dataPool.setSalePersonInfo(this.quotationInfo.getSaleOrgUnit().getId().toString() + salePersonInfo.getSaleGroup().getId().toString() + salePersonNumber, salePersonInfo);
                    }
                }
            }
            if (salePersonInfo != null) {
                this.quotationInfo.setSalePerson(salePersonInfo.getPerson());
            }
        }
    }

    private void doCurrencyAndExchangeRate(Context ctx, Map lineData) throws BOSException, EASBizException, TaskExternalException {
        BigDecimal exchangeRate;
        String currencyNumber = this.getStringFromData(lineData, "FCurrency_number");
        CurrencyInfo currencyInfo = null;
        if (currencyNumber != null) {
            if (this.dataPool.getCurrencyInfo(currencyNumber) != null) {
                currencyInfo = this.dataPool.getCurrencyInfo(currencyNumber);
            } else {
                ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyCollection collection = iCurrency.getCurrencyCollection(this.getFilter(currencyNumber, "number"));
                if (collection != null && collection.size() > 0) {
                    currencyInfo = collection.get(0);
                }
                this.dataPool.setCurrencyInfo(currencyNumber, currencyInfo);
            }
            if (currencyInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CURRENCY_NOT_EXIST", (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDCURRENCY", (Context)ctx));
        }
        this.quotationInfo.setCurrency(currencyInfo);
        String exchangeRateStr = this.getStringFromData(lineData, "FExchangeRate");
        if (!StringUtil.isEmptyString((String)exchangeRateStr) && (exchangeRate = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)exchangeRateStr)) != null && exchangeRate.compareTo(BigDecimal.ZERO) > 0) {
            this.quotationInfo.setExchangeRate(exchangeRate.setScale(2, 4));
        }
    }

    private void doHeadStringFields(Context ctx, Map lineData) {
        for (int i = 0; i < this.strHeadCellFields.length; ++i) {
            String strInfo = this.getStringFromData(lineData, this.strHeadCellFields[i]);
            if (strInfo == null) continue;
            this.quotationInfo.setString(this.strHeadFields[i], strInfo);
        }
    }

    private void doBaseStatus() {
        this.quotationInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void doEntryMaterial(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws TaskExternalException, BOSException {
        MaterialInfo materialInfo;
        String materialNumber = this.getStringFromData(lineData, "FEntries$material_number4idx");
        if (materialNumber != null && materialNumber.length() > 0) {
            materialInfo = null;
            materialInfo = this.getMaterial(ctx, "number", materialNumber, new OrgUnitInfo[]{this.sou});
            if (materialInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"MATERIAL_NOT_EXISTS", (Context)ctx));
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)materialInfo.getStatus())) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.QuotationResource", (String)"MATERIAL_NOT_APPROVED", (String[])new String[]{materialInfo.getNumber()}, (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"SALEINV_NEEDMATERIAL", (Context)ctx));
        }
        entryInfo.setMaterial(materialInfo);
    }

    private void doEntryAssistProperty(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws BOSException, TaskExternalException {
        AsstAttrValueInfo asstAttrValueInfo;
        if (entryInfo.getMaterial().getAssistAttr() == null) {
            return;
        }
        String assistPropertyNumber = this.getStringFromData(lineData, "FEntries$assistProperty_number");
        if (assistPropertyNumber != null) {
            asstAttrValueInfo = this.getAsstAttr(ctx, assistPropertyNumber, entryInfo.getMaterial().getAssistAttr());
            if (!(asstAttrValueInfo == null || asstAttrValueInfo.getCompondingtype() != null && entryInfo.getMaterial().getAssistAttr().getId().equals((Object)asstAttrValueInfo.getCompondingtype().getId()) || asstAttrValueInfo.getBasictype() != null && entryInfo.getMaterial().getAssistAttr().getId().equals((Object)asstAttrValueInfo.getBasictype().getId()))) {
                asstAttrValueInfo = null;
            }
            if (asstAttrValueInfo == null) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.QuotationResource", (String)"ASSTATTR_NOT_FIND", (String[])new String[]{entryInfo.getMaterial().getNumber()}, (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.QuotationResource", (String)"ASSTATTR_NOT_NULL", (String[])new String[]{entryInfo.getMaterial().getNumber()}, (Context)ctx));
        }
        entryInfo.setAssistProperty(asstAttrValueInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEntryUnit(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws BOSException, TaskExternalException {
        String unitNumber = this.getStringFromData(lineData, "FEntries$unit_number");
        if (unitNumber == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"UNIT_NOT_NULL", (Context)ctx));
        MeasureUnitInfo unitInfo = this.getMeasureUnit(ctx, unitNumber, entryInfo.getMaterial());
        if (unitInfo == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"UNIT_NOT_EXISTS", (Context)ctx));
        MaterialInfo materialInfo = entryInfo.getMaterial();
        String key = materialInfo.getId().toString() + unitInfo.getId().toString();
        MultiMeasureUnitInfo multiMeasureUnitInfo = this.getMultiAssistMeasureUnitInfo(ctx, entryInfo.getMaterial().getId().toString(), unitInfo.getId().toString());
        if (multiMeasureUnitInfo == null) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"MATERIAL_UNIT_NOT_VALID", (String[])new String[]{materialInfo.getName()}, (Context)ctx));
        }
        entryInfo.setUnit(unitInfo);
    }

    private void doEntriesQtys(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws TaskExternalException {
        Integer qtyPrecision = this.getQtyPrecisinByMaterialAndUnit(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
        String qtyFromStr = this.getStringFromData(lineData, "FEntries_qtyFrom");
        String qtyToStr = this.getStringFromData(lineData, "FEntries_qtyTo");
        BigDecimal qtyFrom = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)qtyFromStr);
        BigDecimal qtyTo = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)qtyToStr);
        entryInfo.setQtyFrom(qtyFrom.setScale((int)qtyPrecision, 4));
        entryInfo.setQtyTo(qtyTo.setScale((int)qtyPrecision, 4));
    }

    private void doEntriesPricesAndTaxRate(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws TaskExternalException {
        String priceStr = this.getStringFromData(lineData, "FEntries_price");
        String taxRateStr = this.getStringFromData(lineData, "FEntries_taxRate");
        String taxPriceStr = this.getStringFromData(lineData, "FEntries_taxPrice");
        String actualTaxPriceStr = this.getStringFromData(lineData, "FEntries_actualTaxPrice");
        BigDecimal price = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)priceStr);
        BigDecimal taxRate = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)taxRateStr);
        BigDecimal taxPrice = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)taxPriceStr);
        BigDecimal actualTaxPrice = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)actualTaxPriceStr);
        entryInfo.setPrice(price);
        entryInfo.setTaxRate(taxRate);
        entryInfo.setTaxPrice(taxPrice);
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }

    private void doEntriesProject(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws BOSException, TaskExternalException {
        String projectNumber = this.getStringFromData(lineData, "FEntries$project_number");
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ProjectInfo project = null;
        if (projectNumber != null) {
            project = this.getProject(ctx, projectNumber, cu);
            entryInfo.setProject(project);
        }
    }

    private void doEntriesTrackNumber(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws BOSException, TaskExternalException {
        String trackNumberNumberStr = this.getStringFromData(lineData, "FEntries$trackNumber_number");
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        TrackNumberInfo trackNumber = null;
        if (trackNumberNumberStr != null) {
            trackNumber = this.getTrackNumber(ctx, trackNumberNumberStr, cu);
            entryInfo.setTrackNumber(trackNumber);
        }
    }

    private void doEntriesDiscount(Context ctx, Map lineData, QuotationEntryInfo entryInfo) throws BOSException, TaskExternalException {
        ArrayList<String> tmp;
        String discountTypeStr = this.getStringFromData(lineData, "FEntries_discountType");
        if (String.valueOf(0).equals(discountTypeStr)) {
            entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        } else if (String.valueOf(1).equals(discountTypeStr)) {
            entryInfo.setDiscountType(DiscountModeEnum.PERUNIT);
            tmp = new ArrayList<String>(Arrays.asList(this.priceFields));
            tmp.add("discount");
            this.priceFields = tmp.toArray(new String[0]);
        } else {
            entryInfo.setDiscountType(DiscountModeEnum.NULL);
        }
        if (!DiscountModeEnum.NULL.equals((Object)entryInfo.getDiscountType())) {
            String discountStr = this.getStringFromData(lineData, "FEntries_discount");
            BigDecimal discount = DataImportUtils.getDataDeciaml((Context)ctx, (String)discountStr);
            entryInfo.setDiscount(discount);
        }
        if (DiscountModeEnum.PERCENT.equals((Object)entryInfo.getDiscountType())) {
            entryInfo.setDiscount(entryInfo.getDiscount().setScale(4, 4));
        }
        if (!DiscountModeEnum.PERUNIT.equals((Object)entryInfo.getDiscountType())) {
            tmp = new ArrayList<String>(Arrays.asList(this.priceFields));
            tmp.remove("discount");
            this.priceFields = tmp.toArray(new String[0]);
        }
    }

    private void doEntriesStringFields(Context ctx, Map lineData, QuotationEntryInfo entryInfo) {
        for (int i = 0; i < this.strEntryCellFields.length; ++i) {
            String strValue = this.getStringFromData(lineData, this.strEntryCellFields[i]);
            if (strValue == null) continue;
            entryInfo.setString(this.strEntryFields[i], strValue);
        }
    }

    private void doCreateTime(Map lineData) {
        String createdate = this.getStringFromData(lineData, "FCreateTime");
        if (createdate != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Object dateAfterFormat = df.parseObject(createdate);
                this.quotationInfo.setCreateTime(new Timestamp(((Date)dateAfterFormat).getTime()));
            }
            catch (ParseException df) {
                // empty catch block
            }
        }
        if (this.quotationInfo.getCreateTime() == null) {
            Date date = new Date();
            this.quotationInfo.setCreateTime(new Timestamp(date.getTime()));
        }
    }

    private void doCreator(Context ctx, Map lineData) throws TaskExternalException, BOSException {
        this.quotationInfo.setCreator(this.getCreator(ctx, null));
    }

    private EntityViewInfo getFilter(String[] selectorItems, List<Object[]> filterItems, String maskStr) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        if (selectorItems != null) {
            for (String selectorItem : selectorItems) {
                sic.add(new SelectorItemInfo(selectorItem));
            }
        }
        FilterInfo filter = new FilterInfo();
        if (filterItems != null) {
            for (Object[] filterItem : filterItems) {
                filter.getFilterItems().add(new FilterItemInfo((String)filterItem[0], filterItem[1], (CompareType)filterItem[2]));
            }
        }
        if (maskStr != null) {
            filter.setMaskString(maskStr);
        }
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private String getStringFromData(Map lineData, String key) {
        Object data = ((DataToken)lineData.get((Object)key)).data;
        String result = null;
        if (data != null) {
            result = data.toString().trim();
        }
        if (StringUtil.isEmptyString(result)) {
            result = null;
        }
        return result;
    }

    public void afterBuildEntry(Context ctx, SCMBillBaseInfo info, SCMBillEntryBaseInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, info, entry, lineData);
        int seq = this.quotationInfo.getEntries().size() + 1;
        QuotationEntryInfo entryInfo = (QuotationEntryInfo)entry;
        this.quotationInfo.getEntries().add(entryInfo);
        entryInfo.setSeq(seq);
        entryInfo.setParent(this.quotationInfo);
        entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return QuotationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public String[] getPriceFields() {
        return this.priceFields;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.sale.app.QuotationQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Sale, (String)"quotation_view");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable reslut = new Hashtable();
        try {
            DataImportTools.putToHashtable(reslut, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(reslut, (Object)"FBizDate", (Object)rs.getString("bizDate"));
            DataImportTools.putToHashtable(reslut, (Object)"FCusPurNumber", (Object)rs.getString("cusPurNumber"));
            DataImportTools.putToHashtable(reslut, (Object)"FOrderCustomer_number", (Object)rs.getString("orderCustomer.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FOrderCustomer_name_l2", (Object)rs.getString("orderCustomer.name"));
            DataImportTools.putToHashtable(reslut, (Object)"FDeliveryType_number", (Object)rs.getString("deliveryType.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FSaleOrgUnit_number", (Object)rs.getString("saleOrgUnit.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FSaleOrgUnit_name_l2", (Object)rs.getString("saleOrgUnit.name"));
            DataImportTools.putToHashtable(reslut, (Object)"FSaleGroup_number", (Object)rs.getString("saleGroup.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FSaleGroup_name_l2", (Object)rs.getString("saleGroup.name"));
            DataImportTools.putToHashtable(reslut, (Object)"FSalePerson_number", (Object)rs.getString("salePerson.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FSalePerson_name_l2", (Object)rs.getString("salePerson.name"));
            DataImportTools.putToHashtable(reslut, (Object)"FCurrency_number", (Object)rs.getString("currency.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FCurrency_name_l2", (Object)rs.getString("currency.name"));
            if (StringUtil.isEmptyString((String)rs.getString("exchangeRate"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FExchangeRate", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal exchangeRate = new BigDecimal(rs.getString("exchangeRate"));
                DataImportTools.putToHashtable(reslut, (Object)"FExchangeRate", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)exchangeRate));
            }
            DataImportTools.putToHashtable(reslut, (Object)"FDescription", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(reslut, (Object)"FEnabledDate", (Object)rs.getString("enabledDate"));
            DataImportTools.putToHashtable(reslut, (Object)"FDisibleDate", (Object)rs.getString("disibleDate"));
            DataImportTools.putToHashtable(reslut, (Object)"FCreator_number", (Object)rs.getString("creator.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FCreateTime", (Object)rs.getString("createTime"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries_seq", (Object)rs.getString("entries.seq"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$material_number4idx", (Object)rs.getString("material.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$material_name4idx", (Object)rs.getString("material.name"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$assistProperty_number", (Object)rs.getString("assistProperty.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$unit_number", (Object)rs.getString("unit.number"));
            if (StringUtil.isEmptyString((String)rs.getString("entries.qtyFrom"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_qtyFrom", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal qtyFrom = new BigDecimal(rs.getString("entries.qtyFrom"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_qtyFrom", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qtyFrom));
            }
            if (StringUtil.isEmptyString((String)rs.getString("entries.qtyTo"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_qtyTo", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal qtyTo = new BigDecimal(rs.getString("entries.qtyTo"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_qtyTo", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qtyTo));
            }
            if (StringUtil.isEmptyString((String)rs.getString("entries.price"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_price", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal price = new BigDecimal(rs.getString("entries.price"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_price", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)price));
            }
            if (StringUtil.isEmptyString((String)rs.getString("entries.taxRate"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_taxRate", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal taxRate = new BigDecimal(rs.getString("entries.taxRate"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_taxRate", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)taxRate.setScale(4, 4)));
            }
            if (StringUtil.isEmptyString((String)rs.getString("entries.taxPrice"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_taxPrice", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal taxPrice = new BigDecimal(rs.getString("entries.taxPrice"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_taxPrice", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)taxPrice));
            }
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$project_number", (Object)rs.getString("project.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries$trackNumber_number", (Object)rs.getString("trackNumber.number"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries_discountType", (Object)rs.getString("entries.discountType"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries_discount", (Object)rs.getString("entries.discount"));
            if (StringUtil.isEmptyString((String)rs.getString("entries.actualTaxPrice"))) {
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_actualTaxPrice", (Object)DataImportUtils.transformValue(null));
            } else {
                BigDecimal actualTaxPrice = new BigDecimal(rs.getString("entries.actualTaxPrice"));
                DataImportTools.putToHashtable(reslut, (Object)"FEntries_actualTaxPrice", (Object)ImRptAppUtils.fmtDecimalStr((Context)ctx, (BigDecimal)actualTaxPrice));
            }
            DataImportTools.putToHashtable(reslut, (Object)"FEntries_deliveryDate", (Object)rs.getString("entries.deliveryDate"));
            DataImportTools.putToHashtable(reslut, (Object)"FEntries_remark", (Object)rs.getString("entries.remark"));
        }
        catch (SQLException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return reslut;
    }

    private Integer getQtyPrecisinByMaterialAndUnit(Context ctx, String materialId, String unitId) throws TaskExternalException {
        Integer result = null;
        String key = materialId + unitId;
        if (this.cacheMaterialUnit.containsKey(key)) {
            if (this.cacheMaterialUnit.get(key) != null) {
                result = this.cacheMaterialUnit.get(key).getQtyPrecision();
            }
        } else {
            HashMap tmp;
            try {
                tmp = SCMServerUtils.getMultiMeasureUnits((Context)ctx, (String[])new String[]{materialId}, (String[])new String[]{unitId});
            }
            catch (BOSException e) {
                throw new TaskExternalException("", (Throwable)e);
            }
            MultiMeasureUnitInfo unitInfo = (MultiMeasureUnitInfo)tmp.get(key);
            if (unitInfo != null) {
                result = unitInfo.getQtyPrecision();
            }
            this.cacheMaterialUnit.put(key, unitInfo);
        }
        if (result == null) {
            result = 8;
        }
        return result;
    }

    private String getParamValueByNumberAndOrg(Context ctx, String number, String orgId) throws EASBizException, BOSException {
        if (this.paramMap.get(orgId + number) == null) {
            ParamItemInfo paramItem = ParamControlFactory.getLocalInstance((Context)ctx).getParamItemByNumberAndOrg(number, orgId);
            this.paramMap.put(orgId + number, paramItem.getValue());
        }
        return this.paramMap.get(orgId + number).toString();
    }

    public String getImportPermissionItem() {
        return "quotation_addnew";
    }
}

