/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.IBizobjectFacade;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BillBizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillBizTypeInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.ParamsUtil;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleContractCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryAgent;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractException;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.SaleContractTermCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractTermInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleContractControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.calculate.SaleContractCal;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleContractControllerBean
extends AbstractSaleContractControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleContractControllerBean");
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleContractInfo saleContractInfo = (SaleContractInfo)model;
        if (!this.isAddNew(ctx, (IObjectValue)saleContractInfo)) {
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(saleContractInfo.getId()));
        }
        saleContractInfo.setVersion(0);
        SaleContractEntryCollection tmpEntries = saleContractInfo.getEntries();
        if (tmpEntries.size() == 0) {
            tmpEntries.add(SaleContractEntryAgent.create());
        }
        SaleContractEntryInfo entryInfo = null;
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = tmpEntries.get(i);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            this.setZero((CoreBaseInfo)entryInfo);
            SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)entryInfo);
        }
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)saleContractInfo);
        String srcBillid = null;
        if (model.get("srcBillID") != null) {
            srcBillid = model.get("srcBillID").toString();
        }
        IObjectPK pk = super._save(ctx, model);
        if (srcBillid != null) {
            IBizobjectFacade iBizobjectFacade = BizobjectFacadeFactory.getLocalInstance((Context)ctx);
            iBizobjectFacade.copyBizAttachmentFiles(srcBillid, pk.toString());
            srcBillid = null;
        }
        return pk;
    }

    private void setZero(CoreBaseInfo object) {
        String[] fields = new String[]{"assCoefficient", "associateQty", "baseQty", "qty", "price", "taxRate", "taxPrice", "discount", "actualPrice", "actualTaxPrice", "discountAmount", "amount", "tax", "taxAmount", "localAmount", "localTax", "localTaxAmount", "sendOverRate", "sendOwingRate", "prepaymentRate", "prepayment", "preReceived", "unPreReceivedAmount", "totalOrderedQty", "totalOrderedAmt", "totalReceivedAmt"};
        this.setIsNullValue(object, fields, SysConstant.BIGZERO);
    }

    private void setIsNullValue(CoreBaseInfo object, String[] fields, Object value) {
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            if (object.get(fields[i]) != null) continue;
            object.put(fields[i], value);
        }
    }

    protected void checkFieldBeforeSubmit(Context ctx, SaleContractInfo saleContractInfo) throws EASBizException, BOSException {
        if (saleContractInfo.getBizDate() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_CONTRACTDATE")});
        }
        if (saleContractInfo.getValidTo() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_VALIDTO")});
        }
        if (saleContractInfo.getContractType() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_CONTRACTTYPE")});
        }
        if (saleContractInfo.getCustomer() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_CUSTOMER")});
        }
        if (saleContractInfo.getBizType() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_BIZTYPE")});
        }
        if (saleContractInfo.getSaleOrgUnit() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_SALEORGUNIT")});
        }
        if (saleContractInfo.getSalePerson() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_SALEPERSON")});
        }
        if (saleContractInfo.getCurrency() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_CURRENCY")});
        }
        if (saleContractInfo.getExchangeRate() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_EXCHANGERATE")});
        }
        if (saleContractInfo.getDeliveryType() == null) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_DELIVERYTYPE")});
        }
        if (!"CARRY".equalsIgnoreCase(saleContractInfo.getDeliveryType().getNumber()) && saleContractInfo.getTransLeadTime() < 0) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_TRANSLEADTIME")});
        }
        if (saleContractInfo.getValidTo() == null) {
            throw new SaleContractException(SaleContractException.CONTRACTDATE_CANTNOT_NULL);
        }
        if (saleContractInfo.getEntries() == null || saleContractInfo.getEntries().size() == 0) {
            throw new SaleContractException(SaleContractException.ENTRY_CANNOT_EMPTY);
        }
        String saleOrgId = saleContractInfo.getSaleOrgUnit().getId().toString();
        String propStr = ParamsUtil.getParamsValue((Context)ctx, (ObjectUuidPK)new ObjectUuidPK(saleOrgId), (String)"SALEORDER100");
        boolean isAssistPropNotNecess = !StringUtils.isEmpty((String)propStr) && Boolean.parseBoolean(propStr);
        StringBuilder assistEmptyEntrySeqBuilder = new StringBuilder();
        for (int i = 0; i < saleContractInfo.getEntries().size(); ++i) {
            SaleContractEntryInfo entryInfo = saleContractInfo.getEntries().get(i);
            MaterialGroupInfo materialGroup = entryInfo.getMaterialGroup();
            MaterialInfo material = entryInfo.getMaterial();
            if (materialGroup != null && material != null) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"NotAllowBothExist_Material_Group"));
            }
            if (materialGroup == null && material == null) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"AtleastOnlyExist_Material_Group"));
            }
            if (material != null && entryInfo.getUnit() == null) {
                throw new BOSException(MessageFormat.format(SaleUtil.getUIResource("ORDERENTRYROWFIELD_CANNOTNULL"), entryInfo.getSeq(), SaleUtil.getUIResource("ORDER_FIELD_UNIT")));
            }
            if (material == null || material.getAssistAttr() == null || entryInfo.getAssistProperty() != null || isAssistPropNotNecess) continue;
            assistEmptyEntrySeqBuilder.append(i + 1).append("\u3001");
        }
        if (assistEmptyEntrySeqBuilder.length() != 0) {
            throw new SaleContractException(SaleContractException.ENTRY_FIELD_CANNOT_EMPTY, new String[]{assistEmptyEntrySeqBuilder.substring(0, assistEmptyEntrySeqBuilder.length() - 1), SaleUtil.getUIResource("ORDER_FIELD_ASISTPROPERTY")});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleContractInfo saleContractInfo = (SaleContractInfo)model;
        String orgUnitID = saleContractInfo.getSaleOrgUnit().getId().toString();
        boolean auditAfterSubmit = this.isAuditAfterSubmit(ctx, (SCMBillBaseInfo)saleContractInfo, orgUnitID, 2);
        if (!this.isAddNew(ctx, (IObjectValue)saleContractInfo)) {
            this.checkSubmit(ctx, (IObjectPK)new ObjectUuidPK(saleContractInfo.getId()));
        }
        this.checkFieldBeforeSubmit(ctx, saleContractInfo);
        if (saleContractInfo.getSourceBillType() != null && "510b6503-0105-1000-e000-9113c0a812fd463ED552".equals(saleContractInfo.getSourceBillType().getId().toString())) {
            StringBuffer checkBizDteSQL = new StringBuffer();
            checkBizDteSQL.append(" select saleContract.FID from T_SD_SaleContract saleContract left outer join T_SD_Quotation quotation on saleContract.FSourceBillID = quotation.FID");
            Date bizDate = SaleUtil.getBeginDate(saleContractInfo.getBizDate());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            checkBizDteSQL.append(" where ((quotation.FDisibleDate >= to_date('").append(sdf.format(bizDate)).append("')");
            checkBizDteSQL.append(" and quotation.FEnabledDate <= to_date('").append(sdf.format(bizDate)).append("')");
            checkBizDteSQL.append(" ) or quotation.FDisibleDate is null or quotation.FEnabledDate is null)");
            checkBizDteSQL.append(" and saleContract.FID = '").append(saleContractInfo.getId().toString()).append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)checkBizDteSQL.toString());
            try {
                if (rows == null || !rows.next()) {
                    throw new OrderException(OrderException.CONTRACT_CANNOT_BIZDATE);
                }
            }
            catch (SQLException e) {
                throw new OrderException(OrderException.CONTRACT_CANNOT_BIZDATE);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rows);
            }
        }
        if (saleContractInfo.getBillType() == null) {
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI="));
            saleContractInfo.setBillType(billTypeInfo);
        }
        saleContractInfo.setVersion(0);
        saleContractInfo.setOldID(null);
        SaleContractEntryCollection scEntryCollection = saleContractInfo.getEntries();
        int num = scEntryCollection.size();
        for (int i = 0; i < num; ++i) {
            SaleContractEntryInfo scEntryInfo = scEntryCollection.get(i);
            scEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            scEntryInfo.setAssociateQty(SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getBaseQty()));
            this.setZero((CoreBaseInfo)scEntryInfo);
            SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)scEntryInfo);
        }
        IObjectPK pk = super._submit(ctx, model);
        this.checkAfterSubmit(saleContractInfo);
        if (auditAfterSubmit) {
            ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
            ServiceStateManager.getInstance().reSetServiceState(ls);
            this.audit(ctx, pk);
            ServiceStateManager.getInstance().reSetServiceState(ls);
        }
        return pk;
    }

    private void checkAfterSubmit(SaleContractInfo saleContractInfo) throws SaleContractException {
        if (StringUtils.isEmpty((String)saleContractInfo.getNumber())) {
            throw new SaleContractException(SaleContractException.FIELD_CANNOT_EMPTY, new String[]{SaleUtil.getUIResource("CONTRACT_FIELD_NUMBER")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    public void submit(Context arg0, IObjectPK arg1, CoreBaseInfo arg2) throws BOSException, EASBizException {
        SaleContractInfo saleContractInfo = (SaleContractInfo)arg2;
        SaleContractEntryCollection tmpEntries = saleContractInfo.getEntries();
        SaleContractEntryInfo soEntryInfo = null;
        for (int i = tmpEntries.size() - 1; i >= 0; --i) {
            soEntryInfo = tmpEntries.get(i);
            this.setZero((CoreBaseInfo)soEntryInfo);
        }
        super.submit(arg0, arg1, arg2);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        SaleContractInfo saleContractInfo = this.getSaleContractInfo(ctx, pk, sic);
        if (saleContractInfo.getBaseStatus().getValue() == -2) {
            this._agreeAlter(ctx, pk);
        } else {
            this.isSamePerson4Audit(ctx, (SCMBillBaseInfo)saleContractInfo);
            this._audit(ctx, new IObjectPK[]{pk});
        }
    }

    protected void checkSaleContractAudit(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks == null) {
            return;
        }
        int[] statusValues = new int[]{2};
        if (this.checkHasNoEqualsStatus(ctx, pks, statusValues)) {
            if (pks.length > 1) {
                throw new PurOrderException(PurOrderException.ORDER_PARTCANNOT_AUDIT);
            }
            throw new PurOrderException(PurOrderException.ORDER_CANNOT_AUDIT_NOTSUBMIT);
        }
    }

    private boolean checkHasNoEqualsStatus(Context ctx, IObjectPK[] pks, int[] statusValues) throws BOSException, EASBizException {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(FID) counter FROM T_SD_SALECONTRACT ");
        sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
        sql.append(" AND FBASESTATUS NOT IN (");
        int length = statusValues.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(statusValues[i]);
        }
        sql.append("  )");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next() && rowSet.getInt("counter") > 0) {
                flag = true;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
        return flag;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Statement batchStatement;
        Statement statement;
        Connection con;
        block7: {
            this.checkSaleContractAudit(ctx, pks);
            con = null;
            statement = null;
            batchStatement = null;
            try {
                con = this.getConnection(ctx);
                statement = con.createStatement();
                batchStatement = con.createStatement();
                String params = StringUtil.getPKList((IObjectPK[])pks);
                String checkSql = "select FNumber from T_SD_SaleContract where fid in(?) and FBaseStatus <> 2";
                IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{params});
                if (checkSet.next() && checkSet.getString(1) != null) {
                    throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_AUDIT", (Context)ctx)});
                }
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("update T_SD_SaleContract set FBaseStatus = 4,FAuditorId= ");
                updateSql.append(" '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("',");
                updateSql.append(" FAuditTime = getDate() where fid in (").append(params).append(")");
                String updateEntrySql = "update T_SD_SaleContractEntry set FBaseStatus = 4 where FParentID in (" + params + ")";
                batchStatement.addBatch(updateSql.toString());
                batchStatement.addBatch(updateEntrySql);
                batchStatement.executeBatch();
                String tableName = "T_SD_SaleContractEntry";
                SaleContractInfo saleContractInfo = null;
                Set idSet = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (IObjectPK[])pks);
                if (idSet.size() <= 0) break block7;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractCollection coll = this.getSaleContractCollection(ctx, view);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        saleContractInfo = coll.get(i);
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleContractInfo, (BatchActionEnum)BatchActionEnum.AUDIT);
                    }
                }
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement, (Connection)con);
                    SQLUtils.cleanup(batchStatement, (Connection)con);
                    SQLUtils.cleanup((Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void _autoClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_SD_SALECONTRACT WHERE FID = '").append(pk.toString()).append("'");
        sql.append(" AND FBASESTAUTS <> ").append(7);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null && rowSet.size() > 0) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)("UPDATE T_SD_SALECONTRACT SET FBASESTATUS = 7 WHERE FID = '" + pk.toString() + "'"));
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        SaleContractInfo saleContractInfo = this.getSaleContractInfo(ctx, pk, selector);
        if (saleContractInfo.getBaseStatus().getValue() != 0 && saleContractInfo.getBaseStatus().getValue() != 1) {
            throw new SaleContractException(SaleContractException.CANNOT_UPDATE, new String[]{saleContractInfo.getBaseStatus().toString()});
        }
        this._canUpdate(ctx, pk);
    }

    private void checkSubmit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        SaleContractInfo saleContractInfo = this.getSaleContractInfo(ctx, pk, selector);
        if (saleContractInfo.getBaseStatus().getValue() != 0 && saleContractInfo.getBaseStatus().getValue() != 1 && saleContractInfo.getBaseStatus().getValue() != 2) {
            throw new SaleContractException(SaleContractException.CANNOT_SUBMIT, new String[]{saleContractInfo.getBaseStatus().toString()});
        }
    }

    private void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        SaleContractInfo saleContractInfo = this.getSaleContractInfo(ctx, pk, selector);
        if (saleContractInfo.getBaseStatus().getValue() != 0 && saleContractInfo.getBaseStatus().getValue() != 1 && saleContractInfo.getBaseStatus().getValue() != 2) {
            throw new SaleContractException(SaleContractException.CANNOT_DELETE, new String[]{saleContractInfo.getBaseStatus().toString()});
        }
    }

    @Override
    protected void _canRevoke(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkSaleContractRevoke(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _canRevoke(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleContractRevoke(ctx, pks);
    }

    private void checkSaleContractRevoke(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        SaleContractInfo saleContractInfo = this.getSaleContractInfo(ctx, pk, selector);
        if (saleContractInfo.getBaseStatus().getValue() != 1 && saleContractInfo.getBaseStatus().getValue() != 2) {
            throw new SaleContractException(SaleContractException.CANNOT_REVOKE, new String[]{saleContractInfo.getBaseStatus().toString()});
        }
    }

    private void checkSaleContractRevoke(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            if (pks.length == 1) {
                this.checkSaleContractRevoke(ctx, pks[0]);
            } else {
                int[] statusValues = new int[]{1, 2};
                if (this.checkHasNoEqualsStatus(ctx, pks, statusValues)) {
                    throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_REVOKE", (Context)ctx)});
                }
            }
        }
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        String reason = reasonCode == null ? null : ((ReasonCodeInfo)reasonCode).getName();
        this._revoke(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._revoke(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        String[] reasons = null;
        if (reasonCodes != null) {
            reasons = new String[reasonCodes.length];
            int num = reasonCodes.length;
            for (int i = 0; i < num; ++i) {
                reasons[i] = reasonCodes[i] == null ? null : ((ReasonCodeInfo)reasonCodes[i]).getName();
            }
        }
        this._revoke(ctx, pks, reasons);
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        SaleContractInfo saleContractInfo = null;
        String reason = reasons != null && reasons.length > 0 ? reasons[0] : "";
        this.checkSaleContractRevoke(ctx, pks);
        String tableName = "T_SD_SaleContractEntry";
        Set idSet = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleContractCollection coll = this.getSaleContractCollection(ctx, view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    saleContractInfo = coll.get(i);
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleContractInfo, (BatchActionEnum)BatchActionEnum.CANCEL);
                }
            }
        }
        if (pks != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_SD_SALECONTRACTENTRY SET FBASESTATUS = ").append(3);
            sql.append(" ,FREASON = '").append(reason).append("'");
            sql.append(" WHERE FPARENTID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("UPDATE T_SD_SALECONTRACT SET FBASESTATUS = ").append(3);
            sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _alert(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SaleContractInfo newSaleContractInfo = (SaleContractInfo)model;
        SaleContractInfo oldSaleContractInfo = this.getSaleContractInfo(ctx, pk);
        if (ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)oldSaleContractInfo, (AbstractObjectValue)newSaleContractInfo)) {
            return;
        }
        this.checkAlert(ctx, pk, newSaleContractInfo);
        newSaleContractInfo = this.getAlertSaleContractInfo(ctx, pk, newSaleContractInfo);
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)newSaleContractInfo);
        SaleContractEntryInfo entry = null;
        int count = newSaleContractInfo.getEntries().size();
        for (int i = 0; i < count; ++i) {
            entry = newSaleContractInfo.getEntries().get(i);
            SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)entry);
        }
        this.update(ctx, pk, newSaleContractInfo);
    }

    private void checkAlert(Context ctx, IObjectPK pk, SaleContractInfo newSaleContractInfo) throws EASBizException, BOSException {
        SaleContractInfo oldSaleContractInfo = this.getSaleContractInfo(ctx, pk);
        this.checkAlertStatus(oldSaleContractInfo);
        this.checkAlertData(ctx, oldSaleContractInfo, newSaleContractInfo);
    }

    private void checkAlertStatus(SaleContractInfo saleContractInfo) throws EASBizException {
        if (saleContractInfo.getBaseStatus().getValue() != 4 && saleContractInfo.getBaseStatus().getValue() != -2) {
            throw new SaleContractException(SaleContractException.CANNOT_ALTER, new String[]{saleContractInfo.getBaseStatus().toString()});
        }
    }

    private void buildSaleContractEntryInfo(SaleContractEntryInfo oldInfo, SaleContractEntryInfo newInfo) {
        oldInfo.setSeq(0);
        oldInfo.setAssociateQty(null);
        oldInfo.setDiscountCondition(DiscountConditionEnum.NULL);
        oldInfo.setOldStatus(EntryBaseStatusEnum.NULL);
        newInfo.setSeq(0);
        newInfo.setAssociateQty(null);
        newInfo.setDiscountCondition(DiscountConditionEnum.NULL);
        newInfo.setOldStatus(EntryBaseStatusEnum.NULL);
    }

    private void checkAlertData(Context ctx, SaleContractInfo SaleContractInfo2, SaleContractInfo newSaleContractInfo) throws SaleContractException, BOSException, OrderException {
        SaleContractEntryCollection oldSaleContractEntryCollection = SaleContractInfo2.getEntries();
        SaleContractEntryCollection newSaleContractEntryCollection = newSaleContractInfo.getEntries();
        SaleContractEntryInfo oldSaleContractEntryInfo = null;
        SaleContractEntryInfo newSaleContractEntryInfo = null;
        HashMap<String, SaleContractEntryInfo> newEntryMap = new HashMap<String, SaleContractEntryInfo>();
        for (int i = 0; i < newSaleContractEntryCollection.size(); ++i) {
            if (newSaleContractEntryCollection.get(i).getId() == null) continue;
            newEntryMap.put(newSaleContractEntryCollection.get(i).getId().toString(), newSaleContractEntryCollection.get(i));
        }
        boolean isError = false;
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer alertError = new StringBuffer();
        int num = oldSaleContractEntryCollection.size();
        for (int i = 0; i < num; ++i) {
            oldSaleContractEntryInfo = oldSaleContractEntryCollection.get(i);
            newSaleContractEntryInfo = (SaleContractEntryInfo)newEntryMap.get(oldSaleContractEntryCollection.get(i).getId().toString());
            if (newSaleContractEntryInfo == null) continue;
            this.buildSaleContractEntryInfo(oldSaleContractEntryInfo, newSaleContractEntryInfo);
            if (oldSaleContractEntryInfo.getBaseStatus().getValue() != 4 && oldSaleContractEntryInfo.getBaseStatus().getValue() != -2 && newSaleContractEntryInfo.getOldStatus().getValue() != -1 && !ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)oldSaleContractEntryInfo, (AbstractObjectValue)newSaleContractEntryInfo)) {
                if (isError) {
                    errorMsg.append(", ");
                }
                errorMsg.append(i + 1);
                isError = true;
                continue;
            }
            BigDecimal qty = newSaleContractEntryInfo.getQty();
            boolean isQtyUnCtrl = newSaleContractEntryInfo.isQuantityUnCtrl();
            BigDecimal totalOrderedQty = oldSaleContractEntryInfo.getTotalOrderedQty();
            BigDecimal bigDecimal = qty = qty == null ? SCMConstant.BIGDECIMAL_ZERO : qty;
            if (isQtyUnCtrl || totalOrderedQty == null || totalOrderedQty.compareTo(new BigDecimal("0.00")) <= 0 || (qty = qty.multiply(SCMConstant.BIGDECIMAL_ONE.add(newSaleContractEntryInfo.getSendOverRate().divide(SCMConstant.BIGDECIMAL_ONEHUNDRED)))).compareTo(totalOrderedQty) >= 0) continue;
            alertError.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"ContractCheckAlert", (String[])new String[]{String.valueOf(i + 1)}, (Context)ctx)).append("\n");
        }
        if (isError) {
            throw new SaleContractException(SaleContractException.ENTRY_CANNOT_ALTER, new String[]{errorMsg.toString()});
        }
        if (alertError.length() > 0) {
            throw new SaleContractException(SaleContractException.ALERT_ERROR, new String[]{alertError.toString()});
        }
        if (newSaleContractInfo.getSourceBillType() != null && "510b6503-0105-1000-e000-9113c0a812fd463ED552".equals(newSaleContractInfo.getSourceBillType().getId().toString()) && !newSaleContractInfo.getBizDate().equals(SaleContractInfo2.getBizDate())) {
            StringBuffer checkBizDteSQL = new StringBuffer();
            checkBizDteSQL.append(" select saleContract.FID from T_SD_SaleContract saleContract left outer join T_SD_Quotation quotation on saleContract.FSourceBillID = quotation.FID");
            Date bizDate = SaleUtil.getBeginDate(newSaleContractInfo.getBizDate());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            checkBizDteSQL.append(" where ((quotation.FDisibleDate >= to_date('").append(sdf.format(bizDate)).append("')");
            checkBizDteSQL.append(" and quotation.FEnabledDate <= to_date('").append(sdf.format(bizDate)).append("')");
            checkBizDteSQL.append(" ) or quotation.FDisibleDate is null or quotation.FEnabledDate is null)");
            checkBizDteSQL.append(" and saleContract.FID = '").append(newSaleContractInfo.getId().toString()).append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)checkBizDteSQL.toString());
            try {
                if (rows == null || !rows.next()) {
                    throw new OrderException(OrderException.CONTRACT_CANNOT_BIZDATE);
                }
            }
            catch (SQLException e) {
                throw new OrderException(OrderException.CONTRACT_CANNOT_BIZDATE);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rows);
            }
        }
    }

    private SaleContractInfo getAlertSaleContractInfo(Context ctx, IObjectPK pk, SaleContractInfo newSaleContractInfo) throws EASBizException, BOSException {
        if (pk == null) {
            return null;
        }
        SaleContractInfo SaleContractInfo2 = this.getSaleContractInfo(ctx, pk);
        return this.getAlertSaleContractInfo(ctx, SaleContractInfo2, newSaleContractInfo);
    }

    private SaleContractInfo getAlertSaleContractInfo(Context ctx, SaleContractInfo oldSaleContractInfo, SaleContractInfo newSaleContractInfo) {
        if (oldSaleContractInfo == null) {
            return null;
        }
        SaleContractEntryCollection SaleContractEntryCollection2 = oldSaleContractInfo.getEntries();
        SaleContractEntryCollection newSaleContractEntryCollection = newSaleContractInfo.getEntries();
        int num = SaleContractEntryCollection2.size() <= newSaleContractEntryCollection.size() ? SaleContractEntryCollection2.size() : newSaleContractEntryCollection.size();
        oldSaleContractInfo.setTotalTaxAmount(newSaleContractInfo.getTotalTaxAmount());
        oldSaleContractInfo.setLocalTotalTaxAmount(newSaleContractInfo.getLocalTotalTaxAmount());
        oldSaleContractInfo.setTotalTax(newSaleContractInfo.getTotalTax());
        oldSaleContractInfo.setTotalAmount(newSaleContractInfo.getTotalAmount());
        oldSaleContractInfo.setLocalTotalAmount(newSaleContractInfo.getLocalTotalAmount());
        oldSaleContractInfo.setPrepayment(newSaleContractInfo.getPrepayment());
        oldSaleContractInfo.setDeliveryAddress(newSaleContractInfo.getDeliveryAddress());
        if (newSaleContractInfo.getCU() == null) {
            newSaleContractInfo.setCU(super.getCU(ctx, (ObjectBaseInfo)newSaleContractInfo));
        }
        oldSaleContractInfo.setCU(newSaleContractInfo.getCU());
        newSaleContractInfo.setBillType(oldSaleContractInfo.getBillType());
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        newSaleContractInfo.setModifier(user);
        Date today = new Date();
        newSaleContractInfo.setModificationTime(new Timestamp(today.getTime()));
        oldSaleContractInfo.setModificationTime(newSaleContractInfo.getModificationTime());
        oldSaleContractInfo.setModifier(newSaleContractInfo.getModifier());
        newSaleContractInfo.setLastUpdateTime(oldSaleContractInfo.getLastUpdateTime());
        newSaleContractInfo.setLastUpdateUser(oldSaleContractInfo.getLastUpdateUser());
        SaleContractEntryInfo SaleContractEntryInfo2 = null;
        SaleContractEntryInfo newSaleContractEntryInfo = null;
        for (int i = 0; i < num; ++i) {
            SaleContractEntryInfo2 = SaleContractEntryCollection2.get(i);
            newSaleContractEntryInfo = newSaleContractEntryCollection.get(i);
            SaleContractEntryInfo2.setQty(newSaleContractEntryInfo.getQty());
            SaleContractEntryInfo2.setAmount(newSaleContractEntryInfo.getAmount());
            SaleContractEntryInfo2.setLocalAmount(newSaleContractEntryInfo.getLocalAmount());
            SaleContractEntryInfo2.setTax(newSaleContractEntryInfo.getTax());
            SaleContractEntryInfo2.setTaxAmount(newSaleContractEntryInfo.getTaxAmount());
            SaleContractEntryInfo2.setActualTaxPrice(newSaleContractEntryInfo.getActualTaxPrice());
            SaleContractEntryInfo2.setDiscountAmount(newSaleContractEntryInfo.getDiscountAmount());
            SaleContractEntryInfo2.setDiscount(newSaleContractEntryInfo.getDiscount());
            SaleContractEntryInfo2.setAssistQty(newSaleContractEntryInfo.getAssistQty());
            SaleContractEntryInfo2.setSendOverRate(newSaleContractEntryInfo.getSendOverRate());
            SaleContractEntryInfo2.setSendOwingRate(newSaleContractEntryInfo.getSendOwingRate());
            SaleContractEntryInfo2.setSendAdvanceDay(newSaleContractEntryInfo.getSendAdvanceDay());
            SaleContractEntryInfo2.setSendDeferralDay(newSaleContractEntryInfo.getSendDeferralDay());
            SaleContractEntryInfo2.setTaxPrice(newSaleContractEntryInfo.getTaxPrice());
            SaleContractEntryInfo2.setDeliveryDate(newSaleContractEntryInfo.getDeliveryDate());
            SaleContractEntryInfo2.setPrice(newSaleContractEntryInfo.getPrice());
            SaleContractEntryInfo2.setBaseQty(newSaleContractEntryInfo.getBaseQty());
            SaleContractEntryInfo2.setDiscountAmount(newSaleContractEntryInfo.getDiscountAmount());
            SaleContractEntryInfo2.setAssistQty(newSaleContractEntryInfo.getAssistQty());
            SaleContractEntryInfo2.setSendOverRate(newSaleContractEntryInfo.getSendOverRate());
            SaleContractEntryInfo2.setSendOwingRate(newSaleContractEntryInfo.getSendOwingRate());
        }
        return oldSaleContractInfo;
    }

    @Override
    protected void _alter(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SaleContractInfo newSaleContractInfo = (SaleContractInfo)model;
        SaleContractInfo oldSaleContractInfo = this.getSaleContractInfo(ctx, pk);
        this.checkAlert(ctx, pk, newSaleContractInfo);
        SaleContractEntryInfo entryInfo = null;
        int oldVersion = oldSaleContractInfo.getVersion();
        newSaleContractInfo.setOldStatus(BillBaseStatusEnum.AUDITED);
        newSaleContractInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        if (oldSaleContractInfo.getBaseStatus().getValue() == 4) {
            oldVersion = oldVersion > 0 ? oldVersion : 1;
            newSaleContractInfo.setVersion(oldVersion + 1);
        } else if (oldSaleContractInfo.getBaseStatus().getValue() == -2) {
            newSaleContractInfo.setVersion(oldVersion);
        }
        int pcCount = newSaleContractInfo.getEntries().size();
        for (int pc = 0; pc < pcCount; ++pc) {
            entryInfo = newSaleContractInfo.getEntries().get(pc);
            if (entryInfo.getBaseStatus().getValue() == 0 || entryInfo.getBaseStatus().getValue() == 1 || entryInfo.getBaseStatus().getValue() == 2) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            }
            this.setZero((CoreBaseInfo)entryInfo);
            entryInfo.setOldStatus(EntryBaseStatusEnum.AUDITED);
            if (entryInfo.getBaseStatus().getValue() != 4) continue;
            entryInfo.setBaseStatus(EntryBaseStatusEnum.ALTERING);
        }
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)newSaleContractInfo);
        SaleContractEntryInfo entry = null;
        int count = newSaleContractInfo.getEntries().size();
        for (int i = 0; i < count; ++i) {
            entry = newSaleContractInfo.getEntries().get(i);
            SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)entry);
        }
        newSaleContractInfo.setModificationTime(new Timestamp(new Date().getTime()));
        newSaleContractInfo.setModifier(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (oldSaleContractInfo.getBaseStatus().getValue() == 4) {
            BillEntryCustomCollection customEntry;
            oldSaleContractInfo.setOldID(oldSaleContractInfo.getId());
            oldSaleContractInfo.setId(null);
            oldSaleContractInfo.setVersion(oldVersion);
            oldSaleContractInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
            oldSaleContractInfo.setAlterDate(new Timestamp(new Date().getTime()));
            oldSaleContractInfo.setOldStatus(oldSaleContractInfo.getBaseStatus());
            oldSaleContractInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
            SaleContractEntryCollection oldSaleContractEntries = oldSaleContractInfo.getEntries();
            if (oldSaleContractInfo.getEntries() != null) {
                int pcCount2 = oldSaleContractEntries.size();
                for (int pc = 0; pc < pcCount2; ++pc) {
                    entryInfo = oldSaleContractEntries.get(pc);
                    entryInfo.setOldID(entryInfo.getId());
                    entryInfo.setId(null);
                    entryInfo.setOldStatus(entryInfo.getBaseStatus());
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.VERSION);
                    this.dealwithOtherEntry4Alert(entryInfo);
                }
            }
            SaleContractTermCollection contractTermEntries = oldSaleContractInfo.getTerms();
            SaleContractTermInfo termInfo = null;
            if (contractTermEntries != null) {
                int ctCount = contractTermEntries.size();
                for (int ct = 0; ct < ctCount; ++ct) {
                    termInfo = contractTermEntries.get(ct);
                    termInfo.setOldID(termInfo.getId());
                    termInfo.setId(null);
                }
            }
            if ((customEntry = (BillEntryCustomCollection)oldSaleContractInfo.get("entry")) != null) {
                for (int i = 0; i < customEntry.size(); ++i) {
                    customEntry.get(i).setId(null);
                }
            }
            this.addnew(ctx, oldSaleContractInfo);
            this.innerUpdate(ctx, pk, (IObjectValue)newSaleContractInfo);
        } else if (oldSaleContractInfo.getBaseStatus().getValue() == -2) {
            this.innerUpdate(ctx, pk, (IObjectValue)newSaleContractInfo);
            oldSaleContractInfo = this.getSaleContractInfo(ctx, "where number='" + oldSaleContractInfo.getNumber() + "' and version = " + String.valueOf(oldVersion - 1) + " and saleOrgUnit ='" + newSaleContractInfo.getSaleOrgUnit().getId() + "'");
            oldSaleContractInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
            oldSaleContractInfo.setAlterDate(new Timestamp(new Date().getTime()));
            this.innerUpdate(ctx, (IObjectPK)new ObjectUuidPK(oldSaleContractInfo.getId()), (IObjectValue)oldSaleContractInfo);
        }
        this._fixBizFlowNO(ctx, model.getString("id"), "t_sd_salecontract", "t_sd_salecontractentry", "foldid");
    }

    @Override
    protected void _agreeAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("saleOrgUnit.id"));
        selectors.add(new SelectorItemInfo("saleOrgUnit.name"));
        selectors.add(new SelectorItemInfo("oldStatus"));
        selectors.add(new SelectorItemInfo("entries.baseStatus"));
        selectors.add(new SelectorItemInfo("entries.qty"));
        selectors.add(new SelectorItemInfo("entries.oldStatus"));
        selectors.add(new SelectorItemInfo("entries.totalOrderedQty"));
        selectors.add(new SelectorItemInfo("entries.sendOwingRate"));
        selectors.add(new SelectorItemInfo("auditTime"));
        selectors.add(new SelectorItemInfo("auditor"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        SaleContractInfo updateSaleContractInfo = this.getSaleContractInfo(ctx, pk, selectors);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(updateSaleContractInfo.getSaleOrgUnit().getId());
        if (updateSaleContractInfo != null) {
            int i;
            SaleContractEntryInfo entryInfo = null;
            SaleContractEntryCollection saleContractCollenction = updateSaleContractInfo.getEntries();
            updateSaleContractInfo.setBaseStatus(updateSaleContractInfo.getOldStatus());
            BigDecimal qty = null;
            BigDecimal orderQty = null;
            BigDecimal sendOwingRate = null;
            StringBuffer updateSql = new StringBuffer("");
            ArrayList sqlList = new ArrayList();
            int pcCount = saleContractCollenction.size();
            for (int pc = 0; pc < pcCount; ++pc) {
                entryInfo = saleContractCollenction.get(pc);
                qty = entryInfo.getQty();
                orderQty = entryInfo.getTotalOrderedQty();
                sendOwingRate = entryInfo.getSendOwingRate() == null ? SCMConstant.BIGDECIMAL_ZERO : entryInfo.getSendOwingRate();
                qty = qty.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(sendOwingRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED)));
                if (orderQty != null && qty.compareTo(orderQty) <= 0 && SCMConstant.BIGDECIMAL_ZERO.compareTo(qty) != 0) {
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                    continue;
                }
                if (entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
                entryInfo.setBaseStatus(entryInfo.getOldStatus());
            }
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)updateSaleContractInfo, (BatchActionEnum)BatchActionEnum.ALTER);
            int num = saleContractCollenction.size();
            for (i = 0; i < num && saleContractCollenction.get(i).getBaseStatus() == EntryBaseStatusEnum.CLOSED; ++i) {
            }
            if (i == num) {
                updateSaleContractInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
            }
            updateSaleContractInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
            updateSaleContractInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            this._updatePartial(ctx, (IObjectValue)updateSaleContractInfo, selectors);
        }
    }

    @Override
    protected void _disaccordAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleContractInfo delSaleContractInfo = this.getSaleContractInfo(ctx, pk);
        int version = 1;
        version = delSaleContractInfo.getVersion();
        SaleContractInfo reSaleContract = null;
        Connection con = null;
        Statement statement = null;
        IRowSet checkSet = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String checkSql = "select FID from T_SD_SaleContract where FOldID= ? and FVersion= ?";
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{delSaleContractInfo.getId().toString(), Integer.toString(version - 1)});
            if (checkSet.next() && checkSet.getString("FID") != null) {
                reSaleContract = this.getSaleContractInfo(ctx, (IObjectPK)new ObjectUuidPK(checkSet.getString(1)));
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(checkSet, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)checkSet, (Statement)statement, (Connection)con);
        if (reSaleContract != null) {
            SaleContractEntryCollection reSaleContractEntries = null;
            SaleContractEntryInfo entryInfo = null;
            reSaleContract.setAlterDate(null);
            reSaleContract.setAlterPerson(null);
            reSaleContract.setBaseStatus(reSaleContract.getOldStatus());
            reSaleContractEntries = reSaleContract.getEntries();
            if (reSaleContractEntries != null) {
                int pcCount = reSaleContractEntries.size();
                for (int pc = 0; pc < pcCount; ++pc) {
                    entryInfo = reSaleContractEntries.get(pc);
                    entryInfo.setId(entryInfo.getOldID());
                    entryInfo.setBaseStatus(entryInfo.getOldStatus());
                    this.dealwithOtherEntry4DisaccordAlter(entryInfo);
                }
                SaleContractTermCollection contractTermEntries = reSaleContract.getTerms();
                SaleContractTermInfo termInfo = null;
                if (contractTermEntries != null) {
                    int ctCount = contractTermEntries.size();
                    for (int ct = 0; ct < ctCount; ++ct) {
                        termInfo = contractTermEntries.get(ct);
                        termInfo.setId(termInfo.getOldID());
                    }
                }
            }
            this.innerDelete(ctx, pk);
            this.innerDelete(ctx, (IObjectPK)new ObjectUuidPK(reSaleContract.getId().toString()));
            this.innerAddnew(ctx, (IObjectPK)new ObjectUuidPK(reSaleContract.getOldID().toString()), (IObjectValue)reSaleContract);
        }
    }

    protected void dealwithOtherEntry4DisaccordAlter(SaleContractEntryInfo entryInfo) {
    }

    protected void dealwithOtherEntry4Alert(SaleContractEntryInfo entryInfo) {
    }

    @Override
    protected void _checkAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleContractInfo SaleContractInfo2 = this.getSaleContractInfo(ctx, "select baseStatus where id = '" + pk.toString() + "'");
        this.checkAlertStatus(SaleContractInfo2);
    }

    @Override
    protected void _isNeedAlert(Context ctx, IObjectPK pk, BigDecimal alertDay) throws BOSException {
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IRowSet checkSet;
        Statement batchStatement;
        Connection con;
        block8: {
            int size = pks.length;
            for (int j = 0; j < size; ++j) {
                SaleContractInfo saleInfo = this.getSaleContractInfo(ctx, pks[j]);
                SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)saleInfo);
                this.isSamePerson4UnAudit(ctx, (SCMBillBaseInfo)saleInfo);
            }
            con = null;
            batchStatement = null;
            checkSet = null;
            try {
                con = this.getConnection(ctx);
                batchStatement = con.createStatement();
                String params = StringUtil.getPKList((IObjectPK[])pks);
                String checkSql = "select FNumber from T_SD_SaleContract where fid in(?) and FBaseStatus <> 4";
                checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{params});
                if (checkSet.next() && checkSet.getString(1) != null) {
                    throw new SaleContractException(SaleContractException.PART_CANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_UNAUDIT", (Context)ctx)});
                }
                String updateSql = "update T_SD_SaleContract set FBaseStatus = 1,FAuditorId=null,FAuditTime = null where fid in(" + params + ")";
                String updateEntrySql = "update T_SD_SaleContractEntry set FBaseStatus = 1 where FParentID in(" + params + ")";
                batchStatement.addBatch(updateSql);
                batchStatement.addBatch(updateEntrySql);
                batchStatement.executeBatch();
                String tableName = "T_SD_SaleContractEntry";
                SaleContractInfo saleContractInfo = null;
                Set idSet = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (IObjectPK[])pks);
                if (idSet.size() <= 0) break block8;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractCollection coll = this.getSaleContractCollection(ctx, view);
                if (coll != null && coll.size() > 0) {
                    int size2 = coll.size();
                    for (int i = 0; i < size2; ++i) {
                        saleContractInfo = coll.get(i);
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleContractInfo, (BatchActionEnum)BatchActionEnum.CANCEL);
                    }
                }
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(checkSet);
                    SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)checkSet);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, new IObjectPK[]{pk});
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        SaleContractInfo saleContractInfo = new SaleContractInfo();
        this.handleBizType(saleContractInfo, ctx);
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI="));
        saleContractInfo.setBillType(billTypeInfo);
        Calendar calendar = Calendar.getInstance();
        Date curDate = calendar.getTime();
        saleContractInfo.setBizDate(curDate);
        calendar.add(2, 1);
        Date validToDate = calendar.getTime();
        saleContractInfo.setValidTo(validToDate);
        DeliveryTypeInfo deliveryTypeInfo = DeliveryTypeFactory.getLocalInstance((Context)ctx).getDeliveryTypeInfo((IObjectPK)new ObjectUuidPK("51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F"));
        saleContractInfo.setDeliveryType(deliveryTypeInfo);
        PaymentTypeInfo paymentTypeInfo = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        saleContractInfo.setPaymentType(paymentTypeInfo);
        saleContractInfo.setCreateTime(new Timestamp(curDate.getTime()));
        return saleContractInfo;
    }

    private void handleBizType(SaleContractInfo saleContractInfo, Context ctx) throws BOSException, EASBizException {
        BillBizTypeInfo info;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("billType.number"));
        selector.add(new SelectorItemInfo("bizType.name"));
        selector.add(new SelectorItemInfo("bizType.number"));
        selector.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-010e-1000-e000-04c5c0a812202407435C"));
        filter.getFilterItems().add(new FilterItemInfo("bizType.status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"300"));
        filter.getFilterItems().add(new FilterItemInfo("selfmade", (Object)true));
        view.setFilter(filter);
        view.setSelector(selector);
        BillBizTypeCollection billBizTypeColl = BillBizTypeFactory.getLocalInstance((Context)ctx).getBillBizTypeCollection(view);
        if (null != billBizTypeColl && billBizTypeColl.size() > 0 && null != (info = billBizTypeColl.get(0))) {
            BizTypeInfo bizTypeInfo = info.getBizType();
            saleContractInfo.setBizType(bizTypeInfo);
        }
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo couInfo = null;
        SaleOrgUnitInfo saleInfo = null;
        CustomerCompanyInfoInfo customerCompanyInfoInfo = null;
        CustomerSaleInfoInfo customerSaleInfoInfo = null;
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            SaleContractInfo scInfo = (SaleContractInfo)collection.getObject(i);
            BillTypeInfo sourceBillTypeInfo = scInfo.getSourceBillType();
            if (sourceBillTypeInfo == null || !"510b6503-0105-1000-e000-9113c0a812fd463ED552".equals(sourceBillTypeInfo.getId().toString())) continue;
            if (scInfo.getBizDate() == null) {
                scInfo.setBizDate(new Date());
            }
            this.calByUnitSource(ctx, (SCMBillBaseInfo)scInfo, (IObjectCollection)scInfo.getEntries());
            scInfo.setValidTo(this.addDate(scInfo.getBizDate(), 2, 1));
            if (scInfo.getCurrency() != null) {
                CurrencyInfo currencyInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(scInfo.getCurrency().getId()));
                scInfo.setCurrency(currencyInfo);
            }
            SCMBizDataVO paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, scInfo);
            SCMBizDataVO resultScmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnitByPerson(ctx, scInfo, resultScmBizDataVO);
            couInfo = (CompanyOrgUnitInfo)resultScmBizDataVO.getDefaultDelegatedOrg().get(OrgType.Company);
            saleInfo = scInfo.getSaleOrgUnit();
            scInfo.setAdminOrgUnit(adminOrgUnitInfo);
            this.reCalcAmount(ctx, scInfo, resultScmBizDataVO);
            Object warehsInfo = null;
            Object materialInfo = null;
            HashSet<String> idsSet = new HashSet<String>();
            IMaterialInventory imaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo warehouseView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int row = 0; row < scInfo.getEntries().size(); ++row) {
                idsSet.add(scInfo.getEntries().get(row).getMaterial().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
            warehouseView.getSelector().add(new SelectorItemInfo("Material.id"));
            warehouseView.getSelector().add(new SelectorItemInfo("defaultWarehouse.*"));
            warehouseView.setFilter(filter);
            MaterialInventoryCollection collections = imaterialInventory.getMaterialInventoryCollection(warehouseView);
            for (int row = 0; row < scInfo.getEntries().size(); ++row) {
                if (scInfo.getEntries().get(row).getStorageOrgUnit() == null || scInfo.getEntries().get(row).getWarehouse() != null) continue;
                for (int j = 0; j < collections.size(); ++j) {
                    if (!scInfo.getEntries().get(row).getMaterial().getId().equals((Object)collections.get(j).getMaterial().getId()) || collections.get(j).getDefaultWarehouse() == null || !collections.get(j).getDefaultWarehouse().getStorageOrg().getId().toString().equals(scInfo.getEntries().get(row).getStorageOrgUnit().getId().toString())) continue;
                    scInfo.getEntries().get(row).setWarehouse(collections.get(j).getDefaultWarehouse());
                }
            }
            if (saleInfo != null && scInfo.getCustomer() != null) {
                ObjectUuidPK salePK = new ObjectUuidPK(scInfo.getCustomer().getId().toString());
                ObjectUuidPK saleOrgUnitPK = new ObjectUuidPK(saleInfo.getId().toString());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("transAdvanceDay"));
                customerSaleInfoInfo = iCustomer.getCustomerSaleInfo((IObjectPK)salePK, (IObjectPK)saleOrgUnitPK, sic);
                if (customerSaleInfoInfo != null && customerSaleInfoInfo.getTransAdvanceDay() != null) {
                    scInfo.setTransLeadTime(customerSaleInfoInfo.getTransAdvanceDay().intValue());
                }
            }
            if ((scInfo.getReceiveCondition() == null || scInfo.getSettlementType() == null || scInfo.getPaymentType() == null) && couInfo != null && scInfo.getCustomer() != null) {
                ObjectUuidPK customerPK = new ObjectUuidPK(scInfo.getCustomer().getId().toString());
                ObjectUuidPK companyOrgUnitPK = new ObjectUuidPK(couInfo.getId().toString());
                customerCompanyInfoInfo = iCustomer.getCustomerCompanyInfo((IObjectPK)customerPK, (IObjectPK)companyOrgUnitPK, this.getCustomerCompanyInfoSelector());
            }
            if (customerCompanyInfoInfo == null) continue;
            if (scInfo.getReceiveCondition() == null) {
                scInfo.setReceiveCondition(customerCompanyInfoInfo.getPayCondition());
            }
            if (scInfo.getSettlementType() == null) {
                scInfo.setSettlementType(customerCompanyInfoInfo.getSettlementType());
            }
            if (scInfo.getPaymentType() != null) continue;
            scInfo.setPaymentType(customerCompanyInfoInfo.getPaymentType());
        }
    }

    protected SelectorItemCollection getCustomerCompanyInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("settlementCurrency.*"));
        sic.add(new SelectorItemInfo("paymentType.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("payCondition.*"));
        return sic;
    }

    protected AdminOrgUnitInfo getAdminOrgUnitByPerson(Context ctx, SaleContractInfo scInfo, SCMBizDataVO resultScmBizDataVO) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        SaleOrgUnitInfo saleOrgUnifInfo = scInfo.getSaleOrgUnit();
        if (saleOrgUnifInfo != null) {
            boolean isAdminOrgUnitByPerson = Boolean.valueOf(resultScmBizDataVO.getParametersMap().get("SALEORDER001").toString());
            if (isAdminOrgUnitByPerson) {
                if (scInfo.getSalePerson() != null && scInfo.getSalePerson().getId() != null) {
                    adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(scInfo.getSalePerson().getId());
                }
            } else {
                adminOrgUnitInfo = (AdminOrgUnitInfo)resultScmBizDataVO.getDefaultDelegatedOrg().get(OrgType.Admin);
            }
        }
        return adminOrgUnitInfo;
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, SaleContractInfo scInfo) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)scInfo), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(this.getBOSType().toString());
        scmBizDataVO.setParameters(this.getParameterNames());
        scmBizDataVO.setDelegatedOrgTypes(this.getDelegatedOrgTypes());
        SaleOrderDataVO scmEntryDataVO = new SaleOrderDataVO();
        scmEntryDataVO.setCurrencyInfo(scInfo.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmEntryDataVO.setIsLoadingMou(true);
        scmEntryDataVO.setIsLoadingMmuPrecision(true);
        scmEntryDataVO.setIsLoadingMaterialSale(true);
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        this.initSCMBizDataVO(ctx, scmBizDataVO, scInfo.getEntries());
        SaleOrderDataVO saleOrderDataVO = (SaleOrderDataVO)scmBizDataVO.getScmEntryDataVO();
        saleOrderDataVO.setMainOrgType(this.getMainBizOrgType());
        saleOrderDataVO.setMainOrg(this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)scInfo));
        return scmBizDataVO;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String[] getParameterNames() {
        String[] parameters = new String[]{"SALEORDER001"};
        return parameters;
    }

    protected HashSet<Object> getDelegatedOrgTypes() {
        HashSet<Object> delegateOrgTypeSet = new HashSet<Object>();
        delegateOrgTypeSet.add(OrgType.Admin);
        delegateOrgTypeSet.add(OrgType.Company);
        delegateOrgTypeSet.add(OrgType.Storage);
        return delegateOrgTypeSet;
    }

    protected void reCalcAmount(Context ctx, SaleContractInfo scInfo, SCMBizDataVO vo) throws BOSException, EASBizException {
        SaleOrderDataVO scmEntryDataVO = (SaleOrderDataVO)vo.getScmEntryDataVO();
        CurrencyInfo baseCurrencyInfo = vo.getBaseCurrInfo();
        CurrencyInfo currencyInfo = scInfo.getCurrency();
        BigDecimal exchangeRate = scInfo.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = vo.getScmEntryDataVO().getExchangeAuxInfo();
        Map msInfos = ((SaleOrderDataVO)vo.getScmEntryDataVO()).getMaterialSalesInfos();
        boolean isContainsTax = scInfo.isIsInTax();
        int localScale = baseCurrencyInfo.getPrecision();
        int scale = currencyInfo.getPrecision();
        BigDecimal totalAmount = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal totalTax = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal totalTaxAmount = SCMConstant.BIGDECIMAL_ZERO;
        SaleContractEntryCollection sceCollection = scInfo.getEntries();
        try {
            SaleContractControllerBean.formatQtyPrecision((AbstractObjectCollection)sceCollection, (Method)SaleContractEntryInfo.class.getMethod("getQty", new Class[0]), (Method)SaleContractEntryInfo.class.getMethod("setBaseQty", BigDecimal.class), (Method)SaleContractEntryInfo.class.getMethod("setAssistQty", BigDecimal.class), (Method)SaleContractEntryInfo.class.getMethod("setAssistUnit", MeasureUnitInfo.class), (Method)SaleContractEntryInfo.class.getMethod("getAssistQty", new Class[0]), (SCMEntryDataVO)scmEntryDataVO);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)vo.getDefaultDelegatedOrg().get(OrgType.Storage);
        int m = sceCollection.size();
        for (int j = 0; j < m; ++j) {
            SaleContractEntryInfo scEntryInfo = sceCollection.get(j);
            MaterialInfo materialInfo = scEntryInfo.getMaterial();
            if (materialInfo == null) continue;
            materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            if (scEntryInfo.getStorageOrgUnit() == null) {
                scEntryInfo.setStorageOrgUnit(storageUnitInfo);
            }
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getQty());
            BigDecimal price = SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getPrice());
            BigDecimal taxRate = SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getTaxRate());
            BigDecimal taxPrice = SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getTaxPrice());
            int priceScale = materialInfo.getPricePrecision();
            DiscountModeEnum discountMode = scEntryInfo.getDiscountType();
            if (discountMode == null) {
                discountMode = DiscountModeEnum.PERCENT;
            }
            BigDecimal discount = SCMUtils.effectualNumeric((BigDecimal)scEntryInfo.getDiscount());
            BigDecimal actualPrice = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal amount = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal tax = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal taxAmount = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal discountAmount = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal localAmount = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal localTax = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal localTaxAmount = SCMConstant.BIGDECIMAL_ZERO;
            if (isContainsTax) {
                BigDecimal actualTaxPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)taxPrice, (BigDecimal)discount, (int)10);
                taxAmount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualTaxPrice2, (int)scale);
                tax = taxAmount.multiply(taxRate).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED.add(taxRate), scale, 4);
                amount = taxAmount.subtract(tax);
                discountAmount = CalculateUtils.calDiscountAmountByTaxAmount((BigDecimal)taxPrice, (BigDecimal)qty, (BigDecimal)taxAmount, (int)scale);
                actualPrice = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)price, (BigDecimal)discount, (int)priceScale);
            } else {
                BigDecimal actualPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)price, (BigDecimal)discount, (int)10);
                amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualPrice2, (int)scale);
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
                taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
                discountAmount = CalculateUtils.calDiscountAmount((DiscountModeEnum)discountMode, (BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale, (boolean)isContainsTax);
                actualPrice = actualPrice2.setScale(priceScale, 4);
            }
            localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            scEntryInfo.setAmount(amount);
            scEntryInfo.setTax(tax);
            scEntryInfo.setTaxAmount(taxAmount);
            scEntryInfo.setDiscountAmount(discountAmount);
            scEntryInfo.setActualPrice(actualPrice);
            scEntryInfo.setLocalAmount(localAmount);
            scEntryInfo.setLocalTax(localTax);
            scEntryInfo.setLocalTaxAmount(localTaxAmount);
            if (msInfos == null || msInfos.get(materialInfo.getId().toString()) == null) continue;
            MaterialSalesInfo msInfo = (MaterialSalesInfo)msInfos.get(materialInfo.getId().toString());
            scEntryInfo.setSendOverRate(new BigDecimal(String.valueOf(msInfo.getIssueTopRatio())));
            scEntryInfo.setSendOwingRate(new BigDecimal(String.valueOf(msInfo.getIssueBottomRatio())));
            scEntryInfo.setSendAdvanceDay(msInfo.getDaydAhead());
            scEntryInfo.setSendDeferralDay(msInfo.getDaysDelay());
        }
        scInfo.setTotalAmount(totalAmount);
        scInfo.setTotalTax(totalTax);
        scInfo.setTotalTaxAmount(totalTaxAmount);
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((SaleContractInfo)model).getSaleOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    public String getParamCon4Audit() {
        return "SALEBILL002";
    }

    public String getParamCon4UnAudit() {
        return "SALEBILL003";
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        SaleContractEntryInfo saleContractEntryInfo = (SaleContractEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = saleContractEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = saleContractEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = saleContractEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)saleContractEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)saleContractEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        saleContractEntryInfo.setQty(qty);
        SaleContractInfo saleContractInfo = (SaleContractInfo)scmBillBaseInfo;
        SaleContractCal saleContractCal = new SaleContractCal();
        saleContractCal.setInTax(saleContractInfo.isIsInTax());
        BigDecimal price = null;
        if (saleContractInfo.isIsInTax()) {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleContractEntryInfo.getTaxPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            saleContractEntryInfo.setTaxPrice(price);
            saleContractCal.calByEntryTaxPriceChange((SCMBillBaseInfo)saleContractInfo, (SCMBillEntryBaseInfo)saleContractEntryInfo);
        } else {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleContractEntryInfo.getPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            saleContractEntryInfo.setPrice(price);
            saleContractCal.calByEntryPriceChange((SCMBillBaseInfo)saleContractInfo, (SCMBillEntryBaseInfo)saleContractEntryInfo);
        }
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        SaleContractInfo model = null;
        model = this.getSaleContractInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }
}

