/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.IReqPlanSaleOrderFacade;
import com.kingdee.eas.mm.planning.ReqPlanSaleOrderFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.reservation.service.ReservationBillCloseService;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderArClosedStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleOrderEntryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleOrderEntryControllerBean
extends AbstractSaleOrderEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleOrderEntryControllerBean");

    protected void changeOrderEntryStatus(ISaleOrderEntry iSaleOrderEntry, IObjectPK pk, EntryBaseStatusEnum newStatus) throws EASBizException, BOSException {
        this.changeOrderEntryStatus(iSaleOrderEntry, pk, newStatus, new String(""));
    }

    protected void changeOrderEntryStatus(ISaleOrderEntry iSaleOrderEntry, IObjectPK pk, EntryBaseStatusEnum newStatus, ReasonCodeInfo reasonCodeInfo) throws EASBizException, BOSException {
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select baseStatus,reason,id where id = '" + pk.toString() + "'");
        saleOrderEntryInfo.setBaseStatus(newStatus);
        if (reasonCodeInfo != null) {
            saleOrderEntryInfo.setReason(reasonCodeInfo.getName());
        }
        iSaleOrderEntry.update(pk, (CoreBaseInfo)saleOrderEntryInfo);
    }

    protected void changeOrderEntryStatus(ISaleOrderEntry iSaleOrderEntry, IObjectPK pk, EntryBaseStatusEnum newStatus, String reasonCodeInfo) throws EASBizException, BOSException {
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select baseStatus,reason,id where id = '" + pk.toString() + "'");
        saleOrderEntryInfo.setBaseStatus(newStatus);
        saleOrderEntryInfo.setReason(reasonCodeInfo);
        iSaleOrderEntry.update(pk, (CoreBaseInfo)saleOrderEntryInfo);
    }

    public void checkSaleOrderEntryFreezed(Context ctx, ISaleOrderEntry iSaleOrderEntry, IObjectPK pk) throws EASBizException, BOSException {
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select qty,baseStatus where id = '" + pk.toString() + "'");
        if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_FREEZE);
        }
        if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) {
            throw new OrderException(OrderException.ONLYAUDITEDORDER_CANNOT_FREEZED);
        }
    }

    public void checkSaleOrderEntryUnFreezed(Context ctx, ISaleOrderEntry iSaleOrderEntry, IObjectPK pk) throws EASBizException, BOSException {
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select baseStatus where id = '" + pk.toString() + "'");
        if (saleOrderEntryInfo.getBaseStatus().getValue() != 6) {
            throw new OrderException(OrderException.ONLYBLOCKEDDORDER_CANNOT_UNFREEZED);
        }
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select parent where id = '" + entryPk.toString() + "'");
        ISaleOrder iSalseOrder = SaleOrderFactory.getLocalInstance(ctx);
        SaleOrderInfo saleOrderInfo = iSalseOrder.getSaleOrderInfo("select entries.baseStatus where id = '" + saleOrderEntryInfo.getParent().getId().toString() + "'");
        SaleOrderEntryCollection saleOrderCollenction = saleOrderInfo.getEntries();
        int num = saleOrderCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (saleOrderCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    private void changeSaleOrderStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        if (entryPk == null) {
            return;
        }
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select parent where id = '" + entryPk.toString() + "'");
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(saleOrderEntryInfo.getParent().getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseStatus"));
        SaleOrderInfo saleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)orderPK, selector);
        saleOrderInfo.setBaseStatus(newStatus);
        iSaleOrder.updatePartial((CoreBaseInfo)saleOrderInfo, selector);
    }

    private void changeStatusBySaleOrder(Context ctx, SaleOrderInfo saleOrderInfo, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        if (saleOrderInfo == null) {
            return;
        }
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseStatus"));
        saleOrderInfo.setBaseStatus(newStatus);
        iSaleOrder.updatePartial((CoreBaseInfo)saleOrderInfo, selector);
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        this.checkSaleOrderEntryFreezed(ctx, iSaleOrderEntry, pk);
        this.changeOrderEntryStatus(iSaleOrderEntry, pk, EntryBaseStatusEnum.BLOCKED, (ReasonCodeInfo)reasonCode);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.BLOCKED)) {
            this.changeSaleOrderStatus(ctx, pk, BillBaseStatusEnum.BLOCKED);
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCode) throws BOSException, EASBizException {
        this.checkSaleOrderEntryFreezed(ctx, pks);
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            ReasonCodeInfo reasonCodeInfo = null;
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            ObjectUuidPK parentEntryPK = null;
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("parent"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                reasonCodeInfo = reasonCode == null || reasonCode[i] == null ? null : (ReasonCodeInfo)reasonCode[i];
                this.changeOrderEntryStatus(iSaleOrderEntry, (IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getId()), EntryBaseStatusEnum.BLOCKED, reasonCodeInfo);
                orderPK = new ObjectUuidPK(saleOrderEntryInfo.getParent().getId());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                    this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.BLOCKED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.BLOCKED);
            }
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        SaleOrderInfo info = null;
        SaleOrderEntryInfo entryInfo = null;
        SaleOrderEntryCollection entryColl = null;
        if (pks == null || pks.length == 0 || reasons == null || reasons.length == 0) {
            return;
        }
        Set billIdSet = this.checkOrderEntryFreezed(ctx, pks);
        HashSet<String> saleOrderEIDSet = new HashSet<String>();
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            saleOrderEIDSet.add(pks[i].toString());
        }
        String billEntryTableName = "T_SD_SaleOrderEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)billEntryTableName, saleOrderEIDSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet idSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                idSet.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderCollection coll = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (SaleOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.FREEZE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String reason = reasons != null && reasons.length > 0 ? reasons[0] : "";
        sql.append("UPDATE T_SD_SaleOrderEntry SET FBASESTATUS = ").append(6);
        sql.append(",FREASON = '").append(reason).append("'");
        sql.append(" WHERE FID IN (").append(StringUtil.getPKList((IObjectPK[])pks)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (billIdSet != null && billIdSet.size() > 0) {
            sql.setLength(0);
            String parentids = SCMServerUtils.getInStringFromSet((Set)billIdSet);
            sql.append(" update T_SD_SaleOrder set FBaseStatus = ").append(6);
            sql.append(" where fid in ").append(parentids);
            sql.append(" and fid not in (select fparentid from T_SD_SaleOrderEntry where fbasestatus<>6 and fparentid in ");
            sql.append(parentids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._freezed(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    private IObjectValue getUserFromPerson(IObjectValue personInfo) throws BOSException, EASBizException {
        UserInfo userInfo = new UserInfo();
        if (personInfo != null) {
            PersonInfo personInfoResult = (PersonInfo)personInfo;
            String personID = personInfoResult.getId().toString();
            String oql = "select id,name where person.id=" + personID;
            IUser iuser = UserFactory.getRemoteInstance();
            UserCollection userCollection = iuser.getUserCollection(oql);
            if (userCollection != null && userCollection.size() > 0) {
                return userInfo;
            }
        }
        return null;
    }

    private IObjectValue getBotpResourceInfo(Context ctx, IObjectValue aimValue) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleOrderEntryUnFreezed(ctx, pks);
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            ISaleOrder iSalseOrder = SaleOrderFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            SaleOrderInfo saleOrderInfo = null;
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("parent"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                this.changeOrderEntryStatus(iSaleOrderEntry, (IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getId()), EntryBaseStatusEnum.AUDITED);
                orderPK = new ObjectUuidPK(saleOrderEntryInfo.getParent().getId());
                if (parentOrderPK != null && parentOrderPK.equals((Object)orderPK)) continue;
                saleOrderInfo = iSalseOrder.getSaleOrderInfo("select baseStatus,id where id = '" + orderPK + "'");
                if (saleOrderInfo.getBaseStatus().getValue() == 6) {
                    this.changeStatusBySaleOrder(ctx, saleOrderInfo, BillBaseStatusEnum.AUDITED);
                }
                parentOrderPK = orderPK;
            }
        }
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleOrderInfo saleOrderInfo = null;
        SaleOrderEntryInfo entryInfo = null;
        String tableName = "T_SD_SaleOrderEntry";
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        this.checkSaleOrderEntryUnFreezed(ctx, iSaleOrderEntry, pk);
        this.changeOrderEntryStatus(iSaleOrderEntry, pk, EntryBaseStatusEnum.AUDITED);
        entryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select parent where id = '" + pk.toString() + "'");
        ISaleOrder iSalseOrder = SaleOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(entryInfo.getParent().getId());
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, idSet)) {
            saleOrderInfo = iSalseOrder.getSaleOrderInfo((IObjectPK)orderPK);
            SaleOrderEntryCollection entryColl = (SaleOrderEntryCollection)((Object)saleOrderInfo.getEntries().clone());
            saleOrderInfo.getEntries().clear();
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entryColl.get(i);
                if (!entryInfo.getId().toString().equals(pk.toString())) continue;
                saleOrderInfo.getEntries().add(entryInfo);
            }
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleOrderInfo, (BatchActionEnum)BatchActionEnum.UNFREEZE);
        } else {
            saleOrderInfo = iSalseOrder.getSaleOrderInfo("select baseStatus,id where id = '" + orderPK + "'");
        }
        if (saleOrderInfo.getBaseStatus().getValue() == 6) {
            this.changeStatusBySaleOrder(ctx, saleOrderInfo, BillBaseStatusEnum.AUDITED);
        }
    }

    @Override
    protected void _autoClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select qty,totalIssueQty where id = '" + pk + "'");
        if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) > 0 && saleOrderEntryInfo.getTotalIssueQty().compareTo(saleOrderEntryInfo.getQty()) == 0) {
            this.changeSaleOrderStatus(ctx, pk, BillBaseStatusEnum.CLOSED);
        }
    }

    public void checkSaleOrderEntryHandClose(Context ctx, ISaleOrderEntry iSaleOrderEntry, IObjectPK pk) throws EASBizException, BOSException {
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo("select baseStatus,qty where id = '" + pk + "'");
        if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) {
            throw new OrderException(OrderException.ORDER_CANNOT_CLOSE, new String[]{saleOrderEntryInfo.getBaseStatus().toString()});
        }
        if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_CLOSE);
        }
    }

    public void checkSaleOrderEntryHandClose(Context ctx, SaleOrderEntryInfo saleOrderEntryInfo) throws EASBizException, BOSException {
        if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) {
            throw new OrderException(OrderException.ORDER_CANNOT_CLOSE, new String[]{saleOrderEntryInfo.getBaseStatus().toString()});
        }
        if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) < 0) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_CLOSE);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        this.checkSaleOrderEntryHandClose(ctx, pks);
        ArrayList<String> listReqPlan = new ArrayList<String>();
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            ObjectUuidPK parentEntryPK = null;
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            ReasonCodeInfo reasonCodeInfo = null;
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("parent"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                reasonCodeInfo = reasonCodes == null ? null : (ReasonCodeInfo)reasonCodes[i];
                this.changeOrderEntryStatus(iSaleOrderEntry, (IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getId()), EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                orderPK = new ObjectUuidPK(saleOrderEntryInfo.getParent().getId());
                listReqPlan.add(saleOrderEntryInfo.getParent().getId().toString());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                    this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
        }
        this.autoUnlockInvWhenCloseOrder(ctx, pks);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.CLOSE);
        WriteBackNetOrderHandleFactory.entryHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.CLOSE, (IObjectPK[])pks);
        if (listReqPlan.size() > 0) {
            IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)ctx);
            iReqPlanSaleOrderFacade.requireFromSaleOrder(listReqPlan, BizActionEnum.CLOSE);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        this.checkSaleOrderEntryHandClose(ctx, pks);
        ArrayList<String> listReqPlan = new ArrayList<String>();
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            ObjectUuidPK parentEntryPK = null;
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            String reasonCodeInfo = null;
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("parent"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                reasonCodeInfo = reasons == null ? null : reasons[i];
                this.changeOrderEntryStatus(iSaleOrderEntry, (IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getId()), EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                orderPK = new ObjectUuidPK(saleOrderEntryInfo.getParent().getId());
                listReqPlan.add(saleOrderEntryInfo.getParent().getId().toString());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                    this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = new ObjectUuidPK(saleOrderEntryInfo.getId());
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changeSaleOrderStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
        }
        this.autoUnlockInvWhenCloseOrder(ctx, pks);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.CLOSE);
        WriteBackNetOrderHandleFactory.entryHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.CLOSE, (IObjectPK[])pks);
        if (listReqPlan.size() > 0) {
            IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)ctx);
            iReqPlanSaleOrderFacade.requireFromSaleOrder(listReqPlan, BizActionEnum.CLOSE);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK billId, IObjectPK pk, String reason) throws BOSException, EASBizException {
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        if (pk == null) {
            return;
        }
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("qty"));
        saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo(pk, sic);
        this.checkSaleOrderEntryHandClose(ctx, saleOrderEntryInfo);
        String tableName = "T_SD_SaleOrderEntry";
        boolean isHasFlow = false;
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, idSet)) {
            isHasFlow = true;
            SaleOrderInfo orderInfo = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getParent().getId().toString()));
            if (orderInfo != null) {
                SaleOrderEntryCollection entryColl = (SaleOrderEntryCollection)((Object)orderInfo.getEntries().clone());
                orderInfo.getEntries().clear();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    saleOrderEntryInfo = entryColl.get(i);
                    if (!pk.toString().equals(saleOrderEntryInfo.getId().toString())) continue;
                    orderInfo.getEntries().add(saleOrderEntryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)orderInfo, (BatchActionEnum)BatchActionEnum.CLOSE);
            }
        }
        this.changeOrderEntryStatus(iSaleOrderEntry, pk, EntryBaseStatusEnum.CLOSED, reason);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.CLOSED)) {
            this.changeSaleOrderStatus(ctx, pk, BillBaseStatusEnum.CLOSED);
        }
        this.autoUnlockInvWhenCloseOrder(ctx, new IObjectPK[]{pk});
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.CLOSE);
        WriteBackNetOrderHandleFactory.entryHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.CLOSE, (IObjectPK[])new IObjectPK[]{pk});
        ArrayList<String> listReqPlan = new ArrayList<String>();
        listReqPlan.add(saleOrderEntryInfo.getParent().getId().toString());
        IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)ctx);
        if (listReqPlan.size() > 0) {
            iReqPlanSaleOrderFacade.requireFromSaleOrder(listReqPlan, BizActionEnum.CLOSE);
        }
        try {
            if (!isHasFlow) {
                this.writeSourceBillForSaleContract(ctx, new IObjectPK[]{pk}, "-");
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        try {
            ReservationBillCloseService reservationBillCloseService = ReservationBillCloseService.getInstance();
            reservationBillCloseService.doBillReservationCancel(ctx, new IObjectPK[]{pk});
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        this.checkSaleOrderEntryHandClose(ctx, iSaleOrderEntry, pk);
        this.changeOrderEntryStatus(iSaleOrderEntry, pk, EntryBaseStatusEnum.CLOSED, (ReasonCodeInfo)reasonCode);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.CLOSED)) {
            this.changeSaleOrderStatus(ctx, pk, BillBaseStatusEnum.CLOSED);
        }
        this.autoUnlockInvWhenCloseOrder(ctx, new IObjectPK[]{pk});
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.CLOSE);
        WriteBackNetOrderHandleFactory.entryHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.CLOSE, (IObjectPK[])new IObjectPK[]{pk});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        SaleOrderEntryInfo saleOrderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo(pk, sic);
        ArrayList<String> listReqPlan = new ArrayList<String>();
        listReqPlan.add(saleOrderEntryInfo.getParent().getId().toString());
        IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)ctx);
        if (listReqPlan.size() > 0) {
            iReqPlanSaleOrderFacade.requireFromSaleOrder(listReqPlan, BizActionEnum.CLOSE);
        }
    }

    protected void checkSaleOrderEntryFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("qty"));
            selector.add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                try {
                    if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
                        throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_FREEZE);
                    }
                    if (saleOrderEntryInfo.getBaseStatus().getValue() == 4) continue;
                    throw new OrderException(OrderException.ONLYAUDITEDORDER_CANNOT_FREEZED);
                }
                catch (OrderException ex) {
                    if (pks.length > 1) {
                        throw new OrderException(OrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_FREEZED", (Context)ctx)});
                    }
                    throw ex;
                }
            }
        }
    }

    private Set checkOrderEntryFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        HashSet<String> billIdSet = new HashSet<String>();
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("qty"));
            selector.add(new SelectorItemInfo("baseStatus"));
            selector.add(new SelectorItemInfo("parent.id"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                try {
                    if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) {
                        throw new OrderException(OrderException.ONLYAUDITEDORDER_CANNOT_FREEZED);
                    }
                    if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
                        throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_FREEZE);
                    }
                    billIdSet.add(saleOrderEntryInfo.getParent().getId().toString());
                    continue;
                }
                catch (OrderException ex) {
                    if (pks.length > 1) {
                        throw new OrderException(OrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_FREEZED", (Context)ctx)});
                    }
                    throw ex;
                }
            }
        }
        return billIdSet;
    }

    protected void checkSaleOrderEntryUnFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                try {
                    if (saleOrderEntryInfo.getBaseStatus().getValue() == 6) continue;
                    throw new OrderException(OrderException.ONLYBLOCKEDDORDER_CANNOT_UNFREEZED);
                }
                catch (OrderException ex) {
                    if (pks.length > 1) {
                        throw new OrderException(OrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_UNFREEZED", (Context)ctx)});
                    }
                    throw ex;
                }
            }
        }
    }

    protected void checkSaleOrderEntryHandClose(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null && pks.length > 0) {
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            HashSet<String> saleOrderEIDSet = new HashSet<String>();
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                saleOrderEIDSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("qty"));
            selector.add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", saleOrderEIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderEntryCollection saleOrderEColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            int size = saleOrderEColl.size();
            for (int i = 0; i < size; ++i) {
                saleOrderEntryInfo = saleOrderEColl.get(i);
                try {
                    if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) {
                        throw new OrderException(OrderException.ORDER_CANNOT_CLOSE, new String[]{saleOrderEntryInfo.getBaseStatus().toString()});
                    }
                    if (saleOrderEntryInfo.getQty().compareTo(SysConstant.BIGZERO) > 0) continue;
                    throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_CLOSE);
                }
                catch (OrderException ex) {
                    if (pks.length > 1) {
                        throw new OrderException(OrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"OPERATOR_CLOSE", (Context)ctx)});
                    }
                    throw ex;
                }
            }
        }
    }

    @Override
    protected void _canFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleOrderEntryFreezed(ctx, pks);
    }

    @Override
    protected void _canHandleClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkSaleOrderEntryHandClose(ctx, pks);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleOrderEntryInfo info = this.getSaleOrderEntryInfo(ctx, "select parent,seq where id = '" + pk.toString() + "'");
        SaleOrderInfo sInfo = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderInfo("select number where id = '" + info.getParent().getId().toString() + "'");
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int length = pks.length;
        String parentPK = null;
        SaleOrderEntryInfo entryInfo = null;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList list = new ArrayList();
        ArrayList<String> listReqPlan = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            entryInfo = this.handleEntryAndReturnParentPK(ctx, list, pks[i]);
            parentPK = entryInfo.getParent().getId().toString();
            listReqPlan.add(parentPK);
            map.put(entryInfo.getId().toString(), parentPK);
        }
        this.handleCanNotUncloseOrder(ctx, list);
        Map<String, String> flowMap = this.handleOrder(ctx, map);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])pks, CreditOperationEnum.UNCLOSE);
        WriteBackNetOrderHandleFactory.entryHandle((Context)ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.UNCLOSE, (IObjectPK[])pks);
        if (listReqPlan.size() > 0) {
            IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)ctx);
            iReqPlanSaleOrderFacade.requireFromSaleOrder(listReqPlan, BizActionEnum.UNCLOSE);
        }
        try {
            if (flowMap != null && flowMap.size() > 0) {
                HashSet<String> flowSet = new HashSet<String>();
                for (int i = 0; i < length; ++i) {
                    if (flowMap.containsKey(pks[i].toString())) continue;
                    flowSet.add(pks[i].toString());
                }
                if (flowSet.size() > 0) {
                    IObjectPK[] newPKs = new IObjectPK[flowSet.size()];
                    Iterator its = flowSet.iterator();
                    int num = 0;
                    while (its.hasNext()) {
                        newPKs[num] = new ObjectUuidPK(its.next().toString());
                        ++num;
                    }
                    this.writeSourceBillForSaleContract(ctx, newPKs, "+");
                }
            } else {
                this.writeSourceBillForSaleContract(ctx, pks, "+");
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK billId, IObjectPK pk) throws BOSException, EASBizException {
        this._handleUnclose(ctx, new IObjectPK[]{pk});
    }

    private Map<String, String> handleOrder(Context ctx, Map<String, String> map) throws BOSException, EASBizException {
        SaleOrderEntryInfo entryInfo = null;
        SaleOrderInfo info = null;
        SaleOrderEntryCollection entryColl = null;
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            idSet.add(entry.getKey());
            billIdSet.add(entry.getValue());
        }
        if (idSet.size() == 0) {
            return null;
        }
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)"T_SD_SaleOrderEntry", idSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet flowSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                flowSet.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", flowSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderCollection coll = SaleOrderFactory.getLocalInstance(ctx).getSaleOrderCollection(view);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                entryColl = (SaleOrderEntryCollection)((Object)info.getEntries().clone());
                info.getEntries().clear();
                int n = entryColl.size();
                for (int j = 0; j < n; ++j) {
                    entryInfo = entryColl.get(j);
                    if (!map.containsKey(entryInfo.getId().toString())) continue;
                    info.getEntries().add(entryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
            }
        }
        if (billIdSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String parentids = SCMServerUtils.getInStringFromSet(billIdSet);
            sql.append(" update T_SD_SaleOrder set fbasestatus = ").append(4);
            sql.append(" where fid in ").append(parentids);
            sql.append(" and fid not in (select fparentid from T_SD_SaleOrderEntry where fbasestatus = ");
            sql.append(-2).append(" and fparentid in");
            sql.append(parentids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return flowMap;
    }

    private SaleOrderEntryInfo handleEntryAndReturnParentPK(Context ctx, List list, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection entrySic = new SelectorItemCollection();
        entrySic.add(new SelectorItemInfo("baseStatus"));
        entrySic.add(new SelectorItemInfo("parent.id"));
        entrySic.add(new SelectorItemInfo("localTaxAmount"));
        entrySic.add(new SelectorItemInfo("reason"));
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        ISaleOrderEntry iSalerEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
        saleOrderEntryInfo = (SaleOrderEntryInfo)iSalerEntry.getValue(pk, entrySic);
        EntryBaseStatusEnum entryStatus = saleOrderEntryInfo.getBaseStatus();
        if (entryStatus.equals((Object)EntryBaseStatusEnum.CLOSED)) {
            saleOrderEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            saleOrderEntryInfo.setReason("");
            iSalerEntry.updatePartial((CoreBaseInfo)saleOrderEntryInfo, entrySic);
        } else {
            list.add(saleOrderEntryInfo);
        }
        return saleOrderEntryInfo;
    }

    private void handleCanNotUncloseOrder(Context ctx, List list) throws EASBizException {
        if (list.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("salException", SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CAN_NOT_UNCLOSE_ENTRY", (Context)ctx)));
        }
    }

    private void autoUnlockInvWhenCloseOrder(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        IInventory ii = InventoryFactory.getLocalInstance((Context)ctx);
        ii.unLockInventory(pks);
    }

    @Override
    protected void _closeAr(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
        if (entryPK != null) {
            this._closeAr(ctx, new IObjectPK[]{entryPK});
        }
    }

    @Override
    protected void _closeAr(Context ctx, IObjectPK[] entryPKs) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0) {
            return;
        }
        EntityViewInfo evInfo = this.getCloseArEntityViewInfo(entryPKs);
        SaleOrderEntryCollection soeCollection = this.getSaleOrderEntryCollection(ctx, evInfo);
        if (soeCollection == null || soeCollection.size() == 0) {
            return;
        }
        SaleOrderEntryInfo soEntryInfo = null;
        int n = soeCollection.size();
        for (int i = 0; i < n; ++i) {
            boolean isArClosed;
            soEntryInfo = soeCollection.get(i);
            boolean isAuditedOrClosed = soEntryInfo.getBaseStatus() != null && (soEntryInfo.getBaseStatus().getValue() == 4 || soEntryInfo.getBaseStatus().getValue() == 7);
            boolean bl = isArClosed = soEntryInfo.getArClosedStatus() != null && soEntryInfo.getArClosedStatus().getValue() == 1;
            if (isAuditedOrClosed && !isArClosed) continue;
            throw new OrderException(OrderException.ENTRY_CANNOT_CLOSEAR);
        }
        this.updateArClosedStatus(ctx, entryPKs, SaleOrderArClosedStatusEnum.AR_CLOSED);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])entryPKs, CreditOperationEnum.CLOSEAR);
    }

    protected BatchActionResults innerCloseAr(Context ctx, IObjectPK[] entryPKs) throws BOSException {
        BatchActionResults actionResults = new BatchActionResults();
        if (entryPKs == null || entryPKs.length == 0) {
            return actionResults;
        }
        HashSet<ObjectUuidPK> sucessPKsSet = new HashSet<ObjectUuidPK>(entryPKs.length * 2);
        EntityViewInfo evInfo = this.getCloseArEntityViewInfo(entryPKs);
        SaleOrderEntryCollection soeCollection = this.getSaleOrderEntryCollection(ctx, evInfo);
        if (soeCollection == null || soeCollection.size() == 0) {
            return actionResults;
        }
        SaleOrderEntryInfo soEntryInfo = null;
        int n = soeCollection.size();
        for (int i = 0; i < n; ++i) {
            boolean isArClosed;
            soEntryInfo = soeCollection.get(i);
            boolean isAuditedOrClosed = soEntryInfo.getBaseStatus() != null && (soEntryInfo.getBaseStatus().getValue() == 4 || soEntryInfo.getBaseStatus().getValue() == 7);
            boolean bl = isArClosed = soEntryInfo.getArClosedStatus() != null && soEntryInfo.getArClosedStatus().getValue() == 1;
            if (!isAuditedOrClosed || isArClosed) {
                actionResults.addError(soEntryInfo.getId().toString(), (Exception)((Object)new OrderException(OrderException.ENTRY_CANNOT_CLOSEAR)));
                continue;
            }
            sucessPKsSet.add(new ObjectUuidPK(soEntryInfo.getId()));
        }
        if (sucessPKsSet.size() > 0) {
            try {
                this.updateArClosedStatus(ctx, entryPKs, SaleOrderArClosedStatusEnum.AR_CLOSED);
                Iterator itr = sucessPKsSet.iterator();
                while (itr.hasNext()) {
                    actionResults.addSuccess((IObjectPK)itr.next());
                }
            }
            catch (EASBizException e) {
                Iterator itr = sucessPKsSet.iterator();
                while (itr.hasNext()) {
                    actionResults.addError(((IObjectPK)itr.next()).toString(), (Exception)((Object)e));
                }
            }
        }
        return actionResults;
    }

    @Override
    protected void _unCloseAr(Context ctx, IObjectPK entryPK) throws BOSException, EASBizException {
        if (entryPK != null) {
            this._unCloseAr(ctx, new IObjectPK[]{entryPK});
        }
    }

    @Override
    protected void _unCloseAr(Context ctx, IObjectPK[] entryPKs) throws BOSException, EASBizException {
        if (entryPKs == null || entryPKs.length == 0) {
            return;
        }
        EntityViewInfo evInfo = this.getCloseArEntityViewInfo(entryPKs);
        SaleOrderEntryCollection soeCollection = this.getSaleOrderEntryCollection(ctx, evInfo);
        if (soeCollection == null || soeCollection.size() == 0) {
            return;
        }
        SaleOrderEntryInfo soEntryInfo = null;
        int n = soeCollection.size();
        for (int i = 0; i < n; ++i) {
            boolean isArClosed;
            soEntryInfo = soeCollection.get(i);
            boolean bl = isArClosed = soEntryInfo.getArClosedStatus() != null && soEntryInfo.getArClosedStatus().getValue() == 1;
            if (isArClosed) continue;
            throw new OrderException(OrderException.ENTRY_CANNOT_UNCLOSEAR);
        }
        this.updateArClosedStatus(ctx, entryPKs, null);
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance((Object[])entryPKs, CreditOperationEnum.UNCLOSEAR);
    }

    protected BatchActionResults innerUnCloseAr(Context ctx, IObjectPK[] entryPKs) throws BOSException {
        BatchActionResults actionResults = new BatchActionResults();
        if (entryPKs == null || entryPKs.length == 0) {
            return actionResults;
        }
        HashSet<ObjectUuidPK> sucessPKsSet = new HashSet<ObjectUuidPK>(entryPKs.length * 2);
        EntityViewInfo evInfo = this.getCloseArEntityViewInfo(entryPKs);
        SaleOrderEntryCollection soeCollection = this.getSaleOrderEntryCollection(ctx, evInfo);
        if (soeCollection == null || soeCollection.size() == 0) {
            return actionResults;
        }
        SaleOrderEntryInfo soEntryInfo = null;
        int n = soeCollection.size();
        for (int i = 0; i < n; ++i) {
            boolean isArClosed;
            soEntryInfo = soeCollection.get(i);
            boolean bl = isArClosed = soEntryInfo.getArClosedStatus() != null && soEntryInfo.getArClosedStatus().getValue() == 1;
            if (!isArClosed) {
                actionResults.addError(soEntryInfo.getId().toString(), (Exception)((Object)new OrderException(OrderException.ENTRY_CANNOT_UNCLOSEAR)));
                continue;
            }
            sucessPKsSet.add(new ObjectUuidPK(soEntryInfo.getId()));
        }
        if (sucessPKsSet.size() > 0) {
            try {
                this.updateArClosedStatus(ctx, entryPKs, null);
                Iterator itr = sucessPKsSet.iterator();
                while (itr.hasNext()) {
                    actionResults.addSuccess((IObjectPK)itr.next());
                }
            }
            catch (EASBizException e) {
                Iterator itr = sucessPKsSet.iterator();
                while (itr.hasNext()) {
                    actionResults.addError(((IObjectPK)itr.next()).toString(), (Exception)((Object)e));
                }
            }
        }
        return actionResults;
    }

    private EntityViewInfo getCloseArEntityViewInfo(IObjectPK[] entryPKs) {
        SelectorItemCollection siCollection = new SelectorItemCollection();
        siCollection.add("id");
        siCollection.add("seq");
        siCollection.add("parent.id");
        siCollection.add("baseStatus");
        siCollection.add("arClosedStatus");
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        evInfo.setFilter(filterInfo);
        evInfo.setSelector(siCollection);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getStringSet(entryPKs), CompareType.INCLUDE));
        return evInfo;
    }

    private Set getStringSet(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return new HashSet();
        }
        HashSet<String> set = new HashSet<String>(objs.length * 2);
        int n = objs.length;
        for (int i = 0; i < n; ++i) {
            if (objs == null) continue;
            set.add(objs[i].toString());
        }
        return set;
    }

    private String getString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        int n = objs.length;
        for (int i = 0; i < n; ++i) {
            if (objs == null) continue;
            if (!isFirst) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
            isFirst = false;
        }
        return sb.toString();
    }

    private void updateArClosedStatus(Context ctx, IObjectPK[] entryPKs, SaleOrderArClosedStatusEnum arClosedStatus) throws EASBizException, BOSException {
        if (entryPKs == null || entryPKs.length == 0) {
            return;
        }
        String sArClosedStatus = "null";
        if (arClosedStatus != null) {
            sArClosedStatus = String.valueOf(arClosedStatus.getValue());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update T_SD_SaleOrderEntry set FArClosedStatus = ");
        sb.append(sArClosedStatus);
        sb.append(" where FID in(");
        sb.append(this.getString(entryPKs));
        sb.append(")");
        String sql = sb.toString();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceBillForSaleContract(Context ctx, IObjectPK[] pks, String operate) throws SQLException, BOSException {
        if (pks == null) return;
        if (pks.length < 1) {
            return;
        }
        Connection con = null;
        Statement statement = null;
        IRowSet result = null;
        String params = this.getString(pks);
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty").append(" from T_SD_SaleOrderEntry entry").append(" where entry.FSourceBillTypeId = '").append("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=").append("'").append(" and entry.FID in(").append(params).append(")");
            result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                sourceEntryIdList.add(result.getString(1));
                String sp = " \r\n";
                StringBuffer entryBaseStatusSQL = new StringBuffer("");
                entryBaseStatusSQL.append("update t_SD_SalecontractEntry set FBaseStatus = 7  ");
                entryBaseStatusSQL.append(" where  FTotalOrderedQty >= FQty-FQty*isnull(FSendOwingRate,0)/100 and FBaseStatus <> 7 and FQty <> 0 ");
                entryBaseStatusSQL.append(" and fid in( select entry.FSourceBillEntryId from T_SD_SaleOrderEntry entry ").append(" where entry.FSourceBillTypeId = '").append("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=").append("' and entry.FID in(").append(params).append("))");
                statement.addBatch(entryBaseStatusSQL.toString());
                entryBaseStatusSQL.setLength(0);
                entryBaseStatusSQL.append("update t_SD_SalecontractEntry set FBaseStatus = 4,FReason = null  ").append(sp);
                entryBaseStatusSQL.append("where  FTotalOrderedQty < FQty-FQty*isnull(FSendOwingRate,0)/100 and FBaseStatus = 7 and FQty <> 0 ");
                entryBaseStatusSQL.append(" and fid in( select entry.FSourceBillEntryId from T_SD_SaleOrderEntry entry ").append(" where entry.FSourceBillTypeId = '").append("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=").append("' and entry.FID in(").append(params).append("))");
                statement.addBatch(entryBaseStatusSQL.toString());
                StringBuffer sourceEntryID = new StringBuffer("");
                for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                    if (i > 0) {
                        sourceEntryID.append(",");
                    }
                    sourceEntryID.append("'");
                    sourceEntryID.append(sourceEntryIdList.get(i).toString());
                    sourceEntryID.append("'");
                }
                StringBuffer updateCloseContractSQL = new StringBuffer();
                updateCloseContractSQL.append(" update ");
                updateCloseContractSQL.append(" T_SD_SaleContract set FBaseStatus = 7");
                updateCloseContractSQL.append(" where not exists (select FParentid from T_SD_SaleContractEntry where FBaseStatus <>7 and  ");
                updateCloseContractSQL.append(" fparentid in (select FParentId from T_SD_SaleContractEntry where fid in(");
                updateCloseContractSQL.append(sourceEntryID.toString()).append(") group by fparentid))");
                updateCloseContractSQL.append(" and fid in(select FParentId from T_SD_SaleContractEntry where fid in (");
                updateCloseContractSQL.append(sourceEntryID.toString()).append(") group by fparentid)");
                statement.addBatch(updateCloseContractSQL.toString());
                updateCloseContractSQL.setLength(0);
                updateCloseContractSQL.append(" update ");
                updateCloseContractSQL.append(" T_SD_SaleContract set FBaseStatus = 4");
                updateCloseContractSQL.append(" where exists (select FParentid from T_SD_SaleContractEntry where FBaseStatus = 4 and  ");
                updateCloseContractSQL.append(" fparentid in (select FParentId from T_SD_SaleContractEntry where fid in(");
                updateCloseContractSQL.append(sourceEntryID.toString()).append(") group by fparentid))");
                updateCloseContractSQL.append(" and fid in(select FParentId from T_SD_SaleContractEntry where fid in (");
                updateCloseContractSQL.append(sourceEntryID.toString()).append(") group by fparentid)");
                statement.addBatch(updateCloseContractSQL.toString());
                statement.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw e;
                catch (SQLDataException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result);
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result);
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
    }
}

